//                                               -*- C++ -*-
/**
 *  @file  t_LibraryLoader_load.cxx
 *  @brief The test file of class LibraryLoader for load method
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: t_LibraryLoader_load.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include <iostream>
#include <sstream>
#include <fstream>
#include <iomanip>
#include <string>
#include <cstdlib>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "LibraryLoader.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Common;
using namespace OT::Base::Func;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {
    const String path(std::getenv("OPENTURNS_WRAPPER_PATH"));

    /** Instance creation */
    LibraryLoader & loader = LibraryLoader::GetInstance();

    try {
#ifndef WIN32
      String libraryPath1 = path + "/testwrapper_1.so";
#else
      String libraryPath1 = path + "\\testwrapper_1-0.dll";
#endif
      loader.load( libraryPath1.c_str() );
      fullprint << loader << std::endl;

      // reload the same library
      loader.load( libraryPath1.c_str() );
      fullprint << loader << std::endl;

#ifndef WIN32
      String libraryPath2 = path + "/testwrapper_2.so";
#else
      String libraryPath2 = path + "\\testwrapper_2-0.dll";
#endif
      loader.load( libraryPath2.c_str() );
      fullprint << loader << std::endl;

    } catch (DynamicLibraryException & ex) {
      throw TestFailed(ex.__repr__());
    }

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
