// SWIG file Distribution.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2009-11-09 17:38:15 +0100 (lun. 09 nov. 2009) $
// Id : $Id: Distribution.i 1403 2009-11-09 16:38:15Z dutka $

%{
#include "Distribution.hxx"

namespace OpenTURNS { 

  template <>
  struct traitsPythonType<OpenTURNS::Uncertainty::Model::Distribution>
  {
    typedef _PyObject_ Type;
  };


  template <>
  inline
  OpenTURNS::Uncertainty::Model::Distribution
  convert<_PyObject_,OpenTURNS::Uncertainty::Model::Distribution>(PyObject * pyObj)
  {
    void * ptr = 0;
    if (! SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIG_TypeQuery("OpenTURNS::Uncertainty::Model::DistributionImplementation *"), 0 |  0 )))
      throw OpenTURNS::Base::Common::InvalidArgumentException(HERE) << "Object passed as argument is not an object convertible to an DistributionImplementation";
    OpenTURNS::Uncertainty::Model::DistributionImplementation * p_di = reinterpret_cast< OpenTURNS::Uncertainty::Model::DistributionImplementation * >( ptr );
    return *p_di;
  }

} /* namespace OpenTURNS */


%}

%template(DistributionImplementationTypedInterfaceObject)           OpenTURNS::Base::Common::TypedInterfaceObject<OpenTURNS::Uncertainty::Model::DistributionImplementation>;

%include Distribution.hxx
namespace OpenTURNS { namespace Uncertainty { namespace Model {

%extend Distribution {

Distribution(const Distribution & other) { return new OpenTURNS::Uncertainty::Model::Distribution(other); }

}
}}}
