// SWIG file SVMKernel.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2009-11-09 17:38:15 +0100 (lun. 09 nov. 2009) $
// Id : $Id: SVMKernel.i 1403 2009-11-09 16:38:15Z dutka $

%{
#include "SVMKernel.hxx"

namespace OpenTURNS { 

  template <>
  struct traitsPythonType<OpenTURNS::Uncertainty::Algorithm::SVMKernel>
  {
    typedef _PyObject_ Type;
  };


  template <>
  inline
  OpenTURNS::Uncertainty::Algorithm::SVMKernel
  convert<_PyObject_,OpenTURNS::Uncertainty::Algorithm::SVMKernel>(PyObject * pyObj)
  {
    void * ptr = 0;
    if (! SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIG_TypeQuery("OpenTURNS::Uncertainty::Algorithm::SVMKernelImplementation *"), 0 |  0 )))
      throw OpenTURNS::Base::Common::InvalidArgumentException(HERE) << "Object passed as argument is not an object convertible to an SVMKernelImplementation";
    OpenTURNS::Uncertainty::Algorithm::SVMKernelImplementation * p_ki = reinterpret_cast< OpenTURNS::Uncertainty::Algorithm::SVMKernelImplementation * >( ptr );
    return *p_ki;
  }

} /* namespace OpenTURNS */


%}

%template(SVMKernelImplementationTypedInterfaceObject)           OpenTURNS::Base::Common::TypedInterfaceObject<OpenTURNS::Uncertainty::Algorithm::SVMKernelImplementation>;
%include SVMKernel.hxx
namespace OpenTURNS{ namespace Uncertainty { namespace Algorithm {

%extend SVMKernel {

SVMKernel(const SVMKernel & other) { return new OpenTURNS::Uncertainty::Algorithm::SVMKernel(other); }

}
}}}
