/* -*-c++-*- */
/* osgEarth - Dynamic map generation toolkit for OpenSceneGraph
 * Copyright 2008-2010 Pelican Mapping
 * http://osgearth.org
 *
 * osgEarth is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 */

#include <osgEarth/Progress>

#include <osg/Notify>

using namespace osgEarth;

ProgressCallback::ProgressCallback() :
osg::Referenced( true ),
_canceled(false),
_needsRetry(false)
{
}

bool
ProgressCallback::reportProgress(double current, double total)
{
    return false;
}

/******************************************************************************/
ConsoleProgressCallback::ConsoleProgressCallback() :
ProgressCallback()
{
}

bool
ConsoleProgressCallback::reportProgress(double current, double total)
{
    double percentComplete = (current / total) * 100.0;
    OE_NOTICE << "Completed " << percentComplete << "% " << current << " of " << total << std::endl;
    return false;
}