
/******************************************************************************
**
**  Copyright (C) 2006 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/*****************************************************************************
**
**  File:    database_brief.h
**  Date:    August 18, 2002
**
**  Author:  Brian Wotring
**
**  Purpose: structure representing a db that can be transported in a message.
**
*****************************************************************************/

#ifndef DATABASE_BRIEF_H
#define DATABASE_BRIEF_H

#define MAX_DB_NOTES_LENGTH         128

typedef struct OSI_DATABASE_BRIEF
{
    osi_uint64 complete;
    
    osi_uint64 error_count;
    osi_uint64 record_count;
    
    char name[MAX_PATH_LENGTH];
    char notes[MAX_DB_NOTES_LENGTH];
    
    char config_name[MAX_PATH_LENGTH];
    char config_id[MAX_CONFIG_ID_LENGTH];
        
    OSI_SCAN_RESULTS_1 scan_results;
    
} OSI_DATABASE_BRIEF;


void wrap_database_brief( OSI_DATABASE_BRIEF *database );
void unwrap_database_brief( OSI_DATABASE_BRIEF *database );

#endif
