/*
ClientFinger.cc
*/

#include "ClientFinger.h"
extern Language *L;

/*
example:
info@seismo.emr.ca
quake@seismo.emr.ca
*/

ClientFinger::ClientFinger (const char *aserver, int aport, const char *auser)
  {
  xstrncpy (server, CMAXIPNAME, aserver);
  xstrncpy (user, CMAXBUFFER, auser);
  fingerport = aport;
  }  

ClientFinger::~ClientFinger ()
  {
  }

bool ClientFinger::doFinger (TBuffer ErrorString, StringList *SLRes)
  {
  char buffer[1024];
  int sock;
  XSocket *socket;

  SLRes->Clear();
  sprintf (buffer, "[%.100s]", server);
  SLRes->Add (buffer);
  initStr (ErrorString);
  socket = new XSocket ();
  socket->ignore_pipe();
  sock = socket->do_client_inet (server, NULL, fingerport, 240);
  if (sock == -1) {xstrncpy (ErrorString, CMAXBUFFER, L->get (ERR_SERVERISDOWN)); return false;}
  socket->SetSock (sock);
    
  //ENVIO USER
  sprintf (buffer, "%.100s\n", user);
  if (socket->Send_TO (buffer, 3) == 0) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
  
  //LEO LO RECIBIDO
  while (socket->Gets (buffer, sizeof(buffer) -1))
    {
    SLRes->Add (buffer);
    }
    
  delete socket;  
  return true;
  }
