/*
ClientHTTP.cc
*/

#include "ClientHTTP.h"
extern Language *L;

#define HTTP_VERSION "HTTP/1.0"

ClientHTTP::ClientHTTP (const char *aserver, int aport, int atimeout)
  {
  initStr (ErrorString);
  xstrncpy (httpserver, CMAXIPNAME, aserver);
  httpport = aport;
  httptimeout = atimeout;
  }  

ClientHTTP::~ClientHTTP ()
  {
  }

const char *ClientHTTP::getErrorMsg (void)
  {
  return ErrorString;           
  }  

bool ClientHTTP::doGetHTTPSL (const char *Header2Send, StringList *SLHTTPHead, StringList *SLHTTPBody, int *httpcode)
  {
  TBuffer buffer, httptoken, httpmsg;
  int sock = -1, cont_lineas = 0;
  XSocket *socket;
  bool EncontradoPrimerCRLF = false;

  initStr (ErrorString);
  SLHTTPBody->Clear();
  SLHTTPHead->Clear();
  socket = new XSocket ();
  socket->ignore_pipe();
  sock = socket->do_client_inet (httpserver, NULL, httpport, httptimeout);
  if (sock == -1) {xstrncpy (ErrorString, CMAXBUFFER, L->get (ERR_SERVERISDOWN)); return false;}
  socket->SetSock (sock);
                     
  //ENVIO CABECERA
  if (socket->Send_TO (Header2Send, httptimeout) == 0) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
      
  initStr(buffer);    
  //LEO LO RECIBIDO
  while (socket->Gets (buffer, sizeof(buffer) -1) == true)
    {
    ++cont_lineas;
    if (EncontradoPrimerCRLF == false)
      {
      if ((strcmp (buffer, "") == 0) || (strcmp (buffer, "\n") == 0) || (strcmp (buffer, "\r\n") == 0))
        {
        EncontradoPrimerCRLF = true;
        }
      else
        {  
        //DEBUG ("doGetHTTPSL=%s", buffer);
        if (cont_lineas > 1) 
          {
          //No meto la linea primera: HTTP/1.1 200 OK
          SLHTTPHead->Add (buffer);
          }
        else
          {
          //for get that situation: HTTP/1.1 401 Authorization Required          
          initStr (httptoken);
          initStr (httpmsg);
          if (strlen(buffer) > 1) {sscanf (buffer, "%s %d %[^]]s", httptoken, httpcode, httpmsg);}
          }  
        }
      }
    else
      {  
      SLHTTPBody->Add (buffer);
      }
    }    
  delete socket;  
  if (*httpcode >= 400) {return false;}
  return true;
  }
  
bool ClientHTTP::doPostHTTPSL (const char *Header2Send, const char *PostData, StringList *SLHTTPHead, StringList *SLHTTPBody, int *httpcode)
  {
  TBuffer buffer, httptoken, httpmsg;
  int sock = -1, cont_lineas = 0, contentlength = 0;
  XSocket *socket;
  bool EncontradoPrimerCRLF = false;

  initStr (ErrorString);
  SLHTTPBody->Clear();
  SLHTTPHead->Clear();
  socket = new XSocket ();
  socket->ignore_pipe();
  sock = socket->do_client_inet (httpserver, NULL, httpport, httptimeout);
  if (sock == -1) {xstrncpy (ErrorString, CMAXBUFFER, L->get (ERR_SERVERISDOWN)); return false;}
  socket->SetSock (sock);
    
  contentlength = strlen (PostData);
    
  //ENVIO CABECERA
  if (socket->Send_TO (Header2Send, httptimeout) == 0) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
  
  //ENVIO POSTDATA
  if (!IsEmpty(PostData))
    {
    if (socket->Send_TO (PostData, httptimeout) == 0) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
    }
  
  initStr(buffer);
  //LEO LO RECIBIDO
  while (socket->Gets (buffer, sizeof(buffer) -1))
    {
    ++cont_lineas;
    if (EncontradoPrimerCRLF == false)
      {
      if ((strcmp (buffer, "") == 0) || (strcmp (buffer, "\n") == 0) || (strcmp (buffer, "\r\n") == 0))
        {
        EncontradoPrimerCRLF = true;
        }
      else
        {  
        //DEBUG ("doPostHTTPSL=%s", buffer);
        if (cont_lineas > 1) 
          {
          //No meto la linea primera: HTTP/1.1 200 OK
          SLHTTPHead->Add (buffer);
          }
        else
          {
          //for get that situation: HTTP/1.1 401 Authorization Required          
          initStr (httptoken);
          initStr (httpmsg);
          if (strlen(buffer) > 1) {sscanf (buffer, "%s %d %[^]]s", httptoken, httpcode, httpmsg);}
          }  
        }
      }
    else
      {  
      SLHTTPBody->Add (buffer);
      }
    }    
  delete socket;  
  if (*httpcode >= 400) {return false;}
  return true;
  }  
  
bool ClientHTTP::doGetHTTP (const char *Header2Send, StringList *SLHTTPHead, XSocket *aXS, int *httpcode)
  {
  TBuffer buffer, httptoken, httpmsg;
  int sock = -1, cont_lineas = 0, leido;
  XSocket *socket;
  bool EncontradoPrimerCRLF = false, EsCabecera = true;

  initStr (ErrorString);
  SLHTTPHead->Clear();
  socket = new XSocket ();
  socket->ignore_pipe();
  sock = socket->do_client_inet (httpserver, NULL, httpport, httptimeout);
  if (sock == -1) {xstrncpy (ErrorString, CMAXBUFFER, L->get (ERR_SERVERISDOWN)); return false;}
  socket->SetSock (sock);
        
  //ENVIO CABECERA
  if (socket->Send_TO (Header2Send, httptimeout) == 0) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
  
  //LEO LO RECIBIDO
  leido = socket->Gets (buffer, sizeof(buffer) -1);
  //DEBUG ("%d-%s", leido, buffer);
  while (leido > 0)
    {
    ++cont_lineas;
    if ((EncontradoPrimerCRLF == false) && (EsCabecera == true))
      {
      if ((strcmp (buffer, "") == 0) || (strcmp (buffer, "\n") == 0) || (strcmp (buffer, "\r\n") == 0))
        {
        EncontradoPrimerCRLF = true; 
        EsCabecera = false;       
        aXS->Write (buffer, strlen(buffer));
        aXS->Write ("\r\n", 2);
        }
      else
        { 
        //DEBUG ("doGetHTTP=%s", buffer); 
        if (cont_lineas > 1) 
          {
          //No meto la linea primera: HTTP/1.1 200 OK
          aXS->Write (buffer, strlen(buffer));
          aXS->Write ("\r\n", 2);
          }
        else
          {
          //for get that situation: HTTP/1.1 401 Authorization Required          
          initStr (httptoken);
          initStr (httpmsg);
          if (strlen(buffer) > 1) {sscanf (buffer, "%s %d %[^]]s", httptoken, httpcode, httpmsg);}
          }  
        }
      }
    else
      {  
      aXS->Write (buffer, leido);
      }
    if (EncontradoPrimerCRLF == false)  
      {
      leido = socket->Gets (buffer, sizeof(buffer) -1);      
      //DEBUG ("%d-%s", leido, buffer);
      }
    else
      {
      leido = socket->Read (buffer, CMAXBUFFER);
      //DEBUG ("%d-%s", leido, buffer);
      }
    }    
  delete socket;  
  if (*httpcode >= 400) {return false;}
  return true;
  }
  
  
