/*
ClientNNTP.h
*/

#ifndef __CLIENTNNTP_H
#define __CLIENTNNTP_H

#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <signal.h>

#include "c-client.h"

#include "Language.h"
#include "Utils.h"
#include "Config.h"
#include "XSocket.h"
#include "XVector.h"
#include "Codecs.h"
#include "UserOptions.h"


class ClientNNTP
  {
  private:
    IPNAME nntpserver, defaultipdomain;
    TBuffer fnallnn, user, pw; 
    XString searchedgroups;
    int retrieveAllGroupsListFromNet (void);  
    int retrieveAllGroupsListFromFile (void);          
    void sortAllGroupsList (void);
  public:
    StringList *SLAllGroups, *SLSearchedGroups;  
    ClientNNTP (const char *anntpserver, const char *adefaultipdomain, const char *auser, const char *apw);
    virtual ~ClientNNTP ();
    void setNNTPserver (const char *anntpserver);
    const char *getNNTPServer (void);
    int retrieveAllGroupsList (void);  
    int retrievePartialGroupsList (char *filter);
    const char *getSearchedGroups (void);
  };

#endif

