#emacs: -*- mode: python-mode; py-indent-offset: 4; indent-tabs-mode: nil -*-
#ex: set sts=4 ts=4 sw=4 et:
### ### ### ### ### ### ### ### ### ### ### ### ### ### ### ### ### ### ### ##
#
#   See COPYING file distributed along with the PyMVPA package for the
#   copyright and license terms.
#
### ### ### ### ### ### ### ### ### ### ### ### ### ### ### ### ### ### ### ##
"""Base functionality of PyMVPA

Module Organization
===================

mvpa.base module contains various modules which are used through out
PyMVPA code, and are generic building blocks

.. packagetree::
   :style: UML

:group Basic: externals
"""

__docformat__ = 'restructuredtext'


if __debug__:
    from mvpa.misc import debug
    debug('INIT', 'mvpa.base')

import externals

if __debug__:
    debug('INIT', 'mvpa.base end')
