/*
#
# NJB.h
#
# Duane Maxwell
# (c) Copyright Linspire. Inc, 2005
#
# This is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
*/

#ifndef __NJB__
#define __NJB__

#include <libnjb.h>

class NJBFrame;
class NJBSong;
class NJBPlaylist;
class NJBDatafileTag;
class NJBEAXType;


class NJBFrame {
public:
	njb_songid_frame_t *frame;
public:
	NJBFrame(njb_songid_frame_t *f);
	NJBFrame(const char *label,const char *value);
	//NJBFrame(const char *label,u_int16_t value);
	NJBFrame(const char *label,u_int32_t value);
	~NJBFrame();
	void Destroy(void);
	char *GetLabel(void);
	int GetType(void);;
	char *GetStringValue(void);
	u_int8_t GetInt8Value(void);
	u_int16_t GetInt16Value(void);
	u_int32_t GetInt32Value(void);
	u_int64_t GetInt64Value(void);
	NJBFrame *Next(void);
	
	static char *CODEC_MP3;
	static char *CODEC_WMA;
	static char *CODEC_WAV;

	static char *SIZE;
	static char *LENGTH;
	static char *CODEC;
	static char *TITLE;
	static char *ALBUM;
	static char *GENRE;
	static char *ARTIST;
	static char *TRACK;
	static char *FNAME;
	static char *YEAR;
	static char *PROTECTED;
	static char *BITRATE;
	static char *COMMENT;
	static char *FOLDER;
};

class NJBSong {
public:
	njb_songid_t *song;
public:
	NJBSong(void);
	NJBSong(njb_songid_t *s);
	~NJBSong();
	void Destroy(void);
	void AddFrame(NJBFrame *frame);
	void ResetGetFrame(void);
	NJBFrame *GetFrame(void);
	NJBFrame *FindFrame(const char *label);
	u_int32_t GetTrackID(void);
	NJBSong *Next(void);
};

class NJBPlaylistTrack {
public:
	njb_playlist_track_t *track;
public:	
	NJBPlaylistTrack(njb_playlist_track_t *t);
	NJBPlaylistTrack(int trackID);
	~NJBPlaylistTrack();
	void Destroy(void);
	u_int32_t GetTrackID(void);
	NJBPlaylistTrack *Next(void);
	NJBPlaylistTrack *Previous(void);
};

class NJBPlaylist {
public:
	njb_playlist_t *playlist;
public:	
	NJBPlaylist(njb_playlist_t *p);
	NJBPlaylist();
	~NJBPlaylist();
	
	void Destroy(void);
	void AddTrack(NJBPlaylistTrack *track,unsigned int position);
	void DeleteTrack(unsigned int position);
	void ResetGetTrack(void);
	NJBPlaylistTrack *GetTrack(void);
	int SetName(const char *name);	
	char *GetName(void);
	u_int32_t GetNumTracks(void);
	u_int32_t GetID(void);
};

class NJBDatafileTag {
public:
	njb_datafile_t *datafile;
public:
	NJBDatafileTag();
	NJBDatafileTag(njb_datafile_t *d);
	~NJBDatafileTag();
	void Destroy(void);
};

class NJBEAXType {
public:
	njb_eax_t *eax;
public:	
	NJBEAXType();
	NJBEAXType(njb_eax_t *e);
	~NJBEAXType();
	void Destroy(void);
};

class NJBTime {
public:
	njb_time_t *time;
public:
	NJBTime();
	NJBTime(njb_time_t *t);
	~NJBTime();
	void Destroy(void);
	void Time(int *year,int *month,int *day,int *weekday,int *hours,int *minutes,int *seconds);
};

class NJBDevice {
public:
	njb_t *njb;
public:
	NJBDevice(void);
	NJBDevice(njb_t *n);
	int Open(void);
	void Close(void);
	int Capture(void);
	int Release(void);
	void Ping(void);
	int GetType(void);
	int GetUpdated(void);
	char *GetSDMI(void);
	void GetFWRevision(int *major,int *minor, int *revision);
	void GetHWRevision(int *major,int *minor, int *revision);
	char *GetProductName();
	int GetPower(void);

	int GetDiskUsage(u_int64_t *btotal, u_int64_t *bfree);
	char *GetOwnerString(void);
	int SetOwnerString(char *ownerName);
	int GetBitmapDimensions(int *x,int *y,int *bytes);
	int SetBitMap(unsigned char *bitmap);
	void GetExtendedTags(int extended);
	
	void ResetGetTrackTag(void);
	NJBSong *GetTrackTag(void);
	int ReplaceTrackTag(u_int32_t trackID, NJBSong *song);
	int GetTrack(u_int32_t trackID,u_int32_t size,const char *path);
	int GetTrack(u_int32_t trackid, u_int32_t size,const char *path, NJB_Xfer_Callback *callback, void *data);
	int GetTrackFile(u_int32_t trackID,u_int32_t size,int fd);
	int GetTrackFile(u_int32_t trackID,u_int32_t size,int fd, NJB_Xfer_Callback *callback, void *data);
	int SendTrack(const char *path,NJBSong *song,unsigned int *trackID);
	int SendTrack(const char *path,NJBSong *song,NJB_Xfer_Callback *callback, void *data,unsigned int *trackID);
	int DeleteTrack(u_int32_t trackID);
	
	void ResetGetPlaylist(void);
	NJBPlaylist *GetPlaylist(void);
	int DeletePlaylist(u_int32_t playlistID);
	int UpdatePlaylist(NJBPlaylist *playlist);
	
	void ResetGetDatafileTag(void);
	NJBDatafileTag *GetDatafileTag(void);
	int SendDatafile(const char *path, const char *name, const char *folder,unsigned int *fileID);
	int DeleteDatafile(u_int32_t fileID);
	int CreateFolder(const char *name, unsigned int *folderID);
	
	void ResetGetEAXType(void);
	NJBEAXType *GetEAXType(void);
	void AdjustEAX(u_int16_t eaxID,u_int16_t patchIndex, int16_t scaleValue);
	
	NJBTime GetTime(void);
	
	int PlayTrack(u_int32_t trackID);
	int QueueTrack(u_int32_t trackID);
	int StopPlay(void);
	int PausePlay(void);
	int ResumePlay(void);
	int SeekTrack(u_int32_t position);
	int ElapsedTime(u_int16_t *elapsed, int *change);
	
	int ErrorPending(void);
	void ResetError(void);
	char *GetError(void);
};

#endif
