//
// C++ Implementation: CGuitxtEdit
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <QtGui>

#include "CQcakeDlg.hpp"
#include "CGuitxtEdit.hpp"

CGUITextEditDlg::CGUITextEditDlg(QString strTitle, QWidget * parent, Qt::WFlags f)
: CQcakeDlg(parent, f)
{
   point = NULL;
   ui.setupUi(this);
    
   connect(ui.buttonBox, SIGNAL(accepted()), this, SLOT(slotEditData()));
   connect(ui.buttonBox, SIGNAL(rejected()), this, SLOT(slotGetData()));
   connect(ui.colorlabel, SIGNAL(released()), this, SLOT(slotEditColor()));
   
   myParent = parent;
   setWindowTitle(strTitle);
}

CGUITextEditDlg::~CGUITextEditDlg() {
}

void CGUITextEditDlg::slotGetData()
{
    if(point != NULL){
      slotGetData(point);
    }
}

void CGUITextEditDlg::slotGetData(FolderListItem *i)
{
    int myplace=0;
    char mybuff[256];
    unsigned int colorr;
    unsigned int colorg;
    unsigned int colorb;
    
    point=i;
    
    ui.text->setText(i->text(0));
    ui.on->setChecked(i->GetValue("on",i).toInt());

    ui.locx->setValue(i->GetValue("x",i).toDouble());
    ui.locy->setValue(i->GetValue("y",i).toDouble());

    // place
    myplace = i->GetValue("place",i).toInt();
    switch (myplace){
      case 0:     
          ui.upperleft->setChecked( TRUE );      
      break;
      case 1:
          ui.upperright->setChecked( TRUE );
      break;
      case 2:
          ui.lowerright->setChecked( TRUE );
      break;
      case 3:
          ui.lowerleft->setChecked( TRUE );
      break;
      case 4:
          ui.center->setChecked( TRUE );
      break;
    }
    
    ui.label->setText(i->GetValue("label",i));
    
    strncpy(mybuff,i->GetValue("colorlabel",i).toAscii() ,8);
    sscanf(mybuff,"%02X%02X%02X",&colorr,&colorg,&colorb);
    mycolor.setRgb(colorr,colorg,colorb);
    if ( mycolor.isValid() ){
      QPixmap pix (100,15);
      pix.fill( mycolor );
      QIcon icon(pix);
      ui.colorlabel->setIcon( icon );
      QSize size(100,15);
      ui.colorlabel->setIconSize( size );      
    }
    qWarning( "CGUITextEditDlg::slotGetData(): Geht !" );
}

void CGUITextEditDlg::slotEditData()
{
    char mybuff[256];
    
    if(point != NULL){
        point->setText(0,ui.text->text());
        point->SetValue("on", ui.on->isChecked() ? "1" : "0");
        point->SetValue("x",ui.locx->text());
        point->SetValue("y",ui.locy->text());
        // myplace
        if(ui.upperleft->isChecked())
          point->SetValue("place","0");
        if(ui.upperright->isChecked())
          point->SetValue("place","1");
        if(ui.lowerright->isChecked())
          point->SetValue("place","2");
        if(ui.lowerleft->isChecked())
          point->SetValue("place","3");
        if(ui.center->isChecked())
          point->SetValue("place","4");

        point->SetValue("label",ui.label->text());

        sprintf(mybuff,"%02X%02X%02X",mycolor.red(),mycolor.green(),mycolor.blue());
        point->SetValue("colorlabel",mybuff);

	point->updategl();
    }
    qWarning( "CGUITextEditDlg::slotEditData(): Geht !" );
}

void CGUITextEditDlg::slotEditColor()
{
    QColor color = QColorDialog::getColor(mycolor,this );
    if ( color.isValid() ) {
        QPixmap pix (100,15) ;
        pix.fill( color );
	QIcon icon(pix);
	ui.colorlabel->setIcon( icon );
        QSize size(100,15);
        ui.colorlabel->setIconSize( size );      
        mycolor = color;
    }
    qWarning( "CGUITextEditDlg::slotEditColorAmb(): Geht !" );
}
