//
// C++ Implementation: CSoundEdit
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <QtGui>

#include "CQcakeDlg.hpp"
#include "CSoundEdit.hpp"

CSoundEditDlg::CSoundEditDlg(QString strTitle, QWidget * parent, Qt::WFlags f)
: CQcakeDlg(parent, f)
{
   point = NULL;
   ui.setupUi(this);
    
   connect(ui.buttonBox, SIGNAL(accepted()), this, SLOT(slotEditData()));
   connect(ui.buttonBox, SIGNAL(rejected()), this, SLOT(slotGetData()));

   myParent = parent;
   setWindowTitle(strTitle);
}

CSoundEditDlg::~CSoundEditDlg() {
}

void CSoundEditDlg::slotGetData()
{
    if(point != NULL){
      slotGetData(point);
    }
}

void CSoundEditDlg::slotGetData(FolderListItem *i)
{
    point=i;
    
    ui.text->setText(i->text(0));
    ui.viewbox->setChecked(i->GetValue("viewbox",i).toInt());

    ui.locx->setValue(i->GetValue("x",i).toDouble());
    ui.locy->setValue(i->GetValue("y",i).toDouble());
    ui.locz->setValue(i->GetValue("z",i).toDouble());

    ui.scax->setValue(i->GetValue("scax",i).toDouble());
    ui.scay->setValue(i->GetValue("scay",i).toDouble());
    ui.scaz->setValue(i->GetValue("scaz",i).toDouble());

    ui.rotx->setValue(i->GetValue("rotx",i).toDouble());
    ui.roty->setValue(i->GetValue("roty",i).toDouble());
    ui.rotz->setValue(i->GetValue("rotz",i).toDouble());

    ui.play->setChecked(i->GetValue("play",i).toInt());
    ui.loop->setChecked(i->GetValue("loop",i).toInt());
    ui.relativexyz->setChecked(i->GetValue("relativexyz",i).toInt());

    ui.volume->setText(i->GetValue("volume",i));

    qWarning( "CSoundEditDlg::slotGetData(): Geht !" );
}

void CSoundEditDlg::slotEditData()
{
    if(point != NULL)    {
        point->setText(0,ui.text->text());
        point->SetValue("viewbox", ui.viewbox->isChecked() ? "1" : "0");

        point->SetValue("play", ui.play->isChecked() ? "1" : "0");
        point->SetValue("loop", ui.loop->isChecked() ? "1" : "0");
        point->SetValue("relativexyz", ui.relativexyz->isChecked() ? "1" : "0");

        point->SetValue("x",ui.locx->text());
        point->SetValue("y",ui.locy->text());
        point->SetValue("z",ui.locz->text());

        point->SetValue("scax",ui.scax->text());
        point->SetValue("scay",ui.scay->text());
        point->SetValue("scaz",ui.scaz->text());

        point->SetValue("rotx",ui.rotx->text());
        point->SetValue("roty",ui.roty->text());
        point->SetValue("rotz",ui.rotz->text());

        point->SetValue("volume",ui.volume->text());

	point->updategl();
    }
    qWarning( "CSoundEditDlg::slotEditData(): Geht !" );
}
