/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMCoreException.h"

#include "DOMCoreException.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDOMCoreException);

/* Hash table */

static const HashTableValue JSDOMCoreExceptionTableValues[5] =
{
    { "code", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionCode), (intptr_t)0 },
    { "name", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionName), (intptr_t)0 },
    { "message", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionMessage), (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSDOMCoreExceptionTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSDOMCoreExceptionTableValues, 0 };
#else
    { 10, 7, JSDOMCoreExceptionTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSDOMCoreExceptionConstructorTableValues[23] =
{
    { "INDEX_SIZE_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionINDEX_SIZE_ERR), (intptr_t)0 },
    { "DOMSTRING_SIZE_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionDOMSTRING_SIZE_ERR), (intptr_t)0 },
    { "HIERARCHY_REQUEST_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionHIERARCHY_REQUEST_ERR), (intptr_t)0 },
    { "WRONG_DOCUMENT_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionWRONG_DOCUMENT_ERR), (intptr_t)0 },
    { "INVALID_CHARACTER_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionINVALID_CHARACTER_ERR), (intptr_t)0 },
    { "NO_DATA_ALLOWED_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionNO_DATA_ALLOWED_ERR), (intptr_t)0 },
    { "NO_MODIFICATION_ALLOWED_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionNO_MODIFICATION_ALLOWED_ERR), (intptr_t)0 },
    { "NOT_FOUND_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionNOT_FOUND_ERR), (intptr_t)0 },
    { "NOT_SUPPORTED_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionNOT_SUPPORTED_ERR), (intptr_t)0 },
    { "INUSE_ATTRIBUTE_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionINUSE_ATTRIBUTE_ERR), (intptr_t)0 },
    { "INVALID_STATE_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionINVALID_STATE_ERR), (intptr_t)0 },
    { "SYNTAX_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionSYNTAX_ERR), (intptr_t)0 },
    { "INVALID_MODIFICATION_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionINVALID_MODIFICATION_ERR), (intptr_t)0 },
    { "NAMESPACE_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionNAMESPACE_ERR), (intptr_t)0 },
    { "INVALID_ACCESS_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionINVALID_ACCESS_ERR), (intptr_t)0 },
    { "VALIDATION_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionVALIDATION_ERR), (intptr_t)0 },
    { "TYPE_MISMATCH_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionTYPE_MISMATCH_ERR), (intptr_t)0 },
    { "SECURITY_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionSECURITY_ERR), (intptr_t)0 },
    { "NETWORK_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionNETWORK_ERR), (intptr_t)0 },
    { "ABORT_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionABORT_ERR), (intptr_t)0 },
    { "URL_MISMATCH_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionURL_MISMATCH_ERR), (intptr_t)0 },
    { "QUOTA_EXCEEDED_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionQUOTA_EXCEEDED_ERR), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSDOMCoreExceptionConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 511, JSDOMCoreExceptionConstructorTableValues, 0 };
#else
    { 67, 63, JSDOMCoreExceptionConstructorTableValues, 0 };
#endif

class JSDOMCoreExceptionConstructor : public DOMConstructorObject {
public:
    JSDOMCoreExceptionConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSDOMCoreExceptionConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSDOMCoreExceptionPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSDOMCoreExceptionConstructor::s_info = { "DOMExceptionConstructor", 0, &JSDOMCoreExceptionConstructorTable, 0 };

bool JSDOMCoreExceptionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMCoreExceptionConstructor, DOMObject>(exec, &JSDOMCoreExceptionConstructorTable, this, propertyName, slot);
}

bool JSDOMCoreExceptionConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDOMCoreExceptionConstructor, DOMObject>(exec, &JSDOMCoreExceptionConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSDOMCoreExceptionPrototypeTableValues[24] =
{
    { "INDEX_SIZE_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionINDEX_SIZE_ERR), (intptr_t)0 },
    { "DOMSTRING_SIZE_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionDOMSTRING_SIZE_ERR), (intptr_t)0 },
    { "HIERARCHY_REQUEST_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionHIERARCHY_REQUEST_ERR), (intptr_t)0 },
    { "WRONG_DOCUMENT_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionWRONG_DOCUMENT_ERR), (intptr_t)0 },
    { "INVALID_CHARACTER_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionINVALID_CHARACTER_ERR), (intptr_t)0 },
    { "NO_DATA_ALLOWED_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionNO_DATA_ALLOWED_ERR), (intptr_t)0 },
    { "NO_MODIFICATION_ALLOWED_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionNO_MODIFICATION_ALLOWED_ERR), (intptr_t)0 },
    { "NOT_FOUND_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionNOT_FOUND_ERR), (intptr_t)0 },
    { "NOT_SUPPORTED_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionNOT_SUPPORTED_ERR), (intptr_t)0 },
    { "INUSE_ATTRIBUTE_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionINUSE_ATTRIBUTE_ERR), (intptr_t)0 },
    { "INVALID_STATE_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionINVALID_STATE_ERR), (intptr_t)0 },
    { "SYNTAX_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionSYNTAX_ERR), (intptr_t)0 },
    { "INVALID_MODIFICATION_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionINVALID_MODIFICATION_ERR), (intptr_t)0 },
    { "NAMESPACE_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionNAMESPACE_ERR), (intptr_t)0 },
    { "INVALID_ACCESS_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionINVALID_ACCESS_ERR), (intptr_t)0 },
    { "VALIDATION_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionVALIDATION_ERR), (intptr_t)0 },
    { "TYPE_MISMATCH_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionTYPE_MISMATCH_ERR), (intptr_t)0 },
    { "SECURITY_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionSECURITY_ERR), (intptr_t)0 },
    { "NETWORK_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionNETWORK_ERR), (intptr_t)0 },
    { "ABORT_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionABORT_ERR), (intptr_t)0 },
    { "URL_MISMATCH_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionURL_MISMATCH_ERR), (intptr_t)0 },
    { "QUOTA_EXCEEDED_ERR", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCoreExceptionQUOTA_EXCEEDED_ERR), (intptr_t)0 },
    { "toString", DontDelete|DontEnum|Function, (intptr_t)static_cast<NativeFunction>(jsDOMCoreExceptionPrototypeFunctionToString), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSDOMCoreExceptionPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 511, JSDOMCoreExceptionPrototypeTableValues, 0 };
#else
    { 68, 63, JSDOMCoreExceptionPrototypeTableValues, 0 };
#endif

const ClassInfo JSDOMCoreExceptionPrototype::s_info = { "DOMExceptionPrototype", 0, &JSDOMCoreExceptionPrototypeTable, 0 };

JSObject* JSDOMCoreExceptionPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMCoreException>(exec, globalObject);
}

bool JSDOMCoreExceptionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSDOMCoreExceptionPrototype, JSObject>(exec, &JSDOMCoreExceptionPrototypeTable, this, propertyName, slot);
}

bool JSDOMCoreExceptionPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSDOMCoreExceptionPrototype, JSObject>(exec, &JSDOMCoreExceptionPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSDOMCoreException::s_info = { "DOMException", 0, &JSDOMCoreExceptionTable, 0 };

JSDOMCoreException::JSDOMCoreException(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMCoreException> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSDOMCoreException::~JSDOMCoreException()
{
    forgetDOMObject(this, impl());
}

JSObject* JSDOMCoreException::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSDOMCoreExceptionPrototype(JSDOMCoreExceptionPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSDOMCoreException::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMCoreException, Base>(exec, &JSDOMCoreExceptionTable, this, propertyName, slot);
}

bool JSDOMCoreException::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDOMCoreException, Base>(exec, &JSDOMCoreExceptionTable, this, propertyName, descriptor);
}

JSValue jsDOMCoreExceptionCode(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMCoreException* castedThis = static_cast<JSDOMCoreException*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMCoreException* imp = static_cast<DOMCoreException*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->code());
    return result;
}

JSValue jsDOMCoreExceptionName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMCoreException* castedThis = static_cast<JSDOMCoreException*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMCoreException* imp = static_cast<DOMCoreException*>(castedThis->impl());
    JSValue result = jsString(exec, imp->name());
    return result;
}

JSValue jsDOMCoreExceptionMessage(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMCoreException* castedThis = static_cast<JSDOMCoreException*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMCoreException* imp = static_cast<DOMCoreException*>(castedThis->impl());
    JSValue result = jsString(exec, imp->message());
    return result;
}

JSValue jsDOMCoreExceptionConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMCoreException* domObject = static_cast<JSDOMCoreException*>(asObject(slotBase));
    return JSDOMCoreException::getConstructor(exec, domObject->globalObject());
}
JSValue JSDOMCoreException::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMCoreExceptionConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsDOMCoreExceptionPrototypeFunctionToString(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDOMCoreException::s_info))
        return throwError(exec, TypeError);
    JSDOMCoreException* castedThisObj = static_cast<JSDOMCoreException*>(asObject(thisValue));
    DOMCoreException* imp = static_cast<DOMCoreException*>(castedThisObj->impl());


    JSC::JSValue result = jsString(exec, imp->toString());
    return result;
}

// Constant getters

JSValue jsDOMCoreExceptionINDEX_SIZE_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue jsDOMCoreExceptionDOMSTRING_SIZE_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue jsDOMCoreExceptionHIERARCHY_REQUEST_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(3));
}

JSValue jsDOMCoreExceptionWRONG_DOCUMENT_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(4));
}

JSValue jsDOMCoreExceptionINVALID_CHARACTER_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(5));
}

JSValue jsDOMCoreExceptionNO_DATA_ALLOWED_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(6));
}

JSValue jsDOMCoreExceptionNO_MODIFICATION_ALLOWED_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(7));
}

JSValue jsDOMCoreExceptionNOT_FOUND_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(8));
}

JSValue jsDOMCoreExceptionNOT_SUPPORTED_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(9));
}

JSValue jsDOMCoreExceptionINUSE_ATTRIBUTE_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(10));
}

JSValue jsDOMCoreExceptionINVALID_STATE_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(11));
}

JSValue jsDOMCoreExceptionSYNTAX_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(12));
}

JSValue jsDOMCoreExceptionINVALID_MODIFICATION_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(13));
}

JSValue jsDOMCoreExceptionNAMESPACE_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(14));
}

JSValue jsDOMCoreExceptionINVALID_ACCESS_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(15));
}

JSValue jsDOMCoreExceptionVALIDATION_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(16));
}

JSValue jsDOMCoreExceptionTYPE_MISMATCH_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(17));
}

JSValue jsDOMCoreExceptionSECURITY_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(18));
}

JSValue jsDOMCoreExceptionNETWORK_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(19));
}

JSValue jsDOMCoreExceptionABORT_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(20));
}

JSValue jsDOMCoreExceptionURL_MISMATCH_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(21));
}

JSValue jsDOMCoreExceptionQUOTA_EXCEEDED_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(22));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DOMCoreException* object)
{
    return getDOMObjectWrapper<JSDOMCoreException>(exec, globalObject, object);
}
DOMCoreException* toDOMCoreException(JSC::JSValue value)
{
    return value.inherits(&JSDOMCoreException::s_info) ? static_cast<JSDOMCoreException*>(asObject(value))->impl() : 0;
}

}
