///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// usage:
//	mkgeo_grid -t 10 > square.geo
//      ./fixed_bug_form_bdr_weight_p2_tst square.geo P2 top
// fixed bug with P2 on 2D domains
#include "rheolef.h"
using namespace rheolef;
using namespace std;
int main(int argc, char**argv) {
  geo  omega_h (argv[1]);
  string approx = argv[2];
  domain boundary = omega_h[argv[3]];
  space Wh (omega_h, boundary, approx);
  field w0h (Wh, 1.);
  form mwh (Wh, Wh, "mass", w0h);
  return 0;
}
