///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/rheolef.h"
using namespace rheolef;
using namespace std;

int main() {
    typedef reference_element::size_type size_type;
    char elt[] = { 'p', 'e', 't', 'q', 'T', 'P', 'H' };

    for (size_type k = 0; k < reference_element::max_size; k++) {
      geo_element K;
      K.set_name(elt[k]);
      cout << K.name() << endl; 
      for (size_type d = 0; d < 4; d++) {
 	 cout << "   subgeo " << d << "D: " << endl; 
         for (size_type i = 0; i < reference_element::max_n_subgeo; i++) {
 	   cout << "    " << i << ": "; 
           for (size_type j = 0; j < reference_element::max_subgeo_vertex; j++) {
 	     size_type vertex = K.subgeo_local_vertex (d,i,j);
	     if (vertex == reference_element::not_set) 
	        cout << "_";
	     else
	        cout << int(vertex);
	   }
	   cout << endl;
         }
      }
   }
   return 0;
}

