#include "rheolef/rheolef.h"
using namespace rheolef;
using namespace std;

Float epsilon;

Float u (const point& x) { 
  if (x[0] < Float(0.5)) 
    return x[0]*((1+3*epsilon)/(2*(1+epsilon)) - x[0])/(2*epsilon);
  else
    return (1-x[0])*(x[0] + (1-epsilon)/(2*(1+epsilon)))/2;
}
int main(int argc, char**argv)
{
  field uh;
  cin >> catchmark("epsilon") >> epsilon
      >> catchmark("u")       >> uh;
  space Vh = uh.get_space();
  field pi_h_u = interpolate(Vh, u);
  field eh = pi_h_u - uh;
  form m(Vh, Vh, "mass");
  Float error_linf = eh.max_abs();
  Float error_l2   = sqrt(m(eh,eh));
  cerr << "error_linf "  << error_linf << endl
       << "error_l2   "  << error_l2   << endl;
  Float tol = 1e-5;
  return (error_linf < tol) && (error_l2 < tol) ? 0 : 1;
}
