/*
*  Rubrica
*  file: 
*
*  
*  Copyright (C) 2000-2005 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include "libral/libral.h"

#include "app.h"
#include "personal_gui.h"
#include "company_gui.h"

void cards_modify_personal_card (RubricaApp* app, RAbook* book, RCard* old);
void cards_modify_company_card  (RubricaApp* app, RAbook* book, RCard* old);



void 
cards_modify_personal_card (RubricaApp* app, RAbook* book, RCard* old)
{
  RPersonalCard* newcard = NULL;
  PersonalDialog* form = NULL;  
  
  form = rubrica_personal_dialog_new(app);
  
  rubrica_personal_display_card_data(form, old);
  newcard = rubrica_personal_run_modify_dialog(form);
  
  if (newcard)
    r_abook_replace_card(R_ABOOK(book), old, R_CARD(newcard));
}



void 
cards_modify_company_card  (RubricaApp* app, RAbook* book, RCard* old)
{
  RCompanyCard* newcard = NULL;
  CompanyDialog* form = NULL;  

  form = rubrica_company_dialog_new(app);
  
  rubrica_company_display_card_data(form, old);
  newcard = rubrica_company_run_modify_dialog(form);
  
  if (newcard)
    r_abook_replace_card(R_ABOOK(book), old, R_CARD(newcard));
}



void  
cards_append_personal_card (RubricaApp* app)
{
  PersonalDialog* form;

  form = rubrica_personal_dialog_new(app);
  
  rubrica_personal_run_add_dialog(form); 
}

void 
cards_append_company_card  (RubricaApp* app)
{
  CompanyDialog* form;  
  
  form = rubrica_company_dialog_new(app);
  
  rubrica_company_run_add_dialog(form);   
}


void
cards_modify_card (RubricaApp* app, RAbook* book, RCard* card)
{
  gchar* type;

  g_object_get(card, "card-type", &type, NULL);

  if (g_ascii_strcasecmp(type, "personal") == 0)
    cards_modify_personal_card (app, book, card);
  else
    cards_modify_company_card (app, book, card);  
}
