/* $Id: eth.h,v 1.6 2003/05/30 00:42:40 cgd Exp $ */

/*
 * Copyright 2001, 2003
 * Broadcom Corporation. All rights reserved.
 *
 * This software is furnished under license and may be used and copied only
 * in accordance with the following terms and conditions.  Subject to these
 * conditions, you may download, copy, install, use, modify and distribute
 * modified or unmodified copies of this software in source and/or binary
 * form. No title or ownership is transferred hereby.
 *
 * 1) Any source code used, modified or distributed must reproduce and
 *    retain this copyright notice and list of conditions as they appear in
 *    the source file.
 *
 * 2) No right is granted to use any trade name, trademark, or logo of
 *    Broadcom Corporation.  The "Broadcom Corporation" name may not be
 *    used to endorse or promote products derived from this software
 *    without the prior written permission of Broadcom Corporation.
 *
 * 3) THIS SOFTWARE IS PROVIDED "AS-IS" AND ANY EXPRESS OR IMPLIED
 *    WARRANTIES, INCLUDING BUT NOT LIMITED TO, ANY IMPLIED WARRANTIES OF
 *    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 *    NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT SHALL BROADCOM BE LIABLE
 *    FOR ANY DAMAGES WHATSOEVER, AND IN PARTICULAR, BROADCOM SHALL NOT BE
 *    LIABLE FOR DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *    BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *    WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *    OR OTHERWISE), EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ETH_H
#define _ETH_H

#include "port.h"
#include "mbuf.h"

#define ETH_ADDR_BROADCAST  UINT64_C(0xffffffffffff)

#define ETH_FRAME_TYPE_ARP    0x806
#define ETH_FRAME_TYPE_IP     0x800

/*
 * Receive packets for timeout microseconds, or until whatever flag points at gets set.
 * Dispatch packets to appropriate handlers
 */
void eth_recv_loop(unsigned int timeout, unsigned int *flag);

/* 
 * Encapulate the passed packet in ethernet headers and send it to the wire
 */
void eth_send_packet(mbuf_t *mbuf, uint64_t dest_mac, uint64_t src_mac, uint16_t length);


/* 
 * Add a potential handler to the start of the handler chain.  Returns 0 on success 
 */
void eth_add_handler(int (*handler)(mbuf_t *mbuf, void *data, uint16_t frame_type), 
		     void *data, uint16_t frame_type);

/*
 *  Remove a handler from the list.  The handler to be removed must match
 *  both the function pointer and the data pointer.  Error if not found 
 */
void eth_del_handler(int (*handler)(mbuf_t *mbuf, void *data, uint16_t frame_type), 
		     void *data, uint16_t frame_type);


/*
 * For calling from within handlers, reset the timeout for the recieve loop
 * to this value 
 */

void eth_reset_timeout(uint64_t new_timeout);

#endif
