/* Sigma - Simple greedy multiple alignment */
/* Copyright (C) 2007 Rahul Siddharthan     */
/* Licensed under the GNU GPL, version 2    */
/* See file COPYING in source distribution  */

#include <stdlib.h>
#include <string.h>
#include "sigma.h"
#include "fasta.h"
#include "setbgw.h"
#include "commonroutines.h"

void initseqfrags(params *v, GArray *seqs)
{
    int n,nfrags,m,m2,len,len1;
    fastaseq *oneseq;
    seq_frag *onefrag, *lastfrag;

    v->seqfraglist = g_ptr_array_new();
    v->seqheadlist = g_ptr_array_new();

    for (n=0; n<seqs->len; n++) {
        oneseq= &g_array_index(seqs,fastaseq,n);

        nfrags = 1;
        while (((oneseq->seq->len)/nfrags) > v->maxfraglen)
            nfrags++;
        len = (oneseq->seq->len)/nfrags;
        len1 = oneseq->seq->len - len*(nfrags-1);

        lastfrag=NULL;
        for (m=0; m<nfrags; m++) {
            onefrag = new_seqfrag(v);
            if (m==nfrags-1)
                onefrag->seqlen = len1;
            else
                onefrag->seqlen = len;
        
            onefrag->nseqs=1;
            onefrag->seqindex[0] = n;        

            onefrag->seq[n] = (oneseq->seq->str) + m*len;

            onefrag->aseq = malloc(sizeof(char)*(onefrag->seqlen + 1));
            strncpy(onefrag->aseq,onefrag->seq[n],onefrag->seqlen);

            setbgw(v,onefrag);

            onefrag->seqlabel[n] = malloc((4+m)*sizeof(char));
            onefrag->seqlabel[n][0] = '0';
            onefrag->seqlabel[n][1] = '.';
            for (m2=0; m2<nfrags-m-1; m2++)
                onefrag->seqlabel[n][2+m2] = '0';
            onefrag->seqlabel[n][1+nfrags-m] = '1';
            onefrag->seqlabel[n][2+(nfrags-m)] = '\0';

            onefrag->neighbours_l[n] = lastfrag;
            if (lastfrag)
                lastfrag->neighbours_r[n] = onefrag;

            g_ptr_array_add((v->seqfraglist),onefrag);
            if (m==0)
                g_ptr_array_add((v->seqheadlist),onefrag);
            lastfrag=onefrag;
        }
        
    }
}

