# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2010, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: document abstraction

=end
module SiSU_document_structure_code
  class Instantiate < SiSU_Param::Parameters::Instructions
    @@flag={} #Beware!!
    def initialize
      @@flag['table_to']=false
      @@counter=@@column=@@columns=0
      @@line_mode=''
    end
  end
  class Code
    @@flag={} #Beware!!
    def initialize(md,data)
      @md,@data=md,data
      Instantiate.new
    end
    def code
      data=@data
      tuned_file=[]
      @tuned_group=[]
      @@counter=0
      @verse_count=0
      data.each do |para|
        para.gsub!(/(#{Mx[:gr_o]}(?:code|verse|alt|group)#{Mx[:gr_c]})\s/,'\1') #double check
        para.gsub!(/(?:\n\s*\n)+/m,"\n") unless @@flag['code']
        if para =~/^code\{/ and not @@flag['code']
          @@flag['code']=true
          @@counter=1
          para.gsub!(/^code\{.*/,"#{Mx[:gr_o]}code#{Mx[:gr_c]}")
        elsif para =~/^(?:poem)\{/ \
        and not @@flag['code']
          @@flag['poem']=true
          para.gsub!(/^(poem)\{.*/,"#{Mx[:gr_o]}verse#{Mx[:gr_c]}")
        elsif para =~/^(?:alt|group)\{/ \
        and not @@flag['code'] #group not tested, stub 2005
          @@flag['group']=true
          para.gsub!(/^(alt|group)\{.*/,"#{Mx[:gr_o]}\\1#{Mx[:gr_c]}")
        end
        if @@flag['code']
          if @@flag['code'] \
          and para =~/^\}code/
            para.gsub!(/^\}code.*/,"#{Mx[:gr_o]}code-end#{Mx[:gr_c]}")
            @@flag['code']=false
          end
          if @@flag['code'] \
          or para =~/#{Mx[:gr_o]}code-end#{Mx[:gr_c]}/ #and para =~/\S/
            sub_array=if para !~/#{Mx[:gr_o]}code(?:-end)?#{Mx[:gr_c]}/; para.dup + "#{Mx[:br_nl]}"
            else para.dup
            end
            @line_mode=sub_array.scan(/.+/)
            #@line_mode=[]
            #sub_array.scan(/.+/) {|w| @line_mode << w + '<:br>' if w =~/[\Ss]+/}
            SiSU_document_structure_code::Code.new(@md,@line_mode).code_lines('code')
            para=@line_mode.join
          end
        elsif ( @@flag['poem'] \
        or @@flag['group'] ) \
        and not @@flag['code']
          if @@flag['poem'] \
          and para =~/^\}(?:poem)/
            para.gsub!(/^\}(poem).*/,"\n#{Mx[:gr_o]}verse-end#{Mx[:gr_c]}")
            @@flag['poem']=false
          elsif ( @@flag['group'] \
          and para =~/^\}(?:alt|group)/ ) \
          and not @@flag['code']
            para.gsub!(/^\}(alt|group).*/,"#{Mx[:gr_o]}\\1-end#{Mx[:gr_c]}")
            @@flag['group']=false
          end
          if @@flag['poem'] \
          or @@flag['group'] \
          and para =~/\S/ \
          and para !~/#{Mx[:gr_o]}(verse|code|alt|group)(-end)?#{Mx[:gr_c]}/ \
          and not @@flag['code']
            sub_array=para.dup
            @line_mode=sub_array.scan(/.+/)
            type=if @@flag['poem']; 'poem'
            else 'group'
            end
            SiSU_document_structure_code::Code.new(@md,@line_mode).code_lines(type)
            div=if @@flag['poem'] \
            and @verse_count > 0
              "\n" + "#{Mx[:gr_o]}verse-end#{Mx[:gr_c]}" + "\n\n" + "#{Mx[:gr_o]}verse#{Mx[:gr_c]}"
            else ''
            end
            @verse_count+=1 if @@flag['poem']
            para = div + @line_mode.join
          else para
          end
        end
        if @@flag['code'] \
        or @@flag['poem'] \
        or  @@flag['group']
          @tuned_group << para if para =~/\S+/
        elsif para =~/#{Mx[:gr_o]}(?:code|alt|group|verse)-end#{Mx[:gr_c]}/
          @verse_count=0
          @tuned_group << para
          tuned_file <<= if para =~/#{Mx[:gr_o]}group-end#{Mx[:gr_c]}/
            @tuned_group.join("\n")
          else @tuned_group=@tuned_group.join
            @tuned_group.gsub!(/#{Mx[:br_nl]}#{Mx[:br_nl]}(#{Mx[:gr_o]}code-end#{Mx[:gr_c]})/,'\1')
            @tuned_group
          end
          @tuned_group=[]
        else tuned_file << para
        end
      end
      tuned_file
    end
    def code_lines(type='')
      data=@data
      data.each do |line|
        if line =~/\S/ \
        and line !~/^code\{|^\}code|#{Mx[:gr_o]}code.+/
          line.gsub!(/\s\s/,"#{Mx[:nbsp]}#{Mx[:nbsp]}")
          line.gsub!(/^/,"#{Mx[:gr_o]}codeline#{Mx[:gr_c]}") if type=='code' # try sort for texpdf special case
          if line =~/(?:https?|file|ftp):\/\/\S+$/
            line.gsub!(/$/," #{Mx[:br_nl]}")
          else line.gsub!(/$/,"#{Mx[:br_nl]}") #unless type=='code'
          end
          if @@flag['code']; @@counter+=1
          else
          end
        elsif line =~/^\s*$/
          line.gsub!(/$/,"#{Mx[:br_nl]}")
        end
      end
    end
  end
end
__END__
