# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2010, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: html segment generation, processing

=end
module SiSU_HTML_seg
  require "#{SiSU_lib}/shared_html"
  require "#{SiSU_lib}/html"
  require "#{SiSU_lib}/html_promo"
  class Seg_output
    def initialize(md,outputfile,seg,minitoc,type='')
      @md,@output_seg_file,@seg,@minitoc,@type=md,outputfile,seg,minitoc,type
    end
    def output #CONSIDER
      if @seg[:title] =~/\S/
        filename_seg=[]
        filename_seg << @seg[:title] << @seg[:tocband_banner]
        if @type =~/endnote/
          @seg[:headers]=[]
          format_head_seg=SiSU_HTML_Format::Head_seg.new(@md)
          @seg[:headers] << format_head_seg.title_banner(@md.title,@md.subtitle,@author)
          txt_obj={:txt =>'Endnotes',:ocn_display =>''}
          format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
          @seg[:headers] << format_seg.title_header1
          filename_seg << @seg[:header_endnotes] << @minitoc << @seg[:headers] << %{\n<div class="content">\n} << @seg[:endnote_all] << '</div>' # << '</div>'
        elsif @type =~/idx/
          @seg[:headers]=[]
          format_head_seg=SiSU_HTML_Format::Head_seg.new(@md)
          @seg[:headers] << format_head_seg.title_banner(@md.title,@md.subtitle,@author)
          txt_obj={:txt =>'Index',:ocn_display =>''}
          format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
          @seg[:headers] << format_seg.title_header1
          filename_seg << @seg[:header_idx] << @minitoc << @seg[:headers] << %{\n<div class="content">\n} << @seg[:idx] << '</div>' # << '</div>'
        else
          filename_seg << @minitoc <<  @seg[:headers] << @seg[:main] << "\n</div>\n"
        end
        filename_seg << @seg[:tail] << @seg[:tocband_bannerless] << @seg[:credits]
        filename_seg.flatten!.compact!
        filename_seg.each do |para|
          unless para =~/\A\s*\Z/
            para.strip!
            @output_seg_file << para
          end
        end
        @output_seg_file.close
      end
    end
  end
  class Seg
    @@seg,@@seg_subtoc,@@seg_endnotes,@@seg_ad={},{},{},{}
    @@seg_name,@@seg_name_html=[],[]
    @@seg_url=@@fn=@@get_hash_to=@@get_hash_fn=''
    @@loop_count=@@seg_total=@@tracker=0
    @@is4=@@is3=@@is2=@@is1=0
    @@header1=@@header2=@@header3=@@header4=0
    @@seg[:tocband_banner],@@seg[:tocband_bannerless],@@seg[:title],@@seg[:headers],@@seg[:main],@@seg[:idx],@@seg[:tail],@@seg[:credits],@@seg_subtoc_array,@@seg_endnotes_array,@@seg[:endnote_all]=Array.new(11){[]}
    @@seg[:header_endnotes]=''
    @@tablehead,@@number_of_cols=0,0
    @@flag_alt=false
    @@dp,@@segtocband=nil,nil
    @@fns_previous=''
    attr_reader :seg_name_html,:seg_name_html_tracker
    def initialize(data='',md='')
      @data,@md=data,md
      @vz=SiSU_Env::Get_init.instance.skin
      @seg_name_html=@@seg_name_html || nil
      @seg_name_html_tracker=@@tracker || nil
      @dp=@@dp ||=SiSU_Env::Info_env.new.digest.pattern
    end
    def songsheet
      begin
        @minitoc=SiSU_HTML::Source::Toc.new(@data,@md).minitoc
        data=get_subtoc_endnotes(@data)
        data=articles(data)
        Seg.new.cleanup # (((( added ))))
        #### (((( END )))) ####
      rescue; SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
      ensure
        @@seg_name=[]
      end
    end
  protected
    def articles(data)
      track,tracking,newfile=0,0,0
      @@is4=@@is3=@@is2=@@is1=0
      printed_endnote_seg='n'
      idx_html=nil
      if @md.book_idx
        my_make_source_file=SiSU_Env::Create_file.new(@md.cmd,@md.fns)
        idx_html=SiSU_Particulars::Combined_singleton.instance.get_html_idx(@md.opt).html_idx
        idx_html.each {|x| @@seg[:idx] << x }
        @@seg[:header_idx]=''
      end
      data.each do |para|
        if para =~/^#{Mx[:lv_o]}4:/
          @@seg_name << para[/^#{Mx[:lv_o]}4:(\S+?)#{Mx[:lv_c]}/,1]
          seg_name=para[/^#{Mx[:lv_o]}4:(\S+?)#{Mx[:lv_c]}/,1]
          @@seg_ad[seg_name]=para[/.+?<:\d\s+(.+)\s*?>/,1] #watch
        end
      end
      @@seg_name_html=@@seg_name
      @@seg_total=@@seg_name.length
      testforartnum=@@seg_name_html
      tell=SiSU_Screen::Ansi.new(@md.cmd,@@seg_name.length)
      tell.segmented unless @md.cmd =~/q/
      flagend='y'
      data.each do |para|
        if para =~/^#{Mx[:lv_o]}4:/ #watch
          if para =~/#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
            @@header4=para.to_s[/^#{Mx[:lv_o]}4:\S+?#{Mx[:lv_c]}(.+?)#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/,1]
          else @@header4=para.to_s[/^#{Mx[:lv_o]}4:\S+?#{Mx[:lv_c]}(.+)/,1]
          end
          @@is4=newfile=1
        end
        if para =~/^#{Mx[:lv_o]}3:\S*?#{Mx[:lv_c]}/
          @@header3=para.to_s[/^#{Mx[:lv_o]}3:\S*?#{Mx[:lv_c]}\s*?(.+)/,1]
          @@is4,@@is3=0,1
        end
        if para =~/^#{Mx[:lv_o]}2:\S*?#{Mx[:lv_c]}/
          @@header2=para.to_s[/^#{Mx[:lv_o]}2:\S*?#{Mx[:lv_c]}\s*?(.+)/,1]
          @@is4,@@is3,@@is2=0,0,1
        end
        if para =~/^#{Mx[:lv_o]}1:\S*?#{Mx[:lv_c]}/
          @@header1=para.to_s[/^#{Mx[:lv_o]}1:\S*?#{Mx[:lv_c]}\s*?(.+)/,1]
          @@is4,@@is3,@@is2,@@is1=0,0,0,1
        end
        if (@@is1 && !@@is2 && !@@is3 && !@@is4)
          unless para =~/^#{Mx[:lv_o]}1:/; head1=$_ #;
          end
        end
        if @@is4 == 1 \
        or para =~/^#{Mx[:br_endnotes]}|^#{Mx[:br_eof]}/ \
        or para =~/^#{Mx[:mk_o]}4:metadata#{Mx[:mk_c]}/
          m=para[/^#{Mx[:lv_o]}4:(metadata)#{Mx[:lv_c]}/]; @@get_hash_fn=$1 if m
          if newfile == 1 \
          or para =~/^#{Mx[:br_endnotes]}|^#{Mx[:br_eof]}/
            newfile=0
            if para =~/^#{Mx[:lv_o]}4:\S+?#{Mx[:lv_c]}/ \
            or para =~/^#{Mx[:br_endnotes]}|^#{Mx[:br_eof]}/ # @@level4
              if tracking != 0
                mkdir_p(@md.dir_out) unless FileTest.directory?(@md.dir_out) #bug - added specifically for nav! not needed by regular seg, check !!!
                Seg.new('',@md).tail
                segfilename="#{@md.dir_out}/#{@md.fnl[:pre]}#{@@seg_name_html[tracking-1]}#{@md.fnl[:mid]}#{Sfx[:html]}#{@md.fnl[:post]}"
                @output_seg_file=File.new(segfilename,'w') if @@seg_name_html[tracking-1]
                if @@seg_name_html[tracking-1] !~/endnotes|idx/
                  Seg_output.new(@md,@output_seg_file,@@seg,@minitoc).output
                elsif @@seg_name_html[tracking-1] =~/endnotes/
                  Seg_output.new(@md,@output_seg_file,@@seg,@minitoc,'endnotes').output
                elsif @@seg_name_html[tracking-1] =~/idx/
                  Seg_output.new(@md,@output_seg_file,@@seg,@minitoc,'idx').output
                  @@seg[:idx]=[]
                else p 'check'
                end
                Seg.new.reinitialise
                header_art(para)
                head(para)
                if @@seg_name_html[tracking] =~/metadata/ # this is for metadata
                  segfilename="#{@md.dir_out}/#{@md.fnl[:pre]}#{@@seg_name_html[tracking]}#{@md.fnl[:mid]}#{Sfx[:html]}#{@md.fnl[:post]}"
                  @output_seg_file=File.new(segfilename,'w')
                  Seg.new.reinitialise #BUG with items following endnote, and occurring before metadata, this becomes a bug ... work area for book index, FIX
                  flagend='x'
                  @output_seg_file.close                                         #%(((( EOF )))) -->
                end
              end
              if  tracking == 0
                header_art(para)
                head(para)
              end
            end
            tracking=tracking + 1
          end
          m=para[/.+?<a name="(\d+)">.*/]; @@get_hash_to=$1 if m              # changed 2002w42, again w44 ! & again 2003w16
          m=para[/^#{Mx[:lv_o]}4:(\S+?)#{Mx[:lv_c]}/]; @@get_hash_fn=$1 if m
          para=if para =~/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}\s*c|#{Mx[:gr_o]}(?:code|alt|verse|group)#{Mx[:gr_c]}/um; para.split(/\n/)
          else para
          end
          if para.class == String
            markup(para)
          elsif para.class == Array
            para.each do |pg|
              markup(pg)
            end
          end
          if testforartnum[tracking-1] =~/endnote/
            if printed_endnote_seg == 'n'
              printed_endnote_seg='y'
            end
          end
        end
      end
      data
    end
    def header_art(para)
      format_head_seg=SiSU_HTML_Format::Head_seg.new(@md)
      if para =~/^#{Mx[:lv_o]}[1-6]:/ #2004w27/5
        if @@tracker < @@seg_total-1; @@seg[:dot_nav]=format_head_seg.dot_control_pre_next
        else                          @@seg[:dot_nav]=format_head_seg.dot_control_pre
        end
      end
      ads=SiSU_HTML_promo::Ad.new(@md)
      @@seg[:title]=format_head_seg.head << ads.div.major
    end
    def head(para)
      clean=/<!.*?!>|#{Mx[:gr_o]}:.*?#{Mx[:gr_c]}|<:.*?>|#{Mx[:id_o]}~\d+;(?:[ohum]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
      format_head_seg=SiSU_HTML_Format::Head_seg.new(@md)
      if @@tracker < @@seg_total-1
        if @@tracker == 0; @@segtocband=format_head_seg.toc_next2 #if format_head_seg.toc_next2
        else               @@segtocband=format_head_seg.toc_pre_next2 #if format_head_seg.toc_pre_next2
        end
      else @@segtocband=format_head_seg.toc_pre2 #if format_head_seg.toc_pre2
      end
      @p_num ||= ''
      if @@is1 == 1
        @author=%{<b>#{@md.author}</b>\n} if @md.author.to_s =~/\S/
        @@seg[:tocband_banner] << format_head_seg.navigation_band(@@segtocband,@@seg[:dot_nav])
        conditional_div_close=if @@get_hash_fn =~/metadata/ #watch
          ''
        else ''
        end
        @@seg[:tocband_bannerless] << conditional_div_close << format_head_seg.navigation_band_bottom(@@segtocband,@@seg[:dot_nav])
        @@seg[:headers] << format_head_seg.seg_head_escript if SiSU_HTML_Format::Head_seg.method_defined? :seg_head_escript #debug PHP move up in text #bug
        @@seg[:headers] << format_head_seg.title_banner(@md.title,@md.subtitle,@author).gsub(clean,'')
        ocn=if @@header1[/.+?#{Mx[:id_o]}~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/]; $1
        else ''
        end
        @p_num=SiSU_HTML_Format::Paragraph_number.new(@md,ocn)
        txt_obj={:txt =>@@header1,:ocn_display =>@p_num.ocn_display}
        format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
        @@seg[:headers] << format_seg.title_header1.gsub(clean,'')
        @@header1.gsub!(/&nbsp;<a name="-[\d*+]+" href="#_[\d*+]+">&nbsp;<sup>[\d*+]+<\/sup>&nbsp;<\/a>/,'')
      end
      if @@is2 == 1
        header2=@@header2
        ocn=if header2[/.+?#{Mx[:id_o]}~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/]; $1
        else ''
        end
        @p_num=SiSU_HTML_Format::Paragraph_number.new(@md,ocn)
        txt_obj={:txt =>header2,:ocn_display =>@p_num.ocn_display}
        format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
        @@seg[:headers] << format_seg.title_header2.gsub(clean,'')
        @@header2.gsub!(/&nbsp;<a name="-[\d*+]+" href="#_[\d*+]+">&nbsp;<sup>[\d*+]+<\/sup>&nbsp;<\/a>/,'')
      end
      if @@is3 == 1
        header3=@@header3
        ocn=if header3[/.+?#{Mx[:id_o]}~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/]; $1
        else ''
        end
        @p_num=SiSU_HTML_Format::Paragraph_number.new(@md,ocn)
        txt_obj={:txt =>header3,:ocn_display =>@p_num.ocn_display}
        format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
        @@seg[:headers] << format_seg.title_header3.gsub(clean,'')
        @@header3.gsub!(/&nbsp;<a name="-[\d*+]+" href="#_[\d*+]+">&nbsp;<sup>[\d*+]+<\/sup>&nbsp;<\/a>/,'')
      end
      if @@is4 == 1
        header4=@@header4
        ocn=if header4[/.+?#{Mx[:id_o]}~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/]; $1
        else ''
        end
        @p_num=SiSU_HTML_Format::Paragraph_number.new(@md,ocn)
        txt_obj={:txt =>header4,:ocn_display =>@p_num.ocn_display}
        format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
        @@seg[:headers] << format_seg.title_header4.gsub(clean,'')
      end
      @@seg[:header_endnotes]=format_head_seg.title_endnote(@md.title,@md.subtitle,@author,@@seg[:dot_nav])
      @@tracker=@@tracker+1
    end
    def markup(para)
      @debug=[]
      para.gsub!(/(?:\s*#{Mx[:br_page]}\s*|\s*#{Mx[:br_page_new]}\s*)+/m,'')
      format_head_seg=SiSU_HTML_Format::Head_seg.new(@md)
      if para !~/^#{Rx[:meta]}/
        m=para[/.+?#{Mx[:id_o]}~(\d+);(?:[ohm]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/]
        if m
          ocn=m[1].to_s
          @p_num=SiSU_HTML_Format::Paragraph_number.new(@md,ocn)
        end
        if para =~/#{Mx[:gr_o]}(?:code|alt|verse|group)#{Mx[:gr_c]}/m \
        or @@flag_alt==true
          if para =~/#{Mx[:gr_o]}(?:code|alt|verse|group)#{Mx[:gr_c]}/m
            @group_collect=[] #unless @group_collect.class == Array
            @group_collect << @vz.margin_txt_0 + para.gsub(/#{Mx[:gr_o]}(?:code|alt|verse|group)-end#{Mx[:gr_c]}/m,'') #watch !
            @@flag_alt=true
          elsif @@flag_alt==true
            @group_collect << if para !~/#{Mx[:gr_o]}(?:code|alt|verse|group)-end#{Mx[:gr_c]}/m                  # neither ideal nor necessary sort later
              para
            else
              para.gsub(/#{Mx[:gr_o]}(?:code|alt|verse|group)-end#{Mx[:gr_c]}/m,'')
            end
          end
          if para =~/#{Mx[:gr_o]}(?:code|alt|verse|group)-end#{Mx[:gr_c]}/m
            para=@group_collect.flatten.join
            @@flag_alt=false
            @group_collect=[]
          end
        end
        if para !~/^#{Mx[:lv_o]}[1-9]:|#{Rx[:meta]}/
          if para =~/(.*)#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}(.*)/
            cont="#{$1} #{$2}" #check where $2 is other than space
            txt_obj={:txt =>cont}
            format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
            para=format_seg.no_paranum
          end
        end
        m=/#{Mx[:id_o]}~(\d+;(?:[ohmu]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp)#{Mx[:id_c]}$/
        if para =~m
          @sto=SiSU_HTML::Source::Split_text_object.new(@md,para).html_seg
          if @sto.format =~/i[1-9]|ordinary/ #watch
            txt_obj={:txt =>@sto.text}
            format_txt_obj=SiSU_HTML_Format::Format_text_object.new(@md,txt_obj)
          end
          para=case @sto.format # work area 2003w29 ||@|def lev_segname_para_ocn|
          when /^4:/; @sto.seg_lev_para_ocn.header4 # work on see Split_text_object
          when /^5:/; @sto.seg_lev_para_ocn.header5
          when /^6:/; @sto.seg_lev_para_ocn.header6
          when /^#{Mx[:gl_bullet]}/
            @sto.seg_lev_para_ocn.bullet
          when /^#{Mx[:pa_o]}:i([1-9])#{Mx[:pa_c]}#{Mx[:gl_bullet]}/  #indent levels 1-9 with bullet
            format_txt_obj.gsub_body
            para=@sto.seg_lev_para_ocn.format('li',"i#{$1}")
          when /^i([1-9])$/    #indent levels 1-9
            format_txt_obj.gsub_body
            para=@sto.seg_lev_para_ocn.format('p',"i#{$1}")
          when /^(?:verse|group|alt)$/m
            @sto.seg_lev_para_ocn.para
          when /^code$/
            @sto.seg_lev_para_ocn.code
          when /ordinary/
            if para !~/#{@vz.margin_txt_0}|#{@vz.margin_txt_1}|#{@vz.margin_txt_2}/ \
            and para !~/^#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/
              format_txt_obj.gsub_body
              @sto.seg_lev_para_ocn.para
            elsif para !~/#{@vz.margin_txt_0}|#{@vz.margin_txt_1}|#{@vz.margin_txt_2}/ \
            and para =~/^#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/
              format_txt_obj.gsub_body
              @sto.seg_lev_para_ocn.table_css_end
            else para
            end
          else para
          end
        elsif para =~/#{Mx[:tc_p]}|#{Mx[:gr_o]}T[hZ]?/u
          @sto=nil
          table=SiSU_HTML_shared::Table.new(para)
          para=table.table
        else
          para.gsub!(/#{Mx[:gl_bullet]}/,'●&nbsp;&nbsp;') #watch
          @sto=nil
        end
        if @md.flag_separate_endnotes
          para.gsub!(/"\s+href="#_(\d+)">/,%{" href=\"endnotes#{Sfx[:html]}#_\\1">})       #endnote- twice #removed file type
        end
        if para !~/#{@vz.margin_txt_w1}|#{@vz.margin_txt_w2}/
          if para[/(.*)#{Mx[:id_o]}~0;(?:u|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}(.*)/] #% watch u & m?
            one,two=$1,$2
            txt_obj={:txt =>$1.strip,:trailing =>$2.strip}
            format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
          end
          para.gsub!(/\s*(-\{{2}~\d+|<:e[:_]\d+>).*/,'')                   #potentially dagerous - removes all paragraphs with <!e_!> #?? workpoint
          if para =~/<a name="_\d+" href="#-\d+">&nbsp;<sup>/                #endnote- note-
            txt_obj={:txt =>para}
            format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
            para=format_seg.no_paranum
          end
        end
        if @sto and @sto.format=~/4:\S+/
          para.gsub!(/^\s*4:\S+\s*|<:[-_\w\d]?(-.+?-)?>|4~!.+/m,'')              #sort seg headers
          @@seg[:main] <<  %{\n<div class="content">\n}
          @@seg[:main] << para
          @@seg[:main] << @@seg_subtoc[@@get_hash_fn]                       #% insertion of sub-toc
        else
          para.gsub!(/<:[-_\w\d]?(-.+?-)?>|4~!.+/,'')
          @@seg[:main] << para unless @@flag_alt==true
        end
      end
    end
    def tail
      format_head_seg=SiSU_HTML_Format::Head_seg.new(@md)
      if @md.flag_auto_endnotes and @@seg_endnotes[@@get_hash_fn]
        @@seg[:tail] <<  %{\n<div class="content">\n<div class="endnote">\n}
        if @@seg_endnotes[@@get_hash_fn].flatten.length > 0
          @@seg[:tail] << format_head_seg.endnote_mark
          @@seg[:tail] << @@seg_endnotes[@@get_hash_fn].flatten #endnotes deposited at end of individual segments ||@|EXTRACTION OF ENDNOTES|
        end
        @@seg[:tail] << '</div>'
        @@seg[:tail] << '</div>' #this div closes div class content
      end
      #@@seg[:tail] << '</div><table summary="whitespace"><tr><td>&nbsp;</td></tr></table>'
      ads=SiSU_HTML_promo::Ad.new(@md)
      @@seg[:credits] << format_head_seg.credit << ads.div.close << ads.display << format_head_seg.html_close
    end
    def reinitialise
      @@seg[:title],@@seg[:dot_nav],@@seg[:tocband_banner],@@seg[:tocband_bannerless],@@seg[:headers],@@seg[:main],@@seg[:tail],@@seg[:credits]=Array.new(8){[]}
      @@segtocband=nil
    end
    def cleanup
      reinitialise
      @@seg_total,@@tracker=0,0
      @@seg_endnotes,@@seg_subtoc={},{}
      @@seg_endnotes_array,@@seg_subtoc_array=[],[]
      @@seg[:endnote_all]=[]
    end
    def get_subtoc_endnotes(data) #get endnotes & sub-table of contents subtoc
      data.each do |para|
        para.gsub!(/<a name=\"h\d.*?\">(.+?)<\/a>/mi,'\1')
        if @md.flag_auto_endnotes
          if para =~/^#{Mx[:lv_o]}[1234]:/ \
          and not @@fn.empty?
            @@seg_endnotes[@@fn]=[]
            @@seg_endnotes[@@fn] << @@seg_endnotes_array
            @@seg_endnotes_array=[] if para=~/^#{Mx[:lv_o]}4:/
            @@fns_previous=@md.fns if para=~/^#{Mx[:lv_o]}1:meta#{Mx[:lv_c]}/
          end
          if para =~/^#{Mx[:lv_o]}4:/                                              #%  EXTRACTION OF SUB-TOCs & SEGMENT NAME, after EXTRACTION OF ENDNOTES & SUB-TOCs
            @@seg_subtoc[@@fn]=@@seg_subtoc_array
            @@seg_subtoc_array=[]
            if para !~/^#{Mx[:lv_o]}4:metadata#{Mx[:lv_c]}/
              m=para[/^#{Mx[:lv_o]}4:(\S+?)#{Mx[:lv_c]}.+?#{Mx[:id_o]}~(\d+);(?:[oh]|4:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/]
            end
            if m;  @@fn=$1 if m # changed 2004w07          #endnotes and sub-tocs
            else
              if para !~/^#{Mx[:lv_o]}4:metadata#{Mx[:lv_c]}/
                m=para[/^#{Mx[:lv_o]}4:(\S+?)#{Mx[:lv_c]}/]
                @@fn=$1 if m # changed 2005w13
              else @@fn=''
              end
            end
          end
        end
        if para =~/^#{Mx[:lv_o]}[56]:\S*?#{Mx[:lv_c]}\s*(.+)?#{Mx[:id_o]}~(\d+);(?:h|[56]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
          para.gsub!(/&nbsp;<\/a>/,'&nbsp;')
          case para # series changed 2002w42
          when /^#{Mx[:lv_o]}5:\S*?#{Mx[:lv_c]}\s*(.+)?#{Mx[:id_o]}~(\d+);(?:h|[56]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/ #remove [u]? req by pg texts, revist
            txt_obj={:txt =>$1.strip,:ocn =>$2}
            format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
            para=format_seg.subtoc_lev5
          when /^#{Mx[:lv_o]}6:\S*?#{Mx[:lv_c]}\s*(.+)?#{Mx[:id_o]}~(\d+);(?:h|[56]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
            txt_obj={:txt =>$1.strip,:ocn =>$2}
            format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
            para=format_seg.subtoc_lev6
          end
          @@seg_subtoc_array << para
        end
        if @md.flag_auto_endnotes
          if para =~/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]})[\d*+]+ <a name="_[\d*+]+"/ \
          and not para =~/^#{Mx[:gr_o]}code#{Mx[:gr_c]}/ # endnote-
            endnote_array=[]
            if para=~/#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}/m
              endnote_array << para.scan(/#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}/m)
            end
            if para=~/#{Mx[:en_b_o]}[*]\d+\s.+?#{Mx[:en_b_c]}/m
              endnote_array << para.scan(/#{Mx[:en_b_o]}[*]\d+\s.+?#{Mx[:en_b_c]}/m)
            end
            if para=~/#{Mx[:en_b_o]}[+]\d+\s.+?#{Mx[:en_b_c]}/m
              endnote_array << para.scan(/#{Mx[:en_b_o]}[+]\d+\s.+?#{Mx[:en_b_c]}/m)
            end
            endnote_array.flatten!.compact! #check compacting
            endnote_array.each do |note|
              note_match=note.dup
              note_match_seg=note.dup
              e_n=note_match_seg[/(?:#{Mx[:en_a_o]}[\d*+]+|#{Mx[:en_b_o]}[*+]\d+)\s+(.+?)(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/m,1]
              try=e_n.split(/<br \/>/)
              try.each do |e|
                txt_obj={:txt =>e}
                format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
                note_match=if e =~/#{Mx[:pa_o]}i[1-9]#{Mx[:pa_c]}/
                  format_seg.endnote_body_indent
                else format_seg.endnote_body
                end
                @@seg_endnotes_array << note_match
              end
              try.join('<br \/>')
              #% creation of separate end segment/page of all endnotes referenced back to reference segment
              m=/(?:#{Mx[:en_a_o]}[\d*+]+|#{Mx[:en_b_o]}[*+]\d+)\s+(.+?href=")(#-[\d*+]+".+)(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/mi
              endnote_part_a=note_match_seg[m,1]
              endnote_part_b=note_match_seg[m,2]
              txt_obj={:endnote_part_a =>endnote_part_a,:endnote_part_b =>endnote_part_b}
              format_seg=SiSU_HTML_Format::Format_seg.new(@md,txt_obj)
              note_match_all_seg=format_seg.endnote_seg_body(@@fn) #BUG WATCH 200408
              @@seg[:endnote_all] << note_match_all_seg
            end
            para.gsub!(/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]}).+?(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})\s*/m,' ')
          end
        end
      end
    end
  end
end
__END__
