# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2010, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: generates naive cgi search form for search of sisu database
    (pgsql sqlite)

=end
module  SiSU_CGI                                                                 #% database building documents
  require "#{SiSU_lib}/sysenv"                             # sysenv.rb
  require "#{SiSU_lib}/cgi_pgsql"                          # cgi_pgsql.rb
    include SiSU_CGI_pgsql
  require "#{SiSU_lib}/cgi_sqlite"                         # cgi_sqlite.rb
  class SiSU_search
    def initialize(opt)
      @opt=opt
      @webserv=@opt.files[0].to_s.strip #verify @opt.files[0].class
    end
    def search_info
     a=%{
          For help on sisu search, type:
            sisu --help search
          For help on setting up hyperestraier for sisu, type:
            sisu --help hyperestraier
    }
        SiSU_Screen::Ansi.new(@opt.cmd,a).print_grey
    end
    def read
      SiSU_CGI_sqlite::SiSU_search_sqlite.new(@opt,@webserv).sqlite
      SiSU_CGI_pgsql::SiSU_search_pgsql.new(@opt,@webserv).pgsql
      search_info unless @opt.cmd =~/q/
    end
  end
end
__END__
