# coding:utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search
   constants

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2010, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/copyleft/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
Sfx={:txt=>'.txt',:html=>'.html',:xhtml=>'.xhtml',:xml=>'.xml',:epub=>'.epub',:epub_xhtml=>'.xhtml',:odt=>'.odt',:pdf=>'.pdf'}
Ax,Xx,Mx,Rx,Hx,Dx,Px,Db,Gt,Tex=Array.new(10){{}}
Ax[:tab]="\t"
Xx[:protect]='☞'
Xx[:segment]='Ф'
Mx[:meta_o],Mx[:meta_c]='〔@','〕'
Mx[:lv_o_1],Mx[:lv_o_2],Mx[:lv_o_3],Mx[:lv_o_4],Mx[:lv_o_5],Mx[:lv_o_6],Mx[:lv_o_7],Mx[:lv_o_8],Mx[:lv_o_9]=1,2,3,4,5,6,7,8,9;
Mx[:lv_o],Mx[:lv_c]='〔','〕'
Mx[:en_a_o]='【'; Mx[:en_a_c]='】'                                      #endnote Mx[:en_a_o]='~{'; Mx[:en_a_c]='}~'
Mx[:en_b_o]='〖'; Mx[:en_b_c]='〗'                                      #endnote Mx[:en_b_o]='~['; Mx[:en_b_c]=']~'
Mx[:gr_o]='〔';                                          Mx[:gr_c]='〕' #group text mark
Mx[:id_o]='〔';                                          Mx[:id_c]='〕' #object id mark
Mx[:tc_o]='『';                                          Mx[:tc_c]="』" #table row mark #Mx[:tc_c]="』\n"
Mx[:tc_p]='┆'                                                           #table col/misc mark
Mx[:pa_o]='〔';                                          Mx[:pa_c]='〕' #affects paragraph mark
Mx[:mk_o]='〔';                                          Mx[:mk_c]='〕' #generic mark
Mx[:gl_o]='〔';                                          Mx[:gl_c]='〕' #glyph
Mx[:fa_o]='〔'; Mx[:fa_o_c]='¤';                         Mx[:fa_c_o]='¤'; Mx[:fa_c]='〕'
Mx[:fa_bold_o]=       "#{Mx[:fa_o]}b#{Mx[:fa_o_c]}";     Mx[:fa_bold_c]=       "#{Mx[:fa_c_o]}b#{Mx[:fa_c]}"
Mx[:fa_italics_o]=    "#{Mx[:fa_o]}i#{Mx[:fa_o_c]}";     Mx[:fa_italics_c]=    "#{Mx[:fa_c_o]}i#{Mx[:fa_c]}"
Mx[:fa_underscore_o]= "#{Mx[:fa_o]}u#{Mx[:fa_o_c]}";     Mx[:fa_underscore_c]= "#{Mx[:fa_c_o]}u#{Mx[:fa_c]}"
Mx[:fa_cite_o]=       "#{Mx[:fa_o]}cite#{Mx[:fa_o_c]}";  Mx[:fa_cite_c]=       "#{Mx[:fa_c_o]}cite#{Mx[:fa_c]}"
Mx[:fa_insert_o]=     "#{Mx[:fa_o]}ins#{Mx[:fa_o_c]}";   Mx[:fa_insert_c]=     "#{Mx[:fa_c_o]}ins#{Mx[:fa_c]}"
Mx[:fa_strike_o]=     "#{Mx[:fa_o]}del#{Mx[:fa_o_c]}";   Mx[:fa_strike_c]=     "#{Mx[:fa_c_o]}del#{Mx[:fa_c]}"
Mx[:fa_superscript_o]="#{Mx[:fa_o]}sup#{Mx[:fa_o_c]}";   Mx[:fa_superscript_c]="#{Mx[:fa_c_o]}sup#{Mx[:fa_c]}"
Mx[:fa_subscript_o]=  "#{Mx[:fa_o]}sub#{Mx[:fa_o_c]}";   Mx[:fa_subscript_c]=  "#{Mx[:fa_c_o]}sub#{Mx[:fa_c]}"
Mx[:fa_hilite_o]=     "#{Mx[:fa_o]}hi#{Mx[:fa_o_c]}";    Mx[:fa_hilite_c]=     "#{Mx[:fa_c_o]}hi#{Mx[:fa_c]}"
Mx[:fa_monospace_o]=  "#{Mx[:fa_o]}mono#{Mx[:fa_o_c]}";  Mx[:fa_monospace_c]=  "#{Mx[:fa_c_o]}mono#{Mx[:fa_c]}"
Mx[:gl_bullet]=       "#{Mx[:gl_o]}●#{Mx[:gl_c]}"
  Mx[:pa_non_object_dummy_heading]="#{Mx[:pa_o]}-##{Mx[:pa_c]}" #unnumbered paragraph, delete when not required [used in dummy headings, eg. for segmented html] (place marker at end of paragraph)
  Mx[:pa_non_object_no_heading]="#{Mx[:pa_o]}~##{Mx[:pa_c]}" #unnumbered paragraph (place marker at end of paragraph)
Mx[:idx_o]='▢ ';                                         Mx[:idx_c]='▢ ' #
Mx[:nbsp]=            '░' #'▭ '
Mx[:br_line]=         '▌' #lB ▌  9612 #'┘' #'¶'
Mx[:br_paragraph]=    '█' #FB █  9608 # PP ∥  8741 #'▐'  #'┘' #'¶' #FB █  9608  lB ▌  9612   RB ▐  9616
Mx[:br_nl]=           '』' #   '┘'
Mx[:br_page]=         'break_page';                      Hx[:br_page]=        {:obj=>Mx[:br_page]}      # newpage
Mx[:br_page_new]=     'break_page_new';                  Hx[:br_page_new]=    {:obj=>Mx[:br_page_new]}  # clearpage
Mx[:br_endnotes]=     "#{Mx[:mk_o]}ENDNOTES#{Mx[:mk_c]}"
Mx[:br_eof]=          "#{Mx[:mk_o]}EOF#{Mx[:mk_c]}"
Mx[:lnk_o]='⌠'; Mx[:lnk_c]='⌡' #'⌈' '⌋' '⌠' '⌡' #Mx[:lnk_o]='◁'; Mx[:lnk_c]='▷' #‹ ›
Mx[:url_o]='「'; Mx[:url_c]='」'
Mx[:rel_o]='⌈'; Mx[:rel_c]='⌋'
Mx[:tag_o]='⌊'; Mx[:tag_c]='⌉'
Mx[:sm_set_o]='《'; Mx[:sm_set_c]='》'
Mx[:sm_subset_o]='《 '; Mx[:sm_subset_c]='》'
Mx[:vline]='┆' #  ¦ |
#Mx[:sm_set_o]='∈ '; Mx[:sm_set_c]='∋ '
#Mx[:sm_subset_o]='∈ '; Mx[:sm_subset_c]='∋ '
Rx[:mx_fa_clean]=     /#{Mx[:fa_o]}.+?#{Mx[:fa_c]}|#{Mx[:pa_o]}.+?#{Mx[:pa_c]}|#{Mx[:mk_o]}.+?#{Mx[:mk_c]}/
Rx[:lv],Rx[:lv_1],Rx[:lv_2],Rx[:lv_3],Rx[:lv_4],Rx[:lv_5],Rx[:lv_6],Rx[:lv_7],Rx[:lv_8],Rx[:lv_9]=
  /〔([1-9]):(\S*?)〕/,/#{Mx[:lv_o_1]}(\S*?)#{Mx[:lv_c]}/,/#{Mx[:lv_o_2]}(\S*?)#{Mx[:lv_c]}/,/#{Mx[:lv_o_3]}(\S*?)#{Mx[:lv_c]}/,/#{Mx[:lv_o_4]}(\S*?)#{Mx[:lv_c]}/,/#{Mx[:lv_o_5]}(\S*?)#{Mx[:lv_c]}/,/#{Mx[:lv_o_6]}(\S*?)#{Mx[:lv_c]}/,/#{Mx[:lv_o_7]}(\S*?)#{Mx[:lv_c]}/,/#{Mx[:lv_o_8]}(\S*?)#{Mx[:lv_c]}/,/#{Mx[:lv_o_9]}(\S*?)#{Mx[:lv_c]}/
Rx[:meta]=/#{Mx[:meta_o]}(\S+?)#{Mx[:meta_c]}/
Dx[:url_o]='‹';   Dx[:url_c]='›'
Dx[:url_o_xml]='&lt;';   Dx[:url_c_xml]='&gt;'
Dx[:rel_o]='‹';   Dx[:rel_c]='›' # Dx[:rel_o]='「';   Dx[:rel_c]='」'
Tex[:backslash]="\\\\"
Tex[:backslash]="\\\\"
Tex[:tilde]='\\\\\\~'
#Px[:emphasis_o]=   '*';     Px[:emphasis_c]=   '*'
#Px[:bold_o]=       '!';     Px[:bold_c]=       '!'
Px[:bold_o]=       '*';     Px[:bold_c]=       '*'
Px[:italics_o]=    '/';     Px[:italics_c]=    '/'
Px[:underscore_o]= '_';     Px[:underscore_c]= '_'
Px[:cite_o]=       '"';     Px[:cite_c]=       '"'
Px[:insert_o]=     '+';     Px[:insert_c]=     '+'
Px[:strike_o]=     '-';     Px[:strike_c]=     '-'
Px[:superscript_o]='^';     Px[:superscript_c]='^'
Px[:subscript_o]=  '[';     Px[:subscript_c]=  ']'
Px[:hilite_o]=     '*';     Px[:hilite_c]=     '*'
Px[:monospace_o]=  '';      Px[:monospace_c]=  ''
Px[:lv1]=     '*'
Px[:lv2]=     '='
Px[:lv3]=     '='
#Px[:lv2_3]=   '='
Px[:lv4]=     '-'
Px[:lv5]=     '.'
Px[:lv6]=     '.'
#Px[:lv5_6]=   '.'
Db[:name_prefix]="SiSU#{SiSU_version_dir}c_"
Db[:name_prefix_db]="sisu_#{SiSU_version_dir}c_"
Db[:col_title]=800
Db[:col_title_part]=400
Db[:col_title_edition]=10
Db[:col_name]=600
Db[:col_creator_misc_short]=100
Db[:col_language]=100
Db[:col_language_char]=3
Db[:col_date_text]=10
Db[:col_classify_txt_long]=600
Db[:col_classify_txt_short]=600
Db[:col_classify_short]=200
Db[:col_classify_identify]=256
Db[:col_classify_library]=30
Db[:col_classify_small]=16
Db[:col_filename]=256
Db[:col_digest]=64
Db[:col_filesize]=10
Db[:col_info_note]=2500
Gt[:grotto]='sisu:'
Gt[:txt]='txt'
Gt[:image]='images'
Gt[:conf]='conf'
__END__
consider:
  〔comment〕
  〔links?????〕
   import document?
check:
  bold line

┆┆⋮┇┊┋
『』
「」
〔〕
【】

·
¤
 #˝ " λ Ω  β   α π  Ѫ Ж  Я Ѳ  ѳ   Ф ㈣
 Ѳ  ѳ   Ф
 ♩ ♭   ✠   ▭  ▬   ▪
【】〖〗《》「」
 ‹ › ∗ 
'〔lv1〕','〔lv2〕','〔lv3〕','〔lv4〕','〔lv5〕','〔lv6〕','〔lv7〕','〔lv8〕','〔lv9〕'
'〔 Ѳ1〕','〔 Ѳ2〕','〔 Ѳ3〕','〔 Ѳ4〕','〔 Ѳ5〕','〔Ѳ6〕','〔Ѳ7〕','〔Ѳ8〕','〔Ѳ9〕'
◁▷
◀this is text or an image▶ http://
p __FILE__ +':'+ __LINE__.to_s
p __FILE__ + ' ' + __LINE__.to_s + ' ' + html
puts "#{__FILE__} #{__LINE__} #{o.inspect}"
puts __FILE__ + ' ' + __LINE__.to_s + '-->  ' + o.inspect
puts %{-\t#{__FILE__}::#{__LINE__}::#{caller}:\n"#{name}"}
p "\t" + txt.obj + " << #{__FILE__} #{__LINE__} >>"
p (__FILE__ + ' ' + __LINE__.to_s + '--> ' + dob.inspect) if dob.is=='heading'
data.each {|o| p (__FILE__ + ' ' + __LINE__.to_s + '--> ' + o.inspect) if o.is=='heading'}
puts "#{__FILE__} #{__LINE__} #{para}" if @opt.cmd =~/M/
puts "#{__FILE__} #{__LINE__} #{t_o}" if @opt.cmd =~/M/
 dr ┌  9484   dR ┍  9485   Dr ┎  9486   DR ┏  9487   dl ┐  9488   dL ┑  9489   Dl ┒  9490   LD ┓  9491  ur └  9492   uR ┕  9493   Ur ┖  9494   UR ┗  9495   ul ┘  9496   uL ┙  9497   Ul ┚  9498   UL ┛  9499   vr ├
 dr ┌  9484   dR ┍  9485   Dr ┎  9486   DR ┏  9487   dl ┐  9488   dL ┑  9489   Dl ┒  9490   LD ┓  9491  ur └  9492   uR ┕  9493   Ur ┖  9494   UR ┗  9495   ul ┘  9496   uL ┙  9497   Ul ┚  9498   UL ┛  9499   vr ├
 └  ┘
Iu ⌠  8992   Il ⌡ <7 ⌈  8968   >7 ⌉  8969   7< ⌊  8970   7> ⌋  8971
<" 『 12302  >" 』 12303
<' 「 12300  >' 」 12301
