<?php
/**
* Smarty Internal Plugin Templateparser
*
* This is the template parser.
* It is generated from the internal.templateparser.y file
* @package Smarty
* @subpackage Compiler
* @author Uwe Tews
*/

class TP_yyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    function __construct($s, $m = array())
    {
        if ($s instanceof TP_yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof TP_yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    function __toString()
    {
        return $this->_string;
    }

    function offsetExists($offset)
    {
        return isset($this->metadata[$offset]);
    }

    function offsetGet($offset)
    {
        return $this->metadata[$offset];
    }

    function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof TP_yyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);
                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof TP_yyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    function offsetUnset($offset)
    {
        unset($this->metadata[$offset]);
    }
}

class TP_yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};


#line 12 "smarty_internal_templateparser.y"
class Smarty_Internal_Templateparser#line 79 "smarty_internal_templateparser.php"
{
#line 14 "smarty_internal_templateparser.y"

    // states whether the parse was successful or not
    public $successful = true;
    public $retvalue = 0;
    private $lex;
    private $internalError = false;

    function __construct($lex, $compiler) {
        // set instance object
        self::instance($this); 
        $this->lex = $lex;
        $this->compiler = $compiler;
        $this->smarty = $this->compiler->smarty;
        $this->template = $this->compiler->template;
        if ($this->template->security && isset($this->smarty->security_handler)) {
              $this->sec_obj = $this->smarty->security_policy;
        } else {
              $this->sec_obj = $this->smarty;
        }
        $this->compiler->has_variable_string = false;
				$this->compiler->prefix_code = array();
				$this->prefix_number = 0;
				$this->block_nesting_level = 0;
				$this->is_xml = false;
    }
    public static function &instance($new_instance = null)
    {
        static $instance = null;
        if (isset($new_instance) && is_object($new_instance))
            $instance = $new_instance;
        return $instance;
    }

    public static function escape_start_tag($tag_text) {
       $tag = preg_replace('/\A<\?(.*)\z/', '<<?php ?>?\1', $tag_text, -1 , $count); //Escape tag
       assert($tag !== false && $count === 1);
       return $tag;
    }

    public static function escape_end_tag($tag_text) {
       assert($tag_text === '?>');
       return '?<?php ?>>';
    }

    
#line 128 "smarty_internal_templateparser.php"

    const TP_VERT                           =  1;
    const TP_COLON                          =  2;
    const TP_COMMENT                        =  3;
    const TP_PHPSTARTTAG                    =  4;
    const TP_PHPENDTAG                      =  5;
    const TP_FAKEPHPSTARTTAG                =  6;
    const TP_XMLTAG                         =  7;
    const TP_OTHER                          =  8;
    const TP_LITERALSTART                   =  9;
    const TP_LITERALEND                     = 10;
    const TP_LITERAL                        = 11;
    const TP_LDEL                           = 12;
    const TP_RDEL                           = 13;
    const TP_DOLLAR                         = 14;
    const TP_ID                             = 15;
    const TP_EQUAL                          = 16;
    const TP_FOREACH                        = 17;
    const TP_PTR                            = 18;
    const TP_IF                             = 19;
    const TP_SPACE                          = 20;
    const TP_FOR                            = 21;
    const TP_SEMICOLON                      = 22;
    const TP_INCDEC                         = 23;
    const TP_TO                             = 24;
    const TP_STEP                           = 25;
    const TP_AS                             = 26;
    const TP_APTR                           = 27;
    const TP_LDELSLASH                      = 28;
    const TP_INTEGER                        = 29;
    const TP_COMMA                          = 30;
    const TP_MATH                           = 31;
    const TP_UNIMATH                        = 32;
    const TP_ANDSYM                         = 33;
    const TP_ISIN                           = 34;
    const TP_ISDIVBY                        = 35;
    const TP_ISNOTDIVBY                     = 36;
    const TP_ISEVEN                         = 37;
    const TP_ISNOTEVEN                      = 38;
    const TP_ISEVENBY                       = 39;
    const TP_ISNOTEVENBY                    = 40;
    const TP_ISODD                          = 41;
    const TP_ISNOTODD                       = 42;
    const TP_ISODDBY                        = 43;
    const TP_ISNOTODDBY                     = 44;
    const TP_INSTANCEOF                     = 45;
    const TP_OPENP                          = 46;
    const TP_CLOSEP                         = 47;
    const TP_QMARK                          = 48;
    const TP_NOT                            = 49;
    const TP_TYPECAST                       = 50;
    const TP_DOT                            = 51;
    const TP_SINGLEQUOTESTRING              = 52;
    const TP_DOUBLECOLON                    = 53;
    const TP_AT                             = 54;
    const TP_HATCH                          = 55;
    const TP_OPENB                          = 56;
    const TP_CLOSEB                         = 57;
    const TP_EQUALS                         = 58;
    const TP_NOTEQUALS                      = 59;
    const TP_GREATERTHAN                    = 60;
    const TP_LESSTHAN                       = 61;
    const TP_GREATEREQUAL                   = 62;
    const TP_LESSEQUAL                      = 63;
    const TP_IDENTITY                       = 64;
    const TP_NONEIDENTITY                   = 65;
    const TP_MOD                            = 66;
    const TP_LAND                           = 67;
    const TP_LOR                            = 68;
    const TP_LXOR                           = 69;
    const TP_QUOTE                          = 70;
    const TP_BACKTICK                       = 71;
    const TP_DOLLARID                       = 72;
    const YY_NO_ACTION = 548;
    const YY_ACCEPT_ACTION = 547;
    const YY_ERROR_ACTION = 546;

    const YY_SZ_ACTTAB = 1810;
static public $yy_action = array(
 /*     0 */   183,  280,    7,   38,  325,  217,  275,  199,   53,  119,
 /*    10 */   104,  266,  317,  156,  323,  308,  305,  309,  335,  184,
 /*    20 */   153,  298,  307,  283,  281,  193,  278,   32,  104,  319,
 /*    30 */    47,   46,   45,   39,   16,   23,  341,  337,   21,   18,
 /*    40 */   338,  339,   19,   20,  278,   43,  296,  293,  292,  288,
 /*    50 */   289,  290,  153,  157,  323,    3,   24,  348,  355,  356,
 /*    60 */   357,  358,  354,  353,  349,  350,  351,  352,  336,  183,
 /*    70 */   280,  125,  183,  117,  100,   12,   99,   51,  121,  102,
 /*    80 */   148,  322,  112,   26,  331,  168,    4,  335,  184,  191,
 /*    90 */   333,  184,  283,  281,  286,  278,  459,  184,  316,   47,
 /*   100 */    46,   45,   39,   16,   23,  341,  337,   21,   18,  338,
 /*   110 */   339,   19,   20,  294,  295,  297,   12,   12,  547,   84,
 /*   120 */   226,  295,  297,  112,  112,   36,  348,  355,  356,  357,
 /*   130 */   358,  354,  353,  349,  350,  351,  352,  336,  183,  137,
 /*   140 */    87,  280,  261,  240,  254,  182,  253,  199,   49,  118,
 /*   150 */   104,   38,  123,  286,  275,   29,  172,  184,  335,   10,
 /*   160 */   421,   13,   14,  283,  281,  277,  278,  421,   47,   46,
 /*   170 */    45,   39,   16,   23,  341,  337,   21,   18,  338,  339,
 /*   180 */    19,   20,  183,  318,   28,  280,  113,  133,  152,  282,
 /*   190 */   184,  199,   43,  202,  104,  348,  355,  356,  357,  358,
 /*   200 */   354,  353,  349,  350,  351,  352,  336,  283,  281,  306,
 /*   210 */   278,  299,   47,   46,   45,   39,   16,   23,  341,  337,
 /*   220 */    21,   18,  338,  339,   19,   20,   38,   89,   38,  275,
 /*   230 */    29,  275,  271,  238,  122,  113,  195,    2,  244,  348,
 /*   240 */   355,  356,  357,  358,  354,  353,  349,  350,  351,  352,
 /*   250 */   336,  183,  280,  125,  183,  187,  174,   12,  199,   83,
 /*   260 */   229,  104,  200,  163,  112,  419,  302,  274,  245,  335,
 /*   270 */   202,  215,  419,  184,  283,  281,   89,  278,  204,  207,
 /*   280 */   234,   47,   46,   45,   39,   16,   23,  341,  337,   21,
 /*   290 */    18,  338,  339,   19,   20,  236,   17,  232,   12,  313,
 /*   300 */     8,   38,   54,   54,  275,  112,  184,  340,  348,  355,
 /*   310 */   356,  357,  358,  354,  353,  349,  350,  351,  352,  336,
 /*   320 */   183,  280,   35,  165,  418,  100,  104,  101,   52,  121,
 /*   330 */   102,  184,   38,  326,  271,  275,  172,  196,  335,  184,
 /*   340 */    10,   13,  278,  283,  281,  359,  278,  218,  228,  183,
 /*   350 */    47,   46,   45,   39,   16,   23,  341,  337,   21,   18,
 /*   360 */   338,  339,   19,   20,  183,  344,   38,  280,  184,  211,
 /*   370 */   265,  273,  184,  199,   26,  271,  104,  348,  355,  356,
 /*   380 */   357,  358,  354,  353,  349,  350,  351,  352,  336,  283,
 /*   390 */   281,  147,  278,  274,   47,   46,   45,   39,   16,   23,
 /*   400 */   341,  337,   21,   18,  338,  339,   19,   20,  183,  208,
 /*   410 */   230,   38,   38,  327,  275,  275,   33,   40,  107,  225,
 /*   420 */   166,  348,  355,  356,  357,  358,  354,  353,  349,  350,
 /*   430 */   351,  352,  336,  224,  267,  184,  158,  323,   47,   46,
 /*   440 */    45,   39,   16,   23,  341,  337,   21,   18,  338,  339,
 /*   450 */    19,   20,  183,  210,   38,  280,  332,  185,   92,  284,
 /*   460 */   155,  199,  233,  184,  104,  348,  355,  356,  357,  358,
 /*   470 */   354,  353,  349,  350,  351,  352,  336,  283,  281,  145,
 /*   480 */   278,  201,   47,   46,   45,   39,   16,   23,  341,  337,
 /*   490 */    21,   18,  338,  339,   19,   20,  183,  324,   95,  239,
 /*   500 */   161,  323,  189,  178,  184,   43,  347,  150,  247,  348,
 /*   510 */   355,  356,  357,  358,  354,  353,  349,  350,  351,  352,
 /*   520 */   336,  286,  235,  115,  208,  268,   47,   46,   45,   39,
 /*   530 */    16,   23,  341,  337,   21,   18,  338,  339,   19,   20,
 /*   540 */   183,  312,  160,  280,  345,  203,  231,  272,  184,  199,
 /*   550 */   154,  184,  104,  348,  355,  356,  357,  358,  354,  353,
 /*   560 */   349,  350,  351,  352,  336,  283,  281,  279,  278,  188,
 /*   570 */    47,   46,   45,   39,   16,   23,  341,  337,   21,   18,
 /*   580 */   338,  339,   19,   20,  183,   37,  214,  280,  315,   93,
 /*   590 */   114,  241,  108,  199,  194,  184,  104,  348,  355,  356,
 /*   600 */   357,  358,  354,  353,  349,  350,  351,  352,  336,  283,
 /*   610 */   281,   90,  278,  255,   47,   46,   45,   39,   16,   23,
 /*   620 */   341,  337,   21,   18,  338,  339,   19,   20,  183,  300,
 /*   630 */    12,  256,  310,  271,  198,  258,  184,  112,  184,  221,
 /*   640 */   328,  348,  355,  356,  357,  358,  354,  353,  349,  350,
 /*   650 */   351,  352,  336,  213,  109,  252,  216,   11,   47,   46,
 /*   660 */    45,   39,   16,   23,  341,  337,   21,   18,  338,  339,
 /*   670 */    19,   20,  183,  303,  243,  280,  334,    4,  184,  311,
 /*   680 */   184,  199,   54,  184,  104,  348,  355,  356,  357,  358,
 /*   690 */   354,  353,  349,  350,  351,  352,  336,  283,  281,   34,
 /*   700 */   278,    9,   47,   46,   45,   39,   16,   23,  341,  337,
 /*   710 */    21,   18,  338,  339,   19,   20,   38,  196,  304,  275,
 /*   720 */    27,  262,  263,  233,  238,  184,  106,  250,    2,  348,
 /*   730 */   355,  356,  357,  358,  354,  353,  349,  350,  351,  352,
 /*   740 */   336,  183,  280,  301,  125,  291,  217,  201,  199,   64,
 /*   750 */    43,  104,  134,   43,  212,   38,  329,  162,  275,  335,
 /*   760 */   237,    6,  159,  266,  283,  281,  286,  278,   94,  135,
 /*   770 */   220,   47,   46,   45,   39,   16,   23,  341,  337,   21,
 /*   780 */    18,  338,  339,   19,   20,  183,  246,   17,  232,  330,
 /*   790 */    88,  219,    5,  274,   41,   54,  184,  257,  348,  355,
 /*   800 */   356,  357,  358,  354,  353,  349,  350,  351,  352,  336,
 /*   810 */   111,  197,  139,  276,  248,   47,   46,   45,   39,   16,
 /*   820 */    23,  341,  337,   21,   18,  338,  339,   19,   20,  183,
 /*   830 */   287,  343,  314,   22,  144,   91,  270,  184,  184,  184,
 /*   840 */   142,  227,  348,  355,  356,  357,  358,  354,  353,  349,
 /*   850 */   350,  351,  352,  336,  286,   40,  249,  303,  303,   47,
 /*   860 */    46,   45,   39,   16,   23,  341,  337,   21,   18,  338,
 /*   870 */   339,   19,   20,  183,  264,  303,  280,  303,  303,  303,
 /*   880 */   269,  116,  199,  303,  303,  104,  348,  355,  356,  357,
 /*   890 */   358,  354,  353,  349,  350,  351,  352,  336,  283,  281,
 /*   900 */   303,  278,  303,   47,   46,   45,   39,   16,   23,  341,
 /*   910 */   337,   21,   18,  338,  339,   19,   20,  167,  303,  303,
 /*   920 */   303,  303,  303,  303,  303,  303,  303,   31,   15,  303,
 /*   930 */   348,  355,  356,  357,  358,  354,  353,  349,  350,  351,
 /*   940 */   352,  336,  132,    3,  303,  105,   86,  167,  120,  303,
 /*   950 */   222,    3,  205,  110,  169,  303,  286,   31,   15,  125,
 /*   960 */   209,   98,  126,   48,  303,  131,  303,  125,  209,  129,
 /*   970 */   164,   48,  303,  303,  277,  277,  303,   25,  303,  286,
 /*   980 */    44,   42,  277,  285,  303,   30,   89,    1,   44,   42,
 /*   990 */     3,  285,  110,  175,   89,    1,  242,  151,  143,  303,
 /*  1000 */   303,   85,    3,  167,  110,  175,  125,  209,  303,   85,
 /*  1010 */    48,  286,  286,   31,   15,  136,  303,  146,  125,  209,
 /*  1020 */   303,  303,   48,  303,   30,  270,  303,   44,   42,  286,
 /*  1030 */   285,  286,  303,   89,    1,    3,   25,  113,  175,   44,
 /*  1040 */    42,  124,  285,  270,  128,   89,    1,    3,   85,  113,
 /*  1050 */   170,  125,  209,   97,  277,   48,  303,  277,   96,  303,
 /*  1060 */    85,  303,  303,  125,  179,  303,  277,   48,  303,   30,
 /*  1070 */   303,  277,   44,   42,  149,  285,  127,  303,   89,    1,
 /*  1080 */     3,   30,  110,  173,   44,   42,  303,  285,  286,  277,
 /*  1090 */    89,    1,    3,   85,  103,  175,  125,  209,  303,  303,
 /*  1100 */    48,  130,  270,  303,  303,   85,  303,  141,  125,  209,
 /*  1110 */   303,  303,   48,  303,   30,  286,  303,   44,   42,  303,
 /*  1120 */   285,  286,  303,   89,    1,    3,   30,  110,  171,   44,
 /*  1130 */    42,  303,  285,  303,  303,   89,    1,    3,   85,  113,
 /*  1140 */   175,  125,  209,  303,  303,   48,  303,  303,  303,  303,
 /*  1150 */    85,  303,  303,  125,  209,  303,  303,   48,  303,   25,
 /*  1160 */   303,  303,   44,   42,  303,  285,  303,  303,   89,    1,
 /*  1170 */     3,   30,  113,  177,   44,   42,  303,  285,  303,  303,
 /*  1180 */    89,  303,  303,   85,  303,  303,  125,  209,  303,  303,
 /*  1190 */    48,  303,  280,  303,  303,   85,  176,  303,  199,   71,
 /*  1200 */   303,  104,  303,  303,   30,  303,  303,   44,   42,  335,
 /*  1210 */   285,  303,  303,   89,  283,  281,  280,  278,  303,  303,
 /*  1220 */   217,  303,  199,   62,  303,  104,  180,  321,   85,  303,
 /*  1230 */   303,  303,  303,  335,  303,  303,  303,  303,  283,  281,
 /*  1240 */   280,  278,  303,  303,  217,  303,  199,   62,  206,  104,
 /*  1250 */   303,  303,  280,  303,  303,  303,  217,  335,  199,   62,
 /*  1260 */   303,  104,  283,  281,  280,  278,  303,  303,  176,  335,
 /*  1270 */   199,   71,  223,  104,  283,  281,  303,  278,  303,  303,
 /*  1280 */   303,  335,  303,  303,  251,  303,  283,  281,  280,  278,
 /*  1290 */   303,  303,  217,  303,  199,   62,  303,  104,  303,  320,
 /*  1300 */   280,  303,  303,  303,  217,  335,  199,   65,  303,  104,
 /*  1310 */   283,  281,  303,  278,  303,  303,  303,  335,  303,  303,
 /*  1320 */   190,  303,  283,  281,  280,  278,  303,  303,  217,  303,
 /*  1330 */   199,   73,  303,  104,  303,  303,  280,  303,  303,  303,
 /*  1340 */   217,  335,  199,   72,  303,  104,  283,  281,  280,  278,
 /*  1350 */   303,  303,  217,  335,  199,   63,  303,  104,  283,  281,
 /*  1360 */   303,  278,  303,  303,  303,  335,  303,  303,  303,  303,
 /*  1370 */   283,  281,  280,  278,  303,  303,  217,  303,  199,   70,
 /*  1380 */   303,  104,  303,  303,  280,  303,  303,  303,  217,  335,
 /*  1390 */   199,   67,  303,  104,  283,  281,  303,  278,  303,  303,
 /*  1400 */   303,  335,  303,  303,  303,  303,  283,  281,  280,  278,
 /*  1410 */   303,  303,  217,  303,  199,   75,  303,  104,  303,  303,
 /*  1420 */   280,  303,  303,  303,  217,  335,  199,   74,  303,  104,
 /*  1430 */   283,  281,  280,  278,  303,  303,  217,  335,  199,   79,
 /*  1440 */   303,  104,  283,  281,  303,  278,  303,  303,  303,  335,
 /*  1450 */   303,  303,  303,  303,  283,  281,  280,  278,  303,  303,
 /*  1460 */   217,  303,  199,   66,  303,  104,  303,  303,  280,  303,
 /*  1470 */   303,  303,  217,  335,  199,   57,  303,  104,  283,  281,
 /*  1480 */   303,  278,  303,  303,  303,  335,  303,  303,  303,  303,
 /*  1490 */   283,  281,  280,  278,  303,  303,  217,  303,  199,   76,
 /*  1500 */   303,  104,  303,  303,  280,  303,  303,  303,  217,  335,
 /*  1510 */   199,   82,  303,  104,  283,  281,  280,  278,  303,  303,
 /*  1520 */   217,  335,  181,   59,  303,  104,  283,  281,  303,  278,
 /*  1530 */   303,  303,  303,  335,  303,  303,  303,  303,  283,  281,
 /*  1540 */   280,  278,  303,  303,  217,  303,  199,   81,  303,  104,
 /*  1550 */   303,  303,  280,  303,  303,  303,  217,  335,  199,   77,
 /*  1560 */   303,  104,  283,  281,  303,  278,  303,  303,  303,  335,
 /*  1570 */   303,  303,  303,  303,  283,  281,  280,  278,  303,  303,
 /*  1580 */   217,  303,  199,   50,  303,  104,  303,  303,  280,  303,
 /*  1590 */   303,  303,  217,  335,  199,   55,  303,  104,  283,  281,
 /*  1600 */   280,  278,  303,  303,  217,  335,  199,   69,  303,  104,
 /*  1610 */   283,  281,  303,  278,  303,  303,  303,  335,  303,  303,
 /*  1620 */   303,  303,  283,  281,  280,  278,  303,  303,  217,  303,
 /*  1630 */   199,   60,  303,  104,  303,  303,  280,  303,  303,  303,
 /*  1640 */   217,  335,  199,   61,  303,  104,  283,  281,  303,  278,
 /*  1650 */   303,  303,  303,  335,  303,  303,  303,  303,  283,  281,
 /*  1660 */   280,  278,  303,  303,  217,  303,  199,   56,  303,  104,
 /*  1670 */   303,  303,  280,  303,  303,  303,  217,  335,  199,   80,
 /*  1680 */   303,  104,  283,  281,  280,  278,  303,  303,  217,  335,
 /*  1690 */   199,   68,  303,  104,  283,  281,  303,  278,  303,  303,
 /*  1700 */   303,  335,  303,  303,  303,  303,  283,  281,  280,  278,
 /*  1710 */   303,  303,  217,  303,  199,   58,  303,  104,  303,  303,
 /*  1720 */   280,  303,  303,  303,  217,  335,  199,   78,  303,  104,
 /*  1730 */   283,  281,  303,  278,  303,  303,  303,  335,  303,  303,
 /*  1740 */   303,  138,  283,  281,  280,  278,  167,  303,  192,  303,
 /*  1750 */   199,  303,  303,  104,  280,  286,   31,   15,  342,  303,
 /*  1760 */   199,  186,  303,  104,  303,  303,  283,  281,  303,  278,
 /*  1770 */   303,  346,  303,  303,  303,  303,  283,  281,  303,  278,
 /*  1780 */   140,  303,  303,  303,  280,  167,  303,  303,  259,  303,
 /*  1790 */   199,  303,  303,  104,  286,   31,   15,  303,  303,  303,
 /*  1800 */   303,  260,  303,  303,  303,  303,  283,  281,  303,  278,
    );
    static public $yy_lookahead = array(
 /*     0 */     1,   77,   30,   12,   13,   81,   15,   83,   84,   85,
 /*    10 */    86,  104,   13,  106,  107,    4,    5,    6,   94,   20,
 /*    20 */     9,   10,   11,   99,  100,   83,  102,   27,   86,   57,
 /*    30 */    31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
 /*    40 */    41,   42,   43,   44,  102,   45,    3,    4,    5,    6,
 /*    50 */     7,    8,    9,  106,  107,   12,   27,   58,   59,   60,
 /*    60 */    61,   62,   63,   64,   65,   66,   67,   68,   69,    1,
 /*    70 */    77,   28,    1,   20,   81,   46,   83,   84,   85,   86,
 /*    80 */    82,   13,   53,   16,   13,   87,   16,   94,   20,   18,
 /*    90 */    13,   20,   99,  100,   96,  102,   26,   20,   15,   31,
 /*   100 */    32,   33,   34,   35,   36,   37,   38,   39,   40,   41,
 /*   110 */    42,   43,   44,   76,   77,   78,   46,   46,   74,   75,
 /*   120 */    76,   77,   78,   53,   53,   12,   58,   59,   60,   61,
 /*   130 */    62,   63,   64,   65,   66,   67,   68,   69,    1,   82,
 /*   140 */    15,   77,   17,   47,   19,   81,   21,   83,   84,   85,
 /*   150 */    86,   12,   92,   96,   15,   16,   51,   20,   94,   46,
 /*   160 */    13,   56,   25,   99,  100,  105,  102,   20,   31,   32,
 /*   170 */    33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
 /*   180 */    43,   44,    1,   13,   12,   77,   14,   15,   15,   81,
 /*   190 */    20,   83,   45,   54,   86,   58,   59,   60,   61,   62,
 /*   200 */    63,   64,   65,   66,   67,   68,   69,   99,  100,   78,
 /*   210 */   102,   80,   31,   32,   33,   34,   35,   36,   37,   38,
 /*   220 */    39,   40,   41,   42,   43,   44,   12,   55,   12,   15,
 /*   230 */    16,   15,   23,    8,   47,   14,   15,   12,   57,   58,
 /*   240 */    59,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   250 */    69,    1,   77,   28,    1,   93,   81,   46,   83,   84,
 /*   260 */    85,   86,   51,   13,   53,   13,   13,  105,   57,   94,
 /*   270 */    54,   18,   20,   20,   99,  100,   55,  102,   14,   15,
 /*   280 */    71,   31,   32,   33,   34,   35,   36,   37,   38,   39,
 /*   290 */    40,   41,   42,   43,   44,   70,   71,   72,   46,   13,
 /*   300 */    16,   12,   18,   18,   15,   53,   20,   15,   58,   59,
 /*   310 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   320 */     1,   77,   48,   83,   13,   81,   86,   83,   84,   85,
 /*   330 */    86,   20,   12,   13,   23,   15,   51,   53,   94,   20,
 /*   340 */    46,   56,  102,   99,  100,   13,  102,   27,  108,    1,
 /*   350 */    31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
 /*   360 */    41,   42,   43,   44,    1,   13,   12,   77,   20,   15,
 /*   370 */    15,   81,   20,   83,   16,   23,   86,   58,   59,   60,
 /*   380 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   99,
 /*   390 */   100,  103,  102,  105,   31,   32,   33,   34,   35,   36,
 /*   400 */    37,   38,   39,   40,   41,   42,   43,   44,    1,   51,
 /*   410 */    47,   12,   12,   13,   15,   15,   12,    2,   14,   15,
 /*   420 */    13,   58,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   430 */    67,   68,   69,   29,   15,   20,  106,  107,   31,   32,
 /*   440 */    33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
 /*   450 */    43,   44,    1,   54,   12,   77,   13,   15,   88,   81,
 /*   460 */    88,   83,   77,   20,   86,   58,   59,   60,   61,   62,
 /*   470 */    63,   64,   65,   66,   67,   68,   69,   99,  100,  103,
 /*   480 */   102,    2,   31,   32,   33,   34,   35,   36,   37,   38,
 /*   490 */    39,   40,   41,   42,   43,   44,    1,   13,  113,  114,
 /*   500 */   106,  107,   89,   90,   20,   45,   15,   82,   13,   58,
 /*   510 */    59,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   520 */    69,   96,   71,   14,   51,   29,   31,   32,   33,   34,
 /*   530 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*   540 */     1,   13,   22,   77,   13,   54,   13,   81,   20,   83,
 /*   550 */    30,   20,   86,   58,   59,   60,   61,   62,   63,   64,
 /*   560 */    65,   66,   67,   68,   69,   99,  100,   55,  102,   26,
 /*   570 */    31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
 /*   580 */    41,   42,   43,   44,    1,    2,   47,   77,   13,   15,
 /*   590 */    14,   81,   14,   83,   26,   20,   86,   58,   59,   60,
 /*   600 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   99,
 /*   610 */   100,   88,  102,   13,   31,   32,   33,   34,   35,   36,
 /*   620 */    37,   38,   39,   40,   41,   42,   43,   44,    1,   13,
 /*   630 */    46,   13,   55,   23,   15,   47,   20,   53,   20,   15,
 /*   640 */    13,   58,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   650 */    67,   68,   69,   29,   14,   13,   15,   20,   31,   32,
 /*   660 */    33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
 /*   670 */    43,   44,    1,   13,   57,   77,   13,   16,   20,   81,
 /*   680 */    20,   83,   18,   20,   86,   58,   59,   60,   61,   62,
 /*   690 */    63,   64,   65,   66,   67,   68,   69,   99,  100,   24,
 /*   700 */   102,   30,   31,   32,   33,   34,   35,   36,   37,   38,
 /*   710 */    39,   40,   41,   42,   43,   44,   12,   53,   13,   15,
 /*   720 */    16,   13,   15,   77,    8,   20,   14,   23,   12,   58,
 /*   730 */    59,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   740 */    69,    1,   77,   96,   28,   10,   81,    2,   83,   84,
 /*   750 */    45,   86,   82,   45,   89,   12,   13,   87,   15,   94,
 /*   760 */   114,   16,   22,  104,   99,  100,   96,  102,   79,  103,
 /*   770 */    27,   31,   32,   33,   34,   35,   36,   37,   38,   39,
 /*   780 */    40,   41,   42,   43,   44,    1,   70,   71,   72,   13,
 /*   790 */   103,   95,   46,  105,   20,   18,   20,   13,   58,   59,
 /*   800 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   810 */    14,   91,  103,  107,   20,   31,   32,   33,   34,   35,
 /*   820 */    36,   37,   38,   39,   40,   41,   42,   43,   44,    1,
 /*   830 */    13,   13,   13,   91,  103,   88,  110,   20,   20,   20,
 /*   840 */    82,   13,   58,   59,   60,   61,   62,   63,   64,   65,
 /*   850 */    66,   67,   68,   69,   96,    2,   89,  115,  115,   31,
 /*   860 */    32,   33,   34,   35,   36,   37,   38,   39,   40,   41,
 /*   870 */    42,   43,   44,    1,  101,  115,   77,  115,  115,  115,
 /*   880 */    81,  108,   83,  115,  115,   86,   58,   59,   60,   61,
 /*   890 */    62,   63,   64,   65,   66,   67,   68,   69,   99,  100,
 /*   900 */   115,  102,  115,   31,   32,   33,   34,   35,   36,   37,
 /*   910 */    38,   39,   40,   41,   42,   43,   44,   87,  115,  115,
 /*   920 */   115,  115,  115,  115,  115,  115,  115,   97,   98,  115,
 /*   930 */    58,   59,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   940 */    68,   69,   82,   12,  115,   14,   15,   87,   17,  115,
 /*   950 */    19,   12,   21,   14,   15,  115,   96,   97,   98,   28,
 /*   960 */    29,   92,   92,   32,  115,   82,  115,   28,   29,   92,
 /*   970 */    87,   32,  115,  115,  105,  105,  115,   46,  115,   96,
 /*   980 */    49,   50,  105,   52,  115,   46,   55,   56,   49,   50,
 /*   990 */    12,   52,   14,   15,   55,   56,   57,   82,   82,  115,
 /*  1000 */   115,   70,   12,   87,   14,   15,   28,   29,  115,   70,
 /*  1010 */    32,   96,   96,   97,   98,   82,  115,   82,   28,   29,
 /*  1020 */   115,  115,   32,  115,   46,  110,  115,   49,   50,   96,
 /*  1030 */    52,   96,  115,   55,   56,   12,   46,   14,   15,   49,
 /*  1040 */    50,   92,   52,  110,   92,   55,   56,   12,   70,   14,
 /*  1050 */    15,   28,   29,   92,  105,   32,  115,  105,   92,  115,
 /*  1060 */    70,  115,  115,   28,   29,  115,  105,   32,  115,   46,
 /*  1070 */   115,  105,   49,   50,   82,   52,   92,  115,   55,   56,
 /*  1080 */    12,   46,   14,   15,   49,   50,  115,   52,   96,  105,
 /*  1090 */    55,   56,   12,   70,   14,   15,   28,   29,  115,  115,
 /*  1100 */    32,   82,  110,  115,  115,   70,  115,   82,   28,   29,
 /*  1110 */   115,  115,   32,  115,   46,   96,  115,   49,   50,  115,
 /*  1120 */    52,   96,  115,   55,   56,   12,   46,   14,   15,   49,
 /*  1130 */    50,  115,   52,  115,  115,   55,   56,   12,   70,   14,
 /*  1140 */    15,   28,   29,  115,  115,   32,  115,  115,  115,  115,
 /*  1150 */    70,  115,  115,   28,   29,  115,  115,   32,  115,   46,
 /*  1160 */   115,  115,   49,   50,  115,   52,  115,  115,   55,   56,
 /*  1170 */    12,   46,   14,   15,   49,   50,  115,   52,  115,  115,
 /*  1180 */    55,  115,  115,   70,  115,  115,   28,   29,  115,  115,
 /*  1190 */    32,  115,   77,  115,  115,   70,   81,  115,   83,   84,
 /*  1200 */   115,   86,  115,  115,   46,  115,  115,   49,   50,   94,
 /*  1210 */    52,  115,  115,   55,   99,  100,   77,  102,  115,  115,
 /*  1220 */    81,  115,   83,   84,  115,   86,  111,  112,   70,  115,
 /*  1230 */   115,  115,  115,   94,  115,  115,  115,  115,   99,  100,
 /*  1240 */    77,  102,  115,  115,   81,  115,   83,   84,  109,   86,
 /*  1250 */   115,  115,   77,  115,  115,  115,   81,   94,   83,   84,
 /*  1260 */   115,   86,   99,  100,   77,  102,  115,  115,   81,   94,
 /*  1270 */    83,   84,  109,   86,   99,  100,  115,  102,  115,  115,
 /*  1280 */   115,   94,  115,  115,  109,  115,   99,  100,   77,  102,
 /*  1290 */   115,  115,   81,  115,   83,   84,  115,   86,  115,  112,
 /*  1300 */    77,  115,  115,  115,   81,   94,   83,   84,  115,   86,
 /*  1310 */    99,  100,  115,  102,  115,  115,  115,   94,  115,  115,
 /*  1320 */   109,  115,   99,  100,   77,  102,  115,  115,   81,  115,
 /*  1330 */    83,   84,  115,   86,  115,  115,   77,  115,  115,  115,
 /*  1340 */    81,   94,   83,   84,  115,   86,   99,  100,   77,  102,
 /*  1350 */   115,  115,   81,   94,   83,   84,  115,   86,   99,  100,
 /*  1360 */   115,  102,  115,  115,  115,   94,  115,  115,  115,  115,
 /*  1370 */    99,  100,   77,  102,  115,  115,   81,  115,   83,   84,
 /*  1380 */   115,   86,  115,  115,   77,  115,  115,  115,   81,   94,
 /*  1390 */    83,   84,  115,   86,   99,  100,  115,  102,  115,  115,
 /*  1400 */   115,   94,  115,  115,  115,  115,   99,  100,   77,  102,
 /*  1410 */   115,  115,   81,  115,   83,   84,  115,   86,  115,  115,
 /*  1420 */    77,  115,  115,  115,   81,   94,   83,   84,  115,   86,
 /*  1430 */    99,  100,   77,  102,  115,  115,   81,   94,   83,   84,
 /*  1440 */   115,   86,   99,  100,  115,  102,  115,  115,  115,   94,
 /*  1450 */   115,  115,  115,  115,   99,  100,   77,  102,  115,  115,
 /*  1460 */    81,  115,   83,   84,  115,   86,  115,  115,   77,  115,
 /*  1470 */   115,  115,   81,   94,   83,   84,  115,   86,   99,  100,
 /*  1480 */   115,  102,  115,  115,  115,   94,  115,  115,  115,  115,
 /*  1490 */    99,  100,   77,  102,  115,  115,   81,  115,   83,   84,
 /*  1500 */   115,   86,  115,  115,   77,  115,  115,  115,   81,   94,
 /*  1510 */    83,   84,  115,   86,   99,  100,   77,  102,  115,  115,
 /*  1520 */    81,   94,   83,   84,  115,   86,   99,  100,  115,  102,
 /*  1530 */   115,  115,  115,   94,  115,  115,  115,  115,   99,  100,
 /*  1540 */    77,  102,  115,  115,   81,  115,   83,   84,  115,   86,
 /*  1550 */   115,  115,   77,  115,  115,  115,   81,   94,   83,   84,
 /*  1560 */   115,   86,   99,  100,  115,  102,  115,  115,  115,   94,
 /*  1570 */   115,  115,  115,  115,   99,  100,   77,  102,  115,  115,
 /*  1580 */    81,  115,   83,   84,  115,   86,  115,  115,   77,  115,
 /*  1590 */   115,  115,   81,   94,   83,   84,  115,   86,   99,  100,
 /*  1600 */    77,  102,  115,  115,   81,   94,   83,   84,  115,   86,
 /*  1610 */    99,  100,  115,  102,  115,  115,  115,   94,  115,  115,
 /*  1620 */   115,  115,   99,  100,   77,  102,  115,  115,   81,  115,
 /*  1630 */    83,   84,  115,   86,  115,  115,   77,  115,  115,  115,
 /*  1640 */    81,   94,   83,   84,  115,   86,   99,  100,  115,  102,
 /*  1650 */   115,  115,  115,   94,  115,  115,  115,  115,   99,  100,
 /*  1660 */    77,  102,  115,  115,   81,  115,   83,   84,  115,   86,
 /*  1670 */   115,  115,   77,  115,  115,  115,   81,   94,   83,   84,
 /*  1680 */   115,   86,   99,  100,   77,  102,  115,  115,   81,   94,
 /*  1690 */    83,   84,  115,   86,   99,  100,  115,  102,  115,  115,
 /*  1700 */   115,   94,  115,  115,  115,  115,   99,  100,   77,  102,
 /*  1710 */   115,  115,   81,  115,   83,   84,  115,   86,  115,  115,
 /*  1720 */    77,  115,  115,  115,   81,   94,   83,   84,  115,   86,
 /*  1730 */    99,  100,  115,  102,  115,  115,  115,   94,  115,  115,
 /*  1740 */   115,   82,   99,  100,   77,  102,   87,  115,   81,  115,
 /*  1750 */    83,  115,  115,   86,   77,   96,   97,   98,   81,  115,
 /*  1760 */    83,   94,  115,   86,  115,  115,   99,  100,  115,  102,
 /*  1770 */   115,   94,  115,  115,  115,  115,   99,  100,  115,  102,
 /*  1780 */    82,  115,  115,  115,   77,   87,  115,  115,   81,  115,
 /*  1790 */    83,  115,  115,   86,   96,   97,   98,  115,  115,  115,
 /*  1800 */   115,   94,  115,  115,  115,  115,   99,  100,  115,  102,
);
    const YY_SHIFT_USE_DFLT = -29;
    const YY_SHIFT_MAX = 223;
    static public $yy_shift_ofst = array(
 /*     0 */    43, 1068,  931,  931, 1113,  978,  990, 1068,  990,  978,
 /*    10 */   978, 1080,  978,  939,  978,  978,  978,  978,  978,  978,
 /*    20 */   978,  978,  978,  978,  978,  978,  978,  978,  978,  978,
 /*    30 */   978,  978,  978,  978,  978,  978,  978,  978,  978, 1023,
 /*    40 */  1023, 1035, 1125, 1158, 1125, 1125, 1125, 1125, 1125,   -1,
 /*    50 */   137,   68,  319,  319,  172,  407,  250,  181,  363,  451,
 /*    60 */   828,  784,  671,  740,  627,  583,  495,  539,  872,  872,
 /*    70 */   872,  872,  872,  872,  872,  872,  872,  872,  872,  872,
 /*    80 */   872,  872,  872,  872,   43,  716,   71,  253,  285,  221,
 /*    90 */   415,  415,  415,  348,   11,  225,  704,  139,  216,  352,
 /*   100 */   705,  311,  284,  354,  664,  442,  289,  289,  289,  289,
 /*   110 */   354,  289,  264,  289,  289,  289,  777,  796,  658,  658,
 /*   120 */   774,  658,  777,  743,  320,  125,  399,  400,   -9,  214,
 /*   130 */   575,  484,  531,  113,  443,  105,   77,  170,  819,  105,
 /*   140 */   286,  528,  818,  618,  105,  105,  616,  105,  660,  817,
 /*   150 */   776,  663,  746,  735,  796,  853,  777,  777,  777,  794,
 /*   160 */   794,  777,  -29,  -29,  -29,  -29,  -29,  -29,  -29,  211,
 /*   170 */    70,  252,  404,   29,  147,  584,    0,  584,  520,  358,
 /*   180 */   -28,  209,  708,  491,  624,  745,  543,  642,  640,  675,
 /*   190 */   588,  574,  568,  577,  712,  512,   83,  509,  617,  610,
 /*   200 */   619,  707,  355,  292,  173,   53,   96,  294,  496,  473,
 /*   210 */   419,  479,  332,   67,  274,  641,  533,  460,  576,  600,
 /*   220 */   578,  661,  637,  187,
);
    const YY_REDUCE_USE_DFLT = -94;
    const YY_REDUCE_MAX = 168;
    static public $yy_reduce_ofst = array(
 /*     0 */    44, 1115,   -7,  244,  175, 1163,   64, 1187,  -76, 1175,
 /*    10 */  1139,  665, 1211, 1391, 1379, 1415, 1427, 1439, 1355, 1343,
 /*    20 */  1259, 1247, 1271, 1295, 1331, 1307, 1463, 1475, 1583, 1607,
 /*    30 */  1631, 1643, 1595, 1559, 1499, 1223, 1511, 1523, 1547, 1677,
 /*    40 */  1707, 1667,  799,  510,  290,  598,  378,  108,  466, 1698,
 /*    50 */   916,  860,  860, 1659,  240,  830,  830,  830,  830,  830,
 /*    60 */   830,  830,  830,  830,  830,  830,  830,  830,  830,  830,
 /*    70 */   830,  830,  830,  830,  830,  830,  830,  830,  830,  830,
 /*    80 */   830,  830,  830,  830,   37,  385,  883,   -2,  -93,  -58,
 /*    90 */   915,  933,  992,  670,  131,  646,  162,  288,  288,  758,
 /*   100 */   935,  758,  330,  961,  330,  869,   60,  870,  952,  949,
 /*   110 */   869,  877,  773,  869,  984,  966,  394,  413, 1025, 1019,
 /*   120 */   425,   57,  -53,  688,  688,  696,  688,  688,  688,  688,
 /*   130 */   647,  647,  647,  709,  647,  659,  647,  647,  647,  659,
 /*   140 */   647,  647,  647,  647,  659,  659,  647,  659,  647,  647,
 /*   150 */   647,  647,  687,  689,  767,  726,  706,  706,  706,  720,
 /*   160 */   742,  706,  747,  731,  523,  666,  376,  372,  370,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(3, 4, 5, 6, 7, 8, 9, 12, 28, ),
        /* 1 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 2 */ array(12, 14, 15, 17, 19, 21, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 3 */ array(12, 14, 15, 17, 19, 21, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 4 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 5 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 6 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 7 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 8 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 9 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 10 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 11 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 12 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 13 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 57, 70, ),
        /* 14 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 15 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 16 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 17 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 18 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 19 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 20 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 21 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 22 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 23 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 24 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 25 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 26 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 27 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 28 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 29 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 30 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 31 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 32 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 33 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 34 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 35 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 36 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 37 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 38 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 39 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 40 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 41 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 56, 70, ),
        /* 42 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 70, ),
        /* 43 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 70, ),
        /* 44 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 70, ),
        /* 45 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 70, ),
        /* 46 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 70, ),
        /* 47 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 70, ),
        /* 48 */ array(12, 14, 15, 28, 29, 32, 46, 49, 50, 52, 55, 70, ),
        /* 49 */ array(1, 13, 20, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 50 */ array(1, 20, 25, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 51 */ array(1, 13, 20, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 52 */ array(1, 20, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 53 */ array(1, 20, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 54 */ array(12, 14, 15, 55, ),
        /* 55 */ array(1, 13, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 56 */ array(1, 13, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 57 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 58 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 47, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 59 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 71, ),
        /* 60 */ array(1, 13, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 61 */ array(1, 13, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 62 */ array(1, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 63 */ array(1, 22, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 64 */ array(1, 13, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 65 */ array(1, 2, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 66 */ array(1, 13, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 67 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 47, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 68 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 69 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 70 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 71 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 72 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 73 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 74 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 75 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 76 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 77 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 78 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 79 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 80 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 81 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 82 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 83 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, ),
        /* 84 */ array(3, 4, 5, 6, 7, 8, 9, 12, 28, ),
        /* 85 */ array(8, 12, 28, 70, 71, 72, ),
        /* 86 */ array(1, 13, 18, 20, 46, 53, ),
        /* 87 */ array(1, 13, 18, 20, ),
        /* 88 */ array(18, 51, 56, ),
        /* 89 */ array(14, 15, 55, ),
        /* 90 */ array(2, 20, ),
        /* 91 */ array(2, 20, ),
        /* 92 */ array(2, 20, ),
        /* 93 */ array(1, 20, ),
        /* 94 */ array(4, 5, 6, 9, 10, 11, ),
        /* 95 */ array(8, 12, 28, 70, 71, 72, ),
        /* 96 */ array(12, 15, 16, 23, ),
        /* 97 */ array(12, 15, 16, 54, ),
        /* 98 */ array(12, 15, 54, ),
        /* 99 */ array(13, 20, 23, ),
        /* 100 */ array(13, 20, 45, ),
        /* 101 */ array(13, 20, 23, ),
        /* 102 */ array(16, 18, 53, ),
        /* 103 */ array(12, 15, ),
        /* 104 */ array(18, 53, ),
        /* 105 */ array(12, 15, ),
        /* 106 */ array(12, 15, ),
        /* 107 */ array(12, 15, ),
        /* 108 */ array(12, 15, ),
        /* 109 */ array(12, 15, ),
        /* 110 */ array(12, 15, ),
        /* 111 */ array(12, 15, ),
        /* 112 */ array(14, 15, ),
        /* 113 */ array(12, 15, ),
        /* 114 */ array(12, 15, ),
        /* 115 */ array(12, 15, ),
        /* 116 */ array(18, ),
        /* 117 */ array(14, ),
        /* 118 */ array(20, ),
        /* 119 */ array(20, ),
        /* 120 */ array(20, ),
        /* 121 */ array(20, ),
        /* 122 */ array(18, ),
        /* 123 */ array(12, 13, 15, 27, ),
        /* 124 */ array(12, 13, 15, 27, ),
        /* 125 */ array(15, 17, 19, 21, ),
        /* 126 */ array(12, 15, 54, ),
        /* 127 */ array(12, 13, 15, ),
        /* 128 */ array(12, 13, 15, ),
        /* 129 */ array(12, 15, 16, ),
        /* 130 */ array(13, 20, ),
        /* 131 */ array(13, 20, ),
        /* 132 */ array(13, 20, ),
        /* 133 */ array(12, 46, ),
        /* 134 */ array(13, 20, ),
        /* 135 */ array(51, 56, ),
        /* 136 */ array(13, 20, ),
        /* 137 */ array(13, 20, ),
        /* 138 */ array(13, 20, ),
        /* 139 */ array(51, 56, ),
        /* 140 */ array(13, 20, ),
        /* 141 */ array(13, 20, ),
        /* 142 */ array(13, 20, ),
        /* 143 */ array(13, 20, ),
        /* 144 */ array(51, 56, ),
        /* 145 */ array(51, 56, ),
        /* 146 */ array(13, 20, ),
        /* 147 */ array(51, 56, ),
        /* 148 */ array(13, 20, ),
        /* 149 */ array(13, 20, ),
        /* 150 */ array(13, 20, ),
        /* 151 */ array(13, 20, ),
        /* 152 */ array(46, ),
        /* 153 */ array(10, ),
        /* 154 */ array(14, ),
        /* 155 */ array(2, ),
        /* 156 */ array(18, ),
        /* 157 */ array(18, ),
        /* 158 */ array(18, ),
        /* 159 */ array(20, ),
        /* 160 */ array(20, ),
        /* 161 */ array(18, ),
        /* 162 */ array(),
        /* 163 */ array(),
        /* 164 */ array(),
        /* 165 */ array(),
        /* 166 */ array(),
        /* 167 */ array(),
        /* 168 */ array(),
        /* 169 */ array(46, 51, 53, 57, ),
        /* 170 */ array(16, 26, 46, 53, ),
        /* 171 */ array(13, 20, 46, 53, ),
        /* 172 */ array(12, 14, 15, 29, ),
        /* 173 */ array(27, 46, 53, ),
        /* 174 */ array(13, 20, 45, ),
        /* 175 */ array(46, 53, ),
        /* 176 */ array(27, 45, ),
        /* 177 */ array(46, 53, ),
        /* 178 */ array(22, 30, ),
        /* 179 */ array(16, 51, ),
        /* 180 */ array(30, 57, ),
        /* 181 */ array(23, 71, ),
        /* 182 */ array(13, 45, ),
        /* 183 */ array(15, 54, ),
        /* 184 */ array(15, 29, ),
        /* 185 */ array(2, 16, ),
        /* 186 */ array(26, ),
        /* 187 */ array(13, ),
        /* 188 */ array(14, ),
        /* 189 */ array(24, ),
        /* 190 */ array(47, ),
        /* 191 */ array(15, ),
        /* 192 */ array(26, ),
        /* 193 */ array(55, ),
        /* 194 */ array(14, ),
        /* 195 */ array(55, ),
        /* 196 */ array(15, ),
        /* 197 */ array(14, ),
        /* 198 */ array(57, ),
        /* 199 */ array(23, ),
        /* 200 */ array(15, ),
        /* 201 */ array(15, ),
        /* 202 */ array(15, ),
        /* 203 */ array(15, ),
        /* 204 */ array(15, ),
        /* 205 */ array(20, ),
        /* 206 */ array(47, ),
        /* 207 */ array(46, ),
        /* 208 */ array(29, ),
        /* 209 */ array(51, ),
        /* 210 */ array(15, ),
        /* 211 */ array(2, ),
        /* 212 */ array(13, ),
        /* 213 */ array(16, ),
        /* 214 */ array(48, ),
        /* 215 */ array(15, ),
        /* 216 */ array(13, ),
        /* 217 */ array(45, ),
        /* 218 */ array(14, ),
        /* 219 */ array(13, ),
        /* 220 */ array(14, ),
        /* 221 */ array(16, ),
        /* 222 */ array(20, ),
        /* 223 */ array(47, ),
        /* 224 */ array(),
        /* 225 */ array(),
        /* 226 */ array(),
        /* 227 */ array(),
        /* 228 */ array(),
        /* 229 */ array(),
        /* 230 */ array(),
        /* 231 */ array(),
        /* 232 */ array(),
        /* 233 */ array(),
        /* 234 */ array(),
        /* 235 */ array(),
        /* 236 */ array(),
        /* 237 */ array(),
        /* 238 */ array(),
        /* 239 */ array(),
        /* 240 */ array(),
        /* 241 */ array(),
        /* 242 */ array(),
        /* 243 */ array(),
        /* 244 */ array(),
        /* 245 */ array(),
        /* 246 */ array(),
        /* 247 */ array(),
        /* 248 */ array(),
        /* 249 */ array(),
        /* 250 */ array(),
        /* 251 */ array(),
        /* 252 */ array(),
        /* 253 */ array(),
        /* 254 */ array(),
        /* 255 */ array(),
        /* 256 */ array(),
        /* 257 */ array(),
        /* 258 */ array(),
        /* 259 */ array(),
        /* 260 */ array(),
        /* 261 */ array(),
        /* 262 */ array(),
        /* 263 */ array(),
        /* 264 */ array(),
        /* 265 */ array(),
        /* 266 */ array(),
        /* 267 */ array(),
        /* 268 */ array(),
        /* 269 */ array(),
        /* 270 */ array(),
        /* 271 */ array(),
        /* 272 */ array(),
        /* 273 */ array(),
        /* 274 */ array(),
        /* 275 */ array(),
        /* 276 */ array(),
        /* 277 */ array(),
        /* 278 */ array(),
        /* 279 */ array(),
        /* 280 */ array(),
        /* 281 */ array(),
        /* 282 */ array(),
        /* 283 */ array(),
        /* 284 */ array(),
        /* 285 */ array(),
        /* 286 */ array(),
        /* 287 */ array(),
        /* 288 */ array(),
        /* 289 */ array(),
        /* 290 */ array(),
        /* 291 */ array(),
        /* 292 */ array(),
        /* 293 */ array(),
        /* 294 */ array(),
        /* 295 */ array(),
        /* 296 */ array(),
        /* 297 */ array(),
        /* 298 */ array(),
        /* 299 */ array(),
        /* 300 */ array(),
        /* 301 */ array(),
        /* 302 */ array(),
        /* 303 */ array(),
        /* 304 */ array(),
        /* 305 */ array(),
        /* 306 */ array(),
        /* 307 */ array(),
        /* 308 */ array(),
        /* 309 */ array(),
        /* 310 */ array(),
        /* 311 */ array(),
        /* 312 */ array(),
        /* 313 */ array(),
        /* 314 */ array(),
        /* 315 */ array(),
        /* 316 */ array(),
        /* 317 */ array(),
        /* 318 */ array(),
        /* 319 */ array(),
        /* 320 */ array(),
        /* 321 */ array(),
        /* 322 */ array(),
        /* 323 */ array(),
        /* 324 */ array(),
        /* 325 */ array(),
        /* 326 */ array(),
        /* 327 */ array(),
        /* 328 */ array(),
        /* 329 */ array(),
        /* 330 */ array(),
        /* 331 */ array(),
        /* 332 */ array(),
        /* 333 */ array(),
        /* 334 */ array(),
        /* 335 */ array(),
        /* 336 */ array(),
        /* 337 */ array(),
        /* 338 */ array(),
        /* 339 */ array(),
        /* 340 */ array(),
        /* 341 */ array(),
        /* 342 */ array(),
        /* 343 */ array(),
        /* 344 */ array(),
        /* 345 */ array(),
        /* 346 */ array(),
        /* 347 */ array(),
        /* 348 */ array(),
        /* 349 */ array(),
        /* 350 */ array(),
        /* 351 */ array(),
        /* 352 */ array(),
        /* 353 */ array(),
        /* 354 */ array(),
        /* 355 */ array(),
        /* 356 */ array(),
        /* 357 */ array(),
        /* 358 */ array(),
        /* 359 */ array(),
);
    static public $yy_default = array(
 /*     0 */   546,  529,  546,  546,  546,  500,  546,  546,  546,  500,
 /*    10 */   500,  546,  500,  546,  546,  546,  546,  546,  546,  546,
 /*    20 */   546,  546,  546,  546,  546,  546,  546,  546,  546,  546,
 /*    30 */   546,  546,  546,  546,  546,  546,  546,  546,  546,  546,
 /*    40 */   546,  546,  546,  546,  546,  546,  546,  546,  546,  546,
 /*    50 */   418,  546,  418,  418,  546,  546,  546,  546,  546,  546,
 /*    60 */   546,  546,  499,  546,  546,  546,  546,  546,  427,  451,
 /*    70 */   440,  532,  448,  443,  447,  531,  438,  400,  435,  444,
 /*    80 */   530,  424,  439,  420,  360,  546,  459,  546,  508,  546,
 /*    90 */   418,  418,  418,  418,  546,  546,  546,  473,  473,  452,
 /*   100 */   428,  452,  466,  546,  466,  546,  546,  546,  546,  546,
 /*   110 */   546,  546,  546,  546,  546,  546,  503,  546,  418,  418,
 /*   120 */   418,  418,  504,  546,  546,  546,  474,  546,  546,  546,
 /*   130 */   546,  546,  546,  473,  546,  492,  546,  546,  546,  491,
 /*   140 */   546,  546,  546,  546,  493,  494,  546,  471,  546,  546,
 /*   150 */   546,  546,  473,  374,  546,  434,  509,  506,  487,  545,
 /*   160 */   545,  505,  511,  473,  511,  473,  473,  511,  511,  459,
 /*   170 */   423,  459,  546,  459,  428,  459,  428,  449,  546,  457,
 /*   180 */   546,  452,  428,  546,  546,  485,  546,  546,  546,  425,
 /*   190 */   546,  546,  546,  546,  546,  546,  546,  546,  546,  452,
 /*   200 */   546,  546,  546,  546,  546,  546,  546,  507,  546,  457,
 /*   210 */   546,  485,  546,  546,  461,  546,  546,  428,  546,  546,
 /*   220 */   546,  423,  546,  546,  477,  476,  361,  486,  495,  422,
 /*   230 */   461,  415,  539,  542,  537,  538,  534,  535,  543,  536,
 /*   240 */   497,  450,  482,  480,  481,  479,  533,  403,  544,  426,
 /*   250 */   401,  498,  399,  411,  410,  409,  402,  478,  496,  512,
 /*   260 */   513,  412,  385,  429,  464,  467,  472,  475,  458,  455,
 /*   270 */   510,  456,  453,  454,  484,  485,  490,  483,  468,  469,
 /*   280 */   465,  463,  430,  460,  431,  462,  417,  414,  368,  369,
 /*   290 */   370,  371,  367,  366,  362,  363,  364,  365,  372,  373,
 /*   300 */   381,  416,  408,  413,  380,  379,  375,  376,  377,  378,
 /*   310 */   470,  432,  388,  387,  389,  390,  488,  386,  384,  526,
 /*   320 */   528,  527,  541,  489,  391,  405,  406,  407,  397,  404,
 /*   330 */   392,  393,  394,  396,  395,  433,  525,  442,  445,  446,
 /*   340 */   501,  441,  437,  382,  540,  383,  436,  502,  514,  521,
 /*   350 */   522,  523,  524,  520,  519,  515,  516,  517,  518,  398,
);
    const YYNOCODE = 116;
    const YYSTACKDEPTH = 100;
    const YYNSTATE = 360;
    const YYNRULE = 186;
    const YYERRORSYMBOL = 73;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    static public $yyFallback = array(
    );
    static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '<br>';
    }

    static public $yyTraceFILE;
    static public $yyTracePrompt;
    public $yyidx;                    /* Index of top element in stack */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    public $yystack = array();  /* The parser's stack */

    public $yyTokenName = array( 
  '$',             'VERT',          'COLON',         'COMMENT',     
  'PHPSTARTTAG',   'PHPENDTAG',     'FAKEPHPSTARTTAG',  'XMLTAG',      
  'OTHER',         'LITERALSTART',  'LITERALEND',    'LITERAL',     
  'LDEL',          'RDEL',          'DOLLAR',        'ID',          
  'EQUAL',         'FOREACH',       'PTR',           'IF',          
  'SPACE',         'FOR',           'SEMICOLON',     'INCDEC',      
  'TO',            'STEP',          'AS',            'APTR',        
  'LDELSLASH',     'INTEGER',       'COMMA',         'MATH',        
  'UNIMATH',       'ANDSYM',        'ISIN',          'ISDIVBY',     
  'ISNOTDIVBY',    'ISEVEN',        'ISNOTEVEN',     'ISEVENBY',    
  'ISNOTEVENBY',   'ISODD',         'ISNOTODD',      'ISODDBY',     
  'ISNOTODDBY',    'INSTANCEOF',    'OPENP',         'CLOSEP',      
  'QMARK',         'NOT',           'TYPECAST',      'DOT',         
  'SINGLEQUOTESTRING',  'DOUBLECOLON',   'AT',            'HATCH',       
  'OPENB',         'CLOSEB',        'EQUALS',        'NOTEQUALS',   
  'GREATERTHAN',   'LESSTHAN',      'GREATEREQUAL',  'LESSEQUAL',   
  'IDENTITY',      'NONEIDENTITY',  'MOD',           'LAND',        
  'LOR',           'LXOR',          'QUOTE',         'BACKTICK',    
  'DOLLARID',      'error',         'start',         'template',    
  'template_element',  'smartytag',     'literal',       'literal_elements',
  'literal_element',  'value',         'attributes',    'variable',    
  'expr',          'ternary',       'varindexed',    'modifier',    
  'modparameters',  'statement',     'statements',    'optspace',    
  'varvar',        'foraction',     'array',         'specialclose',
  'attribute',     'ifcond',        'lop',           'function',    
  'doublequoted_with_quotes',  'static_class_access',  'object',        'arrayindex',  
  'indexdef',      'varvarele',     'objectchain',   'objectelement',
  'method',        'params',        'modparameter',  'arrayelements',
  'arrayelement',  'doublequoted',  'doublequotedcontent',
    );

    static public $yyRuleName = array(
 /*   0 */ "start ::= template",
 /*   1 */ "template ::= template_element",
 /*   2 */ "template ::= template template_element",
 /*   3 */ "template_element ::= smartytag",
 /*   4 */ "template_element ::= COMMENT",
 /*   5 */ "template_element ::= literal",
 /*   6 */ "template_element ::= PHPSTARTTAG",
 /*   7 */ "template_element ::= PHPENDTAG",
 /*   8 */ "template_element ::= FAKEPHPSTARTTAG",
 /*   9 */ "template_element ::= XMLTAG",
 /*  10 */ "template_element ::= OTHER",
 /*  11 */ "literal ::= LITERALSTART LITERALEND",
 /*  12 */ "literal ::= LITERALSTART literal_elements LITERALEND",
 /*  13 */ "literal_elements ::= literal_elements literal_element",
 /*  14 */ "literal_elements ::=",
 /*  15 */ "literal_element ::= literal",
 /*  16 */ "literal_element ::= LITERAL",
 /*  17 */ "literal_element ::= PHPSTARTTAG",
 /*  18 */ "literal_element ::= FAKEPHPSTARTTAG",
 /*  19 */ "literal_element ::= PHPENDTAG",
 /*  20 */ "smartytag ::= LDEL value RDEL",
 /*  21 */ "smartytag ::= LDEL value attributes RDEL",
 /*  22 */ "smartytag ::= LDEL variable attributes RDEL",
 /*  23 */ "smartytag ::= LDEL expr attributes RDEL",
 /*  24 */ "smartytag ::= LDEL ternary attributes RDEL",
 /*  25 */ "smartytag ::= LDEL DOLLAR ID EQUAL value RDEL",
 /*  26 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr RDEL",
 /*  27 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr attributes RDEL",
 /*  28 */ "smartytag ::= LDEL DOLLAR ID EQUAL ternary attributes RDEL",
 /*  29 */ "smartytag ::= LDEL varindexed EQUAL expr attributes RDEL",
 /*  30 */ "smartytag ::= LDEL varindexed EQUAL ternary attributes RDEL",
 /*  31 */ "smartytag ::= LDEL ID attributes RDEL",
 /*  32 */ "smartytag ::= LDEL FOREACH attributes RDEL",
 /*  33 */ "smartytag ::= LDEL ID RDEL",
 /*  34 */ "smartytag ::= LDEL ID PTR ID attributes RDEL",
 /*  35 */ "smartytag ::= LDEL ID modifier modparameters attributes RDEL",
 /*  36 */ "smartytag ::= LDEL ID PTR ID modifier modparameters attributes RDEL",
 /*  37 */ "smartytag ::= LDEL IF SPACE expr RDEL",
 /*  38 */ "smartytag ::= LDEL IF SPACE statement RDEL",
 /*  39 */ "smartytag ::= LDEL FOR SPACE statements SEMICOLON optspace expr SEMICOLON optspace DOLLAR varvar foraction RDEL",
 /*  40 */ "foraction ::= EQUAL expr",
 /*  41 */ "foraction ::= INCDEC",
 /*  42 */ "smartytag ::= LDEL FOR SPACE statement TO expr attributes RDEL",
 /*  43 */ "smartytag ::= LDEL FOR SPACE statement TO expr STEP expr RDEL",
 /*  44 */ "smartytag ::= LDEL FOREACH SPACE value AS DOLLAR varvar RDEL",
 /*  45 */ "smartytag ::= LDEL FOREACH SPACE value AS DOLLAR varvar APTR DOLLAR varvar RDEL",
 /*  46 */ "smartytag ::= LDEL FOREACH SPACE array AS DOLLAR varvar RDEL",
 /*  47 */ "smartytag ::= LDEL FOREACH SPACE array AS DOLLAR varvar APTR DOLLAR varvar RDEL",
 /*  48 */ "smartytag ::= LDELSLASH ID RDEL",
 /*  49 */ "smartytag ::= LDELSLASH specialclose RDEL",
 /*  50 */ "specialclose ::= IF",
 /*  51 */ "specialclose ::= FOR",
 /*  52 */ "specialclose ::= FOREACH",
 /*  53 */ "smartytag ::= LDELSLASH ID attributes RDEL",
 /*  54 */ "smartytag ::= LDELSLASH ID modifier modparameters attributes RDEL",
 /*  55 */ "smartytag ::= LDELSLASH ID PTR ID RDEL",
 /*  56 */ "attributes ::= attributes attribute",
 /*  57 */ "attributes ::= attribute",
 /*  58 */ "attributes ::=",
 /*  59 */ "attribute ::= SPACE ID EQUAL ID",
 /*  60 */ "attribute ::= SPACE ID EQUAL expr",
 /*  61 */ "attribute ::= SPACE ID EQUAL value",
 /*  62 */ "attribute ::= SPACE ID EQUAL ternary",
 /*  63 */ "attribute ::= SPACE ID",
 /*  64 */ "attribute ::= SPACE INTEGER EQUAL expr",
 /*  65 */ "statements ::= statement",
 /*  66 */ "statements ::= statements COMMA statement",
 /*  67 */ "statement ::= DOLLAR varvar EQUAL expr",
 /*  68 */ "expr ::= value",
 /*  69 */ "expr ::= DOLLAR ID COLON ID",
 /*  70 */ "expr ::= expr MATH value",
 /*  71 */ "expr ::= expr UNIMATH value",
 /*  72 */ "expr ::= expr ANDSYM value",
 /*  73 */ "expr ::= array",
 /*  74 */ "expr ::= expr modifier modparameters",
 /*  75 */ "expr ::= expr ifcond expr",
 /*  76 */ "expr ::= expr ISIN array",
 /*  77 */ "expr ::= expr ISIN value",
 /*  78 */ "expr ::= expr lop expr",
 /*  79 */ "expr ::= expr ISDIVBY expr",
 /*  80 */ "expr ::= expr ISNOTDIVBY expr",
 /*  81 */ "expr ::= expr ISEVEN",
 /*  82 */ "expr ::= expr ISNOTEVEN",
 /*  83 */ "expr ::= expr ISEVENBY expr",
 /*  84 */ "expr ::= expr ISNOTEVENBY expr",
 /*  85 */ "expr ::= expr ISODD",
 /*  86 */ "expr ::= expr ISNOTODD",
 /*  87 */ "expr ::= expr ISODDBY expr",
 /*  88 */ "expr ::= expr ISNOTODDBY expr",
 /*  89 */ "expr ::= value INSTANCEOF ID",
 /*  90 */ "expr ::= value INSTANCEOF value",
 /*  91 */ "ternary ::= OPENP expr CLOSEP QMARK expr COLON expr",
 /*  92 */ "value ::= variable",
 /*  93 */ "value ::= UNIMATH value",
 /*  94 */ "value ::= NOT value",
 /*  95 */ "value ::= TYPECAST value",
 /*  96 */ "value ::= variable INCDEC",
 /*  97 */ "value ::= INTEGER",
 /*  98 */ "value ::= INTEGER DOT INTEGER",
 /*  99 */ "value ::= ID",
 /* 100 */ "value ::= function",
 /* 101 */ "value ::= OPENP expr CLOSEP",
 /* 102 */ "value ::= SINGLEQUOTESTRING",
 /* 103 */ "value ::= doublequoted_with_quotes",
 /* 104 */ "value ::= ID DOUBLECOLON static_class_access",
 /* 105 */ "value ::= smartytag",
 /* 106 */ "variable ::= varindexed",
 /* 107 */ "variable ::= DOLLAR varvar AT ID",
 /* 108 */ "variable ::= object",
 /* 109 */ "variable ::= HATCH ID HATCH",
 /* 110 */ "variable ::= HATCH variable HATCH",
 /* 111 */ "varindexed ::= DOLLAR varvar arrayindex",
 /* 112 */ "arrayindex ::= arrayindex indexdef",
 /* 113 */ "arrayindex ::=",
 /* 114 */ "indexdef ::= DOT DOLLAR varvar",
 /* 115 */ "indexdef ::= DOT DOLLAR varvar AT ID",
 /* 116 */ "indexdef ::= DOT ID",
 /* 117 */ "indexdef ::= DOT INTEGER",
 /* 118 */ "indexdef ::= DOT LDEL expr RDEL",
 /* 119 */ "indexdef ::= OPENB ID CLOSEB",
 /* 120 */ "indexdef ::= OPENB ID DOT ID CLOSEB",
 /* 121 */ "indexdef ::= OPENB expr CLOSEB",
 /* 122 */ "indexdef ::= OPENB CLOSEB",
 /* 123 */ "varvar ::= varvarele",
 /* 124 */ "varvar ::= varvar varvarele",
 /* 125 */ "varvarele ::= ID",
 /* 126 */ "varvarele ::= LDEL expr RDEL",
 /* 127 */ "object ::= varindexed objectchain",
 /* 128 */ "object ::= varindexed DOUBLECOLON ID",
 /* 129 */ "objectchain ::= objectelement",
 /* 130 */ "objectchain ::= objectchain objectelement",
 /* 131 */ "objectelement ::= PTR ID arrayindex",
 /* 132 */ "objectelement ::= PTR variable arrayindex",
 /* 133 */ "objectelement ::= PTR LDEL expr RDEL arrayindex",
 /* 134 */ "objectelement ::= PTR ID LDEL expr RDEL arrayindex",
 /* 135 */ "objectelement ::= PTR method",
 /* 136 */ "function ::= ID OPENP params CLOSEP",
 /* 137 */ "method ::= ID OPENP params CLOSEP",
 /* 138 */ "params ::= expr COMMA params",
 /* 139 */ "params ::= expr",
 /* 140 */ "params ::=",
 /* 141 */ "modifier ::= VERT AT ID",
 /* 142 */ "modifier ::= VERT ID",
 /* 143 */ "static_class_access ::= method",
 /* 144 */ "static_class_access ::= DOLLAR ID OPENP params CLOSEP",
 /* 145 */ "static_class_access ::= method objectchain",
 /* 146 */ "static_class_access ::= DOLLAR ID OPENP params CLOSEP objectchain",
 /* 147 */ "static_class_access ::= ID",
 /* 148 */ "static_class_access ::= DOLLAR ID arrayindex",
 /* 149 */ "static_class_access ::= DOLLAR ID arrayindex objectchain",
 /* 150 */ "modparameters ::= modparameters modparameter",
 /* 151 */ "modparameters ::=",
 /* 152 */ "modparameter ::= COLON value",
 /* 153 */ "modparameter ::= COLON array",
 /* 154 */ "ifcond ::= EQUALS",
 /* 155 */ "ifcond ::= NOTEQUALS",
 /* 156 */ "ifcond ::= GREATERTHAN",
 /* 157 */ "ifcond ::= LESSTHAN",
 /* 158 */ "ifcond ::= GREATEREQUAL",
 /* 159 */ "ifcond ::= LESSEQUAL",
 /* 160 */ "ifcond ::= IDENTITY",
 /* 161 */ "ifcond ::= NONEIDENTITY",
 /* 162 */ "ifcond ::= MOD",
 /* 163 */ "lop ::= LAND",
 /* 164 */ "lop ::= LOR",
 /* 165 */ "lop ::= LXOR",
 /* 166 */ "array ::= OPENB arrayelements CLOSEB",
 /* 167 */ "arrayelements ::= arrayelement",
 /* 168 */ "arrayelements ::= arrayelements COMMA arrayelement",
 /* 169 */ "arrayelements ::=",
 /* 170 */ "arrayelement ::= value APTR expr",
 /* 171 */ "arrayelement ::= ID APTR expr",
 /* 172 */ "arrayelement ::= expr",
 /* 173 */ "doublequoted_with_quotes ::= QUOTE QUOTE",
 /* 174 */ "doublequoted_with_quotes ::= QUOTE doublequoted QUOTE",
 /* 175 */ "doublequoted ::= doublequoted doublequotedcontent",
 /* 176 */ "doublequoted ::= doublequotedcontent",
 /* 177 */ "doublequotedcontent ::= BACKTICK variable BACKTICK",
 /* 178 */ "doublequotedcontent ::= BACKTICK expr BACKTICK",
 /* 179 */ "doublequotedcontent ::= DOLLARID",
 /* 180 */ "doublequotedcontent ::= LDEL variable RDEL",
 /* 181 */ "doublequotedcontent ::= LDEL expr RDEL",
 /* 182 */ "doublequotedcontent ::= smartytag",
 /* 183 */ "doublequotedcontent ::= OTHER",
 /* 184 */ "optspace ::= SPACE",
 /* 185 */ "optspace ::=",
    );

    function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count($this->yyTokenName)) {
            return $this->yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . $this->yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;
        return $yymajor;
    }

    function __destruct()
    {
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
                        $expected += self::$yyExpectedTokens[$nextstate];
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        return array_unique($expected);
    }

    function yy_is_expected_token($token)
    {
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;
        return true;
    }

   function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;
     
        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        $this->yyTokenName[$iLookAhead] . " => " .
                        $this->yyTokenName[$iFallback] . "\n");
                }
                return $this->yy_find_shift_action($iFallback);
            }
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
            return;
        }
        $yytos = new TP_yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    $this->yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    static public $yyRuleInfo = array(
  array( 'lhs' => 74, 'rhs' => 1 ),
  array( 'lhs' => 75, 'rhs' => 1 ),
  array( 'lhs' => 75, 'rhs' => 2 ),
  array( 'lhs' => 76, 'rhs' => 1 ),
  array( 'lhs' => 76, 'rhs' => 1 ),
  array( 'lhs' => 76, 'rhs' => 1 ),
  array( 'lhs' => 76, 'rhs' => 1 ),
  array( 'lhs' => 76, 'rhs' => 1 ),
  array( 'lhs' => 76, 'rhs' => 1 ),
  array( 'lhs' => 76, 'rhs' => 1 ),
  array( 'lhs' => 76, 'rhs' => 1 ),
  array( 'lhs' => 78, 'rhs' => 2 ),
  array( 'lhs' => 78, 'rhs' => 3 ),
  array( 'lhs' => 79, 'rhs' => 2 ),
  array( 'lhs' => 79, 'rhs' => 0 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 77, 'rhs' => 3 ),
  array( 'lhs' => 77, 'rhs' => 4 ),
  array( 'lhs' => 77, 'rhs' => 4 ),
  array( 'lhs' => 77, 'rhs' => 4 ),
  array( 'lhs' => 77, 'rhs' => 4 ),
  array( 'lhs' => 77, 'rhs' => 6 ),
  array( 'lhs' => 77, 'rhs' => 6 ),
  array( 'lhs' => 77, 'rhs' => 7 ),
  array( 'lhs' => 77, 'rhs' => 7 ),
  array( 'lhs' => 77, 'rhs' => 6 ),
  array( 'lhs' => 77, 'rhs' => 6 ),
  array( 'lhs' => 77, 'rhs' => 4 ),
  array( 'lhs' => 77, 'rhs' => 4 ),
  array( 'lhs' => 77, 'rhs' => 3 ),
  array( 'lhs' => 77, 'rhs' => 6 ),
  array( 'lhs' => 77, 'rhs' => 6 ),
  array( 'lhs' => 77, 'rhs' => 8 ),
  array( 'lhs' => 77, 'rhs' => 5 ),
  array( 'lhs' => 77, 'rhs' => 5 ),
  array( 'lhs' => 77, 'rhs' => 13 ),
  array( 'lhs' => 93, 'rhs' => 2 ),
  array( 'lhs' => 93, 'rhs' => 1 ),
  array( 'lhs' => 77, 'rhs' => 8 ),
  array( 'lhs' => 77, 'rhs' => 9 ),
  array( 'lhs' => 77, 'rhs' => 8 ),
  array( 'lhs' => 77, 'rhs' => 11 ),
  array( 'lhs' => 77, 'rhs' => 8 ),
  array( 'lhs' => 77, 'rhs' => 11 ),
  array( 'lhs' => 77, 'rhs' => 3 ),
  array( 'lhs' => 77, 'rhs' => 3 ),
  array( 'lhs' => 95, 'rhs' => 1 ),
  array( 'lhs' => 95, 'rhs' => 1 ),
  array( 'lhs' => 95, 'rhs' => 1 ),
  array( 'lhs' => 77, 'rhs' => 4 ),
  array( 'lhs' => 77, 'rhs' => 6 ),
  array( 'lhs' => 77, 'rhs' => 5 ),
  array( 'lhs' => 82, 'rhs' => 2 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 0 ),
  array( 'lhs' => 96, 'rhs' => 4 ),
  array( 'lhs' => 96, 'rhs' => 4 ),
  array( 'lhs' => 96, 'rhs' => 4 ),
  array( 'lhs' => 96, 'rhs' => 4 ),
  array( 'lhs' => 96, 'rhs' => 2 ),
  array( 'lhs' => 96, 'rhs' => 4 ),
  array( 'lhs' => 90, 'rhs' => 1 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 4 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 4 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 2 ),
  array( 'lhs' => 84, 'rhs' => 2 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 2 ),
  array( 'lhs' => 84, 'rhs' => 2 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 7 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 2 ),
  array( 'lhs' => 81, 'rhs' => 2 ),
  array( 'lhs' => 81, 'rhs' => 2 ),
  array( 'lhs' => 81, 'rhs' => 2 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 3 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 3 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 3 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 4 ),
  array( 'lhs' => 83, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 3 ),
  array( 'lhs' => 83, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 103, 'rhs' => 2 ),
  array( 'lhs' => 103, 'rhs' => 0 ),
  array( 'lhs' => 104, 'rhs' => 3 ),
  array( 'lhs' => 104, 'rhs' => 5 ),
  array( 'lhs' => 104, 'rhs' => 2 ),
  array( 'lhs' => 104, 'rhs' => 2 ),
  array( 'lhs' => 104, 'rhs' => 4 ),
  array( 'lhs' => 104, 'rhs' => 3 ),
  array( 'lhs' => 104, 'rhs' => 5 ),
  array( 'lhs' => 104, 'rhs' => 3 ),
  array( 'lhs' => 104, 'rhs' => 2 ),
  array( 'lhs' => 92, 'rhs' => 1 ),
  array( 'lhs' => 92, 'rhs' => 2 ),
  array( 'lhs' => 105, 'rhs' => 1 ),
  array( 'lhs' => 105, 'rhs' => 3 ),
  array( 'lhs' => 102, 'rhs' => 2 ),
  array( 'lhs' => 102, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 1 ),
  array( 'lhs' => 106, 'rhs' => 2 ),
  array( 'lhs' => 107, 'rhs' => 3 ),
  array( 'lhs' => 107, 'rhs' => 3 ),
  array( 'lhs' => 107, 'rhs' => 5 ),
  array( 'lhs' => 107, 'rhs' => 6 ),
  array( 'lhs' => 107, 'rhs' => 2 ),
  array( 'lhs' => 99, 'rhs' => 4 ),
  array( 'lhs' => 108, 'rhs' => 4 ),
  array( 'lhs' => 109, 'rhs' => 3 ),
  array( 'lhs' => 109, 'rhs' => 1 ),
  array( 'lhs' => 109, 'rhs' => 0 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 5 ),
  array( 'lhs' => 101, 'rhs' => 2 ),
  array( 'lhs' => 101, 'rhs' => 6 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 3 ),
  array( 'lhs' => 101, 'rhs' => 4 ),
  array( 'lhs' => 88, 'rhs' => 2 ),
  array( 'lhs' => 88, 'rhs' => 0 ),
  array( 'lhs' => 110, 'rhs' => 2 ),
  array( 'lhs' => 110, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 98, 'rhs' => 1 ),
  array( 'lhs' => 98, 'rhs' => 1 ),
  array( 'lhs' => 98, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 3 ),
  array( 'lhs' => 111, 'rhs' => 1 ),
  array( 'lhs' => 111, 'rhs' => 3 ),
  array( 'lhs' => 111, 'rhs' => 0 ),
  array( 'lhs' => 112, 'rhs' => 3 ),
  array( 'lhs' => 112, 'rhs' => 3 ),
  array( 'lhs' => 112, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 2 ),
  array( 'lhs' => 100, 'rhs' => 3 ),
  array( 'lhs' => 113, 'rhs' => 2 ),
  array( 'lhs' => 113, 'rhs' => 1 ),
  array( 'lhs' => 114, 'rhs' => 3 ),
  array( 'lhs' => 114, 'rhs' => 3 ),
  array( 'lhs' => 114, 'rhs' => 1 ),
  array( 'lhs' => 114, 'rhs' => 3 ),
  array( 'lhs' => 114, 'rhs' => 3 ),
  array( 'lhs' => 114, 'rhs' => 1 ),
  array( 'lhs' => 114, 'rhs' => 1 ),
  array( 'lhs' => 91, 'rhs' => 1 ),
  array( 'lhs' => 91, 'rhs' => 0 ),
    );

    static public $yyReduceMap = array(
        0 => 0,
        5 => 0,
        15 => 0,
        16 => 0,
        50 => 0,
        51 => 0,
        52 => 0,
        68 => 0,
        92 => 0,
        97 => 0,
        100 => 0,
        102 => 0,
        103 => 0,
        108 => 0,
        143 => 0,
        167 => 0,
        1 => 1,
        2 => 2,
        3 => 3,
        4 => 4,
        6 => 6,
        7 => 7,
        8 => 8,
        9 => 9,
        10 => 10,
        11 => 11,
        14 => 11,
        12 => 12,
        13 => 13,
        93 => 13,
        95 => 13,
        96 => 13,
        145 => 13,
        17 => 17,
        18 => 17,
        19 => 19,
        20 => 20,
        21 => 21,
        22 => 21,
        23 => 21,
        24 => 21,
        25 => 25,
        26 => 25,
        27 => 27,
        28 => 27,
        29 => 29,
        30 => 29,
        31 => 31,
        32 => 31,
        33 => 33,
        34 => 34,
        35 => 35,
        36 => 36,
        37 => 37,
        38 => 37,
        39 => 39,
        40 => 40,
        41 => 41,
        57 => 41,
        139 => 41,
        147 => 41,
        172 => 41,
        42 => 42,
        43 => 43,
        44 => 44,
        45 => 45,
        46 => 46,
        47 => 47,
        48 => 48,
        49 => 48,
        53 => 53,
        54 => 54,
        55 => 55,
        56 => 56,
        58 => 58,
        59 => 59,
        60 => 60,
        61 => 60,
        62 => 60,
        64 => 60,
        63 => 63,
        65 => 65,
        66 => 66,
        67 => 67,
        69 => 69,
        70 => 70,
        71 => 70,
        72 => 70,
        73 => 73,
        123 => 73,
        184 => 73,
        74 => 74,
        75 => 75,
        78 => 75,
        89 => 75,
        76 => 76,
        77 => 77,
        79 => 79,
        80 => 80,
        81 => 81,
        86 => 81,
        82 => 82,
        85 => 82,
        83 => 83,
        88 => 83,
        84 => 84,
        87 => 84,
        90 => 90,
        91 => 91,
        94 => 94,
        98 => 98,
        99 => 99,
        101 => 101,
        104 => 104,
        105 => 105,
        106 => 106,
        107 => 107,
        109 => 109,
        110 => 110,
        111 => 111,
        112 => 112,
        113 => 113,
        151 => 113,
        114 => 114,
        115 => 115,
        116 => 116,
        117 => 117,
        118 => 118,
        121 => 118,
        119 => 119,
        120 => 120,
        122 => 122,
        185 => 122,
        124 => 124,
        125 => 125,
        126 => 126,
        127 => 127,
        128 => 128,
        129 => 129,
        130 => 130,
        131 => 131,
        132 => 132,
        133 => 133,
        134 => 134,
        135 => 135,
        136 => 136,
        137 => 137,
        138 => 138,
        140 => 140,
        141 => 141,
        142 => 141,
        144 => 144,
        146 => 146,
        148 => 148,
        149 => 149,
        150 => 150,
        152 => 152,
        153 => 152,
        154 => 154,
        155 => 155,
        156 => 156,
        157 => 157,
        158 => 158,
        159 => 159,
        160 => 160,
        161 => 161,
        162 => 162,
        163 => 163,
        164 => 164,
        165 => 165,
        166 => 166,
        168 => 168,
        169 => 169,
        170 => 170,
        171 => 171,
        173 => 173,
        174 => 174,
        175 => 175,
        176 => 176,
        177 => 177,
        178 => 177,
        180 => 177,
        179 => 179,
        181 => 181,
        182 => 182,
        183 => 183,
    );
#line 85 "smarty_internal_templateparser.y"
    function yy_r0(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;     }
#line 1925 "smarty_internal_templateparser.php"
#line 91 "smarty_internal_templateparser.y"
    function yy_r1(){if ($this->template->extract_code == false) {
                                                  $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
                                               } else {
                                                 // store code in extract buffer
                                                  $this->template->extracted_compiled_code .= $this->yystack[$this->yyidx + 0]->minor;
                                               } 
                                                 }
#line 1934 "smarty_internal_templateparser.php"
#line 99 "smarty_internal_templateparser.y"
    function yy_r2(){if ($this->template->extract_code == false) {
                                                             $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
                                                           } else {
                                                             // store code in extract buffer
                                                             $this->template->extracted_compiled_code .= $this->yystack[$this->yyidx + 0]->minor;
                                                             $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
                                                           } 
                                                              }
#line 1944 "smarty_internal_templateparser.php"
#line 112 "smarty_internal_templateparser.y"
    function yy_r3(){
                                          if ($this->compiler->has_code) {
                                            $tmp =''; foreach ($this->compiler->prefix_code as $code) {$tmp.=$code;} $this->compiler->prefix_code=array();
                                            $this->_retvalue = $this->compiler->processNocacheCode($tmp.$this->yystack[$this->yyidx + 0]->minor,true);
                                         } else { 
                                           $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
                                         }  
                                         $this->compiler->has_variable_string = false;
                                         $this->block_nesting_level = count($this->compiler->_tag_stack);
                                            }
#line 1956 "smarty_internal_templateparser.php"
#line 124 "smarty_internal_templateparser.y"
    function yy_r4(){ $this->_retvalue = '';    }
#line 1959 "smarty_internal_templateparser.php"
#line 130 "smarty_internal_templateparser.y"
    function yy_r6(){
                                      if ($this->sec_obj->php_handling == SMARTY_PHP_PASSTHRU) {
					                             $this->_retvalue = self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor);
                                      } elseif ($this->sec_obj->php_handling == SMARTY_PHP_QUOTE) {
                                       $this->_retvalue = $this->compiler->processNocacheCode(htmlspecialchars($this->yystack[$this->yyidx + 0]->minor, ENT_QUOTES),false);
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_ALLOW) {
                                       $this->_retvalue = $this->compiler->processNocacheCode('<?php', true);
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_REMOVE) {
                                       $this->_retvalue = '';
                                      }
                                         }
#line 1972 "smarty_internal_templateparser.php"
#line 142 "smarty_internal_templateparser.y"
    function yy_r7(){if ($this->is_xml) {
                                       $this->compiler->tag_nocache = true; 
                                       $this->is_xml = true; 
                                       $this->_retvalue = $this->compiler->processNocacheCode("<?php echo '?>';?>", $this->compiler, true);
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_PASSTHRU) {
					                             $this->_retvalue = '?<??>>';
                                      } elseif ($this->sec_obj->php_handling == SMARTY_PHP_QUOTE) {
                                       $this->_retvalue = $this->compiler->processNocacheCode(htmlspecialchars('?>', ENT_QUOTES), false);
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_ALLOW) {
                                       $this->_retvalue = $this->compiler->processNocacheCode('?>', true);
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_REMOVE) {
                                       $this->_retvalue = '';
                                      }
                                         }
#line 1988 "smarty_internal_templateparser.php"
#line 157 "smarty_internal_templateparser.y"
    function yy_r8(){if ($this->lex->strip) {
                                       $this->_retvalue = preg_replace('![\$this->yystack[$this->yyidx + 0]->minor ]*[\r\n]+[\$this->yystack[$this->yyidx + 0]->minor ]*!', '', self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor));	
                                     } else {
                                       $this->_retvalue = self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor);	
                                     }
                                        }
#line 1996 "smarty_internal_templateparser.php"
#line 165 "smarty_internal_templateparser.y"
    function yy_r9(){ $this->compiler->tag_nocache = true; $this->is_xml = true; $this->_retvalue = $this->compiler->processNocacheCode("<?php echo '<?xml';?>", $this->compiler, true);    }
#line 1999 "smarty_internal_templateparser.php"
#line 168 "smarty_internal_templateparser.y"
    function yy_r10(){if ($this->lex->strip) {
                                       $this->_retvalue = preg_replace('![\t ]*[\r\n]+[\t ]*!', '', $this->yystack[$this->yyidx + 0]->minor);	
                                     } else {
                                       $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;	
                                     }
                                        }
#line 2007 "smarty_internal_templateparser.php"
#line 176 "smarty_internal_templateparser.y"
    function yy_r11(){ $this->_retvalue = '';     }
#line 2010 "smarty_internal_templateparser.php"
#line 177 "smarty_internal_templateparser.y"
    function yy_r12(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;     }
#line 2013 "smarty_internal_templateparser.php"
#line 179 "smarty_internal_templateparser.y"
    function yy_r13(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2016 "smarty_internal_templateparser.php"
#line 184 "smarty_internal_templateparser.y"
    function yy_r17(){ $this->_retvalue = self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor);     }
#line 2019 "smarty_internal_templateparser.php"
#line 186 "smarty_internal_templateparser.y"
    function yy_r19(){ $this->_retvalue = self::escape_end_tag($this->yystack[$this->yyidx + 0]->minor);     }
#line 2022 "smarty_internal_templateparser.php"
#line 194 "smarty_internal_templateparser.y"
    function yy_r20(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',array('value'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2025 "smarty_internal_templateparser.php"
#line 195 "smarty_internal_templateparser.y"
    function yy_r21(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',array_merge(array('value'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2028 "smarty_internal_templateparser.php"
#line 206 "smarty_internal_templateparser.y"
    function yy_r25(){ $this->_retvalue = $this->compiler->compileTag('assign',array('value'=>$this->yystack[$this->yyidx + -1]->minor,'var'=>"'".$this->yystack[$this->yyidx + -3]->minor."'"));    }
#line 2031 "smarty_internal_templateparser.php"
#line 208 "smarty_internal_templateparser.y"
    function yy_r27(){ $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array('value'=>$this->yystack[$this->yyidx + -2]->minor,'var'=>"'".$this->yystack[$this->yyidx + -4]->minor."'"),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2034 "smarty_internal_templateparser.php"
#line 210 "smarty_internal_templateparser.y"
    function yy_r29(){ $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array('value'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -4]->minor,$this->yystack[$this->yyidx + -1]->minor));    }
#line 2037 "smarty_internal_templateparser.php"
#line 213 "smarty_internal_templateparser.y"
    function yy_r31(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor,$this->yystack[$this->yyidx + -1]->minor);    }
#line 2040 "smarty_internal_templateparser.php"
#line 215 "smarty_internal_templateparser.y"
    function yy_r33(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor,array());    }
#line 2043 "smarty_internal_templateparser.php"
#line 217 "smarty_internal_templateparser.y"
    function yy_r34(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor,array_merge(array('object_methode'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2046 "smarty_internal_templateparser.php"
#line 219 "smarty_internal_templateparser.y"
    function yy_r35(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor,$this->yystack[$this->yyidx + -1]->minor).'<?php echo ';
                                                                                    $this->_retvalue .= $this->compiler->compileTag('private_modifier',array('modifier'=>$this->yystack[$this->yyidx + -3]->minor,'params'=>'ob_get_clean()'.$this->yystack[$this->yyidx + -2]->minor)).'?>';
                                                                                     }
#line 2051 "smarty_internal_templateparser.php"
#line 223 "smarty_internal_templateparser.y"
    function yy_r36(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -6]->minor,array_merge(array('object_methode'=>$this->yystack[$this->yyidx + -4]->minor),$this->yystack[$this->yyidx + -1]->minor)).'<?php echo ';
                                                                                               $this->_retvalue .= $this->compiler->compileTag('private_modifier',array('modifier'=>$this->yystack[$this->yyidx + -3]->minor,'params'=>'ob_get_clean()'.$this->yystack[$this->yyidx + -2]->minor)).'?>';
                                                                                                }
#line 2056 "smarty_internal_templateparser.php"
#line 227 "smarty_internal_templateparser.y"
    function yy_r37(){ $this->_retvalue = $this->compiler->compileTag(($this->yystack[$this->yyidx + -3]->minor == 'else if')? 'elseif' : $this->yystack[$this->yyidx + -3]->minor,array('if condition'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2059 "smarty_internal_templateparser.php"
#line 230 "smarty_internal_templateparser.y"
    function yy_r39(){
                                                             $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -11]->minor,array('start'=>$this->yystack[$this->yyidx + -9]->minor,'ifexp'=>$this->yystack[$this->yyidx + -6]->minor,'varloop'=>$this->yystack[$this->yyidx + -2]->minor,'loop'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2063 "smarty_internal_templateparser.php"
#line 233 "smarty_internal_templateparser.y"
    function yy_r40(){ $this->_retvalue = '='.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2066 "smarty_internal_templateparser.php"
#line 234 "smarty_internal_templateparser.y"
    function yy_r41(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2069 "smarty_internal_templateparser.php"
#line 235 "smarty_internal_templateparser.y"
    function yy_r42(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -6]->minor,array_merge(array('start'=>$this->yystack[$this->yyidx + -4]->minor,'to'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2072 "smarty_internal_templateparser.php"
#line 236 "smarty_internal_templateparser.y"
    function yy_r43(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -7]->minor,array('start'=>$this->yystack[$this->yyidx + -5]->minor,'to'=>$this->yystack[$this->yyidx + -3]->minor,'step'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2075 "smarty_internal_templateparser.php"
#line 238 "smarty_internal_templateparser.y"
    function yy_r44(){
                                                            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -6]->minor,array('from'=>$this->yystack[$this->yyidx + -4]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2079 "smarty_internal_templateparser.php"
#line 240 "smarty_internal_templateparser.y"
    function yy_r45(){
                                                            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -9]->minor,array('from'=>$this->yystack[$this->yyidx + -7]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor,'key'=>$this->yystack[$this->yyidx + -4]->minor));    }
#line 2083 "smarty_internal_templateparser.php"
#line 242 "smarty_internal_templateparser.y"
    function yy_r46(){ 
                                                            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -6]->minor,array('from'=>$this->yystack[$this->yyidx + -4]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2087 "smarty_internal_templateparser.php"
#line 244 "smarty_internal_templateparser.y"
    function yy_r47(){ 
                                                            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -9]->minor,array('from'=>$this->yystack[$this->yyidx + -7]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor,'key'=>$this->yystack[$this->yyidx + -4]->minor));    }
#line 2091 "smarty_internal_templateparser.php"
#line 248 "smarty_internal_templateparser.y"
    function yy_r48(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor.'close',array());    }
#line 2094 "smarty_internal_templateparser.php"
#line 253 "smarty_internal_templateparser.y"
    function yy_r53(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor.'close',$this->yystack[$this->yyidx + -1]->minor);    }
#line 2097 "smarty_internal_templateparser.php"
#line 254 "smarty_internal_templateparser.y"
    function yy_r54(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor.'close',$this->yystack[$this->yyidx + -1]->minor).'<?php echo ';
                                                                                         $this->_retvalue .= $this->compiler->compileTag('private_modifier',array('modifier'=>$this->yystack[$this->yyidx + -3]->minor,'params'=>'ob_get_clean()'.$this->yystack[$this->yyidx + -2]->minor)).'?>';
                                                                                          }
#line 2102 "smarty_internal_templateparser.php"
#line 258 "smarty_internal_templateparser.y"
    function yy_r55(){  $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor.'close',array('object_methode'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2105 "smarty_internal_templateparser.php"
#line 265 "smarty_internal_templateparser.y"
    function yy_r56(){ $this->_retvalue = array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor);    }
#line 2108 "smarty_internal_templateparser.php"
#line 269 "smarty_internal_templateparser.y"
    function yy_r58(){ $this->_retvalue = array();    }
#line 2111 "smarty_internal_templateparser.php"
#line 272 "smarty_internal_templateparser.y"
    function yy_r59(){ if (preg_match('~^true$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'true');
                                                 } elseif (preg_match('~^false$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'false');
                                                 } elseif (preg_match('~^null$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'null');
                                                 } else
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>"'".$this->yystack[$this->yyidx + 0]->minor."'");    }
#line 2121 "smarty_internal_templateparser.php"
#line 280 "smarty_internal_templateparser.y"
    function yy_r60(){ $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2124 "smarty_internal_templateparser.php"
#line 283 "smarty_internal_templateparser.y"
    function yy_r63(){ $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor=>'true');    }
#line 2127 "smarty_internal_templateparser.php"
#line 290 "smarty_internal_templateparser.y"
    function yy_r65(){ $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);    }
#line 2130 "smarty_internal_templateparser.php"
#line 291 "smarty_internal_templateparser.y"
    function yy_r66(){ $this->yystack[$this->yyidx + -2]->minor[]=$this->yystack[$this->yyidx + 0]->minor; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;    }
#line 2133 "smarty_internal_templateparser.php"
#line 293 "smarty_internal_templateparser.y"
    function yy_r67(){ $this->_retvalue = array('var' => $this->yystack[$this->yyidx + -2]->minor, 'value'=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2136 "smarty_internal_templateparser.php"
#line 302 "smarty_internal_templateparser.y"
    function yy_r69(){$this->_retvalue = '$_smarty_tpl->getStreamVariable(\''. $this->yystack[$this->yyidx + -2]->minor .'://'. $this->yystack[$this->yyidx + 0]->minor . '\')';    }
#line 2139 "smarty_internal_templateparser.php"
#line 304 "smarty_internal_templateparser.y"
    function yy_r70(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor . trim($this->yystack[$this->yyidx + -1]->minor) . $this->yystack[$this->yyidx + 0]->minor;     }
#line 2142 "smarty_internal_templateparser.php"
#line 310 "smarty_internal_templateparser.y"
    function yy_r73(){$this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2145 "smarty_internal_templateparser.php"
#line 313 "smarty_internal_templateparser.y"
    function yy_r74(){  $this->_retvalue = $this->compiler->compileTag('private_modifier',array('modifier'=>$this->yystack[$this->yyidx + -1]->minor,'params'=>$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor));     }
#line 2148 "smarty_internal_templateparser.php"
#line 317 "smarty_internal_templateparser.y"
    function yy_r75(){$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2151 "smarty_internal_templateparser.php"
#line 318 "smarty_internal_templateparser.y"
    function yy_r76(){$this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2154 "smarty_internal_templateparser.php"
#line 319 "smarty_internal_templateparser.y"
    function yy_r77(){$this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.',(array)'.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2157 "smarty_internal_templateparser.php"
#line 321 "smarty_internal_templateparser.y"
    function yy_r79(){$this->_retvalue = '!('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2160 "smarty_internal_templateparser.php"
#line 322 "smarty_internal_templateparser.y"
    function yy_r80(){$this->_retvalue = '('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2163 "smarty_internal_templateparser.php"
#line 323 "smarty_internal_templateparser.y"
    function yy_r81(){$this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2166 "smarty_internal_templateparser.php"
#line 324 "smarty_internal_templateparser.y"
    function yy_r82(){$this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2169 "smarty_internal_templateparser.php"
#line 325 "smarty_internal_templateparser.y"
    function yy_r83(){$this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2172 "smarty_internal_templateparser.php"
#line 326 "smarty_internal_templateparser.y"
    function yy_r84(){$this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2175 "smarty_internal_templateparser.php"
#line 332 "smarty_internal_templateparser.y"
    function yy_r90(){$this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'='.$this->yystack[$this->yyidx + 0]->minor.';?>'; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.'$_tmp'.$this->prefix_number;    }
#line 2178 "smarty_internal_templateparser.php"
#line 338 "smarty_internal_templateparser.y"
    function yy_r91(){ $this->_retvalue = $this->yystack[$this->yyidx + -5]->minor.' ? '.$this->yystack[$this->yyidx + -2]->minor.' : '.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2181 "smarty_internal_templateparser.php"
#line 345 "smarty_internal_templateparser.y"
    function yy_r94(){ $this->_retvalue = '!'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2184 "smarty_internal_templateparser.php"
#line 350 "smarty_internal_templateparser.y"
    function yy_r98(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2187 "smarty_internal_templateparser.php"
#line 352 "smarty_internal_templateparser.y"
    function yy_r99(){ if (preg_match('~^true$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                $this->_retvalue = 'true';
                               } elseif (preg_match('~^false$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                $this->_retvalue = 'false';
                               } elseif (preg_match('~^null$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                $this->_retvalue = 'null';
                               } else
                               $this->_retvalue = "'".$this->yystack[$this->yyidx + 0]->minor."'";     }
#line 2197 "smarty_internal_templateparser.php"
#line 363 "smarty_internal_templateparser.y"
    function yy_r101(){ $this->_retvalue = "(". $this->yystack[$this->yyidx + -1]->minor .")";     }
#line 2200 "smarty_internal_templateparser.php"
#line 369 "smarty_internal_templateparser.y"
    function yy_r104(){if (!$this->template->security || $this->smarty->security_handler->isTrustedStaticClass($this->yystack[$this->yyidx + -2]->minor, $this->compiler)) {
                                                                  $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'::'.$this->yystack[$this->yyidx + 0]->minor; 
                                                                }    }
#line 2205 "smarty_internal_templateparser.php"
#line 373 "smarty_internal_templateparser.y"
    function yy_r105(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php ob_start();?>'.$this->yystack[$this->yyidx + 0]->minor.'<?php $_tmp'.$this->prefix_number.'=ob_get_clean();?>'; $this->_retvalue = '$_tmp'.$this->prefix_number;     }
#line 2208 "smarty_internal_templateparser.php"
#line 382 "smarty_internal_templateparser.y"
    function yy_r106(){if ($this->yystack[$this->yyidx + 0]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('private_special_variable',$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index']);
                                      } else {
                                      if (isset($this->compiler->local_var[$this->yystack[$this->yyidx + 0]->minor['var']])) {
                                          $this->_retvalue = '$_smarty_tpl->tpl_vars['. $this->yystack[$this->yyidx + 0]->minor['var'] .']->value'.$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
                                         } else {
                                          $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + 0]->minor['var'] .')->value'.$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
                                         }
                                       $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + 0]->minor['var'],"'"), null, true, false)->nocache;}    }
#line 2218 "smarty_internal_templateparser.php"
#line 391 "smarty_internal_templateparser.y"
    function yy_r107(){if (isset($this->compiler->local_var[$this->yystack[$this->yyidx + -2]->minor])) {
                                                  $this->_retvalue = '$_smarty_tpl->tpl_vars['. $this->yystack[$this->yyidx + -2]->minor .']->'.$this->yystack[$this->yyidx + 0]->minor;
                                                 } else {
                                                  $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor .')->'.$this->yystack[$this->yyidx + 0]->minor;
                                                 }
                                                  $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor,"'"), null, true, false)->nocache;    }
#line 2226 "smarty_internal_templateparser.php"
#line 400 "smarty_internal_templateparser.y"
    function yy_r109(){$this->_retvalue = '$_smarty_tpl->getConfigVariable(\''. $this->yystack[$this->yyidx + -1]->minor .'\')';    }
#line 2229 "smarty_internal_templateparser.php"
#line 401 "smarty_internal_templateparser.y"
    function yy_r110(){$this->_retvalue = '$_smarty_tpl->getConfigVariable('. $this->yystack[$this->yyidx + -1]->minor .')';    }
#line 2232 "smarty_internal_templateparser.php"
#line 404 "smarty_internal_templateparser.y"
    function yy_r111(){$this->_retvalue = array('var'=>$this->yystack[$this->yyidx + -1]->minor, 'smarty_internal_index'=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2235 "smarty_internal_templateparser.php"
#line 410 "smarty_internal_templateparser.y"
    function yy_r112(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2238 "smarty_internal_templateparser.php"
#line 412 "smarty_internal_templateparser.y"
    function yy_r113(){return;    }
#line 2241 "smarty_internal_templateparser.php"
#line 416 "smarty_internal_templateparser.y"
    function yy_r114(){ $this->_retvalue = '[$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + 0]->minor .')->value]'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable('$this->yystack[$this->yyidx + 0]->minor', null, true, false)->nocache;    }
#line 2244 "smarty_internal_templateparser.php"
#line 417 "smarty_internal_templateparser.y"
    function yy_r115(){ $this->_retvalue = '[$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor .')->'.$this->yystack[$this->yyidx + 0]->minor.']'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor,"'"), null, true, false)->nocache;    }
#line 2247 "smarty_internal_templateparser.php"
#line 418 "smarty_internal_templateparser.y"
    function yy_r116(){ $this->_retvalue = "['". $this->yystack[$this->yyidx + 0]->minor ."']";    }
#line 2250 "smarty_internal_templateparser.php"
#line 419 "smarty_internal_templateparser.y"
    function yy_r117(){ $this->_retvalue = "[". $this->yystack[$this->yyidx + 0]->minor ."]";    }
#line 2253 "smarty_internal_templateparser.php"
#line 420 "smarty_internal_templateparser.y"
    function yy_r118(){ $this->_retvalue = "[". $this->yystack[$this->yyidx + -1]->minor ."]";    }
#line 2256 "smarty_internal_templateparser.php"
#line 422 "smarty_internal_templateparser.y"
    function yy_r119(){ $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable','[\'section\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\'][\'index\']').']';    }
#line 2259 "smarty_internal_templateparser.php"
#line 423 "smarty_internal_templateparser.y"
    function yy_r120(){ $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable','[\'section\'][\''.$this->yystack[$this->yyidx + -3]->minor.'\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\']').']';    }
#line 2262 "smarty_internal_templateparser.php"
#line 427 "smarty_internal_templateparser.y"
    function yy_r122(){$this->_retvalue = '';    }
#line 2265 "smarty_internal_templateparser.php"
#line 435 "smarty_internal_templateparser.y"
    function yy_r124(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2268 "smarty_internal_templateparser.php"
#line 437 "smarty_internal_templateparser.y"
    function yy_r125(){$this->_retvalue = '\''.$this->yystack[$this->yyidx + 0]->minor.'\'';    }
#line 2271 "smarty_internal_templateparser.php"
#line 439 "smarty_internal_templateparser.y"
    function yy_r126(){$this->_retvalue = '('.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2274 "smarty_internal_templateparser.php"
#line 444 "smarty_internal_templateparser.y"
    function yy_r127(){ if ($this->yystack[$this->yyidx + -1]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('private_special_variable',$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index']).$this->yystack[$this->yyidx + 0]->minor;} else {
                                                         $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -1]->minor['var'] .')->value'.$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index'].$this->yystack[$this->yyidx + 0]->minor; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -1]->minor['var'],"'"), null, true, false)->nocache;}    }
#line 2278 "smarty_internal_templateparser.php"
#line 446 "smarty_internal_templateparser.y"
    function yy_r128(){ if ($this->yystack[$this->yyidx + -2]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('private_special_variable',$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index']).'::'.$this->yystack[$this->yyidx + 0]->minor;} else {
                                                         $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor['var'] .')->value'.$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index'].'::'.$this->yystack[$this->yyidx + 0]->minor; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor['var'],"'"), null, true, false)->nocache;}    }
#line 2282 "smarty_internal_templateparser.php"
#line 449 "smarty_internal_templateparser.y"
    function yy_r129(){$this->_retvalue  = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2285 "smarty_internal_templateparser.php"
#line 451 "smarty_internal_templateparser.y"
    function yy_r130(){$this->_retvalue  = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2288 "smarty_internal_templateparser.php"
#line 453 "smarty_internal_templateparser.y"
    function yy_r131(){ $this->_retvalue = '->'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2291 "smarty_internal_templateparser.php"
#line 454 "smarty_internal_templateparser.y"
    function yy_r132(){ $this->_retvalue = '->{'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';    }
#line 2294 "smarty_internal_templateparser.php"
#line 455 "smarty_internal_templateparser.y"
    function yy_r133(){ $this->_retvalue = '->{'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';    }
#line 2297 "smarty_internal_templateparser.php"
#line 456 "smarty_internal_templateparser.y"
    function yy_r134(){ $this->_retvalue = '->{\''.$this->yystack[$this->yyidx + -4]->minor.'\'.'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';    }
#line 2300 "smarty_internal_templateparser.php"
#line 458 "smarty_internal_templateparser.y"
    function yy_r135(){ $this->_retvalue = '->'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2303 "smarty_internal_templateparser.php"
#line 464 "smarty_internal_templateparser.y"
    function yy_r136(){if (!$this->template->security || $this->smarty->security_handler->isTrustedPhpFunction($this->yystack[$this->yyidx + -3]->minor, $this->compiler)) {
																					            if ($this->yystack[$this->yyidx + -3]->minor == 'isset' || $this->yystack[$this->yyidx + -3]->minor == 'empty' || $this->yystack[$this->yyidx + -3]->minor == 'array' || is_callable($this->yystack[$this->yyidx + -3]->minor)) {
																					                $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". $this->yystack[$this->yyidx + -1]->minor .")";
																					            } else {
                                                       $this->compiler->trigger_template_error ("unknown function \"" . $this->yystack[$this->yyidx + -3]->minor . "\"");
                                                      }
                                                    }    }
#line 2312 "smarty_internal_templateparser.php"
#line 475 "smarty_internal_templateparser.y"
    function yy_r137(){ $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". $this->yystack[$this->yyidx + -1]->minor .")";    }
#line 2315 "smarty_internal_templateparser.php"
#line 479 "smarty_internal_templateparser.y"
    function yy_r138(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.",".$this->yystack[$this->yyidx + 0]->minor;    }
#line 2318 "smarty_internal_templateparser.php"
#line 483 "smarty_internal_templateparser.y"
    function yy_r140(){ return;    }
#line 2321 "smarty_internal_templateparser.php"
#line 488 "smarty_internal_templateparser.y"
    function yy_r141(){ $this->_retvalue =  $this->yystack[$this->yyidx + 0]->minor;    }
#line 2324 "smarty_internal_templateparser.php"
#line 493 "smarty_internal_templateparser.y"
    function yy_r144(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'=$_smarty_tpl->getVariable(\''. $this->yystack[$this->yyidx + -3]->minor .'\')->value;?>'; $this->_retvalue = '$_tmp'.$this->prefix_number.'('. $this->yystack[$this->yyidx + -1]->minor .')';     }
#line 2327 "smarty_internal_templateparser.php"
#line 496 "smarty_internal_templateparser.y"
    function yy_r146(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'=$_smarty_tpl->getVariable(\''. $this->yystack[$this->yyidx + -4]->minor .'\')->value;?>'; $this->_retvalue = '$_tmp'.$this->prefix_number.'('. $this->yystack[$this->yyidx + -2]->minor .')'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2330 "smarty_internal_templateparser.php"
#line 500 "smarty_internal_templateparser.y"
    function yy_r148(){ $this->_retvalue = '$'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2333 "smarty_internal_templateparser.php"
#line 502 "smarty_internal_templateparser.y"
    function yy_r149(){ $this->_retvalue = '$'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2336 "smarty_internal_templateparser.php"
#line 513 "smarty_internal_templateparser.y"
    function yy_r150(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2339 "smarty_internal_templateparser.php"
#line 517 "smarty_internal_templateparser.y"
    function yy_r152(){$this->_retvalue = ','.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2342 "smarty_internal_templateparser.php"
#line 521 "smarty_internal_templateparser.y"
    function yy_r154(){$this->_retvalue = '==';    }
#line 2345 "smarty_internal_templateparser.php"
#line 522 "smarty_internal_templateparser.y"
    function yy_r155(){$this->_retvalue = '!=';    }
#line 2348 "smarty_internal_templateparser.php"
#line 523 "smarty_internal_templateparser.y"
    function yy_r156(){$this->_retvalue = '>';    }
#line 2351 "smarty_internal_templateparser.php"
#line 524 "smarty_internal_templateparser.y"
    function yy_r157(){$this->_retvalue = '<';    }
#line 2354 "smarty_internal_templateparser.php"
#line 525 "smarty_internal_templateparser.y"
    function yy_r158(){$this->_retvalue = '>=';    }
#line 2357 "smarty_internal_templateparser.php"
#line 526 "smarty_internal_templateparser.y"
    function yy_r159(){$this->_retvalue = '<=';    }
#line 2360 "smarty_internal_templateparser.php"
#line 527 "smarty_internal_templateparser.y"
    function yy_r160(){$this->_retvalue = '===';    }
#line 2363 "smarty_internal_templateparser.php"
#line 528 "smarty_internal_templateparser.y"
    function yy_r161(){$this->_retvalue = '!==';    }
#line 2366 "smarty_internal_templateparser.php"
#line 529 "smarty_internal_templateparser.y"
    function yy_r162(){$this->_retvalue = '%';    }
#line 2369 "smarty_internal_templateparser.php"
#line 531 "smarty_internal_templateparser.y"
    function yy_r163(){$this->_retvalue = '&&';    }
#line 2372 "smarty_internal_templateparser.php"
#line 532 "smarty_internal_templateparser.y"
    function yy_r164(){$this->_retvalue = '||';    }
#line 2375 "smarty_internal_templateparser.php"
#line 533 "smarty_internal_templateparser.y"
    function yy_r165(){$this->_retvalue = ' XOR ';    }
#line 2378 "smarty_internal_templateparser.php"
#line 538 "smarty_internal_templateparser.y"
    function yy_r166(){ $this->_retvalue = 'array('.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2381 "smarty_internal_templateparser.php"
#line 540 "smarty_internal_templateparser.y"
    function yy_r168(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2384 "smarty_internal_templateparser.php"
#line 541 "smarty_internal_templateparser.y"
    function yy_r169(){ return;     }
#line 2387 "smarty_internal_templateparser.php"
#line 542 "smarty_internal_templateparser.y"
    function yy_r170(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'=>'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2390 "smarty_internal_templateparser.php"
#line 543 "smarty_internal_templateparser.y"
    function yy_r171(){ $this->_retvalue = '\''.$this->yystack[$this->yyidx + -2]->minor.'\'=>'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2393 "smarty_internal_templateparser.php"
#line 550 "smarty_internal_templateparser.y"
    function yy_r173(){ $this->_retvalue = "''";     }
#line 2396 "smarty_internal_templateparser.php"
#line 551 "smarty_internal_templateparser.y"
    function yy_r174(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor->to_smarty_php();     }
#line 2399 "smarty_internal_templateparser.php"
#line 553 "smarty_internal_templateparser.y"
    function yy_r175(){ $this->yystack[$this->yyidx + -1]->minor->append_subtree($this->yystack[$this->yyidx + 0]->minor); $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;     }
#line 2402 "smarty_internal_templateparser.php"
#line 554 "smarty_internal_templateparser.y"
    function yy_r176(){ $this->_retvalue = new _smarty_doublequoted($this, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2405 "smarty_internal_templateparser.php"
#line 556 "smarty_internal_templateparser.y"
    function yy_r177(){ $this->_retvalue = new _smarty_code($this, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2408 "smarty_internal_templateparser.php"
#line 558 "smarty_internal_templateparser.y"
    function yy_r179(){if (isset($this->compiler->local_var["'".substr($this->yystack[$this->yyidx + 0]->minor,1)."'"])) {
                                                       $this->_retvalue = new _smarty_code($this, '$_smarty_tpl->tpl_vars[\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\']->value');
                                                      } else {
                                                       $this->_retvalue = new _smarty_code($this, '$_smarty_tpl->getVariable(\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\')->value');
                                                      }
                                                      $this->compiler->tag_nocache = $this->compiler->tag_nocache | $this->template->getVariable(trim($this->yystack[$this->yyidx + 0]->minor,"'"), null, true, false)->nocache;
      }
#line 2417 "smarty_internal_templateparser.php"
#line 566 "smarty_internal_templateparser.y"
    function yy_r181(){ $this->_retvalue = new _smarty_code($this, '('.$this->yystack[$this->yyidx + -1]->minor.')');     }
#line 2420 "smarty_internal_templateparser.php"
#line 567 "smarty_internal_templateparser.y"
    function yy_r182(){
   $this->_retvalue = new _smarty_tag($this, $this->yystack[$this->yyidx + 0]->minor);
      }
#line 2425 "smarty_internal_templateparser.php"
#line 570 "smarty_internal_templateparser.y"
    function yy_r183(){ $this->_retvalue = new _smarty_dq_content($this, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2428 "smarty_internal_templateparser.php"

    private $_retvalue;

    function yy_reduce($yyruleno)
    {
        $yymsp = $this->yystack[$this->yyidx];
        if (self::$yyTraceFILE && $yyruleno >= 0 
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf(self::$yyTraceFILE, "%sReduce (%d) [%s].\n",
                self::$yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (array_key_exists($yyruleno, self::$yyReduceMap)) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno]['lhs'];
        $yysize = self::$yyRuleInfo[$yyruleno]['rhs'];
        $this->yyidx -= $yysize;
        for($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            if (!self::$yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = new TP_yyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    function yy_parse_failed()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sFail!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
    }

    function yy_syntax_error($yymajor, $TOKEN)
    {
#line 73 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->yymajor = $yymajor;
    $this->compiler->trigger_template_error();
#line 2491 "smarty_internal_templateparser.php"
    }

    function yy_accept()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sAccept!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $stack = $this->yy_pop_parser_stack();
        }
#line 65 "smarty_internal_templateparser.y"

    $this->successful = !$this->internalError;
    $this->internalError = false;
    $this->retvalue = $this->_retvalue;
    //echo $this->retvalue."\n\n";
#line 2509 "smarty_internal_templateparser.php"
    }

    function doParse($yymajor, $yytokenvalue)
    {
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */
        
        if ($this->yyidx === null || $this->yyidx < 0) {
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = new TP_yyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            array_push($this->yystack, $x);
        }
        $yyendofinput = ($yymajor==0);
        
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sInput %s\n",
                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
        }
        
        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL &&
                  !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if (self::$yyTraceFILE) {
                    fprintf(self::$yyTraceFILE, "%sSyntax Error!\n",
                        self::$yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit ){
                        if (self::$yyTraceFILE) {
                            fprintf(self::$yyTraceFILE, "%sDiscard input token %s\n",
                                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 &&
                                 $yymx != self::YYERRORSYMBOL &&
        ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                              ){
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }            
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}
?>