/*
 * PPMPump.cc -- PPM Pump Implementation
 * Copyright (C) 2003 Charles Yates <charles.yates@pandora.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _KINO_PPM_PUMP_
#define _KINO_PPM_PUMP_

#include <stdio.h>
#include <string>

using std::string;

#include "DVPump.h"

class PPMFrame
{
	public:
		PPMFrame();
		PPMFrame( int width, int height );
		PPMFrame( PPMFrame &frame );
		virtual ~PPMFrame();
		virtual int ReadData( uint8_t *data, int length );
		virtual int WriteData( uint8_t *data, int length );
		virtual bool Flush( );
		uint8_t *GetImage( ) const;
		uint8_t *GetImage( int &_width, int &_height ) const;
		virtual bool ReadImage( );
		virtual bool WriteImage( bool alpha = false );
		bool GetPixel( uint8_t rgb[ 4 ], int x, int y );
		bool SetPixel( uint8_t rgb[ 4 ], int x, int y );
		void FillArea( int x, int y, int width, int height, uint8_t rgb[ 4 ] );
		bool Scale( int _width, int _height, int _quality = 3 );
		bool Overlay( string file, int x, int y, int w, int h, double weight = 1.0 );
		bool Overlay( PPMFrame &frame, int x, int y, int w, int h, double weight = 1.0 );
		bool Copy( PPMFrame & );
		bool Load( string filename );
		// Temporary
		void ExtractHeader( ) { }
		int GetWidth( ) { return width; }
		int GetHeight( ) { return height; }
		void SetOutputFile( FILE *file ) { output = file; }

	private:
		int ReadNumber( );
		bool ReadHeader( char *, int &, int &, int & );
		uint8_t *image;
		int width;
		int height;
		string description;
		FILE *output;
};

class PPMPump :
	public DataPump < PPMFrame >
{
};

#endif
