/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_GTK

#include "../player.h"
#include "../other.h"
#include "gdaemon.h"

#define getrandom(min, max) ((rand() % (int)(((max)+1) - (min))) + (min))
#define MAX_COLOR 10

char *gdaemon_admin_parse (daemon_client * c);

/* All inputs have a new color: */
GdkColor *
mix_get_color (void)
{
  static GdkColor color[MAX_COLOR];
  static int k = -1;

  if (k == -1)
    {

      for (k = 0; k < MAX_COLOR; k++)
	{
	  color[k].red = getrandom (0x00, 0xffff);
	  color[k].blue = getrandom (0x00, 0xffff);
	  color[k].green = getrandom (0x00, 0xffff);
	}

      k = 0;
    }
  else
    k++;

  if (k == MAX_COLOR)
    k = 0;

  return color + k;
}

/* Remove an input */
void
gdaemon_del_mix (daemon_client * c)
{
  int i;

  if (!c || !c->widget)
    return;

  pthread_mutex_lock (&gdaemon_mutex);

  gtk_container_remove (GTK_CONTAINER (gdaemon_box), c->widget);

  if (c->solo)
    for (i = 0; i < DAEMON_MAX_CLIENTS; i++)
      if (play->daemon->client[i] != NULL && play->daemon->client[i] != c)
	{
	  play->daemon->client[i]->mute -= 1;
	  gtk_widget_set_sensitive (play->daemon->client[i]->widget, TRUE);
	}

  pthread_mutex_unlock (&gdaemon_mutex);
}

/* Add an input */
GtkWidget *
gdaemon_add_mix (char *client, daemon_client * c)
{
  GtkWidget *admin;
  GtkWidget *kill;
  GtkWidget *solo;
  GtkWidget *mute;
  GtkWidget *label1;
  GtkWidget *label2;
  GtkWidget *vseparator;
  GtkWidget *hseparator;
  GtkWidget *table;
  GtkWidget *frame;
  GtkTooltips *tooltips;
  GtkStyle *style;
  GtkAdjustment *adj_vol;
  GtkAdjustment *adj_bal;

  pthread_mutex_lock (&gdaemon_mutex);

  frame = gtk_frame_new (client);
  gtk_widget_show (frame);

  style = gtk_style_copy (gtk_widget_get_default_style ());
  c->color = mix_get_color ();
  style->bg[GTK_STATE_NORMAL] = *c->color;
  gtk_widget_set_style (frame, style);

  table = gtk_table_new (0, 0, FALSE);
  gtk_widget_show (table);
  gtk_container_add (GTK_CONTAINER (frame), table);

  admin = gtk_button_new_with_label (_("Admin"));
  gtk_widget_show (admin);
  gtk_table_attach (GTK_TABLE (table), admin, 0, 3, 0, 1,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  if (c->socket)
    kill = gtk_button_new_with_label (_("Kill"));
  else
    kill = gtk_button_new_with_label (_("Close"));
  gtk_widget_show (kill);
  gtk_table_attach (GTK_TABLE (table), kill, 0, 3, 1, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  solo = gtk_toggle_button_new_with_label (_("Solo"));
  gtk_widget_show (solo);
  gtk_table_attach (GTK_TABLE (table), solo, 0, 3, 2, 3,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  mute = gtk_toggle_button_new_with_label (_("Mute"));
  gtk_widget_show (mute);
  gtk_table_attach (GTK_TABLE (table), mute, 0, 3, 3, 4,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  vseparator = gtk_vseparator_new ();
  gtk_widget_show (vseparator);
  gtk_table_attach (GTK_TABLE (table), vseparator, 1, 2, 5, 9,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL), 0, 0);

  hseparator = gtk_hseparator_new ();
  gtk_widget_show (hseparator);

  gtk_table_attach (GTK_TABLE (table), hseparator, 0, 3, 4, 5,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL), 0, 0);

  label1 = gtk_label_new (_("Volume"));
  gtk_widget_show (label1);
  gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_CENTER);
  gtk_table_attach (GTK_TABLE (table), label1, 0, 1, 6, 7,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  label2 = gtk_label_new (_("Balance"));
  gtk_widget_show (label2);
  gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_CENTER);
  gtk_table_attach (GTK_TABLE (table), label2, 2, 3, 6, 7,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  adj_vol = (GtkAdjustment *) gtk_adjustment_new (100, 0, 100, 5, 10, 0);
  c->w_volume = gtk_vscale_new (adj_vol);
  gtk_widget_show (c->w_volume);
  gtk_table_attach (GTK_TABLE (table), c->w_volume, 0, 1, 5, 6,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_range_set_inverted (GTK_RANGE (c->w_volume), TRUE);

  adj_bal = (GtkAdjustment *) gtk_adjustment_new (50, 0, 100, 5, 10, 0);
  c->w_balance = gtk_vscale_new (adj_bal);
  gtk_widget_show (c->w_balance);
  gtk_table_attach (GTK_TABLE (table), c->w_balance, 2, 3, 5, 6,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_range_set_inverted (GTK_RANGE (c->w_balance), TRUE);

  tooltips = gtk_tooltips_new ();
  c->w_v_up = gtk_toggle_button_new_with_label (_("CVU"));
  gtk_tooltips_set_tip (tooltips, c->w_v_up, _("Crossfade Volume Up"), NULL);
  gtk_widget_show (c->w_v_up);
  gtk_table_attach (GTK_TABLE (table), c->w_v_up, 0, 1, 7, 8,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  tooltips = gtk_tooltips_new ();
  c->w_v_down = gtk_toggle_button_new_with_label (_("CVD"));
  gtk_tooltips_set_tip (tooltips, c->w_v_down, _("Crossfade Volume Down"),
			NULL);
  gtk_widget_show (c->w_v_down);
  gtk_table_attach (GTK_TABLE (table), c->w_v_down, 0, 1, 8, 9,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  tooltips = gtk_tooltips_new ();
  c->w_b_up = gtk_toggle_button_new_with_label (_("CBU"));
  gtk_tooltips_set_tip (tooltips, c->w_b_up, _("Crossfade Balance Up"), NULL);
  gtk_widget_show (c->w_b_up);
  gtk_table_attach (GTK_TABLE (table), c->w_b_up, 2, 3, 7, 8,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  tooltips = gtk_tooltips_new ();
  c->w_b_down = gtk_toggle_button_new_with_label (_("CBD"));
  gtk_tooltips_set_tip (tooltips, c->w_b_down, _("Crossfade Balance Down"),
			NULL);
  gtk_widget_show (c->w_b_down);
  gtk_table_attach (GTK_TABLE (table), c->w_b_down, 2, 3, 8, 9,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  tooltips = gtk_tooltips_new ();
  c->w_autofader = gtk_toggle_button_new_with_label (_("AF"));
  gtk_tooltips_set_tip (tooltips, c->w_autofader, _("Auto Fader"), NULL);
  gtk_widget_show (c->w_autofader);
  gtk_table_attach (GTK_TABLE (table), c->w_autofader, 0, 3, 9, 10,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  if (!c->socket)
    gtk_widget_set_sensitive (admin, FALSE);

  if (c->mute)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (mute), TRUE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (mute), FALSE);

  if (c->solo)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (solo), TRUE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (solo), FALSE);

  if (c->volume != 100)
    gtk_adjustment_set_value (adj_vol, c->volume);

  if (c->balance != 0)
    gtk_adjustment_set_value (adj_bal,
			      (c->balance + 100) !=
			      0 ? (c->balance + 100) / 2 : 0);

  g_signal_connect ((gpointer) c->w_volume, "value_changed",
		    G_CALLBACK (on_dvolume_value_changed), c);
  g_signal_connect ((gpointer) c->w_balance, "value_changed",
		    G_CALLBACK (on_dbalance_value_changed), c);
  g_signal_connect ((gpointer) solo, "toggled", G_CALLBACK (on_solo_toggled),
		    c);
  g_signal_connect ((gpointer) kill, "clicked", G_CALLBACK (on_kill_clicked),
		    c);
  g_signal_connect ((gpointer) admin, "clicked",
		    G_CALLBACK (on_admin_clicked), c);
  g_signal_connect ((gpointer) mute, "toggled", G_CALLBACK (on_mute_toggled),
		    c);
  g_signal_connect ((gpointer) c->w_v_up, "toggled",
		    G_CALLBACK (crossfade_v_up_toggled), c);
  g_signal_connect ((gpointer) c->w_v_down, "toggled",
		    G_CALLBACK (crossfade_v_down_toggled), c);
  g_signal_connect ((gpointer) c->w_b_up, "toggled",
		    G_CALLBACK (crossfade_b_up_toggled), c);
  g_signal_connect ((gpointer) c->w_b_down, "toggled",
		    G_CALLBACK (crossfade_b_down_toggled), c);
  g_signal_connect ((gpointer) c->w_autofader, "toggled",
		    G_CALLBACK (autofader_toggled), c);

  gtk_box_pack_start (GTK_BOX (gdaemon_box), frame, TRUE, TRUE, 0);

  gtk_widget_show_all (gdaemon_box);

  pthread_mutex_unlock (&gdaemon_mutex);

  return frame;
}

void
on_kill_clicked (GtkWidget * w, daemon_client * c)
{
  if (c->socket)
    {
      char *buf;
      somaplayer_controller *sc = NULL;

      if (!(buf = strdup (c->socket)))
	fatal (_("Error: memory."));

      if (!strncmp (buf, "unix://", 7))
	{
	  sc = somaplayer_open_unix (buf + 7);
	}

      else if (!strncmp (buf, "tcp://", 6))
	{
	  char *server;
	  int i, port = 0;

	  server = buf + 6;

	  for (i = 0; i < strlen (server); i++)
	    {
	      if (server[i] == ':')
		{
		  if (i + 1 < strlen (server))
		    port = atoi (&server[i + 1]);

		  server[i] = 0;
		}
	    }

	  server = c->addr;
	  sc = somaplayer_open_tcp (server, port);
	}

      free (buf);

      if (sc)
	{
	  somaplayer_quit (sc);
	  somaplayer_close (sc);
	}
    }

  close (c->fd);
}

void
on_admin_clicked (GtkWidget * w, daemon_client * c)
{
  char *argv[4];
  int i = 0;
  char p[SIZE_BUFFER];
  struct stat st;
  char *socket;

  if (!c->socket)
    return;

  if(!(socket = gdaemon_admin_parse(c)))
	  return;

  snprintf (p, sizeof (p), SOMAPLAYER_CONTROLLER);
  if (lstat (p, &st))
    {
      snprintf (p, sizeof (p), "/usr/bin/somaplayer_controller");
      if (lstat (p, &st))
	{
	  snprintf (p, sizeof (p), "/usr/local/bin/somaplayer_controller");
	  if (lstat (p, &st))
	    {
	      GtkWidget *dialog;

	      dialog = gtk_message_dialog_new (GTK_WINDOW (windaemon),
					       GTK_DIALOG_MODAL |
					       GTK_DIALOG_DESTROY_WITH_PARENT,
					       GTK_MESSAGE_ERROR,
					       GTK_BUTTONS_OK,
					       _
					       ("SomaPlayer_Controller not found."));

	      gtk_dialog_run (GTK_DIALOG (dialog));
	      gtk_widget_destroy (dialog);
	      return;

	    }
	}
    }

  argv[i++] = p;
  argv[i++] = socket;
  argv[i++] = NULL;

  msg(_("Exec somaplayer_controller %s"),socket);

  switch (fork ())
    {
    case -1:
      fatal (_("Fork error."));

    case 0:
      execve (argv[0], argv, env);
      exit(1);
      break;

    default:
      free(socket);
      gpid++;
      break;
    }
}

char *
gdaemon_admin_parse (daemon_client * c)
{
  char *buf;

  if (!c->socket)
    return NULL;

  if (!(buf = strdup (c->socket)))
    fatal (_("Error: memory."));

  if (!strncmp (buf, "unix://", 7))
    return buf;

  else if (!strncmp (buf, "tcp://", 6))
    {
      char *server;
      int i, port = 0;
      char ret[1024];

      server = buf + 6;

      for (i = 0; i < strlen (server); i++)
	{
	  if (server[i] == ':')
	    {
	      if (i + 1 < strlen (server))
		port = atoi (&server[i + 1]);

	      server[i] = 0;
	    }
	}

      snprintf (ret, sizeof (ret), "tcp://%s:%d", c->addr, port);
      return strdup (ret);
    }

  return NULL;
}

#endif

/* EOF */
