'\" t
.\" ** The above line should force tbl to be a preprocessor **
.\" Man page for X vncviewer
.\"
.\" Copyright (C) 1998 Marcus.Brinkmann@ruhr-uni-bochum.de
.\" Copyright (C) 2000,2001 Red Hat, Inc.
.\" Copyright (C) 2001-2003 Constantin Kaplinsky <const@ce.cctpu.edu.ru>
.\" Copyright (C) 2006-2010 Karl J. Runge <runge@karlrunge.com>
.\"
.\" You may distribute under the terms of the GNU General Public
.\" License as specified in the file LICENCE.TXT that comes with the
.\" TightVNC distribution.
.\"
.TH ssvncviewer 1 "April 2010" "" "SSVNC"
.SH NAME
ssvncviewer \- an X viewer client for VNC
.SH SYNOPSIS
.B ssvncviewer
.RI [\| options \|]
.RI [\| host \|][\| :display \|]
.br
.B ssvncviewer
.RI [\| options \|]
.RI [\| host \|][\| ::port \|]
.br
.B ssvncviewer
.RI [\| options \|]
.RI exec=[\| cmd+args... \|]
.br
.B ssvncviewer
.RI [\| options \|]
.RI fd=n
.br
.B ssvncviewer
.RI [\| options \|]
.RI /path/to/unix/socket
.br
.B ssvncviewer
.RI [\| options \|]
.IR \-listen
.RI [\| display \|]
.br
.B ssvncviewer
.IR \-help
.br
.SH DESCRIPTION
.B ssvncviewer
is an Xt\-based client application for the VNC (Virtual Network
Computing) system. It can connect to any VNC\-compatible server such
as \fBXvnc\fR, WinVNC, or \fBx11vnc\fR, allowing you to control desktop environment
of a different machine.

ssvncviewer is an enhanced version of the tightvnc unix viewer that can
take advantage of features in the \fBx11vnc\fR and UltraVNC VNC servers.
See below for the description of these features.

You can use F8 to display a pop\-up utility menu. Press F8 twice to
pass single F8 to the remote side.
.SH OPTIONS
.TP
\fB\-help\fR
Prints a short usage notice to stderr.
.TP
\fB\-listen\fR
Make the viewer listen on port 5500+\fIdisplay\fR for reverse
connections from a server. WinVNC supports reverse connections using
the "Add New Client" menu option, or the \-connect command line
option. \fBXvnc\fR requires the use of the helper program
\fBvncconnect\fR.
.TP
\fB\-via\fR \fIgateway\fR
Automatically create encrypted TCP tunnel to the \fIgateway\fR machine
before connection, connect to the \fIhost\fR through that tunnel
(TightVNC\-specific). By default, this option invokes SSH local port
forwarding, assuming that SSH client binary can be accessed as
/usr/bin/ssh. Note that when using the \fB\-via\fR option, the host
machine name should be specified as known to the gateway machine, e.g. 
"localhost" denotes the \fIgateway\fR, not the machine where vncviewer
was launched. See the ENVIRONMENT section below for the information on
configuring the \fB\-via\fR option.
.TP
\fB\-shared\fR
When connecting, specify that a shared connection is requested. In
TightVNC, this is the default mode, allowing you to share the desktop
with other clients already using it.
.TP
\fB\-noshared\fR
When connecting, specify that the session may not be shared. This
would either disconnect other connected clients or refuse your
connection, depending on the server configuration.
.TP
\fB\-viewonly\fR
Disable transfer of mouse and keyboard events from the client to the
server.
.TP
\fB\-fullscreen\fR
Start in full\-screen mode. Please be aware that operating in
full\-screen mode may confuse X window managers. Typically, such
conflicts cause incorrect handling of input focus or make the viewer
window disappear mysteriously. See the grabKeyboard setting in the
RESOURCES section below for a method to solve input focus problem.
.TP
\fB\-noraiseonbeep\fR
By default, the viewer shows and raises its window on remote beep
(bell) event. This option disables such behaviour
(TightVNC\-specific).
.TP
\fB\-user\fR \fIusername\fR
User name for Unix login authentication. Default is to use current
Unix user name. If this option was given, the viewer will prefer Unix
login authentication over the standard VNC authentication.
.TP
\fB\-passwd\fR \fIpasswd\-file\fR
File from which to get the password (as generated by the
\fBvncpasswd\fR(1) program). This option affects only the standard VNC
authentication.
.TP
\fB\-encodings\fR \fIencoding\-list\fR
TightVNC supports several different compression methods to encode
screen updates; this option specifies a set of them to use in order of
preference. Encodings are specified separated with spaces, and must
thus be enclosed in quotes if more than one is specified.  Commas may be used to avoid spaces.
Available encodings, in default order for a remote connection, are
"copyrect tight hextile zlib corre rre raw". For a local connection
(to the same machine), the default order to try is "raw copyrect tight
hextile zlib corre rre". Raw encoding is always assumed as a last option
if no other encoding can be used for some reason. For more information
on encodings, see the section ENCODINGS below.
.TP
\fB\-bgr233\fR
Always use the BGR233 format to encode pixel data. This reduces
network traffic, but colors may be represented inaccurately. The
bgr233 format is an 8\-bit "true color" format, with 2 bits blue, 3
bits green, and 3 bits red.
.TP
\fB\-owncmap\fR
Try to use a PseudoColor visual and a private colormap. This allows
the VNC server to control the colormap.
.TP
\fB\-truecolour\fR, \fB\-truecolor\fR
Try to use a TrueColor visual.
.TP
\fB\-depth\fR \fIdepth\fR
On an X server which supports multiple TrueColor visuals of different
depths, attempt to use the specified one (in bits per pixel); if
successful, this depth will be requested from the VNC server.
.TP
\fB\-compresslevel \fIlevel\fR
Use specified compression \fIlevel\fR (0..9) for "tight" and "zlib"
encodings (TightVNC\-specific). Level 1 uses minimum of CPU time and
achieves weak compression ratios, while level 9 offers best
compression but is slow in terms of CPU time consumption on the server
side. Use high levels with very slow network connections, and low
levels when working over high\-speed LANs. It's not recommended to use
compression level 0, reasonable choices start from the level 1.
.TP
\fB\-quality \fIlevel\fR
Use the specified JPEG quality \fIlevel\fR (0..9) for the "tight"
encoding (TightVNC\-specific). Quality level 0 denotes bad image
quality but very impressive compression ratios, while level 9 offers
very good image quality at lower compression ratios. Note that the
"tight" encoder uses JPEG to encode only those screen areas that look
suitable for lossy compression, so quality level 0 does not always
mean unacceptable image quality.
.TP
\fB\-nojpeg\fR
Disable lossy JPEG compression in Tight encoding (TightVNC\-specific). 
Disabling JPEG compression is not a good idea in typical cases, as
that makes the Tight encoder less efficient. You might want to use
this option if it's absolutely necessary to achieve perfect image
quality (see also the \fB\-quality\fR option).
.TP
\fB\-nocursorshape\fR
Disable cursor shape updates, protocol extensions used to handle
remote cursor movements locally on the client side
(TightVNC\-specific). Using cursor shape updates decreases delays with
remote cursor movements, and can improve bandwidth usage dramatically. 
.TP
\fB\-x11cursor\fR
Use a real X11 cursor with X-style cursor shape updates, instead of
drawing the remote cursor on the framebuffer. This option also
disables the dot cursor, and disables cursor position updates in
non-fullscreen mode.
.TP
\fB\-autopass\fR
Read a plain-text password from stdin. This option affects only the
standard VNC authentication.

.SH Enhanced TightVNC Viewer (SSVNC) OPTIONS
.TP
Enhanced TightVNC Viewer (SSVNC) web page is located at:
.TP
http://www.karlrunge.com/x11vnc/ssvnc.html
.TP
Note: ZRLE and ZYWRLE encodings are now supported.
.TP
Note: F9 is shortcut to Toggle FullScreen mode.
.TP
Note: In -listen mode set the env var. SSVNC_MULTIPLE_LISTEN=1
to allow more than one incoming VNC server at a time.
This is the same as -multilisten described below.  Set
SSVNC_MULTIPLE_LISTEN=MAX:n to allow no more than "n"
simultaneous reverse connections.

If the host:port is specified as "exec=command args..."
then instead of making a TCP/IP socket connection to the
remote VNC server, "command args..." is executed and the
viewer is attached to its stdio.  This enables tunnelling
established via an external command, e.g. an stunnel(8)
that does not involve a listening socket.
This mode does not work for -listen reverse connections.

If the host:port is specified as "fd=n" then it is assumed
n is an already opened file descriptor to the socket. (i.e
the parent did fork+exec)

If the host:port contains a '/' it is interpreted as a
unix-domain socket (AF_LOCAL insead of AF_INET)
.TP
\fB\-multilisten\fR
As in -listen (reverse connection listening) except
allow more than one incoming VNC server to be connected
at a time.  The default for -listen of only one at a
time tries to play it safe by not allowing anyone on
the network to put (many) desktops on your screen over
a long window of time. Use -multilisten for no limit.
.TP
\fB\-acceptpopup\fR
In \fB\-listen\fR (reverse connection listening) mode when
a reverse VNC connection comes in show a popup asking
whether to Accept or Reject the connection.  The IP
address of the connecting host is shown.  Same as
setting the env. var. SSVNC_ACCEPT_POPUP=1.
.TP
\fB\-acceptpopupsc\fR
As in \fB\-acceptpopup\fR except assume UltraVNC Single
Click (SC) server.  Retrieve User and ComputerName
info from UltraVNC Server and display in the Popup.
.TP
\fB\-use64\fR
In \fB\-bgr233\fR mode, use 64 colors instead of 256.
.TP
\fB\-bgr222\fR
Same as \fB\-use64\fR.
.TP
\fB\-use8\fR
In \fB\-bgr233\fR mode, use 8 colors instead of 256.
.TP
\fB\-bgr111\fR
Same as \fB\-use8\fR.
.TP
\fB\-16bpp\fR
If the vnc viewer X display is depth 24 at 32bpp
request a 16bpp format from the VNC server to cut
network traffic by up to 2X, then tranlate the
pixels to 32bpp locally.
.TP
\fB\-bgr565\fR
Same as \fB\-16bpp\fR.
.TP
\fB\-grey\fR
Use a grey scale for the 16- and 8\fB\-bpp\fR modes.
.TP
\fB\-alpha\fR
Use alphablending transparency for local cursors
requires: x11vnc server, both client and server
must be 32bpp and same endianness.
.TP
\fB\-scale\fR \fIstr\fR
Scale the desktop locally.  The string "str" can
a floating point ratio, e.g. "0.9", or a fraction,
e.g. "3/4", or WxH, e.g. 1280x1024.  Use "fit"
to fit in the current screen size.  Use "auto" to
fit in the window size.  "str" can also be set by
the env. var. SSVNC_SCALE.

If you observe mouse trail painting errors, enable
X11 Cursor mode (either via Popup or \fB\-x11cursor\fR.)

Note that scaling is done in software and so can be
slow and requires more memory.  Some speedup Tips:

ZRLE is faster than Tight in this mode.  When
scaling is first detected, the encoding will
be automatically switched to ZRLE.  Use the
Popup menu if you want to go back to Tight.
Set SSVNC_PRESERVE_ENCODING=1 to disable this.

Use a solid background on the remote side.
(e.g. manually or via x11vnc \fB\-solid\fR ...)

If the remote server is x11vnc, try client
side caching: x11vnc \fB\-ncache\fR 10 ...
.TP
\fB\-ycrop\fR n
Only show the top n rows of the framebuffer.  For
use with x11vnc \fB\-ncache\fR client caching option
to help "hide" the pixel cache region.
Use a negative value (e.g. \fB\-1\fR) for autodetection.
Autodetection will always take place if the remote
fb height is more than 2 times the width.
.TP
\fB\-sbwidth\fR n
Scrollbar width for x11vnc \fB\-ncache\fR mode (\fB\-ycrop\fR),
default is very narrow: 2 pixels, it is narrow to
avoid distraction in \fB\-ycrop\fR mode.
.TP
\fB\-nobell\fR
Disable bell.
.TP
\fB\-rawlocal\fR
Prefer raw encoding for localhost, default is
no, i.e. assumes you have a SSH tunnel instead.
.TP
\fB\-notty\fR
Try to avoid using the terminal for interactive
responses: use windows for messages and prompting
instead.  Messages will also be printed to terminal.
.TP
\fB\-sendclipboard\fR
Send the X CLIPBOARD selection (i.e. Ctrl+C,
Ctrl+V) instead of the X PRIMARY selection (mouse
select and middle button paste.)
.TP
\fB\-sendalways\fR
Whenever the mouse enters the VNC viewer main
window, send the selection to the VNC server even if
it has not changed.  This is like the Xt resource
translation SelectionToVNC(always)
.TP
\fB\-recvtext\fR
str   When cut text is received from the VNC server,
ssvncviewer will set both the X PRIMARY and the
X CLIPBOARD local selections.  To control which
is set, specify 'str' as 'primary', 'clipboard',
or 'both' (the default.)
.TP
\fB\-graball\fR
Grab the entire X server when in fullscreen mode,
needed by some old window managers like fvwm2.
.TP
\fB\-popupfix\fR
Warp the popup back to the pointer position,
needed by some old window managers like fvwm2.
.TP
\fB\-grabkbd\fR
Grab the X keyboard when in fullscreen mode,
needed by some window managers. Same as \fB\-grabkeyboard\fR.
\fB\-grabkbd\fR is the default, use \fB\-nograbkbd\fR to disable.
.TP
\fB\-bs\fR, \fB\-nobs\fR
Whether or not to use X server Backingstore for the
main viewer window.  The default is to not, mainly
because most Linux, etc, systems X servers disable
*all* Backingstore by default.  To re\fB\-enable\fR it put

Option "Backingstore"

in the Device section of /etc/X11/xorg.conf.
In \fB\-bs\fR mode with no X server backingstore, whenever an
area of the screen is re\fB\-exposed\fR it must go out to the
VNC server to retrieve the pixels. This is too slow.

In \fB\-nobs\fR mode, memory is allocated by the viewer to
provide its own backing of the main viewer window. This
actually makes some activities faster (changes in large
regions) but can appear to "flash" too much.
.TP
\fB\-noshm\fR
Disable use of MIT shared memory extension (not recommended)
.TP
\fB\-termchat\fR
Do the UltraVNC chat in the terminal vncviewer is in
instead of in an independent window.
.TP
\fB\-unixpw\fR \fIstr\fR
Useful for logging into x11vnc in \fB\-unixpw\fR mode. "str" is a
string that allows many ways to enter the Unix Username
and Unix Password.  These characters: username, newline,
password, newline are sent to the VNC server after any VNC
authentication has taken place.  Under x11vnc they are
used for the \fB\-unixpw\fR login.  Other VNC servers could do
something similar.

You can also indicate "str" via the environment
variable SSVNC_UNIXPW.

Note that the Escape key is actually sent first to tell
x11vnc to not echo the Unix Username back to the VNC
viewer. Set SSVNC_UNIXPW_NOESC=1 to override this.

If str is ".", then you are prompted at the command line
for the username and password in the normal way.  If str is
"-" the stdin is read via getpass(3) for username@password.
Otherwise if str is a file, it is opened and the first line
read is taken as the Unix username and the 2nd as the
password. If str prefixed by "rm:" the file is removed
after reading. Otherwise, if str has a "@" character,
it is taken as username@password. Otherwise, the program
exits with an error. Got all that?
.TP
\fB-repeater\fR \fIstr\fR
This is for use with UltraVNC repeater proxy described
here: http://www.uvnc.com/addons/repeater.html.  The "str"
is the ID string to be sent to the repeater.  E.g. ID:1234
It can also be the hostname and port or display of the VNC
server, e.g. 12.34.56.78:0 or snoopy.com:1.  Note that when
using -repeater, the host:dpy on the cmdline is the repeater
server, NOT the VNC server.  The repeater will connect you.

Example: vncviewer ... -repeater ID:3333 repeat.host:5900

Example: vncviewer ... -repeater vhost:0 repeat.host:5900

Use, e.g., '-repeater SCIII=ID:3210' if the repeater is a
Single Click III (SSL) repeater (repeater_SSL.exe) and you
are passing the SSL part of the connection through stunnel, socat, etc.
This way the magic UltraVNC string 'testB' needed to work with the
repeater is sent to it.
.TP
\fB-rfbversion\fR \fIstr\fR
Set the advertised RFB version.  E.g.: -rfbversion 3.6  For some
servers, e.g. UltraVNC this needs to be done.
.TP
\fB-ultradsm\fR
UltraVNC has symmetric private encryption DSM plugins.  See
http://www.uvnc.com/features/encryption.html.  It is assumed
you are using a unix program (e.g. our ultravnc_dsm_helper) to
encrypt and decrypt the UltraVNC DSM stream. IN ADDITION TO
THAT supply -ultradsm to tell THIS viewer to modify the RFB
data sent so as to work with the UltraVNC Server.  For some
reason, each RFB msg type must be sent twice under DSM.
.TP
\fB\-mslogon\fR \fIuser\fR
Use Windows MS Logon to an UltraVNC server.  Supply the
username or "1" to be prompted.  The default is to
autodetect the UltraVNC MS Logon server and prompt for
the username and password.

IMPORTANT NOTE: The UltraVNC MS-Logon Diffie-Hellman
exchange is very weak and can be brute forced to recover
your username and password in a few seconds of CPU
time.  To be safe, be sure to use an additional encrypted
tunnel (e.g. SSL or SSH) for the entire VNC session.
.TP
\fB\-chatonly\fR
Try to be a client that only does UltraVNC text chat. This
mode is used by x11vnc to present a chat window on the physical
X11 console (i.e. to chat with the person at the display).
.TP
\fB-env\fR \fIVAR=VALUE\fR
To save writing a shell script to set environment
variables, specify as many as you need on the command line.  For example,
-env SSVNC_MULTIPLE_LISTEN=MAX:5 -env EDITOR=vi
.TP
\fB\-noipv6\fR
Disable all IPv6 sockets.  Same as VNCVIEWER_NO_IPV6=1.
.TP
\fB\-noipv4\fR
Disable all IPv4 sockets.  Same as VNCVIEWER_NO_IPV4=1.
.TP
\fB\-printres\fR
Print out the Ssvnc X resources (appdefaults) and
then exit. You can save them to a file and customize them (e.g. the
keybindings and Popup menu)  Then point to the file via
XENVIRONMENT or XAPPLRESDIR.
.TP
\fB\-pipeline\fR
Like TurboVNC, request the next framebuffer update as soon
as possible instead of waiting until the end of the current
framebuffer update coming in.  Helps 'pipeline' the updates.
This is currently the default, use \fB-nopipeline\fR to disable.
.TP
\fB\-appshare\fR
Enable features for use with x11vnc's \fB\-appshare\fR mode where
instead of sharing the full desktop only the application's
windows are shared.  Viewer multilisten mode is used to
create the multiple windows: \fB\-multilisten\fR is implied.
See 'x11vnc \fB\-appshare\fR \fB\-help\fR' more information on the mode.
Features enabled in the viewer under \fB\-appshare\fR are:
Minimum extra text in the title, auto \fB\-ycrop\fR is disabled,
x11vnc \fB\-remote_prefix\fR X11VNC_APPSHARE_CMD: message channel,
x11vnc initial window position hints.  See also Escape Keys
below for additional key and mouse bindings.
.TP
\fB\-escape \fR\fIstr\fR
This sets the 'Escape Keys' modifier sequence and enables
escape keys mode.  When the modifier keys escape sequence
is held down, the next keystroke is interpreted locally
to perform a special action instead of being sent to the
remote VNC server.

Use '\fB\-escape\fR default' for the default modifier sequence.
(Unix: Alt_L,Super_L and MacOSX: Control_L,Meta_L)

Here are the 'Escape Keys: Help+Set' instructions from the Popup:

Escape Keys:  Enter a comma separated list of modifier keys to be the 'escape
sequence'.  When these keys are held down, the next keystroke is
interpreted locally to invoke a special action instead of being sent to
the remote VNC server.  In other words, a set of 'Hot Keys'.

Here is the list of local key mappings to special actions:

r: refresh desktop  b: toggle bell  c: toggle full-color

f: file transfer    x: x11cursor    z: toggle Tight/ZRLE

l: full screen      g: graball      e: escape keys dialog

s: scale dialog     +: scale up (=) -: scale down (_)

t: text chat                        a: alphablend cursor

V: toggle viewonly  Q: quit viewer  123456: UltraVNC scale 1/n

Arrow keys: pan the viewport about 10% for each keypress.

PageUp/PageDown: pan the viewport by a screenful vertically.

Home/End: pan the viewport by a screenful horizontally.

KeyPad Arrows: pan the viewport by 1 pixel for each keypress.

Dragging the Mouse with Button1 pressed also pans the viewport.

Clicking Mouse Button3 brings up the Popup Menu.

The above mappings are \fBalways\fR active in ViewOnly mode, unless you set
the Escape Keys value to 'never'.

x11vnc -appshare hot-keys:  x11vnc has a simple application sharing mode
that enables the viewer-side to move, resize, or raise the remote toplevel
windows.  To enable it, hold down Shift + the Escape Keys and press these:

Arrow keys: move the remote window around in its desktop.

PageUp/PageDn/Home/End:  resize the remote window.

+/-: raise or lower the remote window.

M or Button1 move win to local position;  D or Button3: delete remote win.

If the Escape Keys value below is set to 'default' then a default list of
of modifier keys is used.  For Unix it is: Alt_L,Super_L and for MacOSX it
is Control_L,Meta_L.  Note: the Super_L key usually has a Windows(TM) Flag
on it.  Also note the _L and _R mean the key is on the LEFT or RIGHT side
of the keyboard.

On Unix   the default is Alt and Windows keys on Left side of keyboard.
On MacOSX the default is Control and Command keys on Left side of keyboard.

Example: Press and hold the Alt and Windows keys on the LEFT side of the
keyboard and then press 'c' to toggle the full-color state.  Or press 't'
to toggle the ultravnc Text Chat window, etc.

To use something besides the default, supply a comma separated list (or a
single one) from: Shift_L Shift_R Control_L Control_R Alt_L Alt_R Meta_L
Meta_R Super_L Super_R Hyper_L Hyper_R or Mode_switch.
.TP
\fB New Popup actions:\fR

 ViewOnly:                ~ -viewonly
 Disable Bell:            ~ -nobell
 Cursor Shape:            ~ -nocursorshape
 X11 Cursor:              ~ -x11cursor
 Cursor Alphablend:       ~ -alpha
 Toggle Tight/Hextile:    ~ -encodings hextile...
 Toggle Tight/ZRLE:       ~ -encodings zrle...
 Toggle ZRLE/ZYWRLE:      ~ -encodings zywrle...
 Quality Level            ~ -quality (both Tight and ZYWRLE)
 Compress Level           ~ -compresslevel
 Disable JPEG:            ~ -nojpeg  (Tight)
 Pipeline Updates         ~ -pipeline

 Full Color                 as many colors as local screen allows.
 Grey scale (16 & 8-bpp)  ~ -grey, for low colors 16/8bpp modes only.
 16 bit color (BGR565)    ~ -16bpp / -bgr565
 8  bit color (BGR233)    ~ -bgr233
 256 colors               ~ -bgr233 default # of colors.
  64 colors               ~ -bgr222 / -use64
   8 colors               ~ -bgr111 / -use8
 Scale Viewer             ~ -scale
 Escape Keys: Toggle      ~ -escape
 Escape Keys: Help+Set    ~ -escape
 Set Y Crop (y-max)       ~ -ycrop
 Set Scrollbar Width      ~ -sbwidth
 XGrabServer              ~ -graball

 UltraVNC Extensions:

   Set 1/n Server Scale     Ultravnc ext. Scale desktop by 1/n.
   Text Chat                Ultravnc ext. Do Text Chat.
   File Transfer            Ultravnc ext. File xfer via Java helper.
   Single Window            Ultravnc ext. Grab and view a single window.
                            (select then click on the window you want).
   Disable Remote Input     Ultravnc ext. Try to prevent input and
                            viewing of monitor at physical display.

 Note: the Ultravnc extensions only apply to servers that support
       them.  x11vnc/libvncserver supports some of them.

 Send Clipboard not Primary  ~ -sendclipboard
 Send Selection Every time   ~ -sendalways

.SH ENCODINGS
The server supplies information in whatever format is desired by the
client, in order to make the client as easy as possible to implement. 
If the client represents itself as able to use multiple formats, the
server will choose one.

.I Pixel format
refers to the representation of an individual pixel. The most common
formats are 24 and 16 bit "true\-color" values, and 8\-bit "color map"
representations, where an arbitrary map converts the color number to
RGB values.

.I Encoding
refers to how a rectangle of pixels are sent (all pixel information in
VNC is sent as rectangles). All rectangles come with a header giving
the location and size of the rectangle and an encoding type used by
the data which follows. These types are listed below.
.TP
.B Raw
The raw encoding simply sends width*height pixel values. All clients
are required to support this encoding type. Raw is also the fastest
when the server and viewer are on the same machine, as the connection
speed is essentially infinite and raw encoding minimizes processing
time.
.TP
.B CopyRect
The Copy Rectangle encoding is efficient when something is being
moved; the only data sent is the location of a rectangle from which
data should be copied to the current location. Copyrect could also be
used to efficiently transmit a repeated pattern.
.TP
.B RRE
The Rise\-and\-Run\-length\-Encoding is basically a 2D version of
run\-length encoding (RLE). In this encoding, a sequence of identical
pixels are compressed to a single value and repeat count. In VNC, this
is implemented with a background color, and then specifications of an
arbitrary number of subrectangles and color for each. This is an
efficient encoding for large blocks of constant color.
.TP
.B CoRRE
This is a minor variation on RRE, using a maximum of 255x255 pixel
rectangles. This allows for single\-byte values to be used, reducing
packet size. This is in general more efficient, because the savings
from sending 1\-byte values generally outweighs the losses from the
(relatively rare) cases where very large regions are painted the same
color.
.TP
.B Hextile
Here, rectangles are split up in to 16x16 tiles, which are sent in a
predetermined order. The data within the tiles is sent either raw or
as a variant on RRE. Hextile encoding is usually the best choice for
using in high\-speed network environments (e.g. Ethernet local\-area
networks).
.TP
.B Zlib
Zlib is a very simple encoding that uses zlib library to compress raw
pixel data. This encoding achieves good compression, but consumes a
lot of CPU time. Support for this encoding is provided for
compatibility with VNC servers that might not understand Tight
encoding which is more efficient than Zlib in nearly all real\-life
situations.
.TP
.B Tight
Like Zlib encoding, Tight encoding uses zlib library to compress the
pixel data, but it pre\-processes data to maximize compression ratios,
and to minimize CPU usage on compression. Also, JPEG compression may
be used to encode color\-rich screen areas (see the description of
\-quality and \-nojpeg options above). Tight encoding is usually the
best choice for low\-bandwidth network environments (e.g. slow modem
connections).
.TP
.B ZRLE
The SSVNC viewer has ported the RealVNC (www.realvnc.com) ZRLE encoding
to the unix tightvnc viewer.
.TP
.B ZYWRLE
The SSVNC viewer has ported the Hitachi lossy wavelet based ZRLE
encoding from http://mobile.hitachi-system.co.jp/publications/ZYWRLE/ 
to the unix tightvnc viewer.
.SH RESOURCES
X resources that \fBvncviewer\fR knows about, aside from the
normal Xt resources, are as follows:
.TP
.B shareDesktop
Equivalent of \fB\-shared\fR/\fB\-noshared\fR options. Default true.
.TP
.B viewOnly
Equivalent of \fB\-viewonly\fR option. Default false.
.TP
.B fullScreen
Equivalent of \fB\-fullscreen\fR option. Default false.
.TP
.B grabKeyboard
Grab keyboard in full-screen mode. This can help to solve problems
with losing keyboard focus. Default false.
.TP
.B raiseOnBeep
Equivalent of \fB\-noraiseonbeep\fR option, when set to false. Default
true.
.TP
.B passwordFile
Equivalent of \fB\-passwd\fR option.
.TP
.B userLogin
Equivalent of \fB\-user\fR option.
.TP
.B passwordDialog
Whether to use a dialog box to get the password (true) or get it from
the tty (false). Irrelevant if \fBpasswordFile\fR is set. Default
false.
.TP
.B encodings
Equivalent of \fB\-encodings\fR option.
.TP
.B compressLevel
Equivalent of \fB\-compresslevel\fR option (TightVNC\-specific).
.TP
.B qualityLevel
Equivalent of \fB\-quality\fR option (TightVNC\-specific).
.TP
.B enableJPEG
Equivalent of \fB\-nojpeg\fR option, when set to false. Default true.
.TP
.B useRemoteCursor
Equivalent of \fB\-nocursorshape\fR option, when set to false
(TightVNC\-specific). Default true.
.TP
.B useBGR233
Equivalent of \fB\-bgr233\fR option. Default false.
.TP
.B nColours
When using BGR233, try to allocate this many "exact" colors from the
BGR233 color cube. When using a shared colormap, setting this resource
lower leaves more colors for other X clients. Irrelevant when using
truecolor. Default is 256 (i.e. all of them).
.TP
.B useSharedColours
If the number of "exact" BGR233 colors successfully allocated is less
than 256 then the rest are filled in using the "nearest" colors
available. This resource says whether to only use the "exact" BGR233
colors for this purpose, or whether to use other clients' "shared"
colors as well. Default true (i.e. use other clients' colors).
.TP
.B forceOwnCmap
Equivalent of \fB\-owncmap\fR option. Default false.
.TP
.B forceTrueColour
Equivalent of \fB\-truecolour\fR option. Default false.
.TP
.B requestedDepth
Equivalent of \fB\-depth\fR option.
.TP
.B useSharedMemory
Use MIT shared memory extension if on the same machine as the X
server. Default true.
.TP
.B wmDecorationWidth, wmDecorationHeight
The total width and height taken up by window manager decorations.
This is used to calculate the maximum size of the VNC viewer window. 
Default is width 4, height 24.
.TP
.B bumpScrollTime, bumpScrollPixels
When in full screen mode and the VNC desktop is bigger than the X
display, scrolling happens whenever the mouse hits the edge of the
screen. The maximum speed of scrolling is bumpScrollPixels pixels
every bumpScrollTime milliseconds. The actual speed of scrolling will
be slower than this, of course, depending on how fast your machine is. 
Default 20 pixels every 25 milliseconds.
.TP
.B popupButtonCount
The number of buttons in the popup window. See the README file for
more information on how to customize the buttons.
.TP
.B debug
For debugging. Default false.
.TP
.B rawDelay, copyRectDelay
For debugging, see the README file for details. Default 0 (off).
.SH ENVIRONMENT
When started with the \fB\-via\fR option, vncviewer reads the
\fBVNC_VIA_CMD\fR environment variable, expands patterns beginning
with the "%" character, and executes result as a command assuming that
it would create TCP tunnel that should be used for VNC connection. If
not set, this environment variable defaults to "/usr/bin/ssh -f -L
%L:%H:%R %G sleep 20".

The following patterns are recognized in the \fBVNC_VIA_CMD\fR (note
that all the patterns %G, %H, %L and %R must be present in the command
template):
.TP
.B %%
A literal "%";
.TP
.B %G
gateway host name;
.TP
.B %H
remote VNC host name, as known to the gateway;
.TP
.B %L
local TCP port number;
.TP
.B %R
remote TCP port number.
.SH SEE ALSO
\fBvncserver\fR(1), \fBx11vnc\fR(1), \fBssvnc\fR(1), \fBXvnc\fR(1), \fBvncpasswd\fR(1),
\fBvncconnect\fR(1), \fBssh\fR(1), http://www.karlrunge.com/x11vnc, http://www.karlrunge.com/x11vnc/ssvnc.html
.SH AUTHORS
Original VNC was developed in AT&T Laboratories Cambridge. TightVNC
additions was implemented by Constantin Kaplinsky. Many other people
participated in development, testing and support.  Karl J. Runge 
added all of the SSVNC related features and improvements.

\fBMan page authors:\fR
.br
Marcus Brinkmann <Marcus.Brinkmann@ruhr-uni-bochum.de>,
.br
Terran Melconian <terran@consistent.org>,
.br
Tim Waugh <twaugh@redhat.com>,
.br
Constantin Kaplinsky <const@ce.cctpu.edu.ru>
.br
Karl J. Runge <runge@karlrunge.com>
