""" OPMLExport.py
"""

__copyright__ = "Copyright (c) 2002-2005 Free Software Foundation, Inc."
__license__ = """
Straw is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

Straw is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 59 Temple
Place - Suite 330, Boston, MA 02111-1307, USA. """


import pygtk
pygtk.require('2.0')
import gnomevfs
import OPML

def export(title, list, fname):
    opml = OPML.OPML()
    opml['title'] = title
    for feed in list:
        o = OPML.Outline()
        o['text'] = feed.title.encode('utf-8')
        o['description'] = feed.channel_description.encode('utf-8')
        o['htmlUrl'] = feed.channel_link
        o['language'] = 'unknown'
        o['title'] = feed.channel_title.encode('utf-8')
        o['type'] = 'rss'
        o['version'] = 'RSS'
        o['xmlUrl'] = feed.access_info[0]
        opml.outlines.append(o)
    f = gnomevfs.create(fname, gnomevfs.OPEN_WRITE, 0)
    f.write('<?xml version="1.0"?>\n')
    opml.output(f)
    f.close()


