/*
 * \file <debug.c>
 * Routines to help with debugging
 * \author Josh Green <jgreen@users.sourceforge.net>
 * \date 2001
 *
 * libInstPatch
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "instpatch.h"
#include "i18n.h"

/**
 * Dump debugging information about the internals of an item
 * @item Item to display info on
 */
void
instp_item_dump (IPItem *item)
{
  g_return_if_fail (item != NULL);

  switch (item->type)
    {
    case IPITEM_SFONT:
      //      dump_sfdata (item);
      break;
    case IPITEM_PRESET:
      //      dump_preset (item);
      break;
    case IPITEM_INST:
      //      dump_inst (item);
      break;
    case IPITEM_SAMPLE:
      //      dump_sample (item);
      break;
    case IPITEM_SAMPLE_DATA:
      dump_sample_data (INSTP_SAMPLE_DATA (item));
      break;
    case IPITEM_ZONE:
      //      dump_zone (item);
      break;
    default:
      break;
    }
}

static void
dump_sample_data (IPSampleData *sample_data)
{
  IPSampleStore *store;

  printf ("IPSampleData (&0x%p)\n", sample_data);
  dump_item_info (INSTP_ITEM (sample_data));
  printf ("size = %d\n", sample_data->size);

  store = sample_data->storage;

  if (!store)
    {
      printf ("No Stores!");
      return;
    }

  while (store)
    {
      
      store = instp_sample_store_next (store);
    }
}
