/** sound font database operation type */
typedef enum
{
  SFDB_OPER_SELECT,		/* item select operation */
  SFDB_OPER_ADD,		/* item add operation */
  SFDB_OPER_CHANGE,		/* item change operation */
  SFDB_OPER_DELETE,		/* item delete operation */
  SFDB_OPER_QUERY,		/* item query operation */
  SFDB_OPER_LOCK,		/* lock sound font (read/write) */
  SFDB_OPER_UNLOCK		/* unlock a sound font */
}
SFdbOperType;

/* sound font database item type */
typedef enum
{
  SFDB_ITEM_NONE,		/* a NULL value */
  SFDB_ITEM_SFONT,		/* sound font */
  SFDB_ITEM_INFO,		/* sound font info item */
  SFDB_ITEM_PRESET,		/* preset */
  SFDB_ITEM_INST,		/* instrument */
  SFDB_ITEM_SAMPLE,		/* sample */
  SFDB_ITEM_SAMPLE_DATA,	/* sample data */
  SFDB_ITEM_PZONE,		/* preset zone */
  SFDB_ITEM_IZONE,		/* instrument zone */
  SFDB_ITEM_PGEN,		/* preset generator */
  SFDB_ITEM_IGEN,		/* instrument generator */
  SFDB_ITEM_PMOD,		/* preset modulator */
  SFDB_ITEM_IMOD		/* instrument modulator */
}
SFdbItemType;

typedef char[4] SFdbInfoID;

typedef struct
{
  guint16 len;
  char val[1];
}
SFdbInfoVal;

typedef struct
{
  guint16 bank;
  guint16 psetnum;
}
SFdbPresetID;

typedef struct
{
  char name[20];
  guint32 libr;
  guint32 genre;
  guint32 morph;
}
SFdbPresetVal;

typedef char[20] SFdbInstID;

typedef char[20] SFdbSampleID;

typedef struct
{
  guint32 size;                /* size of sample (maybe < datainfo.size) */
  guint32 loopstart;           /* Offset to start of loop */
  guint32 loopend;             /* Ofs to 1st point after loop */
  guint32 samplerate;          /* Sample rate recorded at */
  guint8 origpitch;            /* root midi key number */
  gint8 pitchadj;              /* pitch correction in cents */
  guint16 sampletype;          /* 1 mono,2 right,4 left,linked 8,0x8000=ROM */
}
SFdbSampleVal;

typedef struct
{
  guint32 total_size;		/* total size of this sample (in samples) */
  guint32 this_size;		/* size of this chunk (in samples),
				   for sending in partial blocks */
  gint16 samples[1];		/* "this_size" amount of samples */
}
SFdbSampleDataVal;

typedef guint16 SFdbGenID;
typedef IPGenAmount SFdbGenVal;

typedef struct
{
  guint16 src;
  guint16 dest;
  guint16 amtsrc;
}
SFdbModID;

typedef struct
{
  gint16 amount;
  guint16 trans;
}
SFdbModVal;

/** Sound font database event */
typedef union
{
  guint8 oper;			/* operation type (select, add, delete, etc) */
  guint8 flags;
  SFdbItemType item_type;	/* item type */
  SFdbSFontID sfid;		/* sound font id structure */
}
SFdbEvent;


char *sfdb_construct (SFdbSFontID *sfid, SFdbItemType item_type,
		      SFdbOperType oper, ...);


ADD INFO
 Header
 InfoID
 InfoVal

CHN INFO
 Header
 InfoID
 InfoVal

DEL INFO
 Header
 InfoID

ADD PRESET
 Header
 PresetID
 PresetVal

CHN PRESET
 Header
 PresetID	/* old preset bank:preset */
 PresetID	/* new bank:preset */
 PresetVal

DEL PRESET
 Header
 PresetID

ADD INST
 Header
 InstID

CHN INST
 Header
 InstID
 InstID

DEL INST
 Header
 InstID

ADD SAMPLE
 Header
 SampleID
 SampleVal

CHN SAMPLE
 Header
 SampleID
 SampleID
 SampleVal

DEL SAMPLE
 Header
 SampleID

ADD SAMPLE_DATA
 Header
 SampleID
 SampleDataVal

CHN SAMPLE_DATA
 Header
 SampleID
 SampleDataVal

DEL SAMPLE_DATA
 <invalid>

ADD PZONE/IZONE
 Header
 PresetID/InstID
 int InsertPosition

CHN PZONE/IZONE
 <invalid>

DEL PZONE/IZONE
 Header
 PresetID/InstID
 int Position

ADD/CHN PGEN/IGEN
 Header
 PresetID/InstID
 int ZonePosition
 GenID
 GenVal

DEL PGEN/IGEN
 Header
 PresetID/InstID
 int ZonePosition
 GenID

ADD PMOD/IMOD
 Header
 PresetID/InstID
 int ZonePosition
 ModID
 ModVal 

CHN PMOD/IMOD
 Header
 PresetID/InstID
 int ZonePosition
 ModID
 ModID
 ModVal

DEL PMOD/IMOD
 Header
 PresetID/InstID
 int ZonePosition
 ModID


/* sound font item to stream functions */

char *sfdb_info_to_stream (IPSFontInfo *info);
char *sfdb_preset_to_stream (IPPreset *pset);
char *sfdb_inst_to_stream (IPInst *inst);
char *sfdb_sample_to_stream (IPSample *sam);
char *sfdb_zone_to_stream (IPZone *zone);
char *sfdb_gen_to_stream (IPGen *gen);
char *sfdb_mod_to_stream (IPMod *mod);


/* stream to sound font item functions */

IPSFontInfo *sfdb_stream_to_info (char *buf);
IPPreset *sfdb_stream_to_preset (char *buf);
IPInst *sfdb_stream_to_inst (char *buf);
IPSample *sfdb_stream_to_sample (char *buf);
IPZone *sfdb_stream_to_zone (char *buf);
IPGen *sfdb_stream_to_gen (char *buf);
IPMod *sfdb_stream_to_mod (char *buf);
