CREATE TABLE `colors` (`name` TEXT NOT NULL, `red` INTEGER NOT NULL, `green` INTEGER NOT NULL, `blue` INTEGER NOT NULL, `alpha` INTEGER NOT NULL DEFAULT 255, id int auto_increment not null default -1);
INSERT INTO "colors" VALUES('red',255,10,10,255,1);
INSERT INTO "colors" VALUES('blue',0,72,181,255,2);
INSERT INTO "colors" VALUES('green',0,160,23,255,3);
INSERT INTO "colors" VALUES('orange',224,102,0,255,4);
INSERT INTO "colors" VALUES('purple',128,0,128,255,5);
INSERT INTO "colors" VALUES('cyan',0,255,255,255,6);
INSERT INTO "colors" VALUES('yellow',255,215,0,255,7);
INSERT INTO "colors" VALUES('pink',255,0,255,255,8);
INSERT INTO "colors" VALUES('teal',0,146,139,255,9);
INSERT INTO "colors" VALUES('lemon',0,255,0,255,10);
INSERT INTO "colors" VALUES('bordeaux',150,6,40,255,11);
INSERT INTO "colors" VALUES('white',255,255,255,255,12);
INSERT INTO "colors" VALUES('gray',128,128,128,255,13);
INSERT INTO "colors" VALUES('black',0,0,0,255, 14);
CREATE TABLE `ground_class` (`ground` INTEGER NOT NULL, `class` TEXT NOT NULL);
INSERT INTO "ground_class" VALUES(6,'constructible');
INSERT INTO "ground_class" VALUES(5,'coastline');
INSERT INTO "ground_class" VALUES(1,'constructible');
INSERT INTO "ground_class" VALUES(9,'constructible');
INSERT INTO "ground_class" VALUES(10,'constructible');
INSERT INTO "ground_class" VALUES(11,'constructible');
INSERT INTO "ground_class" VALUES(12,'constructible');
INSERT INTO "ground_class" VALUES(17,'constructible');
INSERT INTO "ground_class" VALUES(18,'constructible');
INSERT INTO "ground_class" VALUES(19,'constructible');
INSERT INTO "ground_class" VALUES(20,'constructible');
INSERT INTO "ground_class" VALUES(25,'constructible');
INSERT INTO "ground_class" VALUES(26,'constructible');
INSERT INTO "ground_class" VALUES(27,'constructible');
INSERT INTO "ground_class" VALUES(28,'constructible');
INSERT INTO "ground_class" VALUES(2,'constructible');
INSERT INTO "ground_class" VALUES(49,'coastline');
INSERT INTO "ground_class" VALUES(50,'coastline');
INSERT INTO "ground_class" VALUES(51,'coastline');
INSERT INTO "ground_class" VALUES(52,'coastline');
INSERT INTO "ground_class" VALUES(57,'coastline');
INSERT INTO "ground_class" VALUES(58,'coastline');
INSERT INTO "ground_class" VALUES(59,'coastline');
INSERT INTO "ground_class" VALUES(60,'coastline');
INSERT INTO "ground_class" VALUES(65,'coastline');
INSERT INTO "ground_class" VALUES(66,'coastline');
INSERT INTO "ground_class" VALUES(67,'coastline');
INSERT INTO "ground_class" VALUES(68,'coastline');
INSERT INTO "ground_class" VALUES(68,'coastline');
INSERT INTO "ground_class" VALUES(1,'constructible');
INSERT INTO "ground_class" VALUES(9,'constructible');
INSERT INTO "ground_class" VALUES(10,'constructible');
INSERT INTO "ground_class" VALUES(11,'constructible');
INSERT INTO "ground_class" VALUES(12,'constructible');
INSERT INTO "ground_class" VALUES(17,'constructible');
INSERT INTO "ground_class" VALUES(18,'constructible');
INSERT INTO "ground_class" VALUES(19,'constructible');
INSERT INTO "ground_class" VALUES(20,'constructible');
INSERT INTO "ground_class" VALUES(25,'constructible');
INSERT INTO "ground_class" VALUES(26,'constructible');
INSERT INTO "ground_class" VALUES(27,'constructible');
INSERT INTO "ground_class" VALUES(28,'constructible');
INSERT INTO "ground_class" VALUES(2,'constructible');
INSERT INTO "ground_class" VALUES(49,'coastline');
INSERT INTO "ground_class" VALUES(50,'coastline');
INSERT INTO "ground_class" VALUES(51,'coastline');
INSERT INTO "ground_class" VALUES(52,'coastline');
INSERT INTO "ground_class" VALUES(57,'coastline');
INSERT INTO "ground_class" VALUES(58,'coastline');
INSERT INTO "ground_class" VALUES(59,'coastline');
INSERT INTO "ground_class" VALUES(60,'coastline');
INSERT INTO "ground_class" VALUES(65,'coastline');
INSERT INTO "ground_class" VALUES(66,'coastline');
INSERT INTO "ground_class" VALUES(67,'coastline');
CREATE TABLE `building` (`size_x` INTEGER NOT NULL, `size_y` INTEGER NOT NULL, `radius` INTEGER, `name` TEXT, `class_type` TEXT NOT NULL, `class_package` TEXT NOT NULL, `health` INTEGER NOT NULL, `inhabitants_start` INTEGER NOT NULL DEFAULT 0, `inhabitants_max` INTEGER NOT NULL DEFAULT 0, "id" INTEGER AUTO_INCREMENT, "button_name" TEXT DEFAULT NULL, "settler_level" INTEGER NOT NULL  DEFAULT 0, "tooltip_text" TEXT DEFAULT NULL);
INSERT INTO "building" VALUES(3,3,24,'Branch Office','BranchOffice','storages',1000,2,2,1,NULL,0, NULL);
INSERT INTO "building" VALUES(2,2,17,'Storage Tent','StorageBuilding','storages',1000,1,1,2,'store-1',0,'Extends stock and provides collectors.');
INSERT INTO "building" VALUES(2,2,12,'Tent','Settler','settler',1000,1,2,3,'resident-1',0,'Houses your inhabitants.');
INSERT INTO "building" VALUES(6,6,0,'Main Square','MainSquare','storages',1000,1,1,4,'main_square-1',0,'Supplies citizens with goods.');
INSERT INTO "building" VALUES(2,2,0,'Pavilion','SettlerServiceProvider','production',1000,1,1,5,'church-1',0,'Fulfills religious needs of sailors.');
INSERT INTO "building" VALUES(1,1,10,'Signal Fire','SignalFire','housing',1000,0,0,6,'lighthouse-1',0,'Allows the player to trade with the free trader.');
INSERT INTO "building" VALUES(2,2,8,'Weaver''s Tent','Refiner','production',1000,2,2,7,'weaver-1',1,'Turns lamb wool into cloth.');
INSERT INTO "building" VALUES(2,2,3,'Lumberjack Camp','Lumberjack','production',1000,1,1,8,'lumberjack-1',0,'Chops down trees and turns them into boards.');
INSERT INTO "building" VALUES(2,2,10,'Hunter''s Tent','Hunter','production',1000,1,1,9,'hunter-1',0,'Hunts wild forest animals, produces food.');
INSERT INTO "building" VALUES(2,2,0,'Tent Ruin','SettlerRuin','settler',1000,0,0,10,NULL,0,NULL);
INSERT INTO "building" VALUES(2,2,20,'Fisherman''s Tent','Fisher','production',1000,1,1,11,'fisher-1',0,'Fishes the sea, produces food.');
INSERT INTO "building" VALUES(3,3,10,'Boat Builder','BoatBuilder','boatbuilder',1000,2,2,12,'boat_builder-1',1,'Builds boats and small ships. Built on coast.');
INSERT INTO "building" VALUES(1,1,10,'Lookout','Housing','housing',1000,1,1,13,NULL,0,'Increases the player''s sight.');
INSERT INTO "building" VALUES(1,2,10,'Rampart','Housing','housing',1000,0,0,14,NULL,0,'Protects your settlement.');
INSERT INTO "building" VALUES(1,1,0,'Trail','Path','path',10,0,0,15,'street-1',0,'Needed for collecting goods.');
INSERT INTO "building" VALUES(1,1,10,'Log','Bridge','path',10,0,0,16,NULL,0,'Road across a river.');
INSERT INTO "building" VALUES(1,1,0,'Tree','Tree','nature',10,0,0,17,'tree-1',0, 'Tree');
INSERT INTO "building" VALUES(3,3,0,'Pasture','Field','nature',10,0,0,18,'pasture-1',1,'Raises sheep. Produces wool. Needs a farm.');
INSERT INTO "building" VALUES(3,3,0,'Potato Field','Field','nature',10,0,0,19,'potatofield-1',1,'Yields food. Needs a farm.');
INSERT INTO "building" VALUES(3,3,3,'Farm','Farm','production',1000,2,2,20,'herder-1',1,'Grows field crops and raises livestock.');
INSERT INTO "building" VALUES(2,2,0,'Village school','SettlerServiceProvider','production',1000,1,1,21,'villageschool-1',1,'Provides education.');
INSERT INTO "building" VALUES(3,3,0,'Sugar Field','Field','nature',10,0,0,22,'sugarfield-1',1,'Used in liquor production. Needs a farm.');
INSERT INTO "building" VALUES(3,3,0,'Clay Deposit','ResourceDeposit','nature',10,0,0,23,NULL,0,NULL);
INSERT INTO "building" VALUES(2,4,8,'Brickyard','Refiner','production',1000,1,1,24,'brickyard-1',1,'Turns clay into bricks.');
INSERT INTO "building" VALUES(3,3,0,'Clay Pit','Mine','production',1000,1,2,25,'clay-pit-1',1,'Gets clay from deposit.');
INSERT INTO "building" VALUES(2,2,8,'Distillery','Refiner','production',1000,2,2,26,'distillery-1',1,'Turns sugar into liquor.');
INSERT INTO "building" VALUES(5,5,0,'Iron Mine','Mine','production',1000,0,0,28,'iron-mine-1',2,'Gets iron ore from deposit.');
INSERT INTO "building" VALUES(4,4,10,'Smeltery','Smeltery','production',1000,2,2,29,'smeltery-1',2,'Refines all kind of ores.');
INSERT INTO "building" VALUES(2,2,8,'Toolmaker','IronRefiner','production',1000,1,1,30,'toolmaker-1',2,'Produces tools out of iron.');
INSERT INTO "building" VALUES(2,3,6,'Charcoal Burning','CharcoalBurning','production',1000,1,1,31,'charcoal-burning-1',2,'Burns a lot of boards.');
INSERT INTO "building" VALUES(2,2,6,'Tavern','SettlerServiceProvider','production',1000,2,2,32,'tavern-1',2,'Provides get-together.');
INSERT INTO "building" VALUES(1,1,0,'Fish Deposit','Fish','nature',10,0,0,33,NULL,0,NULL);
INSERT INTO "building" VALUES(5,5,0,'Mountain','ResourceDeposit','nature',10,0,0,34,NULL,0,NULL);
INSERT INTO "building" VALUES(3,3,0,'Salt Ponds','SaltPond','production',1000,1,1,35,'saltponds-1',2,'Evaporates salt. Built on sea coast.');
INSERT INTO "building" VALUES(3,3,0,'Tobacco Field','Field','nature',10,0,0,36,'tobaccofield-1',2,'Produces tobacco. Needs a farm.');
INSERT INTO "building" VALUES(2,2,8,'Tobacconist','Refiner','production',1000,2,2,37,'tobacconist-1',2,'Produces tobaccos out of tobacco.');
INSERT INTO "building" VALUES(3,3,0,'Cattle Run','Field','nature',10,0,0,38,'cattlerun-1',2,'Raises cattle. Needs a farm.');
INSERT INTO "building" VALUES(5,5,0,'Pigsty','Field','nature',1000,0,0,39,'pigsty-1',2,'Raises pigs. Needs a farm.');
INSERT INTO "building" VALUES(3,3,0,'Herbary','Field','nature',10,0,0,40,'herbary-1',2,'Produces herbs. Needs a farm.');
INSERT INTO "building" VALUES(2,2,8,'Butchery','Refiner','production',1000,2,2,41,'butchery-1',2,'Needs pigs or cattle. Produces food.');
INSERT INTO "building" VALUES(2,2,10,'Doctor','Doctor','prevention',1000,2,3,42,'doctor-1',2,'Treats diseases. Consumes herbs.');
INSERT INTO "building" VALUES(1,1,0,'Gravel Path','Path','path',10,0,0,43,NULL,0,NULL);
INSERT INTO "building" VALUES(2,2,6,'Wooden Tower','Tower','war',1000,1,1,44,'tower-1',1,'Defends your settlement.');
CREATE TABLE `unit` (`name` TEXT NOT NULL ,`class_package` TEXT NOT NULL ,`class_type` TEXT NOT NULL , `base_velocity` FLOAT DEFAULT '12.0', "radius" INTEGER DEFAULT 5, "id" INTEGER AUTO_INCREMENT);
INSERT INTO "unit" VALUES('Huker','ship','Ship',5.0,5,1000001);
INSERT INTO "unit" VALUES('BuildingCollector','collectors','BuildingCollector',12.0,5,1000002);
INSERT INTO "unit" VALUES('Sheep','animal','FarmAnimal',12.0,3,1000003);
INSERT INTO "unit" VALUES('Fisher','ship','FisherShip',12.0,5,1000004);
INSERT INTO "unit" VALUES('Pirate Ship','ship','PirateShip',12.0,5,1000005);
INSERT INTO "unit" VALUES('Trader','ship','TradeShip',12.0,8,1000006);
INSERT INTO "unit" VALUES('AnimalCarriage','collectors','AnimalCollector',12.0,5,1000007);
INSERT INTO "unit" VALUES('StorageCollector','collectors','StorageCollector',12.0,5,1000008);
INSERT INTO "unit" VALUES('FieldCollector','collectors','FieldCollector',12.0,5,1000009);
INSERT INTO "unit" VALUES('LumberjackCollector','collectors','FieldCollector',12.0,5,1000010);
INSERT INTO "unit" VALUES('SettlerCollector','collectors','StorageCollector',12.0,5,1000011);
INSERT INTO "unit" VALUES('Deer','animal','WildAnimal',12.0,5,1000013);
INSERT INTO "unit" VALUES('HunterCollector','collectors','HunterCollector',12.0,5,1000014);
INSERT INTO "unit" VALUES('FarmAnimalCollector','collectors','FarmAnimalCollector',12.0,5,1000015);
INSERT INTO "unit" VALUES('UsableFisher','ship','Ship',12.0,5,1000016);
INSERT INTO "unit" VALUES('Cattle','animal','FarmAnimal',12.0,3,1000017);
INSERT INTO "unit" VALUES('Boar','animal','FarmAnimal',12.0,5,1000018);
INSERT INTO "unit" VALUES('Doctor','animal','FarmAnimal',12.0,5,1000019);
INSERT INTO "unit" VALUES('Frigate','fightingship','FightingShip',12.0,5,1000020);
INSERT INTO "unit" VALUES('BomberMan','groundunit','FightingGroundUnit',10.0,5,1000021);
CREATE TABLE "animation" ("animation_id" INTEGER NOT NULL ,"file" TEXT NOT NULL ,"frame_length" FLOAT DEFAULT '0.0' );
INSERT INTO "animation" VALUES(90,'content/gfx/base/land/grass_00.png',0.0);
INSERT INTO "animation" VALUES(91,'content/gfx/base/land/beach_00.png',0.0);
INSERT INTO "animation" VALUES(92,'content/gfx/base/water/shallow_00.png',0.0);
INSERT INTO "animation" VALUES(93,'content/gfx/base/water/deep_00.png',0.0);
INSERT INTO "animation" VALUES(98,'content/gfx/base/land/grass-beach/grass-beach_05.png',0.0);
INSERT INTO "animation" VALUES(99,'content/gfx/base/land/grass-beach/grass-beach_06.png',0.0);
INSERT INTO "animation" VALUES(100,'content/gfx/base/land/grass-beach/grass-beach_07.png',0.0);
INSERT INTO "animation" VALUES(101,'content/gfx/base/land/grass-beach/grass-beach_08.png',0.0);
INSERT INTO "animation" VALUES(106,'content/gfx/base/land/grass-beach/grass-beach_13.png',0.0);
INSERT INTO "animation" VALUES(107,'content/gfx/base/land/grass-beach/grass-beach_14.png',0.0);
INSERT INTO "animation" VALUES(108,'content/gfx/base/land/grass-beach/grass-beach_15.png',0.0);
INSERT INTO "animation" VALUES(109,'content/gfx/base/land/grass-beach/grass-beach_16.png',0.0);
INSERT INTO "animation" VALUES(114,'content/gfx/base/land/grass-beach/grass-beach_21.png',0.0);
INSERT INTO "animation" VALUES(115,'content/gfx/base/land/grass-beach/grass-beach_22.png',0.0);
INSERT INTO "animation" VALUES(116,'content/gfx/base/land/grass-beach/grass-beach_23.png',0.0);
INSERT INTO "animation" VALUES(117,'content/gfx/base/land/grass-beach/grass-beach_24.png',0.0);
INSERT INTO "animation" VALUES(138,'content/gfx/base/land/beach-shallow/beach-shallow_05.png',0.0);
INSERT INTO "animation" VALUES(139,'content/gfx/base/land/beach-shallow/beach-shallow_06.png',0.0);
INSERT INTO "animation" VALUES(140,'content/gfx/base/land/beach-shallow/beach-shallow_07.png',0.0);
INSERT INTO "animation" VALUES(141,'content/gfx/base/land/beach-shallow/beach-shallow_08.png',0.0);
INSERT INTO "animation" VALUES(146,'content/gfx/base/land/beach-shallow/beach-shallow_13.png',0.0);
INSERT INTO "animation" VALUES(147,'content/gfx/base/land/beach-shallow/beach-shallow_14.png',0.0);
INSERT INTO "animation" VALUES(148,'content/gfx/base/land/beach-shallow/beach-shallow_15.png',0.0);
INSERT INTO "animation" VALUES(149,'content/gfx/base/land/beach-shallow/beach-shallow_16.png',0.0);
INSERT INTO "animation" VALUES(154,'content/gfx/base/land/beach-shallow/beach-shallow_21.png',0.0);
INSERT INTO "animation" VALUES(155,'content/gfx/base/land/beach-shallow/beach-shallow_22.png',0.0);
INSERT INTO "animation" VALUES(156,'content/gfx/base/land/beach-shallow/beach-shallow_23.png',0.0);
INSERT INTO "animation" VALUES(157,'content/gfx/base/land/beach-shallow/beach-shallow_24.png',0.0);
INSERT INTO "animation" VALUES(178,'content/gfx/base/water/shallow-deep/shallow-deep_05.png',0.0);
INSERT INTO "animation" VALUES(179,'content/gfx/base/water/shallow-deep/shallow-deep_06.png',0.0);
INSERT INTO "animation" VALUES(180,'content/gfx/base/water/shallow-deep/shallow-deep_07.png',0.0);
INSERT INTO "animation" VALUES(181,'content/gfx/base/water/shallow-deep/shallow-deep_08.png',0.0);
INSERT INTO "animation" VALUES(186,'content/gfx/base/water/shallow-deep/shallow-deep_13.png',0.0);
INSERT INTO "animation" VALUES(187,'content/gfx/base/water/shallow-deep/shallow-deep_14.png',0.0);
INSERT INTO "animation" VALUES(188,'content/gfx/base/water/shallow-deep/shallow-deep_15.png',0.0);
INSERT INTO "animation" VALUES(189,'content/gfx/base/water/shallow-deep/shallow-deep_16.png',0.0);
INSERT INTO "animation" VALUES(194,'content/gfx/base/water/shallow-deep/shallow-deep_21.png',0.0);
INSERT INTO "animation" VALUES(195,'content/gfx/base/water/shallow-deep/shallow-deep_22.png',0.0);
INSERT INTO "animation" VALUES(196,'content/gfx/base/water/shallow-deep/shallow-deep_23.png',0.0);
INSERT INTO "animation" VALUES(197,'content/gfx/base/water/shallow-deep/shallow-deep_24.png',0.0);
CREATE TABLE "speech" ("group_id" INTEGER NOT NULL  DEFAULT 0 ,"file" TEXT NOT NULL );
INSERT INTO "speech" VALUES(1,'content/audio/voice/map_creation/en/0.ogg');
INSERT INTO "speech" VALUES(1,'content/audio/voice/map_creation/en/1.ogg');
INSERT INTO "speech" VALUES(1,'content/audio/voice/map_creation/en/2.ogg');
INSERT INTO "speech" VALUES(1,'content/audio/voice/map_creation/en/3.ogg');
INSERT INTO "speech" VALUES(2,'content/audio/sounds/events/new_settlement.ogg');
INSERT INTO "speech" VALUES(3,'content/audio/sounds/events/new_era.ogg');
CREATE TABLE "sounds" ("file" TEXT NOT NULL  DEFAULT '', id auto_increment not null default -1);
INSERT INTO "sounds" VALUES('content/audio/sounds/sheepfield.ogg',1);
INSERT INTO "sounds" VALUES('content/audio/sounds/ships_bell.ogg',2);
INSERT INTO "sounds" VALUES('content/audio/sounds/build.ogg',3);
INSERT INTO "sounds" VALUES('content/audio/sounds/lumberjack.ogg',4);
INSERT INTO "sounds" VALUES('content/audio/sounds/branch_office.ogg',5);
INSERT INTO "sounds" VALUES('content/audio/sounds/main_square.ogg',6);
INSERT INTO "sounds" VALUES('content/audio/sounds/chapel.ogg',7);
INSERT INTO "sounds" VALUES('content/audio/sounds/ships_bell.ogg',8);
CREATE TABLE "sounds_special" ("type" TEXT NOT NULL  DEFAULT '', "sound" INTEGER NOT NULL  DEFAULT '');
INSERT INTO "sounds_special" VALUES('build',3);
INSERT INTO "sounds_special" VALUES('message',8);
CREATE TABLE "message_icon" ("icon_id" INTEGER NOT NULL ,"color" INTEGER,"up_image" TEXT NOT NULL ,"down_image" TEXT NOT NULL  DEFAULT '""' , "hover_image" TEXT NOT NULL  DEFAULT '""');
INSERT INTO "message_icon" VALUES(1,1,'content/gui/icons/widgets/messages/msg_letter_n.png','content/gui/icons/widgets/messages/msg_letter_d.png','content/gui/icons/widgets/messages/msg_letter_h.png');
INSERT INTO "message_icon" VALUES(2,1,'content/gui/icons/widgets/messages/msg_system_n.png','content/gui/icons/widgets/messages/msg_system_d.png','content/gui/icons/widgets/messages/msg_system_h.png');
INSERT INTO "message_icon" VALUES(3,1,'content/gui/icons/widgets/messages/msg_save_n.png','content/gui/icons/widgets/messages/msg_save_d.png','content/gui/icons/widgets/messages/msg_save_h.png');
INSERT INTO "message_icon" VALUES(4,1,'content/gui/icons/widgets/messages/msg_anchor_n.png','content/gui/icons/widgets/messages/msg_anchor_d.png','content/gui/icons/widgets/messages/msg_anchor_h.png');
INSERT INTO "message_icon" VALUES(5,1,'content/gui/icons/widgets/messages/msg_money_n.png','content/gui/icons/widgets/messages/msg_money_d.png','content/gui/icons/widgets/messages/msg_money_h.png');
CREATE TABLE "action_set" ("action_set_id" TEXT NOT NULL ,"preview_action_set_id" TEXT,"object_id" INTEGER, "level" INTEGER NOT NULL  DEFAULT 0);
INSERT INTO "action_set" VALUES('as_branchoffice0','as_preview_branchoffice0',1,0);
INSERT INTO "action_set" VALUES('as_storagetent0',NULL,2,0);
INSERT INTO "action_set" VALUES('as_tent0',NULL,3,0);
INSERT INTO "action_set" VALUES('as_mainsquare0','as_preview_mainsquare0',4,0);
INSERT INTO "action_set" VALUES('as_sunsail0',NULL,5,0);
INSERT INTO "action_set" VALUES('as_signalfire0','as_preview_signalfire0',6,0);
INSERT INTO "action_set" VALUES('as_weaver0',NULL,7,0);
INSERT INTO "action_set" VALUES('as_lumberjack0',NULL,8,0);
INSERT INTO "action_set" VALUES('as_hunter0',NULL,9,0);
INSERT INTO "action_set" VALUES('as_fisherman0',NULL,11,0);
INSERT INTO "action_set" VALUES('as_boat_builder0',NULL,12,0);
INSERT INTO "action_set" VALUES('as_lookout0',NULL,13,0);
INSERT INTO "action_set" VALUES('as_pasture0',NULL,18,0);
INSERT INTO "action_set" VALUES('as_birch0',NULL,17,0);
INSERT INTO "action_set" VALUES('as_maple0',NULL,17,0);
INSERT INTO "action_set" VALUES('as_maple1',NULL,17,0);
INSERT INTO "action_set" VALUES('as_maple2',NULL,17,0);
INSERT INTO "action_set" VALUES('as_huker0',NULL,1000001,0);
INSERT INTO "action_set" VALUES('as_carrier0',NULL,1000002,0);
INSERT INTO "action_set" VALUES('as_sheep0',NULL,1000003,0);
INSERT INTO "action_set" VALUES('as_fisher0',NULL,1000004,0);
INSERT INTO "action_set" VALUES('as_pirate0',NULL,1000005,0);
INSERT INTO "action_set" VALUES('as_trader0',NULL,1000006,0);
INSERT INTO "action_set" VALUES('as_herder0',NULL,1000007,0);
INSERT INTO "action_set" VALUES('as_carrier0',NULL,1000008,0);
INSERT INTO "action_set" VALUES('as_farmer0',NULL,1000009,0);
INSERT INTO "action_set" VALUES('as_spruce0',NULL,17,0);
INSERT INTO "action_set" VALUES('as_spruce1',NULL,17,0);
INSERT INTO "action_set" VALUES('as_trail',NULL,15,0);
INSERT INTO "action_set" VALUES('as_lumberjackunit0',NULL,1000010,0);
INSERT INTO "action_set" VALUES('as_tupelo0',NULL,17,0);
INSERT INTO "action_set" VALUES('as_tupelo1',NULL,17,0);
INSERT INTO "action_set" VALUES('as_maple3',NULL,17,0);
INSERT INTO "action_set" VALUES('as_tupelo2',NULL,17,0);
INSERT INTO "action_set" VALUES('as_male',NULL,1000011,0);
INSERT INTO "action_set" VALUES('as_female',NULL,1000011,0);
INSERT INTO "action_set" VALUES('as_farmer0',NULL,1000012,0);
INSERT INTO "action_set" VALUES('as_male2',NULL,1000011,0);
INSERT INTO "action_set" VALUES('as_female2',NULL,1000011,0);
INSERT INTO "action_set" VALUES('as_tent1',NULL,3,0);
INSERT INTO "action_set" VALUES('as_fallowdeer0',NULL,1000013,0);
INSERT INTO "action_set" VALUES('as_reddeer0',NULL,1000013,0);
INSERT INTO "action_set" VALUES('as_hunterunit0',NULL,1000014,0);
INSERT INTO "action_set" VALUES('as_potatofield0',NULL,19,0);
INSERT INTO "action_set" VALUES('as_farm0',NULL,20,0);
INSERT INTO "action_set" VALUES('as_herder0',NULL,1000015,0);
INSERT INTO "action_set" VALUES('as_tent_ruin0',NULL,10,0);
INSERT INTO "action_set" VALUES('as_school0',NULL,21,0);
INSERT INTO "action_set" VALUES('as_sugarfield0',NULL,22,0);
INSERT INTO "action_set" VALUES('as_hut0',NULL,3,1);
INSERT INTO "action_set" VALUES('as_hut1',NULL,3,1);
INSERT INTO "action_set" VALUES('as_lumberjack_barrack0',NULL,8,1);
INSERT INTO "action_set" VALUES('as_clay0',NULL,23,0);
INSERT INTO "action_set" VALUES('as_brickyard0',NULL,24,0);
INSERT INTO "action_set" VALUES('as_clay_pit0',NULL,25,0);
INSERT INTO "action_set" VALUES('as_distillery0',NULL,26,0);
INSERT INTO "action_set" VALUES('as_church_wooden0',NULL,5,1);
INSERT INTO "action_set" VALUES('as_signalfire_wooden0',NULL,6,1);
INSERT INTO "action_set" VALUES('as_smeltery0',NULL,29,0);
INSERT INTO "action_set" VALUES('as_toolmaker0',NULL,30,0);
INSERT INTO "action_set" VALUES('as_charcoal_burning0',NULL,31,0);
INSERT INTO "action_set" VALUES('as_tavern0',NULL,32,0);
INSERT INTO "action_set" VALUES('as_fish0',NULL,33,0);
INSERT INTO "action_set" VALUES('as_mountain5x5','as_preview_mountain5x5',34,0);
INSERT INTO "action_set" VALUES('as_mine5x5','as_preview_mine5x5',28,0);
INSERT INTO "action_set" VALUES('as_fisher0',NULL,1000016,0);
INSERT INTO "action_set" VALUES('as_house0',NULL,3,2);
INSERT INTO "action_set" VALUES('as_hut2',NULL,3,1);
INSERT INTO "action_set" VALUES('as_tent2',NULL,3,0);
INSERT INTO "action_set" VALUES('as_tent3',NULL,3,0);
INSERT INTO "action_set" VALUES('as_tent4',NULL,3,0);
INSERT INTO "action_set" VALUES('as_tent5',NULL,3,0);
INSERT INTO "action_set" VALUES('as_storagetent1',NULL,2,1);
INSERT INTO "action_set" VALUES('as_saltponds0',NULL,35,0);
INSERT INTO "action_set" VALUES('as_tobaccofield0',NULL,36,0);
INSERT INTO "action_set" VALUES('as_tobacconist0',NULL,37,0);
INSERT INTO "action_set" VALUES('as_cattlerun0',NULL,38,0);
INSERT INTO "action_set" VALUES('as_pigsty0','as_preview_pigsty0',39,0);
INSERT INTO "action_set" VALUES('as_herbary0',NULL,40,0);
INSERT INTO "action_set" VALUES('as_butchery0',NULL,41,0);
INSERT INTO "action_set" VALUES('as_doctor0',NULL,42,0);
INSERT INTO "action_set" VALUES('as_woodentower0',NULL,44,0);
INSERT INTO "action_set" VALUES('as_gravel_path',NULL,15,2);
INSERT INTO "action_set" VALUES('as_frigate0',NULL,1000020,0);
INSERT INTO "action_set" VALUES('as_groundunit0',NULL,1000021,0);
CREATE TABLE "production_line" ("time" FLOAT NOT NULL ,"changes_animation" INTEGER NOT NULL  DEFAULT 1 ,"id" INTEGER AUTO_INCREMENT,"object_id" INTEGER, "enabled_by_default" BOOL NOT NULL  DEFAULT 1 ,"save_statistics" BOOL NOT NULL  DEFAULT 0 );
INSERT INTO "production_line" VALUES(60.0,1,1,17,1,0);
INSERT INTO "production_line" VALUES(7.0,1,2,8,1,1);
INSERT INTO "production_line" VALUES(45.0,1,4,1000003,1,0);
INSERT INTO "production_line" VALUES(30.0,1,5,18,1,0);
INSERT INTO "production_line" VALUES(1.0,1,7,20,1,1);
INSERT INTO "production_line" VALUES(12.0,1,9,7,1,1);
INSERT INTO "production_line" VALUES(10.0,1,11,11,1,1);
INSERT INTO "production_line" VALUES(4.0,1,13,5,1,1);
INSERT INTO "production_line" VALUES(60.0,1,15,12,1,0);
INSERT INTO "production_line" VALUES(45.0,1,16,1000013,1,0);
INSERT INTO "production_line" VALUES(10.0,1,18,9,1,1);
INSERT INTO "production_line" VALUES(25.0,0,17,17,1,0);
INSERT INTO "production_line" VALUES(60.0,0,19,3,0,0);
INSERT INTO "production_line" VALUES(180.0,0,20,3,0,1);
INSERT INTO "production_line" VALUES(90.0,0,21,3,0,0);
INSERT INTO "production_line" VALUES(26.0,1,22,19,1,0);
INSERT INTO "production_line" VALUES(1.0,1,23,20,1,1);
INSERT INTO "production_line" VALUES(1.0,0,24,3,0,0);
INSERT INTO "production_line" VALUES(4.0,1,25,21,1,1);
INSERT INTO "production_line" VALUES(90.0,0,26,3,0,0);
INSERT INTO "production_line" VALUES(30.0,1,27,22,1,0);
INSERT INTO "production_line" VALUES(1.0,1,28,20,1,1);
INSERT INTO "production_line" VALUES(90.0,0,30,3,0,0);
INSERT INTO "production_line" VALUES(1.0,1,31,4,1,0);
INSERT INTO "production_line" VALUES(15.0,1,32,25,1,1);
INSERT INTO "production_line" VALUES(15.0,1,33,24,1,1);
INSERT INTO "production_line" VALUES(12.0,1,34,26,1,1);
INSERT INTO "production_line" VALUES(1.0,0,35,3,0,0);
INSERT INTO "production_line" VALUES(15.0,1,36,28,1,1);
INSERT INTO "production_line" VALUES(30.0,1,37,29,1,1);
INSERT INTO "production_line" VALUES(15.0,1,38,30,1,1);
INSERT INTO "production_line" VALUES(20.0,1,39,31,1,1);
INSERT INTO "production_line" VALUES(16.0,1,40,32,1,1);
--  time   changes_animation   id   object_id   enabled_by_default   save_statistics
INSERT INTO "production_line" VALUES(90.0,0,41,3,0,0);
INSERT INTO "production_line" VALUES(30.0,0,42,33,1,0);
INSERT INTO "production_line" VALUES(75.0,0,43,3,0,0);
INSERT INTO "production_line" VALUES(90.0,0,44,3,0,0);
INSERT INTO "production_line" VALUES(45.0,1,45,35,1,1);
INSERT INTO "production_line" VALUES(30.0,1,46,36,1,0);
INSERT INTO "production_line" VALUES(1.0,1,47,20,1,0);
INSERT INTO "production_line" VALUES(15.0,1,48,37,1,1);
INSERT INTO "production_line" VALUES(40.0,1,49,38,1,0);
INSERT INTO "production_line" VALUES(60.0,1,50,39,1,0);
INSERT INTO "production_line" VALUES(1.0,1,51,20,1,0);
INSERT INTO "production_line" VALUES(1.0,1,52,20,1,0);
INSERT INTO "production_line" VALUES(30.0,1,53,40,1,1);
--INSERT INTO "production_line" VALUES(1.0,1,54,20,1,0);
INSERT INTO "production_line" VALUES(15.0,1,55,41,1,1);
INSERT INTO "production_line" VALUES(15.0,1,56,41,1,1);
INSERT INTO "production_line" VALUES(60.0,1,57,42,1,0);
INSERT INTO "production_line" VALUES(60.0,1,58,12,1,0);
INSERT INTO "production_line" VALUES(60.0,1,62,12,1,0);
INSERT INTO "production_line" VALUES(60.0,1,63,12,1,0);
INSERT INTO "production_line" VALUES(60.0,1,64,12,1,0);
INSERT INTO "production_line" VALUES(60.0,1,68,12,1,0);
INSERT INTO "production_line" VALUES(90.0,0,69,3,0,0);
INSERT INTO "production_line" VALUES(180.0,0,70,3,0,0);
INSERT INTO "production_line" VALUES(60.0,0,71,3,0,0);
INSERT INTO "production_line" VALUES(90.0,0,72,3,0,0);
CREATE TABLE collector_restrictions(collector INTEGER, object INTEGER);
INSERT INTO "collector_restrictions" VALUES(1000011,4);
INSERT INTO "collector_restrictions" VALUES(1000011,5);
INSERT INTO "collector_restrictions" VALUES(1000011,21);
INSERT INTO "collector_restrictions" VALUES(1000011,32);
CREATE TABLE "message" ("text" TEXT NOT NULL ,"icon" INTEGER NOT NULL ,"visible_for" FLOAT NOT NULL ,"speech_group_id" INTEGER,"id_string" STRING);
INSERT INTO "message" VALUES('A new settlement has been created by ${player}.',1,30.0,2,'NEW_SETTLEMENT');
INSERT INTO "message" VALUES('A new world has been created.',1,15.0,1,'NEW_WORLD');
INSERT INTO "message" VALUES('Your game has been quicksaved.',3,10.0,NULL,'QUICKSAVE');
INSERT INTO "message" VALUES('Screenshot has been saved to ${file}.',2,15.0,NULL,'SCREENSHOT');
INSERT INTO "message" VALUES('Your settlers reached level ${level}.',1,20.0,3,'SETTLER_LEVEL_UP');
INSERT INTO "message" VALUES('You need more ${resource} to build this building.',1,3.0,NULL,'NEED_MORE_RES');
INSERT INTO "message" VALUES('One of your settler has no main square in it''s range.',1,15.0,NULL,'NO_MAIN_SQUARE_IN_RANGE');
INSERT INTO "message" VALUES('Some of your settlers just moved out.',1,20.0,NULL,'SETTLERS_MOVED_OUT');
INSERT INTO "message" VALUES('You have won!',1,60.0,NULL,'YOU_HAVE_WON');
INSERT INTO "message" VALUES('Your mine has run out of resources.',1,15.0,NULL,'MINE_EMPTY');
INSERT INTO "message" VALUES('You can also drag roads.',1,20.0,NULL,'DRAG_ROADS_HINT');
INSERT INTO "message" VALUES('${player1} and ${player2} are now ${status}',1,10.0,NULL,'DIPLOMACY_STATUS_CHANGED');
INSERT INTO "message" VALUES('You have reached the current maximum increment. Your inhabitants will not upgrade further.',1,10.0,NULL,'MAX_INCR_REACHED');
CREATE TABLE ai (client_id TEXT NOT NULL, class_package TEXT NOT NULL, class_name TEXT NOT NULL);
INSERT INTO "ai" VALUES('AIPlayer','aiplayer','AIPlayer');
CREATE TABLE "object_sounds" (object  INTEGER PRIMARY KEY  NOT NULL  DEFAULT '' , "sound" INTEGER NOT NULL  DEFAULT '');
INSERT INTO "object_sounds" VALUES(1,5);
INSERT INTO "object_sounds" VALUES(4,6);
INSERT INTO "object_sounds" VALUES(5,7);
INSERT INTO "object_sounds" VALUES(11,5);
INSERT INTO "object_sounds" VALUES(18,1);
INSERT INTO "object_sounds" VALUES(1000010,4);
CREATE TABLE related_buildings (building int, related_building int);
INSERT INTO "related_buildings" VALUES(8,17);
INSERT INTO "related_buildings" VALUES(20,18);
INSERT INTO "related_buildings" VALUES(20,19);
INSERT INTO "related_buildings" VALUES(20,22);
INSERT INTO "related_buildings" VALUES(20,36);
INSERT INTO "related_buildings" VALUES(20,38);
INSERT INTO "related_buildings" VALUES(20,39);
CREATE TABLE mine(mine INTEGER NOT NULL, deposit NOT NULL);
INSERT INTO "mine" VALUES(25,23);
INSERT INTO "mine" VALUES(28,34);
CREATE TABLE "tile_set" ("set_id" TEXT NOT NULL ,"ground_id" INTEGER NOT NULL );
INSERT INTO "tile_set" VALUES('ts_deep0',0);
INSERT INTO "tile_set" VALUES('ts_shallow0',1);
INSERT INTO "tile_set" VALUES('ts_shallow-deep0',2);
INSERT INTO "tile_set" VALUES('ts_grass0',3);
INSERT INTO "tile_set" VALUES('ts_grass-beach0',4);
INSERT INTO "tile_set" VALUES('ts_beach-shallow0',5);
INSERT INTO "tile_set" VALUES('ts_beach0',6);
CREATE TABLE `ground` (`animation_45` INTEGER NOT NULL, `animation_135` INTEGER NOT NULL, `animation_225` INTEGER NOT NULL, `animation_315` INTEGER NOT NULL, `velocity_modifier` FLOAT DEFAULT '1.0', id int auto_increment not null default -1);
INSERT INTO "ground" VALUES(90,90,90,90,1.0,1);
INSERT INTO "ground" VALUES(91,91,91,91,1.0,2);
INSERT INTO "ground" VALUES(92,92,92,92,1.0,3);
INSERT INTO "ground" VALUES(93,93,93,93,1.0,4);
INSERT INTO "ground" VALUES(98,99,100,101,1.0,9);
INSERT INTO "ground" VALUES(99,100,101,98,1.0,10);
INSERT INTO "ground" VALUES(100,101,98,99,1.0,11);
INSERT INTO "ground" VALUES(101,98,99,100,1.0,12);
INSERT INTO "ground" VALUES(106,109,108,107,1.0,17);
INSERT INTO "ground" VALUES(107,106,109,108,1.0,18);
INSERT INTO "ground" VALUES(108,107,106,109,1.0,19);
INSERT INTO "ground" VALUES(109,108,107,106,1.0,20);
INSERT INTO "ground" VALUES(114,117,116,115,1.0,25);
INSERT INTO "ground" VALUES(115,114,117,116,1.0,26);
INSERT INTO "ground" VALUES(116,115,114,117,1.0,27);
INSERT INTO "ground" VALUES(117,116,115,114,1.0,28);
INSERT INTO "ground" VALUES(138,139,140,141,1.0,49);
INSERT INTO "ground" VALUES(139,140,141,138,1.0,50);
INSERT INTO "ground" VALUES(140,141,138,139,1.0,51);
INSERT INTO "ground" VALUES(141,138,139,140,1.0,52);
INSERT INTO "ground" VALUES(146,149,148,147,1.0,57);
INSERT INTO "ground" VALUES(147,146,149,148,1.0,58);
INSERT INTO "ground" VALUES(148,147,146,149,1.0,59);
INSERT INTO "ground" VALUES(149,148,147,146,1.0,60);
INSERT INTO "ground" VALUES(154,157,156,155,1.0,65);
INSERT INTO "ground" VALUES(155,154,157,156,1.0,66);
INSERT INTO "ground" VALUES(156,155,154,157,1.0,67);
INSERT INTO "ground" VALUES(157,156,155,154,1.0,68);
INSERT INTO "ground" VALUES(178,179,180,181,1.0,89);
INSERT INTO "ground" VALUES(179,180,181,178,1.0,90);
INSERT INTO "ground" VALUES(180,181,178,179,1.0,91);
INSERT INTO "ground" VALUES(181,178,179,180,1.0,92);
INSERT INTO "ground" VALUES(186,189,188,187,1.0,97);
INSERT INTO "ground" VALUES(187,186,189,188,1.0,98);
INSERT INTO "ground" VALUES(188,187,186,189,1.0,99);
INSERT INTO "ground" VALUES(189,188,187,186,1.0,100);
INSERT INTO "ground" VALUES(194,197,196,195,1.0,105);
INSERT INTO "ground" VALUES(195,194,197,196,1.0,106);
INSERT INTO "ground" VALUES(196,195,194,197,1.0,107);
INSERT INTO "ground" VALUES(197,196,195,194,1.0,108);
CREATE TABLE citynames (
    "name" TEXT NOT NULL,
    "for_pirate" BOOL NOT NULL DEFAULT ('0'),
    "for_player" BOOL NOT NULL DEFAULT ('0')
, "locale" TEXT  NOT NULL  DEFAULT ('en'));
INSERT INTO "citynames" VALUES('St. Petrus',0,1,'en');
INSERT INTO "citynames" VALUES('Jagstursprung',1,0,'en');
INSERT INTO "citynames" VALUES('New Xanten',0,1,'en');
INSERT INTO "citynames" VALUES('Port Foobar',0,1,'en');
INSERT INTO "citynames" VALUES('St. Polten',0,1,'en');
INSERT INTO "citynames" VALUES('New Crailsheim',0,1,'en');
INSERT INTO "citynames" VALUES('Port Sollerup',0,1,'en');
INSERT INTO "citynames" VALUES('New Montabaur',0,1,'en');
INSERT INTO "citynames" VALUES('New Cologne',0,1,'en');
INSERT INTO "citynames" VALUES('New Nuremberg',0,1,'en');
INSERT INTO "citynames" VALUES('New Amsterdam',0,1,'en');
INSERT INTO "citynames" VALUES('Port Southland',0,1,'en');
INSERT INTO "citynames" VALUES('St. Patrick',0,1,'en');
INSERT INTO "citynames" VALUES('Hamburg Harbour',0,1,'en');
INSERT INTO "citynames" VALUES('London Harbour',0,1,'en');
INSERT INTO "citynames" VALUES('St. Inken',0,1,'en');
INSERT INTO "citynames" VALUES('Santeocalli',0,1,'en');
INSERT INTO "citynames" VALUES('La Paranagua',0,1,'en');
INSERT INTO "citynames" VALUES('Nouvelle-Montroulez',0,0,'en');
INSERT INTO "citynames" VALUES('Punta do Socorro',0,1,'en');
INSERT INTO "citynames" VALUES('Colonia del Este',0,1,'en');
INSERT INTO "citynames" VALUES('Asuncion Novatlan',0,1,'en');
INSERT INTO "citynames" VALUES('Cholulameco',0,1,'en');
INSERT INTO "citynames" VALUES('Rivanabia',0,1,'en');
INSERT INTO "citynames" VALUES('San Sanabria',0,1,'en');
INSERT INTO "citynames" VALUES('Teducihalpes',0,1,'en');
INSERT INTO "citynames" VALUES('Xoxochetun',0,1,'en');
INSERT INTO "citynames" VALUES('Port Royal',1,0,'en');
INSERT INTO "citynames" VALUES('Tortuga',1,0,'en');
INSERT INTO "citynames" VALUES('Porta Bravo',0,1,'en');
INSERT INTO "citynames" VALUES('Porta dei Sol',0,1,'en');
INSERT INTO "citynames" VALUES('Porta Atlantica',0,1,'en');
INSERT INTO "citynames" VALUES('Porta Lino',0,1,'en');
INSERT INTO "citynames" VALUES('Blackport',1,0,'en');
INSERT INTO "citynames" VALUES('Freetown',1,0,'en');
INSERT INTO "citynames" VALUES('New Viersen',0,1,'en');
INSERT INTO "citynames" VALUES('St. Elmo',0,1,'en');
INSERT INTO "citynames" VALUES('St. Antonio',0,1,'en');
INSERT INTO "citynames" VALUES('New Holland',0,1,'en');
INSERT INTO "citynames" VALUES('Botany Bay',0,1,'en');
INSERT INTO "citynames" VALUES('Batavia',1,0,'en');
INSERT INTO "citynames" VALUES('Fogwaters',1,0,'en');
INSERT INTO "citynames" VALUES('Rum Reef Refuge',1,0,'en');
INSERT INTO "citynames" VALUES('Treasure Gate',1,0,'en');
INSERT INTO "citynames" VALUES('Ghost Piers',1,0,'en');
INSERT INTO "citynames" VALUES('Port Velar',0,1,'en');
INSERT INTO "citynames" VALUES('Wharf Eddy',1,0,'en');
INSERT INTO "citynames" VALUES('St. Anne',0,1,'en');
INSERT INTO "citynames" VALUES('St. Laurens',0,1,'en');
INSERT INTO "citynames" VALUES('St. Peters',0,1,'en');
INSERT INTO "citynames" VALUES('Cap-Rouge',0,1,'en');
INSERT INTO "citynames" VALUES('Charlesfort',0,1,'en');
INSERT INTO "citynames" VALUES('Fort Caroline',0,1,'en');
INSERT INTO "citynames" VALUES('Tadoussac',0,1,'en');
INSERT INTO "citynames" VALUES('Fort Saint Louis',0,1,'en');
INSERT INTO "citynames" VALUES('Saint-Domingue',0,1,'en');
INSERT INTO "citynames" VALUES('Marie-Galante',0,1,'en');
INSERT INTO "citynames" VALUES('Martinique',0,1,'en');
INSERT INTO "citynames" VALUES('St. Croix',0,1,'en');
INSERT INTO "citynames" VALUES('St. Kitts',0,1,'en');
INSERT INTO "citynames" VALUES('St. Lucia',0,1,'en');
INSERT INTO "citynames" VALUES('St. Martin',0,1,'en');
INSERT INTO "citynames" VALUES('St. Vincent',0,1,'en');
INSERT INTO "citynames" VALUES('Tobago',0,1,'en');
INSERT INTO "citynames" VALUES('St. Eustatius',0,1,'en');
INSERT INTO "citynames" VALUES('Los Roques',0,1,'en');
INSERT INTO "citynames" VALUES('La Orchila',0,1,'en');
INSERT INTO "citynames" VALUES('Bonaire',0,1,'en');
INSERT INTO "citynames" VALUES('Saba',0,1,'en');
INSERT INTO "citynames" VALUES('St. Thomas',0,1,'en');
INSERT INTO "citynames" VALUES('St. John',0,1,'en');
INSERT INTO "citynames" VALUES('Santa Ana de Coro',0,1,'en');
INSERT INTO "citynames" VALUES('Seville',0,1,'en');
INSERT INTO "citynames" VALUES('Santo Domingo',0,1,'en');
INSERT INTO "citynames" VALUES('Brandenburg',0,1,'en');
INSERT INTO "citynames" VALUES('Alta Verapaz',0,1,'en');
INSERT INTO "citynames" VALUES('Pozuzo',0,1,'en');
INSERT INTO "citynames" VALUES('Oxapampa',0,1,'en');
INSERT INTO "citynames" VALUES('Recife',0,1,'en');
INSERT INTO "citynames" VALUES('St. Barthelemy',0,1,'en');
INSERT INTO "citynames" VALUES('Bogwaters',1,0,'en');
INSERT INTO "citynames" VALUES('Port la Riqueza',1,0,'en');
CREATE TABLE shipnames (
    "name" TEXT NOT NULL,
    "for_player" BOOL NOT NULL DEFAULT ('0'),
    "for_pirate" BOOL NOT NULL DEFAULT ('0'),
    "for_fisher" BOOL NOT NULL DEFAULT ('0'),
    "for_trader" BOOL NOT NULL DEFAULT ('0'),
    "locale" TEXT NOT NULL DEFAULT ('en')
);
INSERT INTO "shipnames" VALUES('Penelope',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Endeavour',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Surprise',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Acheron',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Xanthos',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Galliwasp',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Tracker',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Antigone',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Patrician',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Bruizer',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Renown',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Caroline',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Indefatigable',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Black Pearl',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Black Hawk',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Dancing Betty',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Red Phoenix',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Flying Dutchman',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Bloody Mary',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('The Bearded Lady',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Huitzilopochtli',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Tonatiuh',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Akhet',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Amarnhaten',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Magna Libertatis',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Navis Nautarum',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Essex',0,0,1,0,'en');
INSERT INTO "shipnames" VALUES('Cibus',0,0,1,0,'en');
INSERT INTO "shipnames" VALUES('Artis',0,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Adventure',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Interceptor',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Enterprise',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Mayflower',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Beagle',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Argo',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Blue Tulip',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Swan of Amsterdam',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Flying Molly',0,0,1,0,'en');
INSERT INTO "shipnames" VALUES('Albertros',0,0,1,0,'en');
INSERT INTO "shipnames" VALUES('Saint Peter',0,0,1,0,'en');
INSERT INTO "shipnames" VALUES('Neptune',0,0,1,0,'en');
INSERT INTO "shipnames" VALUES('Poseidon',0,0,1,0,'en');
INSERT INTO "shipnames" VALUES('Triton',0,0,1,0,'en');
INSERT INTO "shipnames" VALUES('Silver Tuna',0,0,1,0,'en');
INSERT INTO "shipnames" VALUES('Golden Cod',0,0,1,0,'en');
INSERT INTO "shipnames" VALUES('Opal Whale',0,0,1,0,'en');
INSERT INTO "shipnames" VALUES('L''Etoile',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Seastar',0,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Resolution',0,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Santa Barbara',0,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Santa Maria',0,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Gallega',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Pinta',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Santa Clara',0,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Pietro Gonzale',0,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Erasmo',0,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Jodocus',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Cristina de Bolsena',0,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Seewolf',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Queen Anne''s Revenge',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Black Joke',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Blanco',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Cassandra',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Flying Dragon',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Golden Hind',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Good Fortune',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Liberty',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Loyal Fortune',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Ranger',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Revenge',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Rising Sun',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Royal Fortune',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Sea King',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Speedy Return',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Sudden Death',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Victory',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Caleuche',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Dark Maiden',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Night Ram',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Red Sun',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Sea Dragon',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Black Snake',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Surface Shark',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Queen of the Seas',1,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Thunder Dragon',1,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Silver Dragon',1,1,0,0,'en');
INSERT INTO "shipnames" VALUES('The Ghost Dragon',1,1,0,0,'en');
INSERT INTO "shipnames" VALUES('New Hope',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('New Dawn',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('The Mermaid',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Holy Maiden',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Black Thunder',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Black Serpent',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('The Laughing Ghost',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('The Mad King',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('The Dark Maiden',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Victoria',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Carmen',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Jornada',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Fe',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Nassau',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Elisabeth',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Festering Boot',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Cygne Noir',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Los Contaminacao',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Sinspawn',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Keelhaul',0,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Bruynvisch',1,0,0,0,'nl');
INSERT INTO "shipnames" VALUES('Groene Draeck',1,0,0,0,'nl');
INSERT INTO "shipnames" VALUES('Hollandsche Tuin',1,0,0,0,'nl');
INSERT INTO "shipnames" VALUES('Vliegende Draeck',1,0,0,0,'nl');
INSERT INTO "shipnames" VALUES('Vogelstruys',1,0,0,0,'nl');
INSERT INTO "shipnames" VALUES('Vrijheid',1,0,0,0,'nl');
INSERT INTO "shipnames" VALUES('Gerechtigheid',1,0,0,0,'nl');
INSERT INTO "shipnames" VALUES('Gloeyenden Oven',1,0,0,0,'nl');
INSERT INTO "shipnames" VALUES('Tijdverdrijf',1,0,0,0,'nl');
INSERT INTO "shipnames" VALUES('Dolphijn',1,0,0,0,'nl');
INSERT INTO "shipnames" VALUES('Fazant',1,0,0,0,'nl');
INSERT INTO "shipnames" VALUES('Eenhoorn',1,0,0,0,'nl');
INSERT INTO "shipnames" VALUES('Gekroonde Liefde',1,0,0,0,'nl');
INSERT INTO "shipnames" VALUES('Geloof',1,0,0,0,'nl');
INSERT INTO "shipnames" VALUES('Wakende Boei',1,0,0,0,'nl');
INSERT INTO "shipnames" VALUES('Beschermer',1,0,0,0,'nl');
INSERT INTO "shipnames" VALUES('Voorzichtigheid',1,0,0,0,'nl');
INSERT INTO "shipnames" VALUES('Groningen',1,0,0,0,'nl');
INSERT INTO "shipnames" VALUES('Vlissingen',1,0,0,0,'nl');
INSERT INTO "shipnames" VALUES('Walcheren',1,0,0,0,'nl');
INSERT INTO "shipnames" VALUES('Callantsoog',1,0,0,0,'nl');
INSERT INTO "shipnames" VALUES('Ada',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Agnes',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Emma Stonard',1,0,1,1,'en');
INSERT INTO "shipnames" VALUES('Alice',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Alnwick',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Amelia',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Ann Ellen',1,0,1,1,'en');
INSERT INTO "shipnames" VALUES('Ann Summer',1,0,1,1,'en');
INSERT INTO "shipnames" VALUES('Ant',1,0,1,1,'en');
INSERT INTO "shipnames" VALUES('Argus',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Arthur Gordon',1,0,1,1,'en');
INSERT INTO "shipnames" VALUES('Augusta',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Backbarrow',1,1,0,1,'en');
INSERT INTO "shipnames" VALUES('Bans Vale',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Bardsea',1,1,0,1,'en');
INSERT INTO "shipnames" VALUES('Belle',1,0,1,1,'en');
INSERT INTO "shipnames" VALUES('Britannia',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Baron Hill',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Beatrice',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Confidence',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Dove',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Delight',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Dreadnaught',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Emma',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Eugene',1,0,1,1,'en');
INSERT INTO "shipnames" VALUES('Francis',1,1,0,1,'en');
INSERT INTO "shipnames" VALUES('Gauntlet',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Gleaner',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Gratitude',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Glenravil Miner',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Greyhound',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Holy Wath',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Hope',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Hermes',1,1,0,1,'en');
INSERT INTO "shipnames" VALUES('Hare',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Hodbarrow Miner',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Isabella',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Jane',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Kate',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Kitty',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Leo',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Leven',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Mary Jane',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Mary Ann',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Octavia',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Old Hunter',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Rose',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Royal Oak',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Sea King',1,1,0,0,'en');
INSERT INTO "shipnames" VALUES('Squire',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Sirius',1,1,0,1,'en');
INSERT INTO "shipnames" VALUES('Success',1,0,0,0,'en');
INSERT INTO "shipnames" VALUES('Swift',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Tower',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('Wave',1,0,0,1,'en');
INSERT INTO "shipnames" VALUES('William',1,0,1,1,'en');
CREATE TABLE resource (
    "tradeable" BOOL NOT NULL DEFAULT (0),
    "name" TEXT NOT NULL,
    "value" INTEGER,
    "id" INTEGER AUTO_INCREMENT NOT NULL,
    "shown_in_inventory" BOOL NOT NULL DEFAULT (1)
);
INSERT INTO "resource" VALUES(0,'coins',0,1,0);
INSERT INTO "resource" VALUES(0,'lamb wool',2,2,1);
INSERT INTO "resource" VALUES(1,'textile',6.5,3,1);
INSERT INTO "resource" VALUES(1,'boards',1.25,4,1);
INSERT INTO "resource" VALUES(1,'food',2,5,1);
INSERT INTO "resource" VALUES(1,'tools',18.5,6,1);
INSERT INTO "resource" VALUES(1,'bricks',15,7,1);
INSERT INTO "resource" VALUES(0,'wood',1,8,1);
INSERT INTO "resource" VALUES(0,'grass',0,9,0);
INSERT INTO "resource" VALUES(1,'wool',2.5,10,1);
INSERT INTO "resource" VALUES(0,'faith',NULL,11,1);
INSERT INTO "resource" VALUES(0,'deer food A',0,12,0);
INSERT INTO "resource" VALUES(0,'deer meat',2,13,0);
INSERT INTO "resource" VALUES(0,'happiness',NULL,14,0);
INSERT INTO "resource" VALUES(0,'potatoes',2,15,1);
INSERT INTO "resource" VALUES(0,'education',NULL,16,0);
INSERT INTO "resource" VALUES(0,'sugar cane',2,17,1);
INSERT INTO "resource" VALUES(1,'sugar',2.5,18,1);
INSERT INTO "resource" VALUES(0,'community',NULL,19,0);
INSERT INTO "resource" VALUES(0,'clay deposit',0,20,1);
INSERT INTO "resource" VALUES(1,'clay',7.5,21,1);
INSERT INTO "resource" VALUES(1,'liquor',6.5,22,1);
INSERT INTO "resource" VALUES(1,'charcoal',6.5,23,1);
INSERT INTO "resource" VALUES(0,'iron deposit',0,24,1);
INSERT INTO "resource" VALUES(1,'iron ore',7.5,25,1);
INSERT INTO "resource" VALUES(1,'iron ingots',24,26,1);
INSERT INTO "resource" VALUES(0,'get-together',NULL,27,0);
INSERT INTO "resource" VALUES(0,'fish',0,28,0);
INSERT INTO "resource" VALUES(1,'salt',15,29,1);
INSERT INTO "resource" VALUES(0,'tobacco plants',2,30,1);
INSERT INTO "resource" VALUES(1,'tobacco leaves',2.5,31,1);
INSERT INTO "resource" VALUES(1,'tobaccos',10,32,1);
INSERT INTO "resource" VALUES(0,'cattle',0,33,1);
INSERT INTO "resource" VALUES(0,'pigs',0,34,1);
INSERT INTO "resource" VALUES(0,'cattle for slaughter',2,35,1);
INSERT INTO "resource" VALUES(0,'pigs for slaughter',2,36,1);
INSERT INTO "resource" VALUES(0,'herbs',0,37,1);
INSERT INTO "resource" VALUES(0,'medical herbs',2.5,38,0);
INSERT INTO "resource" VALUES(0,'acorns',0,39,1);
INSERT INTO "resource" VALUES(1,'cannon',100,40,1);
INSERT INTO "resource" VALUES(0,'dagger',10,41,0);
CREATE TABLE translucent_buildings(type INTEGER);
INSERT INTO "translucent_buildings" VALUES(17);
INSERT INTO "translucent_buildings" VALUES(34);
INSERT INTO "translucent_buildings" VALUES(28);
CREATE TABLE "weapon" (
	"id" INTEGER,
	"type" TEXT,
	"damage" INT,
	"min_range" INT,
	"max_range" INT,
	"cooldown_time" INT,
	"attack_speed" INT,
	"attack_radius" INT,
	"stackable" BOOLEAN,
	"bullet_image" TEXT);
INSERT INTO "weapon" VALUES(40,'ranged',7,5,15,3,4,2,1,'content/gfx/misc/cannonballs/cannonball.png');
INSERT INTO "weapon" VALUES(41,'melee',3,1,1,3,2,1,0,'');
CREATE TABLE settler_production_line(level INTEGER, production_line INTEGER);
INSERT INTO "settler_production_line" VALUES(0,71);
INSERT INTO "settler_production_line" VALUES(0,72);
INSERT INTO "settler_production_line" VALUES(1,19);
INSERT INTO "settler_production_line" VALUES(1,20);
INSERT INTO "settler_production_line" VALUES(1,21);
INSERT INTO "settler_production_line" VALUES(1,26);
INSERT INTO "settler_production_line" VALUES(0,30);
INSERT INTO "settler_production_line" VALUES(1,30);
INSERT INTO "settler_production_line" VALUES(2,30);
INSERT INTO "settler_production_line" VALUES(2,43);
INSERT INTO "settler_production_line" VALUES(2,20);
INSERT INTO "settler_production_line" VALUES(2,21);
INSERT INTO "settler_production_line" VALUES(2,44);
INSERT INTO "settler_production_line" VALUES(2,41);
INSERT INTO "settler_production_line" VALUES(2,69);
INSERT INTO "settler_production_line" VALUES(2,70);
CREATE TABLE settler_level (
    "level" INT NOT NULL DEFAULT (''),
    "name" TEXT NOT NULL DEFAULT (''),
    "tax_income" INT NOT NULL DEFAULT (''),
    "inhabitants_max" INT
, "residential_name" TEXT   DEFAULT (''));
INSERT INTO "settler_level" VALUES(0,'sailor',3,2,'tent');
INSERT INTO "settler_level" VALUES(1,'pioneer',6,3,'hut');
INSERT INTO "settler_level" VALUES(2,'settler',10,5,'house');
INSERT INTO "settler_level" VALUES(3,'citizen',15,8,'stone house');
INSERT INTO "settler_level" VALUES(4,'merchant',21,13,'estate');
INSERT INTO "settler_level" VALUES(5,'aristocrat',28,21,'manor');
