/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef GTK_DUMPDIALOG_H
#define GTK_DUMPDIALOG_H

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtk.h>

#include <visu_dump.h>
#include <coreTools/toolFileFormat.h>

G_BEGIN_DECLS
/**
 * DUMP_DIALOG_TYPE
 *
 * Return the associated #GType to the DumpDialog objects.
 */
#define DUMP_DIALOG_TYPE         (dumpDialog_get_type ())
/**
 * DUMP_DIALOG:
 *
 * Cast the given object to a #DumpDialog object.
 */
#define DUMP_DIALOG(obj)         (G_TYPE_CHECK_INSTANCE_CAST ((obj), DUMP_DIALOG_TYPE, DumpDialog))
/**
 * DUMP_DIALOG_CLASS
 *
 * Cast the given class to a #DumpDialogClass object.
 */
#define DUMP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DUMP_DIALOG_TYPE, DumpDialogClass))
/**
 * IS_DUMP_DIALOG
 *
 * Return if the given object is a valid #DumpDialog object.
 */
#define IS_DUMP_DIALOG(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DUMP_DIALOG_TYPE))
/**
 * IS_DUMP_DIALOG_CLASS
 *
 * Return if the given class is a valid #DumpDialogClass class.
 */
#define IS_DUMP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DUMP_DIALOG_TYPE))
#define DUMP_DIALOG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS(obj, DUMP_DIALOG_TYPE, DumpDialogClass))

/**
 * DumpDialog
 *
 * Private structure to store informations of a #DumpDialog object.
 */
typedef struct _DumpDialog DumpDialog;
/**
 * DumpDialogClass
 *
 * Private structure to store informations of a #DumpDialogClass object.
 */
typedef struct _DumpDialogClass DumpDialogClass;

/**
 * dumpDialog_get_type
 *
 * #GType are unique numbers to identify objects.
 *
 * Returns: the #GType associated with #DumpDialog objects.
 */
GType          dumpDialog_get_type        (void);
/**
 * dumpDialog_new :
 * @dataObj: a #VisuData object (can be NULL) ;
 * @parent: the parent window ;
 * @suggestedFilename: a string or NULL.
 *
 * A #DumpDialog widget is complete dialog window widget, but it is already
 * prepared for dumping, proposing known file formats. It is usefull to get
 * an filename to export to. It has also a progress bar that can illustrate
 * the process. The given @dataObj argument is used to initialize some
 * values related to the data to be dumped (such as the default size).
 *
 * Returns: a newly created #DumpDialog widget.
 */
GtkWidget* dumpDialog_new(VisuData *dataObj, GtkWindow *parent,
			  const gchar *suggestedFilename);

/**
 * dumpDialogGet_fileName:
 * @dialog: a #DumpDialog object.
 *
 * Retrieve the chosen filename.
 *
 * Returns: a read-only string.
 */
gchar* dumpDialogGet_fileName(DumpDialog *dialog);
/**
 * dumpDialogGet_dumpType:
 * @dialog: a #DumpDialog object.
 *
 * Retrieve the chosen DumpType.
 *
 * Returns: the selected format (FileFormat and write method).
 */
DumpType* dumpDialogGet_dumpType(DumpDialog *dialog);
/**
 * dumpDialogGet_fileFormat:
 * @dialog: a #DumpDialog object.
 *
 * Retrieve the chosen fileFormat.
 *
 * Returns: the selected format, only FileFormat.
 */
FileFormat* dumpDialogGet_fileFormat(DumpDialog *dialog);
/**
 * dumpDialogGet_progressBar:
 * @dialog: a #DumpDialog object.
 *
 * Retrieve interesting widget.
 *
 * Returns: a pointer to the progress bar.
 */
GtkProgressBar* dumpDialogGet_progressBar(DumpDialog *dialog);
/**
 * dumpDialogGet_cancelButton:
 * @dialog: a #DumpDialog object.
 *
 * Retrieve interesting widget.
 *
 * Returns: a pointer to the cancel button.
 */
GtkButton* dumpDialogGet_cancelButton(DumpDialog *dialog);
/**
 * dumpDialogGet_widthValue:
 * @dialog: a #DumpDialog object.
 *
 * Retrieve request image size.
 *
 * Returns: the width value.
 */
gint dumpDialogGet_widthValue(DumpDialog *dialog);
/**
 * dumpDialogGet_heightValue:
 * @dialog: a #DumpDialog object.
 *
 * Retrieve request image size.
 *
 * Returns: the height value.
 */
gint dumpDialogGet_heightValue(DumpDialog *dialog);
/**
 * dumpDialogStart:
 * @dialog: a #DumpDialog object.
 *
 * Make the file chooser part insensitive during dump, only the
 * progress bar and the abort button are kept sensitive.
 */
void dumpDialogStart(DumpDialog *dialog);
/**
 * dumpDialogStop:
 * @dialog: a #DumpDialog object.
 *
 * Return the filechooser to a sensitive state.
 */
void dumpDialogStop(DumpDialog *dialog);


G_END_DECLS

#endif
