/* main.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from main.vala, do not modify */

/* valaprojectgenerator.vala
 *
 * Copyright (C) 2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Andrea Del Signore <sejerpz@tin.it>
 * 	Nicolas Joseph <nicolas.joseph@valaide.org>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gen-project.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <config.h>
#include <stdio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _gen_project_project_options_unref0(var) ((var == NULL) ? NULL : (var = (gen_project_project_options_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define VALA_TYPE_GEN_PROJECT_DIALOG (vala_gen_project_dialog_get_type ())
#define VALA_GEN_PROJECT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GEN_PROJECT_DIALOG, ValaGenProjectDialog))
#define VALA_GEN_PROJECT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GEN_PROJECT_DIALOG, ValaGenProjectDialogClass))
#define VALA_IS_GEN_PROJECT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GEN_PROJECT_DIALOG))
#define VALA_IS_GEN_PROJECT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GEN_PROJECT_DIALOG))
#define VALA_GEN_PROJECT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GEN_PROJECT_DIALOG, ValaGenProjectDialogClass))

typedef struct _ValaGenProjectDialog ValaGenProjectDialog;
typedef struct _ValaGenProjectDialogClass ValaGenProjectDialogClass;
#define _vala_gen_project_dialog_unref0(var) ((var == NULL) ? NULL : (var = (vala_gen_project_dialog_unref (var), NULL)))


extern gchar* option_project_path;
gchar* option_project_path = NULL;
extern gboolean option_version;
gboolean option_version = FALSE;
extern gboolean option_list_templates;
gboolean option_list_templates = FALSE;
extern gint option_template_id;
gint option_template_id = 0;
extern gchar* option_author;
gchar* option_author = NULL;
extern gchar* option_email;
gchar* option_email = NULL;
extern gchar** option_files;
extern gint option_files_length1;
gchar** option_files = NULL;
gint option_files_length1 = 0;
static gint _option_files_size_ = 0;
extern GenProjectProjectLicense option_project_license;
GenProjectProjectLicense option_project_license = 0;

gboolean option_parse_callback (const gchar* option_name, const gchar* value, void* data, GError** error);
gint _vala_main (gchar** args, int args_length1);
ValaGenProjectDialog* vala_gen_project_dialog_new (void);
ValaGenProjectDialog* vala_gen_project_dialog_construct (GType object_type);
gpointer vala_gen_project_dialog_ref (gpointer instance);
void vala_gen_project_dialog_unref (gpointer instance);
GParamSpec* vala_param_spec_gen_project_dialog (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_gen_project_dialog (GValue* value, gpointer v_object);
void vala_value_take_gen_project_dialog (GValue* value, gpointer v_object);
gpointer vala_value_get_gen_project_dialog (const GValue* value);
GType vala_gen_project_dialog_get_type (void) G_GNUC_CONST;
GtkResponseType vala_gen_project_dialog_ask_parameters (ValaGenProjectDialog* self, GenProjectProjectOptions* options);

const GOptionEntry options[9] = {{"projectdir", 'p', 0, G_OPTION_ARG_FILENAME, &option_project_path, "Project directory", "DIRECTORY"}, {"template-id", 't', 0, G_OPTION_ARG_INT, &option_template_id, "Project TYPE id. See --list-templates for a list of avalable templates", "TYPE"}, {"list-templates", (gchar) 0, 0, G_OPTION_ARG_NONE, &option_list_templates, "Print a list of avalable project templates", NULL}, {"license", 'l', 0, G_OPTION_ARG_CALLBACK, (void*) option_parse_callback, "License TYPE: gpl2, gpl3, lgpl2, lgpl3", "TYPE"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &option_version, "Display version number", NULL}, {"author", 'a', 0, G_OPTION_ARG_STRING, &option_author, "Author name", "NAME"}, {"email", 'e', 0, G_OPTION_ARG_STRING, &option_email, "Author email address", "EMAIL"}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &option_files, "Project NAME", "NAME"}, {NULL}};

gboolean option_parse_callback (const gchar* option_name, const gchar* value, void* data, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (option_name != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	if (g_strcmp0 (option_name, "--license") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (option_name, "-l") == 0;
	}
	if (_tmp0_) {
		if (g_strcmp0 (value, "gpl2") == 0) {
			option_project_license = GEN_PROJECT_PROJECT_LICENSE_GPL2;
		} else {
			if (g_strcmp0 (value, "gpl3") == 0) {
				option_project_license = GEN_PROJECT_PROJECT_LICENSE_GPL3;
			} else {
				if (g_strcmp0 (value, "lgpl2") == 0) {
					option_project_license = GEN_PROJECT_PROJECT_LICENSE_LGPL2;
				} else {
					if (g_strcmp0 (value, "lgpl3") == 0) {
						option_project_license = GEN_PROJECT_PROJECT_LICENSE_LGPL3;
					} else {
						const gchar* _tmp1_ = NULL;
						gchar* _tmp2_ = NULL;
						gchar* _tmp3_;
						GError* _tmp4_ = NULL;
						GError* _tmp5_;
						_tmp1_ = _ ("license of type %s is not available");
						_tmp2_ = g_strdup_printf (_tmp1_, value);
						_tmp3_ = _tmp2_;
						_tmp4_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _tmp3_);
						_tmp5_ = _tmp4_;
						_g_free0 (_tmp3_);
						_inner_error_ = _tmp5_;
						if (_inner_error_->domain == G_OPTION_ERROR) {
							g_propagate_error (error, _inner_error_);
							return FALSE;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
				}
			}
		}
	} else {
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		GError* _tmp9_ = NULL;
		GError* _tmp10_;
		_tmp6_ = _ ("unknown option %s");
		_tmp7_ = g_strdup_printf (_tmp6_, option_name);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_UNKNOWN_OPTION, _tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_inner_error_ = _tmp10_;
		if (_inner_error_->domain == G_OPTION_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GenProjectProjectOptions* project_options;
	GenProjectProjectOptions* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* opt_context;
	ValaGenProjectDialog* _tmp26_ = NULL;
	ValaGenProjectDialog* dialog;
	gboolean _tmp27_ = FALSE;
	GError * _inner_error_ = NULL;
	project_options = NULL;
	gtk_init (&args_length1, &args);
	bindtextdomain (GETTEXT_PACKAGE, NULL);
	_tmp0_ = gen_project_project_options_new ();
	_gen_project_project_options_unref0 (project_options);
	project_options = _tmp0_;
	_tmp1_ = g_option_context_new ("- Vala Project Generator");
	opt_context = _tmp1_;
	g_option_context_set_help_enabled (opt_context, TRUE);
	g_option_context_add_main_entries (opt_context, options, NULL);
	g_option_context_parse (opt_context, &args_length1, &args, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (opt_context);
		if (_inner_error_->domain == G_OPTION_ERROR) {
			goto __catch0_g_option_error;
		}
		_g_option_context_free0 (opt_context);
		_gen_project_project_options_unref0 (project_options);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	project_options->version = option_version;
	if (option_author != NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (option_author);
		_g_free0 (project_options->author);
		project_options->author = _tmp2_;
	}
	if (option_email != NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (option_email);
		_g_free0 (project_options->email);
		project_options->email = _tmp3_;
	}
	if (option_project_license != 0) {
		project_options->license = option_project_license;
	}
	if (option_project_path != NULL) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (option_project_path);
		_g_free0 (project_options->path);
		project_options->path = _tmp4_;
	}
	if (option_files != NULL) {
		gchar* _tmp7_;
		if (option_files[1] != NULL) {
			const gchar* _tmp5_ = NULL;
			GError* _tmp6_ = NULL;
			_tmp5_ = _ ("Just a single project name can be specified on the command line");
			_tmp6_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _tmp5_);
			_inner_error_ = _tmp6_;
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			_gen_project_project_options_unref0 (project_options);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp7_ = g_strdup (option_files[0]);
		_g_free0 (project_options->name);
		project_options->name = _tmp7_;
		if (option_project_path == NULL) {
			gchar* _tmp8_ = NULL;
			_tmp8_ = g_get_current_dir ();
			_g_free0 (project_options->path);
			project_options->path = _tmp8_;
		}
	}
	_g_option_context_free0 (opt_context);
	goto __finally0;
	__catch0_g_option_error:
	{
		GError * e;
		const gchar* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stdout, "%s\n", e->message);
		_tmp9_ = _ ("Run '%s --help' to see a full list of available command line options.\n");
		fprintf (stdout, _tmp9_, args[0]);
		result = 1;
		_g_error_free0 (e);
		_gen_project_project_options_unref0 (project_options);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_gen_project_project_options_unref0 (project_options);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (option_version) {
		fprintf (stdout, "vala-gen-project %s\n", PACKAGE_VERSION);
		result = 0;
		_gen_project_project_options_unref0 (project_options);
		return result;
	}
	if (option_list_templates) {
		GenProjectTemplates* _tmp10_ = NULL;
		GenProjectTemplates* templates;
		const gchar* _tmp11_ = NULL;
		GList* _tmp12_ = NULL;
		_tmp10_ = gen_project_templates_load (NULL, 0);
		templates = _tmp10_;
		_tmp11_ = _ ("Available project templates\n");
		fprintf (stdout, "%s", _tmp11_);
		_tmp12_ = gen_project_templates_get_definitions (templates);
		{
			GList* definition_collection;
			GList* definition_it;
			definition_collection = _tmp12_;
			for (definition_it = definition_collection; definition_it != NULL; definition_it = definition_it->next) {
				GenProjectTemplateDefinition* _tmp13_;
				GenProjectTemplateDefinition* definition;
				_tmp13_ = _g_object_ref0 ((GenProjectTemplateDefinition*) definition_it->data);
				definition = _tmp13_;
				{
					const gchar* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
					gint _tmp16_;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_;
					_tmp14_ = _ ("\tname '%s' - id %d\n");
					_tmp15_ = gen_project_template_definition_get_name (definition);
					_tmp16_ = gen_project_template_definition_get_id (definition);
					_tmp17_ = g_strdup_printf (_tmp14_, _tmp15_, _tmp16_ + 1);
					_tmp18_ = _tmp17_;
					fprintf (stdout, "%s", _tmp18_);
					_g_free0 (_tmp18_);
					_g_object_unref0 (definition);
				}
			}
		}
		result = 0;
		_g_object_unref0 (templates);
		_gen_project_project_options_unref0 (project_options);
		return result;
	}
	if (option_template_id > 0) {
		GenProjectTemplates* _tmp19_ = NULL;
		GenProjectTemplates* templates;
		GList* _tmp20_ = NULL;
		_tmp19_ = gen_project_templates_load (NULL, 0);
		templates = _tmp19_;
		_g_object_unref0 (project_options->template);
		project_options->template = NULL;
		_tmp20_ = gen_project_templates_get_definitions (templates);
		{
			GList* definition_collection;
			GList* definition_it;
			definition_collection = _tmp20_;
			for (definition_it = definition_collection; definition_it != NULL; definition_it = definition_it->next) {
				GenProjectTemplateDefinition* _tmp21_;
				GenProjectTemplateDefinition* definition;
				_tmp21_ = _g_object_ref0 ((GenProjectTemplateDefinition*) definition_it->data);
				definition = _tmp21_;
				{
					gint _tmp22_;
					_tmp22_ = gen_project_template_definition_get_id (definition);
					if ((_tmp22_ + 1) == option_template_id) {
						GenProjectTemplateDefinition* _tmp23_;
						_tmp23_ = _g_object_ref0 (definition);
						_g_object_unref0 (project_options->template);
						project_options->template = _tmp23_;
						_g_object_unref0 (definition);
						break;
					}
					_g_object_unref0 (definition);
				}
			}
		}
		if (project_options->template == NULL) {
			const gchar* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			_tmp24_ = _ ("Cannot find template id %d\n");
			fprintf (stdout, _tmp24_, option_template_id);
			_tmp25_ = _ ("Run '%s --list-templates' to see a full list of available templates.\n");
			fprintf (stdout, _tmp25_, args[0]);
			result = 1;
			_g_object_unref0 (templates);
			_gen_project_project_options_unref0 (project_options);
			return result;
		}
		_g_object_unref0 (templates);
	}
	_tmp26_ = vala_gen_project_dialog_new ();
	dialog = _tmp26_;
	if (project_options->name != NULL) {
		_tmp27_ = TRUE;
	} else {
		GtkResponseType _tmp28_;
		_tmp28_ = vala_gen_project_dialog_ask_parameters (dialog, project_options);
		_tmp27_ = _tmp28_ == GTK_RESPONSE_OK;
	}
	if (_tmp27_) {
		GenProjectProjectGenerator* _tmp29_ = NULL;
		GenProjectProjectGenerator* generator;
		_tmp29_ = gen_project_project_generator_new (project_options);
		generator = _tmp29_;
		gen_project_project_generator_create_project (generator);
		result = 0;
		_g_object_unref0 (generator);
		_vala_gen_project_dialog_unref0 (dialog);
		_gen_project_project_options_unref0 (project_options);
		return result;
	}
	result = 1;
	_vala_gen_project_dialog_unref0 (dialog);
	_gen_project_project_options_unref0 (project_options);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



