/* gedit-3.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Gedit", lower_case_cprefix = "gedit_", gir_namespace = "Gedit", gir_version = "3.0")]
namespace Gedit {
	[CCode (type_id = "gedit_app_get_type ()", cheader_filename = "gedit/gedit-app.h")]
	public class App : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		protected App ();
		public unowned Gedit.Window create_window (Gdk.Screen? screen);
		public unowned Gedit.Window get_active_window ();
		public static unowned Gedit.App get_default ();
		public GLib.List<weak Gedit.Document> get_documents ();
		public Gedit.LockdownMask get_lockdown ();
		public GLib.List<weak Gedit.View> get_views ();
		public unowned GLib.List<weak Gedit.Window> get_windows ();
		[NoWrapper]
		public virtual string help_link_id (string name, string link_id);
		[NoWrapper]
		public virtual bool last_window_destroyed ();
		public virtual void set_window_title (Gedit.Window window, string title);
		public virtual bool show_help (Gtk.Window parent, string name, string link_id);
		public Gedit.LockdownMask lockdown { get; }
	}
	[CCode (type_id = "gedit_document_get_type ()", cheader_filename = "gedit/gedit-document.h")]
	public class Document : GtkSource.Buffer {
		[CCode (has_construct_function = false)]
		public Document ();
		public static GLib.Quark error_quark ();
		public bool get_can_search_again ();
		public Gedit.DocumentCompressionType get_compression_type ();
		public string get_content_type ();
		public bool get_deleted ();
		public bool get_enable_search_highlighting ();
		public unowned Gedit.Encoding get_encoding ();
		public unowned GtkSource.Language get_language ();
		public GLib.File get_location ();
		public string get_metadata (string key);
		public string get_mime_type ();
		public Gedit.DocumentNewlineType get_newline_type ();
		public bool get_readonly ();
		public string get_search_text (uint? flags);
		public string get_short_name_for_display ();
		public string get_uri_for_display ();
		public bool goto_line (int line);
		public bool goto_line_offset (int line, int line_offset);
		public bool is_local ();
		public bool is_untitled ();
		public bool is_untouched ();
		public bool load_cancel ();
		public void load_stream (GLib.InputStream stream, Gedit.Encoding? encoding, int line_pos, int column_pos);
		public int replace_all (string find, string replace, uint flags);
		[CCode (vfunc_name = "save")]
		public virtual void save_as (GLib.File location, Gedit.Encoding encoding, Gedit.DocumentNewlineType newline_type, Gedit.DocumentCompressionType compression_type, Gedit.DocumentSaveFlags flags);
		public bool search_backward (Gtk.TextIter? start, Gtk.TextIter? end, Gtk.TextIter? match_start, Gtk.TextIter? match_end);
		public bool search_forward (Gtk.TextIter? start, Gtk.TextIter? end, Gtk.TextIter? match_start, Gtk.TextIter? match_end);
		public void set_content_type (string? content_type);
		public void set_enable_search_highlighting (bool enable);
		public void set_language (GtkSource.Language? lang);
		public void set_location (GLib.File location);
		public void set_search_text (string text, uint flags);
		public void set_short_name_for_display (string? short_name);
		public bool can_search_again { get; }
		public Gedit.DocumentCompressionType compression_type { get; set construct; }
		public string content_type { owned get; set; }
		public bool enable_search_highlighting { get; set; }
		public Gedit.Encoding encoding { get; }
		public GLib.File location { owned get; set; }
		public string mime_type { owned get; }
		public Gedit.DocumentNewlineType newline_type { get; set construct; }
		[NoAccessorMethod]
		public bool read_only { get; }
		[NoAccessorMethod]
		public string shortname { owned get; set; }
		public virtual signal void cursor_moved ();
		[HasEmitter]
		public virtual signal void load (GLib.File location, Gedit.Encoding encoding, int line_pos, bool column_pos);
		public virtual signal void loaded (void* error);
		public virtual signal void loading (uint64 size, uint64 total_size);
		[HasEmitter]
		public virtual signal void save (GLib.File location, Gedit.Encoding encoding, Gedit.DocumentNewlineType newline_type, Gedit.DocumentCompressionType compression_type, Gedit.DocumentSaveFlags flags);
		public virtual signal void saved (void* error);
		public virtual signal void saving (uint64 size, uint64 total_size);
		public virtual signal void search_highlight_updated (Gtk.TextIter start, Gtk.TextIter end);
	}
	[Compact]
	[CCode (copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gedit_encoding_get_type ()", cheader_filename = "gedit/gedit-encodings.h")]
	public class Encoding {
		[CCode (has_construct_function = false)]
		protected Encoding ();
		public Gedit.Encoding copy ();
		public void free ();
		public unowned string get_charset ();
		public static unowned Gedit.Encoding get_current ();
		public static unowned Gedit.Encoding get_from_charset (string charset);
		public static unowned Gedit.Encoding get_from_index (int index);
		public unowned string get_name ();
		public static unowned Gedit.Encoding get_utf8 ();
		public string to_string ();
	}
	[CCode (type_id = "gedit_encodings_combo_box_get_type ()", cheader_filename = "gedit/gedit-encodings-combo-box.h")]
	public class EncodingsComboBox : Gtk.ComboBox, Atk.Implementor, Gtk.Buildable, Gtk.CellEditable, Gtk.CellLayout {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public EncodingsComboBox (bool save_mode);
		public unowned Gedit.Encoding get_selected_encoding ();
		public void set_selected_encoding (Gedit.Encoding? encoding);
		[NoAccessorMethod]
		public bool save_mode { get; set construct; }
	}
	[CCode (type_id = "gedit_message_get_type ()", cheader_filename = "gedit/gedit-message.h")]
	public class Message : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Message ();
		public GLib.Type get_key_type (string key);
		public void* get_message_type ();
		public unowned string get_method ();
		public unowned string get_object_path ();
		public void get_value (string key, out GLib.Value value);
		public bool has_key (string key);
		public void set_value (string key, out GLib.Value value);
		public void set_valuesv ([CCode (array_length_cname = "n_values", array_length_pos = 2.1)] string[] keys, [CCode (array_length_cname = "n_values", array_length_pos = 2.1)] GLib.Value[] values);
		public bool validate ();
		public string method { get; }
		public string object_path { get; }
		[NoAccessorMethod]
		public Gedit.MessageType type { owned get; construct; }
	}
	[CCode (type_id = "gedit_message_bus_get_type ()", cheader_filename = "gedit/gedit-message-bus.h")]
	public class MessageBus : GLib.Object {
		[CCode (has_construct_function = false)]
		public MessageBus ();
		public void block (uint id);
		public void block_by_func (string object_path, string method, [CCode (delegate_target_pos = 3.1)] Gedit.MessageCallback callback);
		public uint connect (string object_path, string method, [CCode (delegate_target_pos = 3.1)] owned Gedit.MessageCallback callback);
		public void disconnect (uint id);
		public void disconnect_by_func (string object_path, string method, [CCode (delegate_target_pos = 3.1)] Gedit.MessageCallback callback);
		public void @foreach (Gedit.MessageBusForeach func);
		public static unowned Gedit.MessageBus get_default ();
		public bool is_registered (string object_path, string method);
		public Gedit.MessageType lookup (string object_path, string method);
		public void send_message (Gedit.Message message);
		public void send_message_sync (Gedit.Message message);
		public void unblock (uint id);
		public void unblock_by_func (string object_path, string method, [CCode (delegate_target_pos = 3.1)] Gedit.MessageCallback callback);
		public void unregister (Gedit.MessageType message_type);
		public void unregister_all (string object_path);
		public virtual signal void dispatch (Gedit.Message message);
		public virtual signal void registered (Gedit.MessageType message_type);
		public virtual signal void unregistered (Gedit.MessageType message_type);
	}
	[Compact]
	[CCode (copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gedit_message_type_get_type ()", cheader_filename = "gedit/gedit-message-type.h")]
	public class MessageType {
		[CCode (has_construct_function = false)]
		protected MessageType ();
		public void @foreach (Gedit.MessageTypeForeach func);
		public unowned string get_method ();
		public unowned string get_object_path ();
		public static string identifier (string? object_path, string? method);
		public static bool is_supported (GLib.Type type);
		public static bool is_valid_object_path (string? object_path);
		public GLib.Type lookup (string key);
		public Gedit.MessageType @ref ();
		public void unref ();
	}
	[CCode (type_id = "gedit_panel_get_type ()", cheader_filename = "gedit/gedit-panel.h")]
	public class Panel : Gtk.VBox, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Panel (Gtk.Orientation orientation);
		public bool activate_item (Gtk.Widget item);
		public bool add_item (Gtk.Widget item, string id, string display_name, Gtk.Widget? image);
		public bool add_item_with_stock_icon (Gtk.Widget item, string id, string display_name, string? stock_id);
		public int get_n_items ();
		public Gtk.Orientation get_orientation ();
		public bool item_is_active (Gtk.Widget item);
		public bool remove_item (Gtk.Widget item);
		public Gtk.Orientation orientation { get; construct; }
		public virtual signal void close ();
		public virtual signal void focus_document ();
		public virtual signal void item_added (Gtk.Widget item);
		public virtual signal void item_removed (Gtk.Widget item);
	}
	[CCode (type_id = "gedit_progress_info_bar_get_type ()", cheader_filename = "gedit/gedit-progress-info-bar.h")]
	public class ProgressInfoBar : Gtk.InfoBar, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public ProgressInfoBar (string stock_id, string markup, bool has_cancel);
		public void pulse ();
		public void set_fraction (double fraction);
		public void set_markup (string markup);
		public void set_stock_image (string stock_id);
		public void set_text (string text);
		[NoAccessorMethod]
		public bool has_cancel_button { construct; }
	}
	[CCode (type_id = "gedit_statusbar_get_type ()", cheader_filename = "gedit/gedit-statusbar.h")]
	public class Statusbar : Gtk.Statusbar, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Statusbar ();
		public void clear_overwrite ();
		public void set_cursor_position (int line, int col);
		public void set_overwrite (bool overwrite);
		public void set_window_state (Gedit.WindowState state, int num_of_errors);
	}
	[CCode (type_id = "gedit_tab_get_type ()", cheader_filename = "gedit/gedit-tab.h")]
	public class Tab : Gtk.VBox, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false)]
		protected Tab ();
		public bool get_auto_save_enabled ();
		public int get_auto_save_interval ();
		public unowned Gedit.Document get_document ();
		public static unowned Gedit.Tab get_from_document (Gedit.Document doc);
		public Gedit.TabState get_state ();
		public unowned Gedit.View get_view ();
		public void set_auto_save_enabled (bool enable);
		public void set_auto_save_interval (int interval);
		public void set_info_bar (Gtk.Widget info_bar);
		[NoAccessorMethod]
		public bool autosave { get; set; }
		[NoAccessorMethod]
		public int autosave_interval { get; set; }
		[NoAccessorMethod]
		public string name { owned get; }
		public Gedit.TabState state { get; }
		public virtual signal void drop_uris ([CCode (array_length = false, array_null_terminated = true)] string[] uri_list);
	}
	[CCode (type_id = "gedit_view_get_type ()", cheader_filename = "gedit/gedit-view.h")]
	public class View : GtkSource.View, Atk.Implementor, Gtk.Buildable, Gtk.Scrollable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public View (Gedit.Document doc);
		public void copy_clipboard ();
		public void cut_clipboard ();
		public void delete_selection ();
		public void paste_clipboard ();
		public void scroll_to_cursor ();
		public void select_all ();
		public void set_font (bool def, string font_name);
		public virtual signal void drop_uris ([CCode (array_length = false, array_null_terminated = true)] string[] uri_list);
	}
	[CCode (type_id = "gedit_window_get_type ()", cheader_filename = "gedit/gedit-window.h")]
	public class Window : Gtk.Window, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected Window ();
		public void close_all_tabs ();
		public void close_tab (Gedit.Tab tab);
		public void close_tabs (GLib.List<weak Gedit.Tab> tabs);
		public unowned Gedit.Tab create_tab (bool jump_to);
		public unowned Gedit.Tab create_tab_from_location (GLib.File location, Gedit.Encoding encoding, int line_pos, int column_pos, bool create, bool jump_to);
		public unowned Gedit.Tab create_tab_from_stream (GLib.InputStream stream, Gedit.Encoding encoding, int line_pos, int column_pos, bool jump_to);
		public unowned Gedit.Document get_active_document ();
		public unowned Gedit.Tab get_active_tab ();
		public unowned Gedit.View get_active_view ();
		public unowned Gedit.Panel get_bottom_panel ();
		public GLib.List<weak Gedit.Document> get_documents ();
		public unowned Gtk.WindowGroup get_group ();
		public unowned Gedit.MessageBus get_message_bus ();
		public unowned Gedit.Panel get_side_panel ();
		public Gedit.WindowState get_state ();
		public unowned Gtk.Widget get_statusbar ();
		public unowned Gedit.Tab get_tab_from_location (GLib.File location);
		public unowned Gtk.UIManager get_ui_manager ();
		public GLib.List<weak Gedit.Document> get_unsaved_documents ();
		public GLib.List<weak Gedit.View> get_views ();
		public void set_active_tab (Gedit.Tab tab);
		public Gedit.WindowState state { get; }
		public virtual signal void active_tab_changed (Gedit.Tab tab);
		public virtual signal void active_tab_state_changed ();
		public virtual signal void tab_added (Gedit.Tab tab);
		public virtual signal void tab_removed (Gedit.Tab tab);
		public virtual signal void tabs_reordered ();
	}
	[CCode (cheader_filename = "gedit/gedit-app-activatable.h", type_cname = "GeditAppActivatableInterface", type_id = "gedit_app_activatable_get_type ()")]
	public interface AppActivatable : GLib.Object {
		public abstract void activate ();
		public abstract void deactivate ();
		[NoAccessorMethod]
		public Gedit.App app { owned get; construct; }
	}
	[CCode (cheader_filename = "gedit/gedit-view-activatable.h", type_cname = "GeditViewActivatableInterface", type_id = "gedit_view_activatable_get_type ()")]
	public interface ViewActivatable : GLib.Object {
		public abstract void activate ();
		public abstract void deactivate ();
		[NoAccessorMethod]
		public Gedit.View view { owned get; construct; }
	}
	[CCode (cheader_filename = "gedit/gedit-window-activatable.h", type_cname = "GeditWindowActivatableInterface", type_id = "gedit_window_activatable_get_type ()")]
	public interface WindowActivatable : GLib.Object {
		public abstract void activate ();
		public abstract void deactivate ();
		public abstract void update_state ();
		[NoAccessorMethod]
		public Gedit.Window window { owned get; construct; }
	}
	[CCode (cprefix = "GEDIT_", cheader_filename = "gedit/gedit-debug.h")]
	[Flags]
	public enum DebugSection {
		NO_DEBUG,
		DEBUG_VIEW,
		DEBUG_SEARCH,
		DEBUG_PRINT,
		DEBUG_PREFS,
		DEBUG_PLUGINS,
		DEBUG_TAB,
		DEBUG_DOCUMENT,
		DEBUG_COMMANDS,
		DEBUG_APP,
		DEBUG_SESSION,
		DEBUG_UTILS,
		DEBUG_METADATA,
		DEBUG_WINDOW,
		DEBUG_LOADER,
		DEBUG_SAVER,
		DEBUG_PANEL
	}
	[CCode (cprefix = "GEDIT_DOCUMENT_COMPRESSION_TYPE_", cheader_filename = "gedit/gedit-document.h")]
	public enum DocumentCompressionType {
		NONE,
		GZIP
	}
	[CCode (cprefix = "GEDIT_DOCUMENT_NEWLINE_TYPE_", cheader_filename = "gedit/gedit-document.h")]
	public enum DocumentNewlineType {
		LF,
		CR,
		CR_LF
	}
	[CCode (cprefix = "GEDIT_DOCUMENT_SAVE_", cheader_filename = "gedit/gedit-document.h")]
	[Flags]
	public enum DocumentSaveFlags {
		IGNORE_MTIME,
		IGNORE_BACKUP,
		PRESERVE_BACKUP,
		IGNORE_INVALID_CHARS
	}
	[CCode (cprefix = "GEDIT_LOCKDOWN_", cheader_filename = "gedit/gedit-app.h")]
	[Flags]
	public enum LockdownMask {
		COMMAND_LINE,
		PRINTING,
		PRINT_SETUP,
		SAVE_TO_DISK
	}
	[CCode (cprefix = "GEDIT_SEARCH_", cheader_filename = "gedit/gedit-document.h")]
	[Flags]
	public enum SearchFlags {
		DONT_SET_FLAGS,
		ENTIRE_WORD,
		CASE_SENSITIVE
	}
	[CCode (cprefix = "GEDIT_TAB_", cheader_filename = "gedit/gedit-tab.h")]
	public enum TabState {
		STATE_NORMAL,
		STATE_LOADING,
		STATE_REVERTING,
		STATE_SAVING,
		STATE_PRINTING,
		STATE_PRINT_PREVIEWING,
		STATE_SHOWING_PRINT_PREVIEW,
		STATE_GENERIC_NOT_EDITABLE,
		STATE_LOADING_ERROR,
		STATE_REVERTING_ERROR,
		STATE_SAVING_ERROR,
		STATE_GENERIC_ERROR,
		STATE_CLOSING,
		STATE_EXTERNALLY_MODIFIED_NOTIFICATION,
		NUM_OF_STATES
	}
	[CCode (cprefix = "GEDIT_WINDOW_STATE_", cheader_filename = "gedit/gedit-window.h")]
	[Flags]
	public enum WindowState {
		NORMAL,
		SAVING,
		PRINTING,
		LOADING,
		ERROR,
		SAVING_SESSION
	}
	[CCode (cheader_filename = "gedit/gedit-message-bus.h", instance_pos = 1.9)]
	public delegate void MessageBusForeach (Gedit.MessageType message_type);
	[CCode (cheader_filename = "gedit/gedit-message-bus.h", instance_pos = 2.9)]
	public delegate void MessageCallback (Gedit.MessageBus bus, Gedit.Message message);
	[CCode (cheader_filename = "gedit/gedit-message-type.h", instance_pos = 3.9)]
	public delegate void MessageTypeForeach (string key, GLib.Type type, bool required);
	[CCode (cheader_filename = "gedit/gedit-app.h")]
	public const int LOCKDOWN_ALL;
	[CCode (cheader_filename = "gedit/gedit-document.h")]
	public const string METADATA_ATTRIBUTE_ENCODING;
	[CCode (cheader_filename = "gedit/gedit-document.h")]
	public const string METADATA_ATTRIBUTE_LANGUAGE;
	[CCode (cheader_filename = "gedit/gedit-document.h")]
	public const string METADATA_ATTRIBUTE_POSITION;
	[CCode (cheader_filename = "gedit/gedit-commands.h")]
	public static void commands_load_location (Gedit.Window window, GLib.File location, Gedit.Encoding? encoding, int line_pos, int column_pos);
	[CCode (cheader_filename = "gedit/gedit-commands.h")]
	public static GLib.SList<weak Gedit.Document> commands_load_locations (Gedit.Window window, GLib.SList<weak GLib.File> locations, Gedit.Encoding? encoding, int line_pos, int column_pos);
	[CCode (cheader_filename = "gedit/gedit-commands.h")]
	public static void commands_save_all_documents (Gedit.Window window);
	[CCode (cheader_filename = "gedit/gedit-commands.h")]
	public static void commands_save_document (Gedit.Window window, Gedit.Document document);
	[CCode (cheader_filename = "gedit/gedit-debug.h")]
	public static void debug (Gedit.DebugSection section, string file, int line, string function);
	[CCode (cheader_filename = "gedit/gedit-debug.h")]
	public static void debug_init ();
	[CCode (cheader_filename = "gedit/gedit-utils.h")]
	public static string utils_basename_for_display (GLib.File location);
	[CCode (cheader_filename = "gedit/gedit-utils.h")]
	public static bool utils_can_read_from_stdin ();
	[CCode (cheader_filename = "gedit/gedit-utils.h")]
	public static bool utils_decode_uri (string uri, out string? scheme, out string? user, out string? port, out string? host, out string? path);
	[CCode (cheader_filename = "gedit/gedit-utils.h", array_length = false, array_null_terminated = true)]
	public static string[] utils_drop_get_uris (Gtk.SelectionData selection_data);
	[CCode (cheader_filename = "gedit/gedit-utils.h")]
	public static string utils_escape_search_text (string text);
	[CCode (cheader_filename = "gedit/gedit-utils.h")]
	public static string utils_escape_underscores (string text, ssize_t length);
	[CCode (cheader_filename = "gedit/gedit-utils.h")]
	public static Gedit.DocumentCompressionType utils_get_compression_type_from_content_type (string content_type);
	[CCode (cheader_filename = "gedit/gedit-utils.h")]
	public static void utils_get_current_viewport (Gdk.Screen screen, out int x, out int y);
	[CCode (cheader_filename = "gedit/gedit-utils.h")]
	public static uint utils_get_current_workspace (Gdk.Screen screen);
	[CCode (cheader_filename = "gedit/gedit-utils.h")]
	public static uint utils_get_window_workspace (Gtk.Window gtkwindow);
	[CCode (cheader_filename = "gedit/gedit-utils.h")]
	public static bool utils_is_valid_location (GLib.File location);
	[CCode (cheader_filename = "gedit/gedit-utils.h")]
	public static string utils_location_get_dirname_for_display (GLib.File location);
	[CCode (cheader_filename = "gedit/gedit-utils.h")]
	public static bool utils_location_has_file_scheme (GLib.File location);
	[CCode (cheader_filename = "gedit/gedit-utils.h")]
	public static string utils_make_canonical_uri_from_shell_arg (string str);
	[CCode (cheader_filename = "gedit/gedit-utils.h")]
	public static string utils_make_valid_utf8 (string name);
	[CCode (cheader_filename = "gedit/gedit-utils.h")]
	public static void utils_menu_position_under_tree_view (Gtk.Menu menu, int x, int y, bool push_in, void* user_data);
	[CCode (cheader_filename = "gedit/gedit-utils.h")]
	public static void utils_menu_position_under_widget (Gtk.Menu menu, int x, int y, bool push_in, void* user_data);
	[CCode (cheader_filename = "gedit/gedit-utils.h")]
	public static string utils_replace_home_dir_with_tilde (string uri);
	[CCode (cheader_filename = "gedit/gedit-utils.h")]
	public static void utils_set_atk_name_description (Gtk.Widget widget, string name, string description);
	[CCode (cheader_filename = "gedit/gedit-utils.h")]
	public static void utils_set_atk_relation (Gtk.Widget obj1, Gtk.Widget obj2, Atk.RelationType rel_type);
	[CCode (cheader_filename = "gedit/gedit-utils.h")]
	public static string utils_str_end_truncate (string string, uint truncate_length);
	[CCode (cheader_filename = "gedit/gedit-utils.h")]
	public static string utils_str_middle_truncate (string string, uint truncate_length);
	[CCode (cheader_filename = "gedit/gedit-utils.h")]
	public static string utils_unescape_search_text (string text);
	[CCode (cheader_filename = "gedit/gedit-utils.h")]
	public static string utils_uri_get_dirname (string uri);
}
