/* vbfsmartfolder.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from vbfsmartfolder.vala, do not modify */

/*
 *  vbfsmartfolder.vala - Vala Build Framework library
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <gio/gio.h>
#include <glib/gstdio.h>


#define VBF_TYPE_IPROJECT_BACKEND (vbf_iproject_backend_get_type ())
#define VBF_IPROJECT_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_IPROJECT_BACKEND, VbfIProjectBackend))
#define VBF_IS_IPROJECT_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_IPROJECT_BACKEND))
#define VBF_IPROJECT_BACKEND_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VBF_TYPE_IPROJECT_BACKEND, VbfIProjectBackendIface))

typedef struct _VbfIProjectBackend VbfIProjectBackend;
typedef struct _VbfIProjectBackendIface VbfIProjectBackendIface;

#define VBF_TYPE_CONFIG_NODE (vbf_config_node_get_type ())
#define VBF_CONFIG_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_CONFIG_NODE, VbfConfigNode))
#define VBF_CONFIG_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_CONFIG_NODE, VbfConfigNodeClass))
#define VBF_IS_CONFIG_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_CONFIG_NODE))
#define VBF_IS_CONFIG_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_CONFIG_NODE))
#define VBF_CONFIG_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_CONFIG_NODE, VbfConfigNodeClass))

typedef struct _VbfConfigNode VbfConfigNode;
typedef struct _VbfConfigNodeClass VbfConfigNodeClass;

#define VBF_TYPE_PROJECT (vbf_project_get_type ())
#define VBF_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_PROJECT, VbfProject))
#define VBF_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_PROJECT, VbfProjectClass))
#define VBF_IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_PROJECT))
#define VBF_IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_PROJECT))
#define VBF_PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_PROJECT, VbfProjectClass))

typedef struct _VbfProject VbfProject;
typedef struct _VbfProjectClass VbfProjectClass;

#define VBF_BACKENDS_TYPE_SMART_FOLDER (vbf_backends_smart_folder_get_type ())
#define VBF_BACKENDS_SMART_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_BACKENDS_TYPE_SMART_FOLDER, VbfBackendsSmartFolder))
#define VBF_BACKENDS_SMART_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_BACKENDS_TYPE_SMART_FOLDER, VbfBackendsSmartFolderClass))
#define VBF_BACKENDS_IS_SMART_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_BACKENDS_TYPE_SMART_FOLDER))
#define VBF_BACKENDS_IS_SMART_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_BACKENDS_TYPE_SMART_FOLDER))
#define VBF_BACKENDS_SMART_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_BACKENDS_TYPE_SMART_FOLDER, VbfBackendsSmartFolderClass))

typedef struct _VbfBackendsSmartFolder VbfBackendsSmartFolder;
typedef struct _VbfBackendsSmartFolderClass VbfBackendsSmartFolderClass;
typedef struct _VbfBackendsSmartFolderPrivate VbfBackendsSmartFolderPrivate;

#define VBF_BACKENDS_SMART_FOLDER_TYPE_PROJECT_SUB_TYPE (vbf_backends_smart_folder_project_sub_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _VbfConfigNodePrivate VbfConfigNodePrivate;
typedef struct _VbfProjectPrivate VbfProjectPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define VBF_TYPE_GROUP (vbf_group_get_type ())
#define VBF_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_GROUP, VbfGroup))
#define VBF_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_GROUP, VbfGroupClass))
#define VBF_IS_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_GROUP))
#define VBF_IS_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_GROUP))
#define VBF_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_GROUP, VbfGroupClass))

typedef struct _VbfGroup VbfGroup;
typedef struct _VbfGroupClass VbfGroupClass;
typedef struct _VbfGroupPrivate VbfGroupPrivate;

#define VBF_TYPE_TARGET_TYPES (vbf_target_types_get_type ())

#define VBF_TYPE_TARGET (vbf_target_get_type ())
#define VBF_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_TARGET, VbfTarget))
#define VBF_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_TARGET, VbfTargetClass))
#define VBF_IS_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_TARGET))
#define VBF_IS_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_TARGET))
#define VBF_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_TARGET, VbfTargetClass))

typedef struct _VbfTarget VbfTarget;
typedef struct _VbfTargetClass VbfTargetClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VBF_TYPE_PACKAGE (vbf_package_get_type ())
#define VBF_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_PACKAGE, VbfPackage))
#define VBF_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_PACKAGE, VbfPackageClass))
#define VBF_IS_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_PACKAGE))
#define VBF_IS_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_PACKAGE))
#define VBF_PACKAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_PACKAGE, VbfPackageClass))

typedef struct _VbfPackage VbfPackage;
typedef struct _VbfPackageClass VbfPackageClass;

#define VBF_TYPE_FILE (vbf_file_get_type ())
#define VBF_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_FILE, VbfFile))
#define VBF_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_FILE, VbfFileClass))
#define VBF_IS_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_FILE))
#define VBF_IS_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_FILE))
#define VBF_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_FILE, VbfFileClass))

typedef struct _VbfFile VbfFile;
typedef struct _VbfFileClass VbfFileClass;

#define VBF_TYPE_SOURCE (vbf_source_get_type ())
#define VBF_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_SOURCE, VbfSource))
#define VBF_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_SOURCE, VbfSourceClass))
#define VBF_IS_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_SOURCE))
#define VBF_IS_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_SOURCE))
#define VBF_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_SOURCE, VbfSourceClass))

typedef struct _VbfSource VbfSource;
typedef struct _VbfSourceClass VbfSourceClass;

#define VBF_TYPE_FILE_TYPES (vbf_file_types_get_type ())
typedef struct _VbfFilePrivate VbfFilePrivate;
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))

struct _VbfIProjectBackendIface {
	GTypeInterface parent_iface;
	gboolean (*probe) (VbfIProjectBackend* self, const gchar* project_file);
	VbfProject* (*open) (VbfIProjectBackend* self, const gchar* project_file);
	void (*refresh) (VbfIProjectBackend* self, VbfProject* project);
	gchar* (*get_configure_command) (VbfIProjectBackend* self);
	gchar* (*get_build_command) (VbfIProjectBackend* self);
	gchar* (*get_clean_command) (VbfIProjectBackend* self);
};

struct _VbfBackendsSmartFolder {
	GObject parent_instance;
	VbfBackendsSmartFolderPrivate * priv;
};

struct _VbfBackendsSmartFolderClass {
	GObjectClass parent_class;
};

typedef enum  {
	VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_UNKNOWN,
	VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_WAF,
	VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_CMAKE,
	VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_MAKE
} VbfBackendsSmartFolderProjectSubType;

struct _VbfBackendsSmartFolderPrivate {
	VbfProject* _project;
	gchar* _configure_command;
	gchar* _build_command;
	gchar* _clean_command;
	GRegex* _regex;
	GRegex* _regex_genie;
	ValaList* _file_mons;
	ValaList* _visited_directory;
	VbfBackendsSmartFolderProjectSubType _project_subtype;
};

struct _VbfConfigNode {
	GObject parent_instance;
	VbfConfigNodePrivate * priv;
	VbfConfigNode* parent;
};

struct _VbfConfigNodeClass {
	GObjectClass parent_class;
	gchar* (*to_string) (VbfConfigNode* self);
};

struct _VbfProject {
	VbfConfigNode parent_instance;
	VbfProjectPrivate * priv;
	gchar* id;
	gchar* name;
	gchar* url;
	gchar* version;
	gchar* working_dir;
	VbfIProjectBackend* backend;
};

struct _VbfProjectClass {
	VbfConfigNodeClass parent_class;
};

struct _VbfGroup {
	GObject parent_instance;
	VbfGroupPrivate * priv;
	gchar* name;
	gchar* id;
	VbfProject* project;
};

struct _VbfGroupClass {
	GObjectClass parent_class;
};

typedef enum  {
	VBF_TARGET_TYPES_PROGRAM,
	VBF_TARGET_TYPES_LIBRARY,
	VBF_TARGET_TYPES_DATA,
	VBF_TARGET_TYPES_BUILT_SOURCES
} VbfTargetTypes;

typedef enum  {
	VBF_FILE_TYPES_UNKNOWN,
	VBF_FILE_TYPES_DATA,
	VBF_FILE_TYPES_VALA_SOURCE,
	VBF_FILE_TYPES_OTHER_SOURCE
} VbfFileTypes;

struct _VbfFile {
	GObject parent_instance;
	VbfFilePrivate * priv;
	gchar* name;
	gchar* filename;
	gchar* uri;
	VbfFileTypes type;
	VbfTarget* target;
};

struct _VbfFileClass {
	GObjectClass parent_class;
};


static gpointer vbf_backends_smart_folder_parent_class = NULL;
static VbfIProjectBackendIface* vbf_backends_smart_folder_vbf_iproject_backend_parent_iface = NULL;

GType vbf_config_node_get_type (void) G_GNUC_CONST;
GType vbf_project_get_type (void) G_GNUC_CONST;
GType vbf_iproject_backend_get_type (void) G_GNUC_CONST;
GType vbf_backends_smart_folder_get_type (void) G_GNUC_CONST;
static GType vbf_backends_smart_folder_project_sub_type_get_type (void) G_GNUC_UNUSED;
#define VBF_BACKENDS_SMART_FOLDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VBF_BACKENDS_TYPE_SMART_FOLDER, VbfBackendsSmartFolderPrivate))
enum  {
	VBF_BACKENDS_SMART_FOLDER_DUMMY_PROPERTY,
	VBF_BACKENDS_SMART_FOLDER_CONFIGURE_COMMAND,
	VBF_BACKENDS_SMART_FOLDER_BUILD_COMMAND,
	VBF_BACKENDS_SMART_FOLDER_CLEAN_COMMAND
};
static gboolean vbf_backends_smart_folder_real_probe (VbfIProjectBackend* base, const gchar* project_file);
gboolean vbf_utils_is_waf_project (const gchar* path);
gboolean vbf_utils_is_cmake_project (const gchar* path);
gboolean vbf_utils_is_simple_make_project (const gchar* path);
static VbfProject* vbf_backends_smart_folder_real_open (VbfIProjectBackend* base, const gchar* project_file);
VbfProject* vbf_project_new (const gchar* id);
VbfProject* vbf_project_construct (GType object_type, const gchar* id);
void vbf_iproject_backend_refresh (VbfIProjectBackend* self, VbfProject* project);
static void vbf_backends_smart_folder_cleanup_file_monitors (VbfBackendsSmartFolder* self);
static void vbf_backends_smart_folder_on_project_directory_changed (VbfBackendsSmartFolder* self, GFileMonitor* sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type);
static void _vbf_backends_smart_folder_on_project_directory_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static void vbf_backends_smart_folder_real_refresh (VbfIProjectBackend* base, VbfProject* project);
void vbf_project_clear (VbfProject* self);
VbfGroup* vbf_group_new (VbfProject* project, const gchar* id);
VbfGroup* vbf_group_construct (GType object_type, VbfProject* project, const gchar* id);
GType vbf_group_get_type (void) G_GNUC_CONST;
GType vbf_target_types_get_type (void) G_GNUC_CONST;
VbfTarget* vbf_target_new (VbfGroup* group, VbfTargetTypes type, const gchar* id, const gchar* name);
VbfTarget* vbf_target_construct (GType object_type, VbfGroup* group, VbfTargetTypes type, const gchar* id, const gchar* name);
GType vbf_target_get_type (void) G_GNUC_CONST;
void vbf_group_add_target (VbfGroup* self, VbfTarget* target);
void vbf_project_add_group (VbfProject* self, VbfGroup* group);
void vbf_utils_trace (const gchar* format, ...);
static void vbf_backends_smart_folder_scan_directory (VbfBackendsSmartFolder* self, const gchar* directory, VbfProject* project, const gchar* build_filename, GError** error);
void vbf_backends_smart_folder_setup_file_monitors (VbfBackendsSmartFolder* self, VbfProject* project);
VbfGroup* vbf_project_get_group (VbfProject* self, const gchar* id);
VbfTarget* vbf_group_get_target_for_id (VbfGroup* self, const gchar* id);
static void vbf_backends_smart_folder_add_vala_source (VbfBackendsSmartFolder* self, VbfTarget* target, const gchar* directory, GFileInfo* file_info);
static void vbf_backends_smart_folder_add_vapi_source (VbfBackendsSmartFolder* self, VbfTarget* target, const gchar* directory, GFileInfo* file_info);
static void vbf_backends_smart_folder_parse_build_file_infos (VbfBackendsSmartFolder* self, VbfTarget* target, const gchar* filename);
static void vbf_backends_smart_folder_parse_cmake_build_file (VbfBackendsSmartFolder* self, VbfTarget* target, const gchar* filename);
static void vbf_backends_smart_folder_parse_waf_build_file (VbfBackendsSmartFolder* self, VbfTarget* target, const gchar* filename);
static gchar* vbf_backends_smart_folder_get_token (VbfBackendsSmartFolder* self, const gchar* content, gint* start_position);
static gint vbf_backends_smart_folder_skip_line (VbfBackendsSmartFolder* self, const gchar* content, gint start_position);
gboolean vbf_target_contains_package (VbfTarget* self, const gchar* package_id);
GType vbf_package_get_type (void) G_GNUC_CONST;
void vbf_target_add_package (VbfTarget* self, VbfPackage* package);
VbfPackage* vbf_package_new (const gchar* id);
VbfPackage* vbf_package_construct (GType object_type, const gchar* id);
static gboolean vbf_backends_smart_folder_expect_token (VbfBackendsSmartFolder* self, const gchar* token, const gchar* content, gint* start_position);
static gint vbf_backends_smart_folder_skip_spaces (VbfBackendsSmartFolder* self, const gchar* content, gint start_position);
static gboolean vbf_backends_smart_folder_eof (VbfBackendsSmartFolder* self, const gchar* content, gint position);
VbfSource* vbf_source_new (VbfTarget* target, const gchar* filename);
VbfSource* vbf_source_construct (GType object_type, VbfTarget* target, const gchar* filename);
GType vbf_file_get_type (void) G_GNUC_CONST;
GType vbf_source_get_type (void) G_GNUC_CONST;
GType vbf_file_types_get_type (void) G_GNUC_CONST;
void vbf_target_add_source (VbfTarget* self, VbfSource* source);
gchar* vbf_utils_guess_package_vapi (const gchar* using_name, gchar** vapi_dirs, int vapi_dirs_length1);
gboolean vbf_target_contains_include_dir (VbfTarget* self, const gchar* dir);
void vbf_target_add_include_dir (VbfTarget* self, const gchar* dir);
gboolean vbf_utils_is_vala_source (const gchar* filename);
void vbf_project_update (VbfProject* self);
VbfBackendsSmartFolder* vbf_backends_smart_folder_new (void);
VbfBackendsSmartFolder* vbf_backends_smart_folder_construct (GType object_type);
static void vbf_backends_smart_folder_finalize (GObject* obj);
gchar* vbf_iproject_backend_get_configure_command (VbfIProjectBackend* self);
gchar* vbf_iproject_backend_get_build_command (VbfIProjectBackend* self);
gchar* vbf_iproject_backend_get_clean_command (VbfIProjectBackend* self);
static void _vala_vbf_backends_smart_folder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static GType vbf_backends_smart_folder_project_sub_type_get_type (void) {
	static volatile gsize vbf_backends_smart_folder_project_sub_type_type_id__volatile = 0;
	if (g_once_init_enter (&vbf_backends_smart_folder_project_sub_type_type_id__volatile)) {
		static const GEnumValue values[] = {{VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_UNKNOWN, "VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_UNKNOWN", "unknown"}, {VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_WAF, "VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_WAF", "waf"}, {VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_CMAKE, "VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_CMAKE", "cmake"}, {VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_MAKE, "VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_MAKE", "make"}, {0, NULL, NULL}};
		GType vbf_backends_smart_folder_project_sub_type_type_id;
		vbf_backends_smart_folder_project_sub_type_type_id = g_enum_register_static ("VbfBackendsSmartFolderProjectSubType", values);
		g_once_init_leave (&vbf_backends_smart_folder_project_sub_type_type_id__volatile, vbf_backends_smart_folder_project_sub_type_type_id);
	}
	return vbf_backends_smart_folder_project_sub_type_type_id__volatile;
}


static gboolean vbf_backends_smart_folder_real_probe (VbfIProjectBackend* base, const gchar* project_file) {
	VbfBackendsSmartFolder * self;
	gboolean result = FALSE;
	gboolean res;
	gboolean _tmp0_;
	self = (VbfBackendsSmartFolder*) base;
	g_return_val_if_fail (project_file != NULL, FALSE);
	res = FALSE;
	_tmp0_ = g_file_test (project_file, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_DIR);
	if (_tmp0_) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		_tmp3_ = vbf_utils_is_waf_project (project_file);
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			gboolean _tmp4_;
			_tmp4_ = vbf_utils_is_cmake_project (project_file);
			_tmp2_ = _tmp4_;
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp5_;
			_tmp5_ = vbf_utils_is_simple_make_project (project_file);
			_tmp1_ = _tmp5_;
		}
		res = _tmp1_;
	}
	result = res;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static VbfProject* vbf_backends_smart_folder_real_open (VbfIProjectBackend* base, const gchar* project_file) {
	VbfBackendsSmartFolder * self;
	VbfProject* result = NULL;
	VbfProject* _tmp0_ = NULL;
	VbfProject* project;
	VbfIProjectBackend* _tmp1_;
	self = (VbfBackendsSmartFolder*) base;
	g_return_val_if_fail (project_file != NULL, NULL);
	self->priv->_project = NULL;
	_g_free0 (self->priv->_configure_command);
	self->priv->_configure_command = NULL;
	_g_free0 (self->priv->_build_command);
	self->priv->_build_command = NULL;
	_g_free0 (self->priv->_clean_command);
	self->priv->_clean_command = NULL;
	_tmp0_ = vbf_project_new (project_file);
	project = _tmp0_;
	_tmp1_ = _g_object_ref0 ((VbfIProjectBackend*) self);
	_g_object_unref0 (project->backend);
	project->backend = _tmp1_;
	vbf_iproject_backend_refresh ((VbfIProjectBackend*) self, project);
	if (project->name == NULL) {
		result = NULL;
		_g_object_unref0 (project);
		return result;
	} else {
		self->priv->_project = project;
		result = project;
		return result;
	}
	_g_object_unref0 (project);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static void _vbf_backends_smart_folder_on_project_directory_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	vbf_backends_smart_folder_on_project_directory_changed (self, _sender, file, other_file, event_type);
}


static void vbf_backends_smart_folder_cleanup_file_monitors (VbfBackendsSmartFolder* self) {
	g_return_if_fail (self != NULL);
	{
		ValaList* _tmp0_;
		ValaList* _file_mon_list;
		gint _tmp1_;
		gint _file_mon_size;
		gint _file_mon_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->_file_mons);
		_file_mon_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _file_mon_list);
		_file_mon_size = _tmp1_;
		_file_mon_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			GFileMonitor* file_mon;
			guint _tmp3_;
			_file_mon_index = _file_mon_index + 1;
			if (!(_file_mon_index < _file_mon_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_file_mon_list, _file_mon_index);
			file_mon = (GFileMonitor*) _tmp2_;
			g_signal_parse_name ("changed", G_TYPE_FILE_MONITOR, &_tmp3_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (file_mon, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _vbf_backends_smart_folder_on_project_directory_changed_g_file_monitor_changed, self);
			g_file_monitor_cancel (file_mon);
			_g_object_unref0 (file_mon);
		}
		_vala_iterable_unref0 (_file_mon_list);
	}
	vala_collection_clear ((ValaCollection*) self->priv->_file_mons);
}


static void vbf_backends_smart_folder_real_refresh (VbfIProjectBackend* base, VbfProject* project) {
	VbfBackendsSmartFolder * self;
	gchar* build_filename;
	gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	VbfGroup* _tmp5_ = NULL;
	VbfGroup* group;
	gchar* _tmp6_;
	VbfTarget* _tmp7_ = NULL;
	VbfTarget* target;
	gboolean _tmp8_;
	GRegex* _tmp22_ = NULL;
	GRegex* _tmp23_;
	GRegex* _tmp24_ = NULL;
	GRegex* _tmp25_;
	ValaArrayList* _tmp26_ = NULL;
	GError * _inner_error_ = NULL;
	self = (VbfBackendsSmartFolder*) base;
	g_return_if_fail (project != NULL);
	vbf_backends_smart_folder_cleanup_file_monitors (self);
	build_filename = NULL;
	vbf_project_clear (project);
	_tmp0_ = g_strdup (project->id);
	_g_free0 (project->working_dir);
	project->working_dir = _tmp0_;
	_tmp1_ = g_file_new_for_path (project->id);
	file = _tmp1_;
	_tmp2_ = g_file_get_basename (file);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_filename_display_basename (_tmp3_);
	_g_free0 (project->name);
	project->name = _tmp4_;
	_g_free0 (_tmp3_);
	_tmp5_ = vbf_group_new (project, project->id);
	group = _tmp5_;
	_tmp6_ = g_strdup (project->name);
	_g_free0 (group->name);
	group->name = _tmp6_;
	_tmp7_ = vbf_target_new (group, VBF_TARGET_TYPES_PROGRAM, project->id, project->name);
	target = _tmp7_;
	vbf_group_add_target (group, target);
	vbf_project_add_group (project, group);
	_tmp8_ = vbf_utils_is_waf_project (project->id);
	if (_tmp8_) {
		gchar* _tmp9_ = NULL;
		gchar* waf_command;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		_tmp9_ = g_build_filename (project->id, "waf", NULL);
		waf_command = _tmp9_;
		vbf_utils_trace ("vbfsmartfolder.vala:125: waf command is %s", waf_command);
		_tmp10_ = g_strdup_printf ("%s configure", waf_command);
		_g_free0 (self->priv->_configure_command);
		self->priv->_configure_command = _tmp10_;
		_tmp11_ = g_strdup_printf ("%s build", waf_command);
		_g_free0 (self->priv->_build_command);
		self->priv->_build_command = _tmp11_;
		_tmp12_ = g_strdup_printf ("%s clean", waf_command);
		_g_free0 (self->priv->_clean_command);
		self->priv->_clean_command = _tmp12_;
		self->priv->_project_subtype = VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_WAF;
		_tmp13_ = g_strdup ("wscript");
		_g_free0 (build_filename);
		build_filename = _tmp13_;
		_g_free0 (waf_command);
	} else {
		gboolean _tmp14_;
		_tmp14_ = vbf_utils_is_cmake_project (project->id);
		if (_tmp14_) {
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp15_ = g_strdup ("cmake");
			_g_free0 (self->priv->_configure_command);
			self->priv->_configure_command = _tmp15_;
			_tmp16_ = g_strdup ("make");
			_g_free0 (self->priv->_build_command);
			self->priv->_build_command = _tmp16_;
			_tmp17_ = g_strdup ("make clean");
			_g_free0 (self->priv->_clean_command);
			self->priv->_clean_command = _tmp17_;
			self->priv->_project_subtype = VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_CMAKE;
			_tmp18_ = g_strdup ("CMakeLists.txt");
			_g_free0 (build_filename);
			build_filename = _tmp18_;
		} else {
			gboolean _tmp19_;
			_tmp19_ = vbf_utils_is_simple_make_project (project->id);
			if (_tmp19_) {
				gchar* _tmp20_;
				gchar* _tmp21_;
				_tmp20_ = g_strdup ("make");
				_g_free0 (self->priv->_build_command);
				self->priv->_build_command = _tmp20_;
				_tmp21_ = g_strdup ("make clean");
				_g_free0 (self->priv->_clean_command);
				self->priv->_clean_command = _tmp21_;
				self->priv->_project_subtype = VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_MAKE;
			} else {
				self->priv->_project_subtype = VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_UNKNOWN;
			}
		}
	}
	_tmp22_ = g_regex_new ("^\\s*(using)\\s+(\\w\\S*)\\s*;.*$", G_REGEX_MULTILINE, 0, &_inner_error_);
	_tmp23_ = _tmp22_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (target);
		_g_object_unref0 (group);
		_g_object_unref0 (file);
		_g_free0 (build_filename);
		goto __catch9_g_error;
	}
	_g_regex_unref0 (self->priv->_regex);
	self->priv->_regex = _tmp23_;
	_tmp24_ = g_regex_new ("^(uses|\\t+|\\s+)(\\w\\S*)\\s*\\n", G_REGEX_MULTILINE, 0, &_inner_error_);
	_tmp25_ = _tmp24_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (target);
		_g_object_unref0 (group);
		_g_object_unref0 (file);
		_g_free0 (build_filename);
		goto __catch9_g_error;
	}
	_g_regex_unref0 (self->priv->_regex_genie);
	self->priv->_regex_genie = _tmp25_;
	_tmp26_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	_vala_iterable_unref0 (self->priv->_visited_directory);
	self->priv->_visited_directory = (ValaList*) _tmp26_;
	vbf_backends_smart_folder_scan_directory (self, project->id, project, build_filename, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (target);
		_g_object_unref0 (group);
		_g_object_unref0 (file);
		_g_free0 (build_filename);
		goto __catch9_g_error;
	}
	if (project->name != NULL) {
		vbf_backends_smart_folder_setup_file_monitors (self, project);
	}
	_g_regex_unref0 (self->priv->_regex);
	self->priv->_regex = NULL;
	_g_regex_unref0 (self->priv->_regex_genie);
	self->priv->_regex_genie = NULL;
	vala_collection_clear ((ValaCollection*) self->priv->_visited_directory);
	_vala_iterable_unref0 (self->priv->_visited_directory);
	self->priv->_visited_directory = NULL;
	_g_object_unref0 (target);
	_g_object_unref0 (group);
	_g_object_unref0 (file);
	_g_free0 (build_filename);
	goto __finally9;
	__catch9_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("vbfsmartfolder.vala:158: open: %s", err->message);
		_g_error_free0 (err);
		return;
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void vbf_backends_smart_folder_scan_directory (VbfBackendsSmartFolder* self, const gchar* directory, VbfProject* project, const gchar* build_filename, GError** error) {
	GFile* _tmp0_ = NULL;
	GFile* dir;
	GFileEnumerator* _tmp1_ = NULL;
	GFileEnumerator* enm;
	GFileInfo* file_info = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (directory != NULL);
	g_return_if_fail (project != NULL);
	vala_collection_add ((ValaCollection*) self->priv->_visited_directory, directory);
	_tmp0_ = g_file_new_for_path (directory);
	dir = _tmp0_;
	_tmp1_ = g_file_enumerate_children (dir, "standard::*", 0, NULL, &_inner_error_);
	enm = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (dir);
		return;
	}
	while (TRUE) {
		GFileInfo* _tmp2_ = NULL;
		GFileInfo* _tmp3_;
		GFileType _tmp4_;
		_tmp2_ = g_file_enumerator_next_file (enm, NULL, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (file_info);
			_g_object_unref0 (enm);
			_g_object_unref0 (dir);
			return;
		}
		_g_object_unref0 (file_info);
		file_info = _tmp3_;
		if (!(file_info != NULL)) {
			break;
		}
		_tmp4_ = g_file_info_get_file_type (file_info);
		if (_tmp4_ == G_FILE_TYPE_DIRECTORY) {
			gboolean _tmp5_ = FALSE;
			const gchar* _tmp6_ = NULL;
			gboolean _tmp7_;
			_tmp6_ = g_file_info_get_name (file_info);
			_tmp7_ = g_str_has_prefix (_tmp6_, ".");
			if (!_tmp7_) {
				const gchar* _tmp8_ = NULL;
				gboolean _tmp9_;
				_tmp8_ = g_file_info_get_name (file_info);
				_tmp9_ = g_str_has_prefix (_tmp8_, "_");
				_tmp5_ = !_tmp9_;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				const gchar* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				_tmp10_ = g_file_info_get_name (file_info);
				_tmp11_ = g_build_filename (directory, _tmp10_, NULL);
				_tmp12_ = _tmp11_;
				vbf_backends_smart_folder_scan_directory (self, _tmp12_, project, build_filename, &_inner_error_);
				_g_free0 (_tmp12_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (file_info);
					_g_object_unref0 (enm);
					_g_object_unref0 (dir);
					return;
				}
			}
		} else {
			VbfTarget* target = NULL;
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			gchar* name;
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_;
			_tmp13_ = g_file_info_get_display_name (file_info);
			_tmp14_ = g_strdup (_tmp13_);
			name = _tmp14_;
			_tmp16_ = g_str_has_suffix (name, ".vala");
			if (_tmp16_) {
				_tmp15_ = TRUE;
			} else {
				gboolean _tmp17_;
				_tmp17_ = g_str_has_suffix (name, ".gs");
				_tmp15_ = _tmp17_;
			}
			if (_tmp15_) {
				VbfGroup* _tmp18_ = NULL;
				VbfGroup* _tmp19_;
				VbfTarget* _tmp20_ = NULL;
				_tmp18_ = vbf_project_get_group (project, project->id);
				_tmp19_ = _tmp18_;
				_tmp20_ = vbf_group_get_target_for_id (_tmp19_, project->id);
				_g_object_unref0 (target);
				target = _tmp20_;
				_g_object_unref0 (_tmp19_);
				vbf_backends_smart_folder_add_vala_source (self, target, directory, file_info);
			} else {
				gboolean _tmp21_;
				_tmp21_ = g_str_has_suffix (name, ".vapi");
				if (_tmp21_) {
					VbfGroup* _tmp22_ = NULL;
					VbfGroup* _tmp23_;
					VbfTarget* _tmp24_ = NULL;
					_tmp22_ = vbf_project_get_group (project, project->id);
					_tmp23_ = _tmp22_;
					_tmp24_ = vbf_group_get_target_for_id (_tmp23_, project->id);
					_g_object_unref0 (target);
					target = _tmp24_;
					_g_object_unref0 (_tmp23_);
					vbf_backends_smart_folder_add_vapi_source (self, target, directory, file_info);
				} else {
					gboolean _tmp25_ = FALSE;
					if (build_filename != NULL) {
						_tmp25_ = g_strcmp0 (name, build_filename) == 0;
					} else {
						_tmp25_ = FALSE;
					}
					if (_tmp25_) {
						VbfGroup* _tmp26_ = NULL;
						VbfGroup* _tmp27_;
						VbfTarget* _tmp28_ = NULL;
						const gchar* _tmp29_ = NULL;
						gchar* _tmp30_ = NULL;
						gchar* _tmp31_;
						_tmp26_ = vbf_project_get_group (project, project->id);
						_tmp27_ = _tmp26_;
						_tmp28_ = vbf_group_get_target_for_id (_tmp27_, project->id);
						_g_object_unref0 (target);
						target = _tmp28_;
						_g_object_unref0 (_tmp27_);
						_tmp29_ = g_file_info_get_name (file_info);
						_tmp30_ = g_build_filename (directory, _tmp29_, NULL);
						_tmp31_ = _tmp30_;
						vbf_backends_smart_folder_parse_build_file_infos (self, target, _tmp31_);
						_g_free0 (_tmp31_);
					}
				}
			}
			_g_free0 (name);
			_g_object_unref0 (target);
		}
	}
	_g_object_unref0 (file_info);
	_g_object_unref0 (enm);
	_g_object_unref0 (dir);
}


static void vbf_backends_smart_folder_parse_build_file_infos (VbfBackendsSmartFolder* self, VbfTarget* target, const gchar* filename) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	g_return_if_fail (filename != NULL);
	switch (self->priv->_project_subtype) {
		case VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_CMAKE:
		{
			vbf_backends_smart_folder_parse_cmake_build_file (self, target, filename);
			break;
		}
		case VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_WAF:
		{
			vbf_backends_smart_folder_parse_waf_build_file (self, target, filename);
			break;
		}
		default:
		case VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_MAKE:
		{
			break;
		}
	}
}


static void vbf_backends_smart_folder_parse_cmake_build_file (VbfBackendsSmartFolder* self, VbfTarget* target, const gchar* filename) {
	gchar* content;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	g_return_if_fail (filename != NULL);
	vbf_utils_trace ("vbfsmartfolder.vala:210: parsing cmake build file: %s", filename);
	content = NULL;
	_tmp2_ = g_file_get_contents (filename, &_tmp1_, NULL, &_inner_error_);
	_g_free0 (content);
	content = _tmp1_;
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		_g_free0 (content);
		goto __catch10_g_error;
	}
	if (_tmp3_) {
		_tmp0_ = content != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint start_position;
		gchar* token = NULL;
		gboolean in_precompile;
		gboolean in_package;
		gint par_level;
		start_position = 0;
		in_precompile = FALSE;
		in_package = FALSE;
		par_level = 0;
		while (TRUE) {
			gchar* _tmp4_ = NULL;
			gboolean _tmp5_;
			_tmp4_ = vbf_backends_smart_folder_get_token (self, content, &start_position);
			_g_free0 (token);
			token = _tmp4_;
			if (!(token != NULL)) {
				break;
			}
			_tmp5_ = g_str_has_prefix (token, "#");
			if (_tmp5_) {
				gint _tmp6_;
				_tmp6_ = vbf_backends_smart_folder_skip_line (self, content, start_position);
				start_position = _tmp6_;
			} else {
				if (in_package) {
					gboolean _tmp7_ = FALSE;
					gboolean _tmp8_ = FALSE;
					gboolean _tmp9_ = FALSE;
					gint _tmp10_;
					_tmp10_ = strlen (token);
					if (_tmp10_ > 1) {
						_tmp9_ = g_strcmp0 (token, "OPTIONS") == 0;
					} else {
						_tmp9_ = FALSE;
					}
					if (_tmp9_) {
						_tmp8_ = TRUE;
					} else {
						_tmp8_ = g_strcmp0 (token, "CUSTOM_VAPIS") == 0;
					}
					if (_tmp8_) {
						_tmp7_ = TRUE;
					} else {
						gchar* _tmp11_ = NULL;
						gchar* _tmp12_;
						_tmp11_ = g_utf8_strup (token, (gssize) (-1));
						_tmp12_ = _tmp11_;
						_tmp7_ = g_strcmp0 (_tmp12_, token) == 0;
						_g_free0 (_tmp12_);
					}
					if (_tmp7_) {
						in_package = FALSE;
						break;
					} else {
						gboolean _tmp13_;
						vbf_utils_trace ("vbfsmartfolder.vala:227: cmake backend adding package: %s", token);
						_tmp13_ = vbf_target_contains_package (target, token);
						if (!_tmp13_) {
							VbfPackage* _tmp14_ = NULL;
							VbfPackage* _tmp15_;
							_tmp14_ = vbf_package_new (token);
							_tmp15_ = _tmp14_;
							vbf_target_add_package (target, _tmp15_);
							_g_object_unref0 (_tmp15_);
						}
					}
				} else {
					if (in_precompile) {
						if (g_strcmp0 (token, "(") == 0) {
							par_level++;
						} else {
							if (g_strcmp0 (token, ")") == 0) {
								if (par_level == 0) {
									in_precompile = FALSE;
									break;
								} else {
									par_level--;
								}
							} else {
								if (g_strcmp0 (token, "PACKAGES") == 0) {
									in_package = TRUE;
								}
							}
						}
					} else {
						if (g_strcmp0 (token, "vala_precompile") == 0) {
							gboolean _tmp16_;
							_tmp16_ = vbf_backends_smart_folder_expect_token (self, "(", content, &start_position);
							in_precompile = _tmp16_;
						}
					}
				}
			}
		}
		_g_free0 (token);
	}
	_g_free0 (content);
	goto __finally10;
	__catch10_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("vbfsmartfolder.vala:254: Error parsing cmake build file '%s': %s", filename, err->message);
		_g_error_free0 (err);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void vbf_backends_smart_folder_parse_waf_build_file (VbfBackendsSmartFolder* self, VbfTarget* target, const gchar* filename) {
	gchar* content;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	g_return_if_fail (filename != NULL);
	vbf_utils_trace ("vbfsmartfolder.vala:261: parsing waf build file: %s", filename);
	content = NULL;
	_tmp2_ = g_file_get_contents (filename, &_tmp1_, NULL, &_inner_error_);
	_g_free0 (content);
	content = _tmp1_;
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		_g_free0 (content);
		goto __catch11_g_error;
	}
	if (_tmp3_) {
		_tmp0_ = content != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint start_position;
		gchar* token = NULL;
		gboolean in_build;
		gboolean in_package;
		gint par_level;
		start_position = 0;
		in_build = FALSE;
		in_package = FALSE;
		par_level = 0;
		while (TRUE) {
			gchar* _tmp4_ = NULL;
			gboolean _tmp5_;
			_tmp4_ = vbf_backends_smart_folder_get_token (self, content, &start_position);
			_g_free0 (token);
			token = _tmp4_;
			if (!(token != NULL)) {
				break;
			}
			_tmp5_ = g_str_has_prefix (token, "#");
			if (_tmp5_) {
				gint _tmp6_;
				_tmp6_ = vbf_backends_smart_folder_skip_line (self, content, start_position);
				start_position = _tmp6_;
			} else {
				if (in_package) {
					gboolean _tmp7_ = FALSE;
					gint _tmp8_;
					_tmp8_ = strlen (token);
					if (_tmp8_ == 1) {
						gboolean _tmp9_ = FALSE;
						if (g_strcmp0 (token, "\"") == 0) {
							_tmp9_ = TRUE;
						} else {
							_tmp9_ = g_strcmp0 (token, "'") == 0;
						}
						_tmp7_ = _tmp9_;
					} else {
						_tmp7_ = FALSE;
					}
					if (_tmp7_) {
						in_package = FALSE;
						break;
					} else {
						gboolean _tmp10_;
						vbf_utils_trace ("vbfsmartfolder.vala:278: waf backend adding package: %s", token);
						_tmp10_ = vbf_target_contains_package (target, token);
						if (!_tmp10_) {
							VbfPackage* _tmp11_ = NULL;
							VbfPackage* _tmp12_;
							_tmp11_ = vbf_package_new (token);
							_tmp12_ = _tmp11_;
							vbf_target_add_package (target, _tmp12_);
							_g_object_unref0 (_tmp12_);
						}
					}
				} else {
					if (in_build) {
						if (g_strcmp0 (token, "(") == 0) {
							par_level++;
						} else {
							if (g_strcmp0 (token, ")") == 0) {
								if (par_level == 0) {
									in_build = FALSE;
									break;
								} else {
									par_level--;
								}
							} else {
								if (g_strcmp0 (token, "prog.packages") == 0) {
									gboolean _tmp13_;
									gchar* _tmp14_ = NULL;
									gchar* _tmp15_;
									_tmp13_ = vbf_backends_smart_folder_expect_token (self, "=", content, &start_position);
									in_package = _tmp13_;
									_tmp14_ = vbf_backends_smart_folder_get_token (self, content, &start_position);
									_tmp15_ = _tmp14_;
									_g_free0 (_tmp15_);
								}
							}
						}
					} else {
						if (g_strcmp0 (token, "def") == 0) {
							gboolean _tmp16_;
							gint _tmp17_;
							_tmp16_ = vbf_backends_smart_folder_expect_token (self, "build", content, &start_position);
							in_build = _tmp16_;
							_tmp17_ = vbf_backends_smart_folder_skip_line (self, content, start_position);
							start_position = _tmp17_;
						}
					}
				}
			}
		}
		_g_free0 (token);
	}
	_g_free0 (content);
	goto __finally11;
	__catch11_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("vbfsmartfolder.vala:308: Error parsing waf wscript file '%s': %s", filename, err->message);
		_g_error_free0 (err);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gboolean vbf_backends_smart_folder_expect_token (VbfBackendsSmartFolder* self, const gchar* token, const gchar* content, gint* start_position) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* tmp;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (token != NULL, FALSE);
	g_return_val_if_fail (content != NULL, FALSE);
	_tmp0_ = vbf_backends_smart_folder_get_token (self, content, start_position);
	tmp = _tmp0_;
	result = g_strcmp0 (token, tmp) == 0;
	_g_free0 (tmp);
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}


static gchar* vbf_backends_smart_folder_get_token (VbfBackendsSmartFolder* self, const gchar* content, gint* start_position) {
	gchar* result = NULL;
	gchar* token;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (content != NULL, NULL);
	token = NULL;
	_tmp0_ = vbf_backends_smart_folder_skip_spaces (self, content, *start_position);
	*start_position = _tmp0_;
	while (TRUE) {
		gboolean _tmp1_;
		gchar _tmp2_;
		gunichar ch;
		_tmp1_ = vbf_backends_smart_folder_eof (self, content, *start_position);
		if (!(!_tmp1_)) {
			break;
		}
		_tmp2_ = string_get (content, (glong) (*start_position));
		ch = (gunichar) _tmp2_;
		if (token == NULL) {
			gboolean _tmp3_ = FALSE;
			gboolean _tmp4_ = FALSE;
			if (ch != '_') {
				_tmp4_ = ch != '$';
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				gboolean _tmp5_;
				_tmp5_ = g_unichar_isalnum (ch);
				_tmp3_ = _tmp5_ == FALSE;
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				gchar* _tmp6_ = NULL;
				_tmp6_ = g_unichar_to_string (ch);
				_g_free0 (token);
				token = _tmp6_;
				(*start_position)++;
				break;
			} else {
				gchar* _tmp7_ = NULL;
				_tmp7_ = g_unichar_to_string (ch);
				_g_free0 (token);
				token = _tmp7_;
			}
		} else {
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_ = FALSE;
			if (ch == ' ') {
				_tmp16_ = TRUE;
			} else {
				_tmp16_ = ch == '\t';
			}
			if (_tmp16_) {
				_tmp15_ = TRUE;
			} else {
				_tmp15_ = ch == '\n';
			}
			if (_tmp15_) {
				_tmp14_ = TRUE;
			} else {
				_tmp14_ = ch == '\r';
			}
			if (_tmp14_) {
				_tmp13_ = TRUE;
			} else {
				_tmp13_ = ch == ')';
			}
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				_tmp12_ = ch == '}';
			}
			if (_tmp12_) {
				_tmp11_ = TRUE;
			} else {
				_tmp11_ = ch == '\'';
			}
			if (_tmp11_) {
				_tmp10_ = TRUE;
			} else {
				_tmp10_ = ch == '\"';
			}
			if (_tmp10_) {
				_tmp9_ = TRUE;
			} else {
				gboolean _tmp17_ = FALSE;
				if (ch == '(') {
					gint _tmp18_;
					gchar _tmp19_;
					_tmp18_ = strlen (token);
					_tmp19_ = string_get (token, (glong) (_tmp18_ - 1));
					_tmp17_ = _tmp19_ != '$';
				} else {
					_tmp17_ = FALSE;
				}
				_tmp9_ = _tmp17_;
			}
			if (_tmp9_) {
				_tmp8_ = TRUE;
			} else {
				gboolean _tmp20_ = FALSE;
				if (ch == '{') {
					gint _tmp21_;
					gchar _tmp22_;
					_tmp21_ = strlen (token);
					_tmp22_ = string_get (token, (glong) (_tmp21_ - 1));
					_tmp20_ = _tmp22_ != '$';
				} else {
					_tmp20_ = FALSE;
				}
				_tmp8_ = _tmp20_;
			}
			if (_tmp8_) {
				break;
			} else {
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_;
				gchar* _tmp25_;
				_tmp23_ = g_unichar_to_string (ch);
				_tmp24_ = _tmp23_;
				_tmp25_ = g_strconcat (token, _tmp24_, NULL);
				_g_free0 (token);
				token = _tmp25_;
				_g_free0 (_tmp24_);
			}
		}
		(*start_position)++;
	}
	result = token;
	return result;
}


static gint vbf_backends_smart_folder_skip_line (VbfBackendsSmartFolder* self, const gchar* content, gint start_position) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (content != NULL, 0);
	while (TRUE) {
		gboolean _tmp0_;
		gchar _tmp1_;
		gunichar ch;
		_tmp0_ = vbf_backends_smart_folder_eof (self, content, start_position);
		if (!(!_tmp0_)) {
			break;
		}
		_tmp1_ = string_get (content, (glong) start_position);
		ch = (gunichar) _tmp1_;
		if (ch != '\n') {
			start_position++;
		} else {
			break;
		}
	}
	result = start_position;
	return result;
}


static gint vbf_backends_smart_folder_skip_spaces (VbfBackendsSmartFolder* self, const gchar* content, gint start_position) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (content != NULL, 0);
	while (TRUE) {
		gboolean _tmp0_;
		gchar _tmp1_;
		gunichar ch;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
		_tmp0_ = vbf_backends_smart_folder_eof (self, content, start_position);
		if (!(!_tmp0_)) {
			break;
		}
		_tmp1_ = string_get (content, (glong) start_position);
		ch = (gunichar) _tmp1_;
		_tmp4_ = g_unichar_isspace (ch);
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = ch == '\t';
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = ch == '\n';
		}
		if (_tmp2_) {
			start_position++;
		} else {
			break;
		}
	}
	result = start_position;
	return result;
}


static gboolean vbf_backends_smart_folder_eof (VbfBackendsSmartFolder* self, const gchar* content, gint position) {
	gboolean result = FALSE;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (content != NULL, FALSE);
	_tmp0_ = strlen (content);
	result = _tmp0_ <= position;
	return result;
}


static gpointer _g_regex_ref0 (gpointer self) {
	return self ? g_regex_ref (self) : NULL;
}


static void vbf_backends_smart_folder_add_vala_source (VbfBackendsSmartFolder* self, VbfTarget* target, const gchar* directory, GFileInfo* file_info) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_;
	const gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_;
	GFile* file;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	VbfSource* _tmp9_ = NULL;
	VbfSource* _tmp10_;
	VbfSource* source;
	GFileInputStream* _tmp11_ = NULL;
	GFileInputStream* input_stream;
	GDataInputStream* _tmp12_ = NULL;
	GDataInputStream* data_stream;
	gint count;
	gchar* line = NULL;
	gsize len = 0UL;
	GRegex* regex = NULL;
	gboolean _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	g_return_if_fail (directory != NULL);
	g_return_if_fail (file_info != NULL);
	_tmp0_ = g_file_new_for_path (directory);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_info_get_name (file_info);
	_tmp3_ = g_file_resolve_relative_path (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	file = _tmp4_;
	_tmp5_ = g_file_get_path (file);
	_tmp6_ = _tmp5_;
	vbf_utils_trace ("vbfsmartfolder.vala:390: adding vala source: %s", _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = g_file_get_path (file);
	_tmp8_ = _tmp7_;
	_tmp9_ = vbf_source_new (target, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	source = _tmp10_;
	((VbfFile*) source)->type = VBF_FILE_TYPES_VALA_SOURCE;
	vbf_target_add_source (target, source);
	_tmp11_ = g_file_read (file, NULL, &_inner_error_);
	input_stream = _tmp11_;
	if (_inner_error_ != NULL) {
		goto __catch12_g_error;
	}
	_tmp12_ = g_data_input_stream_new ((GInputStream*) input_stream);
	data_stream = _tmp12_;
	count = 0;
	_tmp13_ = g_str_has_suffix (((VbfFile*) source)->uri, ".gs");
	if (_tmp13_) {
		GRegex* _tmp14_;
		_tmp14_ = _g_regex_ref0 (self->priv->_regex_genie);
		_g_regex_unref0 (regex);
		regex = _tmp14_;
	} else {
		GRegex* _tmp15_;
		_tmp15_ = _g_regex_ref0 (self->priv->_regex);
		_g_regex_unref0 (regex);
		regex = _tmp15_;
	}
	while (TRUE) {
		gboolean _tmp16_ = FALSE;
		gsize _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		GMatchInfo* match = NULL;
		GMatchInfo* _tmp20_ = NULL;
		_tmp18_ = g_data_input_stream_read_line (data_stream, &_tmp17_, NULL, &_inner_error_);
		len = _tmp17_;
		_tmp19_ = _tmp18_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			_g_free0 (line);
			_g_object_unref0 (data_stream);
			_g_object_unref0 (input_stream);
			goto __catch12_g_error;
		}
		_g_free0 (line);
		line = _tmp19_;
		if (line != NULL) {
			_tmp16_ = count < 100;
		} else {
			_tmp16_ = FALSE;
		}
		if (!_tmp16_) {
			break;
		}
		count++;
		g_regex_match (regex, line, G_REGEX_MATCH_NEWLINE_ANY, &_tmp20_);
		_g_match_info_free0 (match);
		match = _tmp20_;
		while (TRUE) {
			gboolean _tmp21_;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_;
			gchar* package_name;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_;
			_tmp21_ = g_match_info_matches (match);
			if (!_tmp21_) {
				break;
			}
			_tmp22_ = g_match_info_fetch (match, 2);
			_tmp23_ = _tmp22_;
			_tmp24_ = vbf_utils_guess_package_vapi (_tmp23_, NULL, 0);
			_tmp25_ = _tmp24_;
			_g_free0 (_tmp23_);
			package_name = _tmp25_;
			_tmp26_ = g_match_info_fetch (match, 2);
			_tmp27_ = _tmp26_;
			vbf_utils_trace ("vbfsmartfolder.vala:414: guessing name for %s: %s", _tmp27_, package_name);
			_g_free0 (_tmp27_);
			if (package_name != NULL) {
				gboolean _tmp28_;
				_tmp28_ = vbf_target_contains_package (target, package_name);
				if (!_tmp28_) {
					VbfPackage* _tmp29_ = NULL;
					VbfPackage* _tmp30_;
					_tmp29_ = vbf_package_new (package_name);
					_tmp30_ = _tmp29_;
					vbf_target_add_package (target, _tmp30_);
					_g_object_unref0 (_tmp30_);
				}
			}
			g_match_info_next (match, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (package_name);
				_g_match_info_free0 (match);
				_g_regex_unref0 (regex);
				_g_free0 (line);
				_g_object_unref0 (data_stream);
				_g_object_unref0 (input_stream);
				goto __catch12_g_error;
			}
			_g_free0 (package_name);
		}
		_g_match_info_free0 (match);
	}
	_g_regex_unref0 (regex);
	_g_free0 (line);
	_g_object_unref0 (data_stream);
	_g_object_unref0 (input_stream);
	goto __finally12;
	__catch12_g_error:
	{
		GError * err;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp31_ = g_file_get_path (file);
		_tmp32_ = _tmp31_;
		g_warning ("vbfsmartfolder.vala:425: error sniffing file %s: %s", _tmp32_, err->message);
		_g_free0 (_tmp32_);
		_g_error_free0 (err);
	}
	__finally12:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (source);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (source);
	_g_object_unref0 (file);
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static void vbf_backends_smart_folder_add_vapi_source (VbfBackendsSmartFolder* self, VbfTarget* target, const gchar* directory, GFileInfo* file_info) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* vapifile;
	gboolean _tmp2_;
	VbfPackage* _tmp5_ = NULL;
	VbfPackage* package;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* path;
	GFile* _tmp8_ = NULL;
	GFile* _tmp9_;
	GFile* _tmp10_ = NULL;
	GFile* _tmp11_;
	GFile* file;
	GFile* _tmp12_ = NULL;
	GFile* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* vapidir;
	gboolean _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	g_return_if_fail (directory != NULL);
	g_return_if_fail (file_info != NULL);
	_tmp0_ = g_file_info_get_name (file_info);
	_tmp1_ = g_strdup (_tmp0_);
	vapifile = _tmp1_;
	_tmp2_ = g_str_has_suffix (vapifile, ".vapi");
	if (_tmp2_) {
		gint _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp3_ = strlen (vapifile);
		_tmp4_ = string_substring (vapifile, (glong) 0, (glong) (_tmp3_ - 5));
		_g_free0 (vapifile);
		vapifile = _tmp4_;
	}
	vbf_utils_trace ("vbfsmartfolder.vala:436: adding vapi package: %s", vapifile);
	_tmp5_ = vbf_package_new (vapifile);
	package = _tmp5_;
	vbf_target_add_package (target, package);
	_tmp6_ = g_file_info_get_name (file_info);
	_tmp7_ = g_build_filename (directory, _tmp6_, NULL);
	path = _tmp7_;
	_tmp8_ = g_file_new_for_path (path);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_file_resolve_relative_path (_tmp9_, path);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (_tmp9_);
	file = _tmp11_;
	_tmp12_ = g_file_get_parent (file);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_file_get_path (_tmp13_);
	_tmp15_ = _tmp14_;
	_g_object_unref0 (_tmp13_);
	vapidir = _tmp15_;
	_tmp16_ = vbf_target_contains_include_dir (target, vapidir);
	if (!_tmp16_) {
		vbf_utils_trace ("vbfsmartfolder.vala:446: adding include dir: %s", vapidir);
		vbf_target_add_include_dir (target, vapidir);
	}
	_g_free0 (vapidir);
	_g_object_unref0 (file);
	_g_free0 (path);
	_g_object_unref0 (package);
	_g_free0 (vapifile);
}


void vbf_backends_smart_folder_setup_file_monitors (VbfBackendsSmartFolder* self, VbfProject* project) {
	GFile* file = NULL;
	GFileMonitor* file_mon = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (project != NULL);
	{
		ValaList* _tmp0_;
		ValaList* _dirname_list;
		gint _tmp1_;
		gint _dirname_size;
		gint _dirname_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->_visited_directory);
		_dirname_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _dirname_list);
		_dirname_size = _tmp1_;
		_dirname_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			gchar* dirname;
			GFile* _tmp3_ = NULL;
			GFileMonitor* _tmp4_ = NULL;
			GFileMonitor* _tmp5_;
			_dirname_index = _dirname_index + 1;
			if (!(_dirname_index < _dirname_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_dirname_list, _dirname_index);
			dirname = (gchar*) _tmp2_;
			_tmp3_ = g_file_new_for_path (dirname);
			_g_object_unref0 (file);
			file = _tmp3_;
			vbf_utils_trace ("vbfsmartfolder.vala:459: setup_file_monitors for: %s", dirname);
			_tmp4_ = g_file_monitor_directory (file, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
			_tmp5_ = _tmp4_;
			if (_inner_error_ != NULL) {
				_g_free0 (dirname);
				_vala_iterable_unref0 (_dirname_list);
				_g_object_unref0 (file_mon);
				_g_object_unref0 (file);
				goto __catch13_g_error;
			}
			_g_object_unref0 (file_mon);
			file_mon = _tmp5_;
			g_signal_connect_object (file_mon, "changed", (GCallback) _vbf_backends_smart_folder_on_project_directory_changed_g_file_monitor_changed, self, 0);
			vala_collection_add ((ValaCollection*) self->priv->_file_mons, file_mon);
			_g_free0 (dirname);
		}
		_vala_iterable_unref0 (_dirname_list);
	}
	_g_object_unref0 (file_mon);
	_g_object_unref0 (file);
	goto __finally13;
	__catch13_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("vbfsmartfolder.vala:466: setup_file_monitors error: %s", err->message);
		_g_error_free0 (err);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void vbf_backends_smart_folder_on_project_directory_changed (VbfBackendsSmartFolder* self, GFileMonitor* sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_monitor_is_cancelled (sender);
	if (!_tmp0_) {
		gboolean _tmp1_ = FALSE;
		if (event_type == G_FILE_MONITOR_EVENT_CREATED) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = event_type == G_FILE_MONITOR_EVENT_DELETED;
		}
		if (_tmp1_) {
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			gboolean _tmp4_;
			gboolean _tmp5_;
			_tmp2_ = g_file_get_path (file);
			_tmp3_ = _tmp2_;
			_tmp4_ = vbf_utils_is_vala_source (_tmp3_);
			_tmp5_ = _tmp4_;
			_g_free0 (_tmp3_);
			if (_tmp5_) {
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				if (event_type == G_FILE_MONITOR_EVENT_CREATED) {
					_tmp6_ = "created";
				} else {
					_tmp6_ = "deleted";
				}
				_tmp7_ = g_file_get_path (file);
				_tmp8_ = _tmp7_;
				vbf_utils_trace ("vbfsmartfolder.vala:475: file %s: %s", _tmp6_, _tmp8_);
				_g_free0 (_tmp8_);
				vbf_project_update (self->priv->_project);
			}
		}
	}
}


VbfBackendsSmartFolder* vbf_backends_smart_folder_construct (GType object_type) {
	VbfBackendsSmartFolder * self = NULL;
	self = (VbfBackendsSmartFolder*) g_object_new (object_type, NULL);
	return self;
}


VbfBackendsSmartFolder* vbf_backends_smart_folder_new (void) {
	return vbf_backends_smart_folder_construct (VBF_BACKENDS_TYPE_SMART_FOLDER);
}


static gchar* vbf_backends_smart_folder_real_get_configure_command (VbfIProjectBackend* base) {
	gchar* result;
	VbfBackendsSmartFolder* self;
	gchar* _tmp0_;
	self = (VbfBackendsSmartFolder*) base;
	_tmp0_ = g_strdup (self->priv->_configure_command);
	result = _tmp0_;
	return result;
}


static gchar* vbf_backends_smart_folder_real_get_build_command (VbfIProjectBackend* base) {
	gchar* result;
	VbfBackendsSmartFolder* self;
	gchar* _tmp0_;
	self = (VbfBackendsSmartFolder*) base;
	_tmp0_ = g_strdup (self->priv->_build_command);
	result = _tmp0_;
	return result;
}


static gchar* vbf_backends_smart_folder_real_get_clean_command (VbfIProjectBackend* base) {
	gchar* result;
	VbfBackendsSmartFolder* self;
	gchar* _tmp0_;
	self = (VbfBackendsSmartFolder*) base;
	_tmp0_ = g_strdup (self->priv->_clean_command);
	result = _tmp0_;
	return result;
}


static void vbf_backends_smart_folder_class_init (VbfBackendsSmartFolderClass * klass) {
	vbf_backends_smart_folder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VbfBackendsSmartFolderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_vbf_backends_smart_folder_get_property;
	G_OBJECT_CLASS (klass)->finalize = vbf_backends_smart_folder_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), VBF_BACKENDS_SMART_FOLDER_CONFIGURE_COMMAND, "configure-command");
	g_object_class_override_property (G_OBJECT_CLASS (klass), VBF_BACKENDS_SMART_FOLDER_BUILD_COMMAND, "build-command");
	g_object_class_override_property (G_OBJECT_CLASS (klass), VBF_BACKENDS_SMART_FOLDER_CLEAN_COMMAND, "clean-command");
}


static void vbf_backends_smart_folder_vbf_iproject_backend_interface_init (VbfIProjectBackendIface * iface) {
	vbf_backends_smart_folder_vbf_iproject_backend_parent_iface = g_type_interface_peek_parent (iface);
	iface->probe = (gboolean (*)(VbfIProjectBackend* ,const gchar*)) vbf_backends_smart_folder_real_probe;
	iface->open = (VbfProject* (*)(VbfIProjectBackend* ,const gchar*)) vbf_backends_smart_folder_real_open;
	iface->refresh = (void (*)(VbfIProjectBackend* ,VbfProject*)) vbf_backends_smart_folder_real_refresh;
	iface->get_configure_command = vbf_backends_smart_folder_real_get_configure_command;
	iface->get_build_command = vbf_backends_smart_folder_real_get_build_command;
	iface->get_clean_command = vbf_backends_smart_folder_real_get_clean_command;
}


static void vbf_backends_smart_folder_instance_init (VbfBackendsSmartFolder * self) {
	ValaArrayList* _tmp0_ = NULL;
	self->priv = VBF_BACKENDS_SMART_FOLDER_GET_PRIVATE (self);
	_tmp0_ = vala_array_list_new (G_TYPE_FILE_MONITOR, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->priv->_file_mons = (ValaList*) _tmp0_;
	self->priv->_project_subtype = VBF_BACKENDS_SMART_FOLDER_PROJECT_SUB_TYPE_UNKNOWN;
}


static void vbf_backends_smart_folder_finalize (GObject* obj) {
	VbfBackendsSmartFolder * self;
	self = VBF_BACKENDS_SMART_FOLDER (obj);
	_g_free0 (self->priv->_configure_command);
	_g_free0 (self->priv->_build_command);
	_g_free0 (self->priv->_clean_command);
	_g_regex_unref0 (self->priv->_regex);
	_g_regex_unref0 (self->priv->_regex_genie);
	_vala_iterable_unref0 (self->priv->_file_mons);
	_vala_iterable_unref0 (self->priv->_visited_directory);
	G_OBJECT_CLASS (vbf_backends_smart_folder_parent_class)->finalize (obj);
}


GType vbf_backends_smart_folder_get_type (void) {
	static volatile gsize vbf_backends_smart_folder_type_id__volatile = 0;
	if (g_once_init_enter (&vbf_backends_smart_folder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VbfBackendsSmartFolderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vbf_backends_smart_folder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VbfBackendsSmartFolder), 0, (GInstanceInitFunc) vbf_backends_smart_folder_instance_init, NULL };
		static const GInterfaceInfo vbf_iproject_backend_info = { (GInterfaceInitFunc) vbf_backends_smart_folder_vbf_iproject_backend_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vbf_backends_smart_folder_type_id;
		vbf_backends_smart_folder_type_id = g_type_register_static (G_TYPE_OBJECT, "VbfBackendsSmartFolder", &g_define_type_info, 0);
		g_type_add_interface_static (vbf_backends_smart_folder_type_id, VBF_TYPE_IPROJECT_BACKEND, &vbf_iproject_backend_info);
		g_once_init_leave (&vbf_backends_smart_folder_type_id__volatile, vbf_backends_smart_folder_type_id);
	}
	return vbf_backends_smart_folder_type_id__volatile;
}


static void _vala_vbf_backends_smart_folder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VbfBackendsSmartFolder * self;
	self = VBF_BACKENDS_SMART_FOLDER (object);
	switch (property_id) {
		case VBF_BACKENDS_SMART_FOLDER_CONFIGURE_COMMAND:
		g_value_take_string (value, vbf_iproject_backend_get_configure_command ((VbfIProjectBackend*) self));
		break;
		case VBF_BACKENDS_SMART_FOLDER_BUILD_COMMAND:
		g_value_take_string (value, vbf_iproject_backend_get_build_command ((VbfIProjectBackend*) self));
		break;
		case VBF_BACKENDS_SMART_FOLDER_CLEAN_COMMAND:
		g_value_take_string (value, vbf_iproject_backend_get_clean_command ((VbfIProjectBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



