/* vtgsourcebookmarks.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from vtgsourcebookmarks.vala, do not modify */

/*
 *  vtgsourcebookmarks.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <valagee.h>
#include <gedit/gedit-document.h>
#include <stdlib.h>
#include <string.h>
#include <gedit/gedit-window.h>
#include <gedit/gedit-tab.h>
#include <gtk/gtk.h>


#define VTG_TYPE_SOURCE_BOOKMARKS (vtg_source_bookmarks_get_type ())
#define VTG_SOURCE_BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_SOURCE_BOOKMARKS, VtgSourceBookmarks))
#define VTG_SOURCE_BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_SOURCE_BOOKMARKS, VtgSourceBookmarksClass))
#define VTG_IS_SOURCE_BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_SOURCE_BOOKMARKS))
#define VTG_IS_SOURCE_BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_SOURCE_BOOKMARKS))
#define VTG_SOURCE_BOOKMARKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_SOURCE_BOOKMARKS, VtgSourceBookmarksClass))

typedef struct _VtgSourceBookmarks VtgSourceBookmarks;
typedef struct _VtgSourceBookmarksClass VtgSourceBookmarksClass;
typedef struct _VtgSourceBookmarksPrivate VtgSourceBookmarksPrivate;

#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;

#define VTG_TYPE_SOURCE_BOOKMARK (vtg_source_bookmark_get_type ())
#define VTG_SOURCE_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_SOURCE_BOOKMARK, VtgSourceBookmark))
#define VTG_SOURCE_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_SOURCE_BOOKMARK, VtgSourceBookmarkClass))
#define VTG_IS_SOURCE_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_SOURCE_BOOKMARK))
#define VTG_IS_SOURCE_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_SOURCE_BOOKMARK))
#define VTG_SOURCE_BOOKMARK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_SOURCE_BOOKMARK, VtgSourceBookmarkClass))

typedef struct _VtgSourceBookmark VtgSourceBookmark;
typedef struct _VtgSourceBookmarkClass VtgSourceBookmarkClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define VTG_TYPE_PROJECT_VIEW (vtg_project_view_get_type ())
#define VTG_PROJECT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_VIEW, VtgProjectView))
#define VTG_PROJECT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_VIEW, VtgProjectViewClass))
#define VTG_IS_PROJECT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_VIEW))
#define VTG_IS_PROJECT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_VIEW))
#define VTG_PROJECT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_VIEW, VtgProjectViewClass))

typedef struct _VtgProjectView VtgProjectView;
typedef struct _VtgProjectViewClass VtgProjectViewClass;

#define VTG_TYPE_PROJECT_MANAGER (vtg_project_manager_get_type ())
#define VTG_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManager))
#define VTG_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))
#define VTG_IS_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER))
#define VTG_IS_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER))
#define VTG_PROJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))

typedef struct _VtgProjectManager VtgProjectManager;
typedef struct _VtgProjectManagerClass VtgProjectManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _VtgSourceBookmarkPrivate VtgSourceBookmarkPrivate;
#define _vtg_source_bookmark_unref0(var) ((var == NULL) ? NULL : (var = (vtg_source_bookmark_unref (var), NULL)))

struct _VtgSourceBookmarks {
	GObject parent_instance;
	VtgSourceBookmarksPrivate * priv;
};

struct _VtgSourceBookmarksClass {
	GObjectClass parent_class;
};

struct _VtgSourceBookmarksPrivate {
	VtgPluginInstance* _plugin_instance;
	gulong signal_id;
	ValaList* _bookmarks;
	gint _current_bookmark_index;
	gboolean _in_move;
	GeditDocument* _idle_add_doc;
};

struct _VtgSourceBookmark {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VtgSourceBookmarkPrivate * priv;
	gchar* uri;
	gint line;
	gint column;
};

struct _VtgSourceBookmarkClass {
	GTypeClass parent_class;
	void (*finalize) (VtgSourceBookmark *self);
};


static gpointer vtg_source_bookmarks_parent_class = NULL;
static GType vtg_source_bookmarks_type_id = 0;

GType vtg_source_bookmarks_get_type (void) G_GNUC_CONST;
GType vtg_source_bookmarks_register_type (GTypeModule * module);
GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
gpointer vtg_source_bookmark_ref (gpointer instance);
void vtg_source_bookmark_unref (gpointer instance);
GParamSpec* vtg_param_spec_source_bookmark (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vtg_value_set_source_bookmark (GValue* value, gpointer v_object);
void vtg_value_take_source_bookmark (GValue* value, gpointer v_object);
gpointer vtg_value_get_source_bookmark (const GValue* value);
GType vtg_source_bookmark_get_type (void) G_GNUC_CONST;
GType vtg_source_bookmark_register_type (GTypeModule * module);
#define VTG_SOURCE_BOOKMARKS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_SOURCE_BOOKMARKS, VtgSourceBookmarksPrivate))
enum  {
	VTG_SOURCE_BOOKMARKS_DUMMY_PROPERTY,
	VTG_SOURCE_BOOKMARKS_IS_EMPTY
};
void vtg_utils_trace (const gchar* format, ...);
GeditWindow* vtg_plugin_instance_get_window (VtgPluginInstance* self);
#define VTG_SOURCE_BOOKMARKS_MAX_BOOKMARKS 20
VtgSourceBookmarks* vtg_source_bookmarks_new (VtgPluginInstance* plugin_instance);
VtgSourceBookmarks* vtg_source_bookmarks_construct (GType object_type, VtgPluginInstance* plugin_instance);
static void vtg_source_bookmarks_on_tab_changed (GeditWindow* sender, GeditTab* tab, VtgSourceBookmarks* instance);
gchar* vtg_utils_get_document_uri (GeditDocument* doc);
GType vtg_project_view_get_type (void) G_GNUC_CONST;
GType vtg_project_view_register_type (GTypeModule * module);
VtgProjectView* vtg_plugin_instance_get_project_view (VtgPluginInstance* self);
GType vtg_project_manager_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_register_type (GTypeModule * module);
VtgProjectManager* vtg_project_view_get_current_project (VtgProjectView* self);
gboolean vtg_project_manager_contains_vala_source_file (VtgProjectManager* self, const gchar* uri);
gboolean vtg_source_bookmarks_on_idle_bookmark_add (VtgSourceBookmarks* self);
static gboolean _vtg_source_bookmarks_on_idle_bookmark_add_gsource_func (gpointer self);
VtgSourceBookmark* vtg_source_bookmark_new (void);
VtgSourceBookmark* vtg_source_bookmark_construct (GType object_type);
void vtg_source_bookmarks_add_bookmark (VtgSourceBookmarks* self, VtgSourceBookmark* item, gboolean _auto_);
gboolean vtg_source_bookmarks_get_is_empty (VtgSourceBookmarks* self);
VtgSourceBookmark* vtg_source_bookmarks_get_current_bookmark (VtgSourceBookmarks* self);
void vtg_source_bookmarks_move_next (VtgSourceBookmarks* self);
void vtg_source_bookmarks_move_previous (VtgSourceBookmarks* self);
static void vtg_source_bookmarks_finalize (GObject* obj);
static void _vala_vtg_source_bookmarks_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


VtgSourceBookmarks* vtg_source_bookmarks_construct (GType object_type, VtgPluginInstance* plugin_instance) {
	VtgSourceBookmarks * self = NULL;
	GeditWindow* _tmp0_ = NULL;
	gulong _tmp1_;
	g_return_val_if_fail (plugin_instance != NULL, NULL);
	self = (VtgSourceBookmarks*) g_object_new (object_type, NULL);
	self->priv->_plugin_instance = plugin_instance;
	_tmp0_ = vtg_plugin_instance_get_window (self->priv->_plugin_instance);
	_tmp1_ = g_signal_connect (_tmp0_, "active_tab_changed", (GCallback) vtg_source_bookmarks_on_tab_changed, self);
	self->priv->signal_id = _tmp1_;
	return self;
}


VtgSourceBookmarks* vtg_source_bookmarks_new (VtgPluginInstance* plugin_instance) {
	return vtg_source_bookmarks_construct (VTG_TYPE_SOURCE_BOOKMARKS, plugin_instance);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _vtg_source_bookmarks_on_idle_bookmark_add_gsource_func (gpointer self) {
	gboolean result;
	result = vtg_source_bookmarks_on_idle_bookmark_add (self);
	return result;
}


static void vtg_source_bookmarks_on_tab_changed (GeditWindow* sender, GeditTab* tab, VtgSourceBookmarks* instance) {
	GeditDocument* _tmp0_ = NULL;
	GeditDocument* _tmp1_;
	GeditDocument* doc;
	gchar* _tmp2_ = NULL;
	gchar* uri;
	VtgProjectView* _tmp3_ = NULL;
	VtgProjectManager* _tmp4_ = NULL;
	VtgProjectManager* _tmp5_;
	VtgProjectManager* prj;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (sender != NULL);
	g_return_if_fail (tab != NULL);
	g_return_if_fail (instance != NULL);
	_tmp0_ = gedit_tab_get_document (tab);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	doc = _tmp1_;
	_tmp2_ = vtg_utils_get_document_uri (doc);
	uri = _tmp2_;
	_tmp3_ = vtg_plugin_instance_get_project_view (instance->priv->_plugin_instance);
	_tmp4_ = vtg_project_view_get_current_project (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	prj = _tmp5_;
	if (prj != NULL) {
		gboolean _tmp7_;
		_tmp7_ = vtg_project_manager_contains_vala_source_file (prj, uri);
		_tmp6_ = _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GeditDocument* _tmp8_;
		_tmp8_ = _g_object_ref0 (doc);
		_g_object_unref0 (instance->priv->_idle_add_doc);
		instance->priv->_idle_add_doc = _tmp8_;
		g_idle_add_full (G_PRIORITY_LOW, _vtg_source_bookmarks_on_idle_bookmark_add_gsource_func, g_object_ref (instance), g_object_unref);
	} else {
		_g_object_unref0 (instance->priv->_idle_add_doc);
		instance->priv->_idle_add_doc = NULL;
	}
	_g_object_unref0 (prj);
	_g_free0 (uri);
	_g_object_unref0 (doc);
}


gboolean vtg_source_bookmarks_on_idle_bookmark_add (VtgSourceBookmarks* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_idle_add_doc != NULL) {
		gchar* _tmp0_ = NULL;
		gchar* uri;
		VtgProjectView* _tmp1_ = NULL;
		VtgProjectManager* _tmp2_ = NULL;
		VtgProjectManager* _tmp3_;
		VtgProjectManager* prj;
		gboolean _tmp4_ = FALSE;
		_tmp0_ = vtg_utils_get_document_uri (self->priv->_idle_add_doc);
		uri = _tmp0_;
		_tmp1_ = vtg_plugin_instance_get_project_view (self->priv->_plugin_instance);
		_tmp2_ = vtg_project_view_get_current_project (_tmp1_);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		prj = _tmp3_;
		if (prj != NULL) {
			gboolean _tmp5_;
			_tmp5_ = vtg_project_manager_contains_vala_source_file (prj, uri);
			_tmp4_ = _tmp5_;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			GtkTextMark* _tmp6_ = NULL;
			GtkTextMark* mark;
			GtkTextIter start = {0};
			GtkTextIter _tmp7_ = {0};
			gint _tmp8_;
			gint line;
			gint _tmp9_;
			gint col;
			VtgSourceBookmark* _tmp10_ = NULL;
			VtgSourceBookmark* book;
			gchar* _tmp11_;
			_tmp6_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self->priv->_idle_add_doc);
			mark = GTK_TEXT_MARK (_tmp6_);
			gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self->priv->_idle_add_doc, &_tmp7_, mark);
			start = _tmp7_;
			_tmp8_ = gtk_text_iter_get_line (&start);
			line = _tmp8_;
			_tmp9_ = gtk_text_iter_get_line_offset (&start);
			col = _tmp9_;
			_tmp10_ = vtg_source_bookmark_new ();
			book = _tmp10_;
			_tmp11_ = g_strdup (uri);
			_g_free0 (book->uri);
			book->uri = _tmp11_;
			book->line = line + 1;
			book->column = col + 1;
			vtg_source_bookmarks_add_bookmark (self, book, TRUE);
			_vtg_source_bookmark_unref0 (book);
		}
		_g_object_unref0 (prj);
		_g_free0 (uri);
	}
	result = FALSE;
	return result;
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


void vtg_source_bookmarks_add_bookmark (VtgSourceBookmarks* self, VtgSourceBookmark* item, gboolean _auto_) {
	gboolean _tmp0_ = FALSE;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	if (self->priv->_in_move) {
		return;
	}
	if (_auto_) {
		gboolean _tmp1_;
		_tmp1_ = vtg_source_bookmarks_get_is_empty (self);
		_tmp0_ = !_tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint idx;
		idx = 0;
		{
			ValaList* _tmp2_;
			ValaList* _book_list;
			gint _tmp3_;
			gint _book_size;
			gint _book_index;
			_tmp2_ = _vala_iterable_ref0 (self->priv->_bookmarks);
			_book_list = _tmp2_;
			_tmp3_ = vala_collection_get_size ((ValaCollection*) _book_list);
			_book_size = _tmp3_;
			_book_index = -1;
			while (TRUE) {
				gpointer _tmp4_ = NULL;
				VtgSourceBookmark* book;
				_book_index = _book_index + 1;
				if (!(_book_index < _book_size)) {
					break;
				}
				_tmp4_ = vala_list_get (_book_list, _book_index);
				book = (VtgSourceBookmark*) _tmp4_;
				if (g_strcmp0 (book->uri, item->uri) == 0) {
					self->priv->_current_bookmark_index = idx;
					book->line = item->line;
					book->column = item->column;
					_vtg_source_bookmark_unref0 (book);
					_vala_iterable_unref0 (_book_list);
					return;
				}
				idx++;
				_vtg_source_bookmark_unref0 (book);
			}
			_vala_iterable_unref0 (_book_list);
		}
	}
	_tmp5_ = vala_collection_get_size ((ValaCollection*) self->priv->_bookmarks);
	if (self->priv->_current_bookmark_index >= (_tmp5_ - 1)) {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) self->priv->_bookmarks);
		if (_tmp6_ == VTG_SOURCE_BOOKMARKS_MAX_BOOKMARKS) {
			vala_list_remove_at (self->priv->_bookmarks, 0);
		}
		vala_collection_add ((ValaCollection*) self->priv->_bookmarks, item);
		_tmp7_ = vala_collection_get_size ((ValaCollection*) self->priv->_bookmarks);
		self->priv->_current_bookmark_index = _tmp7_ - 1;
	} else {
		gint _tmp8_;
		self->priv->_current_bookmark_index++;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) self->priv->_bookmarks);
		if (_tmp8_ == VTG_SOURCE_BOOKMARKS_MAX_BOOKMARKS) {
			vala_list_remove_at (self->priv->_bookmarks, self->priv->_current_bookmark_index);
		}
		vala_list_insert (self->priv->_bookmarks, self->priv->_current_bookmark_index, item);
	}
}


VtgSourceBookmark* vtg_source_bookmarks_get_current_bookmark (VtgSourceBookmarks* self) {
	VtgSourceBookmark* result = NULL;
	VtgSourceBookmark* item;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	item = NULL;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) self->priv->_bookmarks);
	if (_tmp1_ > 0) {
		gint _tmp2_;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) self->priv->_bookmarks);
		_tmp0_ = _tmp2_ > self->priv->_current_bookmark_index;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gpointer _tmp3_ = NULL;
		_tmp3_ = vala_list_get (self->priv->_bookmarks, self->priv->_current_bookmark_index);
		_vtg_source_bookmark_unref0 (item);
		item = (VtgSourceBookmark*) _tmp3_;
	}
	result = item;
	return result;
}


void vtg_source_bookmarks_move_next (VtgSourceBookmarks* self) {
	gboolean wrap;
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	wrap = FALSE;
	_tmp0_ = vala_collection_get_size ((ValaCollection*) self->priv->_bookmarks);
	if (_tmp0_ == 0) {
		return;
	}
	_tmp1_ = vala_collection_get_size ((ValaCollection*) self->priv->_bookmarks);
	if (self->priv->_current_bookmark_index < (_tmp1_ - 1)) {
		self->priv->_current_bookmark_index++;
	} else {
		self->priv->_current_bookmark_index = 0;
		wrap = TRUE;
	}
	self->priv->_in_move = TRUE;
	g_signal_emit_by_name (self, "current-bookmark-changed");
	if (wrap) {
		g_signal_emit_by_name (self, "move-wrapped");
	}
	self->priv->_in_move = FALSE;
}


void vtg_source_bookmarks_move_previous (VtgSourceBookmarks* self) {
	gboolean wrap;
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	wrap = FALSE;
	_tmp0_ = vala_collection_get_size ((ValaCollection*) self->priv->_bookmarks);
	if (_tmp0_ == 0) {
		return;
	}
	if (self->priv->_current_bookmark_index > 0) {
		self->priv->_current_bookmark_index--;
	} else {
		gint _tmp1_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) self->priv->_bookmarks);
		self->priv->_current_bookmark_index = _tmp1_ - 1;
		wrap = TRUE;
	}
	self->priv->_in_move = TRUE;
	g_signal_emit_by_name (self, "current-bookmark-changed");
	if (wrap) {
		g_signal_emit_by_name (self, "move-wrapped");
	}
	self->priv->_in_move = FALSE;
}


gboolean vtg_source_bookmarks_get_is_empty (VtgSourceBookmarks* self) {
	gboolean result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_collection_get_size ((ValaCollection*) self->priv->_bookmarks);
	result = _tmp0_ == 0;
	return result;
}


static void vtg_source_bookmarks_class_init (VtgSourceBookmarksClass * klass) {
	vtg_source_bookmarks_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgSourceBookmarksPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_vtg_source_bookmarks_get_property;
	G_OBJECT_CLASS (klass)->finalize = vtg_source_bookmarks_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_SOURCE_BOOKMARKS_IS_EMPTY, g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("current_bookmark_changed", VTG_TYPE_SOURCE_BOOKMARKS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("move_wrapped", VTG_TYPE_SOURCE_BOOKMARKS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void vtg_source_bookmarks_instance_init (VtgSourceBookmarks * self) {
	ValaArrayList* _tmp0_ = NULL;
	self->priv = VTG_SOURCE_BOOKMARKS_GET_PRIVATE (self);
	self->priv->_plugin_instance = NULL;
	_tmp0_ = vala_array_list_new (VTG_TYPE_SOURCE_BOOKMARK, (GBoxedCopyFunc) vtg_source_bookmark_ref, vtg_source_bookmark_unref, g_direct_equal);
	self->priv->_bookmarks = (ValaList*) _tmp0_;
	self->priv->_current_bookmark_index = -1;
	self->priv->_in_move = FALSE;
	self->priv->_idle_add_doc = NULL;
}


static void vtg_source_bookmarks_finalize (GObject* obj) {
	VtgSourceBookmarks * self;
	GeditWindow* _tmp0_ = NULL;
	self = VTG_SOURCE_BOOKMARKS (obj);
	vtg_utils_trace ("vtgsourcebookmarks.vala:48: SourceBoolmarks destroying");
	_tmp0_ = vtg_plugin_instance_get_window (self->priv->_plugin_instance);
	g_signal_handler_disconnect (_tmp0_, self->priv->signal_id);
	vtg_utils_trace ("vtgsourcebookmarks.vala:50: SourceBoolmarks destroying");
	_vala_iterable_unref0 (self->priv->_bookmarks);
	_g_object_unref0 (self->priv->_idle_add_doc);
	G_OBJECT_CLASS (vtg_source_bookmarks_parent_class)->finalize (obj);
}


GType vtg_source_bookmarks_get_type (void) {
	return vtg_source_bookmarks_type_id;
}


GType vtg_source_bookmarks_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgSourceBookmarksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_source_bookmarks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgSourceBookmarks), 0, (GInstanceInitFunc) vtg_source_bookmarks_instance_init, NULL };
	vtg_source_bookmarks_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgSourceBookmarks", &g_define_type_info, 0);
	return vtg_source_bookmarks_type_id;
}


static void _vala_vtg_source_bookmarks_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgSourceBookmarks * self;
	self = VTG_SOURCE_BOOKMARKS (object);
	switch (property_id) {
		case VTG_SOURCE_BOOKMARKS_IS_EMPTY:
		g_value_set_boolean (value, vtg_source_bookmarks_get_is_empty (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



