/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.ColumnArea;
import org.apache.fop.messaging.MessageHandler;

public class Flow
extends FObj {
    private PageSequence pageSequence;
    private Area area;
    private Vector markerSnapshot;
    private String _flowName;
    private Status _status = new Status(2);

    protected Flow(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
        this.name = this.getElementName();
        if (!fObj.getName().equals("fo:page-sequence")) {
            throw new FOPException("flow must be child of page-sequence, not " + fObj.getName());
        }
        this.pageSequence = (PageSequence)fObj;
        this.setFlowName(this.getProperty("flow-name").getString());
        if (this.pageSequence.isFlowSet()) {
            if (this.name.equals("fo:flow")) {
                throw new FOPException("Only a single fo:flow permitted per fo:page-sequence");
            }
            throw new FOPException(String.valueOf(this.name) + " not allowed after fo:flow");
        }
        this.pageSequence.addFlow(this);
    }

    public boolean generatesReferenceAreas() {
        return true;
    }

    public int getContentWidth() {
        if (this.area != null) {
            return this.area.getContentWidth();
        }
        return 0;
    }

    protected String getElementName() {
        return "fo:flow";
    }

    public String getFlowName() {
        return this._flowName;
    }

    public Status getStatus() {
        return this._status;
    }

    public Status layout(Area area) throws FOPException {
        return this.layout(area, null);
    }

    public Status layout(Area area, Region region) throws FOPException {
        if (this.marker == -1000) {
            this.marker = 0;
        }
        BodyAreaContainer bodyAreaContainer = (BodyAreaContainer)area;
        boolean bl = false;
        Vector vector = this.getMarkerSnapshot(new Vector());
        int n = this.children.size();
        if (n == 0) {
            throw new FOPException("fo:flow must contain block-level children");
        }
        int n2 = this.marker;
        while (n2 < n) {
            FObj fObj = (FObj)this.children.elementAt(n2);
            if (bodyAreaContainer.isBalancingRequired(fObj)) {
                bodyAreaContainer.resetSpanArea();
                this.rollback(this.markerSnapshot);
                n2 = this.marker - 1;
            } else {
                AreaContainer areaContainer = bodyAreaContainer.getNextArea(fObj);
                areaContainer.setIDReferences(bodyAreaContainer.getIDReferences());
                if (bodyAreaContainer.isNewSpanArea()) {
                    this.marker = n2;
                    this.markerSnapshot = this.getMarkerSnapshot(new Vector());
                }
                this._status = fObj.layout(areaContainer);
                if (this._status.isIncomplete()) {
                    if (bl && this._status.laidOutNone()) {
                        this.marker = n2 - 1;
                        FObj fObj2 = (FObj)this.children.elementAt(this.marker);
                        fObj2.removeAreas();
                        fObj2.resetMarker();
                        fObj2.removeID(area.getIDReferences());
                        this._status = new Status(3);
                        return this._status;
                    }
                    if (bodyAreaContainer.isLastColumn()) {
                        if (this._status.getCode() == 7) {
                            this.marker = n2;
                            this._status = new Status(4);
                            return this._status;
                        }
                        this.marker = n2;
                        return this._status;
                    }
                    if (this._status.isPageBreak()) {
                        this.marker = n2;
                        return this._status;
                    }
                    ((ColumnArea)areaContainer).incrementSpanIndex();
                    --n2;
                }
                bl = this._status.getCode() == 8;
            }
            ++n2;
        }
        return this._status;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    protected void setFlowName(String string) throws FOPException {
        if (string == null || string.equals("")) {
            MessageHandler.errorln("WARNING: A 'flow-name' is required for " + this.getElementName() + ". This constraint will be enforced in future versions of FOP");
            this._flowName = "xsl-region-body";
        } else {
            this._flowName = string;
        }
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new Flow(fObj, propertyList);
        }
    }
}

