/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;

public class FootnoteBody
extends FObj {
    FontState fs;
    int align;
    int alignLast;
    int lineHeight;
    int startIndent;
    int endIndent;
    int textIndent;

    public FootnoteBody(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
        this.name = "fo:footnote-body";
    }

    public Status layout(Area area) throws FOPException {
        if (this.marker == -1000) {
            this.marker = 0;
        }
        String string = this.properties.get("font-family").getString();
        String string2 = this.properties.get("font-style").getString();
        String string3 = this.properties.get("font-weight").getString();
        int n = this.properties.get("font-size").getLength().mvalue();
        int n2 = this.properties.get("font-variant").getEnum();
        FontState fontState = new FontState(area.getFontInfo(), string, string2, string3, n, n2);
        BlockArea blockArea = new BlockArea(fontState, area.getAllocationWidth(), area.spaceLeft(), this.startIndent, this.endIndent, this.textIndent, this.align, this.alignLast, this.lineHeight);
        blockArea.setPage(area.getPage());
        blockArea.start();
        blockArea.setAbsoluteHeight(area.getAbsoluteHeight());
        blockArea.setIDReferences(area.getIDReferences());
        blockArea.setTableCellXOffset(area.getTableCellXOffset());
        int n3 = this.children.size();
        int n4 = this.marker;
        while (n4 < n3) {
            FONode fONode = (FONode)this.children.elementAt(n4);
            Status status = fONode.layout(blockArea);
            if (status.isIncomplete()) {
                this.resetMarker();
                return status;
            }
            ++n4;
        }
        blockArea.end();
        area.addChild(blockArea);
        area.increaseHeight(blockArea.getHeight());
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new FootnoteBody(fObj, propertyList);
        }
    }
}

