/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.BufferedInputStream;
import java.io.IOException;
import org.apache.fop.image.analyser.AbstractImageReader;

public class JPEGReader
extends AbstractImageReader {
    protected static final int MARK = 255;
    protected static final int NULL = 0;
    protected static final int SOF1 = 192;
    protected static final int SOF2 = 193;
    protected static final int SOF3 = 194;
    protected static final int SOFA = 202;
    protected static final int APP0 = 224;
    protected static final int APPF = 239;
    protected static final int SOS = 218;
    protected static final int SOI = 216;
    protected static final int JPG_SIG_LENGTH = 2;
    protected byte[] header;

    public String getMimeType() {
        return "image/jpeg";
    }

    protected int read2bytes() throws IOException {
        int n = this.imageStream.read();
        int n2 = this.imageStream.read();
        return n << 8 | n2;
    }

    protected void setDefaultHeader() throws IOException {
        this.header = new byte[2];
        try {
            this.imageStream.mark(3);
            this.imageStream.read(this.header);
            this.imageStream.reset();
        }
        catch (IOException iOException) {
            try {
                this.imageStream.reset();
            }
            catch (IOException iOException2) {}
            throw iOException;
        }
    }

    protected void setDimension() throws IOException {
        try {
            int n = 0;
            block8: while (this.imageStream.available() > 0) {
                while ((n = this.imageStream.read()) != 255) {
                }
                while ((n = this.imageStream.read()) == 255) {
                }
                switch (n) {
                    case 192: 
                    case 193: 
                    case 194: 
                    case 202: {
                        this.skip(3L);
                        this.height = this.read2bytes();
                        this.width = this.read2bytes();
                        break;
                    }
                    default: {
                        long l = this.read2bytes();
                        long l2 = this.skip(l - 2L);
                        if (l2 != l - 2L) {
                            throw new IOException("Skipping Error");
                        }
                    }
                    case 0: 
                    case 216: {
                        continue block8;
                    }
                }
                break;
            }
        }
        catch (IOException iOException) {
            try {
                this.imageStream.reset();
            }
            catch (IOException iOException2) {}
            throw iOException;
        }
    }

    protected long skip(long l) throws IOException {
        long l2 = 0L;
        while (l2 != l) {
            this.imageStream.read();
            ++l2;
        }
        return l2;
    }

    public boolean verifySignature(BufferedInputStream bufferedInputStream) throws IOException {
        boolean bl;
        this.imageStream = bufferedInputStream;
        this.setDefaultHeader();
        boolean bl2 = bl = this.header[0] == -1 && this.header[1] == -40;
        if (bl) {
            this.setDimension();
            return true;
        }
        return false;
    }
}

