/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.OutputStreamWriter;
import org.apache.log4j.Layout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;

public class ConsoleAppender
extends WriterAppender {
    public static final String SYSTEM_OUT = "System.out";
    public static final String SYSTEM_ERR = "System.err";
    public static final String TARGET_OPTION = "Target";
    protected String target = "System.out";

    public ConsoleAppender() {
    }

    public ConsoleAppender(Layout layout) {
        this(layout, SYSTEM_OUT);
    }

    public ConsoleAppender(Layout layout, String target) {
        this.layout = layout;
        if (SYSTEM_OUT.equals(target)) {
            this.setWriter(new OutputStreamWriter(System.out));
        } else if (SYSTEM_ERR.equalsIgnoreCase(target)) {
            this.setWriter(new OutputStreamWriter(System.err));
        } else {
            this.targetWarn(target);
        }
    }

    public void setTarget(String value) {
        String v = value.trim();
        if (SYSTEM_OUT.equalsIgnoreCase(v)) {
            this.target = SYSTEM_OUT;
        } else if (SYSTEM_ERR.equalsIgnoreCase(v)) {
            this.target = SYSTEM_ERR;
        } else {
            this.targetWarn(value);
        }
    }

    public String getTarget() {
        return this.target;
    }

    void targetWarn(String val) {
        LogLog.warn("[" + val + "] should be System.out or System.err.");
        LogLog.warn("Using System.out (default).");
    }

    public void activateOptions() {
        if (this.target.equals(SYSTEM_OUT)) {
            this.setWriter(new OutputStreamWriter(System.out));
        } else {
            this.setWriter(new OutputStreamWriter(System.err));
        }
    }

    protected final void closeWriter() {
    }

    public String[] getOptionStrings() {
        return OptionConverter.concatanateArrays(super.getOptionStrings(), new String[]{TARGET_OPTION});
    }

    public void setOption(String key, String value) {
        if (value == null) {
            return;
        }
        super.setOption(key, value);
        if (key.equalsIgnoreCase(TARGET_OPTION)) {
            String v = value.trim();
            if (SYSTEM_OUT.equalsIgnoreCase(v)) {
                this.target = SYSTEM_OUT;
            } else if (!SYSTEM_ERR.equalsIgnoreCase(v)) {
                this.targetWarn(value);
            }
        }
    }
}

