
#ifndef __VPB_UTILFUNCS
#define __VPB_UTILFUNCS

#include <vector>
#include "llconf.h"

/********************** DEFINITIONS ******************************************/

/* ISDN interface type defns */
#define VPB_PRI_E1	0
#define VPB_PRI_T1	1

/* ISDN protocol types - as taken from libpri */
#define ISDN_PROTO_UNKNOWN		0
#define ISDN_PROTO_NI2			1       /* National ISDN 2 */
#define ISDN_PROTO_DMS100		2       /* DMS 100 */
#define ISDN_PROTO_LUCENT5E		3       /* Lucent 5E */
#define ISDN_PROTO_ATT4ESS		4       /* AT&T 4ESS */
#define ISDN_PROTO_EUROISDN_E1		5       /* Standard EuroISDN (CTR4, ETSI 300-102) */
#define ISDN_PROTO_EUROISDN_T1		6       /* T1 EuroISDN variant (ETSI 300-102) */
#define ISDN_PROTO_NI1			7       /* National ISDN 1 */
#define ISDN_PROTO_GR303_EOC		8       /* GR-303 Embedded Operations Channel */
#define ISDN_PROTO_GR303_TMC		9       /* GR-303 Timeslot Management Channel */
/* Node types */
#define ISDN_NODE_NETWORK		1
#define ISDN_NODE_CLIENT		2
#define ISDN_NODE_LOG			3	/* Logging mode */
/* Dial Plans */
#define ISDN_DP_UNKNOWN                                     0x0
#define ISDN_DP_INTERNATIONAL_ISDN                          0x11
#define ISDN_DP_NATIONAL_ISDN                               0x21
#define ISDN_DP_LOCAL_ISDN                                  0x41
#define ISDN_DP_PRIVATE                                     0x49


//static const char *ISDN_PROTOS[]={"UNKNOWN","NI2","DMS100","LUCENT5E","ATT4ESS","EUROISDN_E1","EUROISDN_T1","NI1","GR303_EOC","GR303_TMC"};

/* Maximum number of ports for each type of card */
#define VPB_CHANS_OL	4
#define VPB_MAX_OL_CD	14
#define VPB_MAX_OL_CH	VPB_CHANS_OL*VPB_MAX_OL_CD
#define VPB_CHANS_OP	32
#define VPB_MAX_OP_CARD	10
#define VPB_MAX_OP_CH	VPB_MAX_OP_CARD*VPB_CHANS_OP


/* Conf file type defns */
#define VPB_CONF_GEN	0
#define VPB_CONF_OL	1
#define VPB_CONF_OP	3
#define VPB_CONF_OLG	4

/* defines to note what has been set from the config file */
#define	MOD_BALS	(1<<0)
#define MOD_HWPG	(1<<1)
#define MOD_HWRG	(1<<2)
#define MOD_PG		(1<<3)
#define MOD_RG		(1<<4)

/* Value selected by fair dice rolls */
#define OPRI_NAME_LEN	28

/* Primary rate interface definition*/
typedef struct {
	int channel;
	int encoding; /* What audio encoding the channel is using */
	unsigned char name[OPRI_NAME_LEN];
	unsigned char card[OPRI_NAME_LEN];
} PRI_IFACE;

/* Open Pri card specific config information */
typedef struct {
	unsigned char name[OPRI_NAME_LEN];
	int if_type; /* E1 or T1 */
	int d_channel; /* Where the d-channel is */
	int protocol; /* What ISDN protocol the d-channel is using */
//	int encoding;	/* What audio encoding the card is using *** now in channel *** */
	int node;	/* Are we Network or Client end */
	int priverbose; /* What verboseness to set the libpri */
	int dialplan; /* What dialplan type for number dialled*/
	int localdialplan; /* What dialplan type for number dialling */
	float hw_play_gain;
	float hw_rec_gain;
	float play_gain;
	float rec_gain;
	int settings;
	PRI_IFACE iface[31+1]; /* Each channel interface, including the d-channel */
} OP_CARD;

/* Analogue interface definition*/
struct ANA_IFACE {
	float hw_play_gain;
	float hw_rec_gain;
	float play_gain;
	float rec_gain;
	unsigned short codec_hyb_bal1;
	unsigned short codec_hyb_bal2;
	unsigned short codec_hyb_bal3;
	int settings;

	ANA_IFACE() : settings(0) {}
};

struct OL_CARD
{
	typedef std::vector<OL_CARD>    List;

	int cardnum;
	int type;
	ANA_IFACE iface[VPB_CHANS_OL];
};

/* Open Line specific config information */
typedef struct {
	int cards;
	OL_CARD card[VPB_MAX_OL_CD];
} OL_INFO;

/* Open Pri specific config information */
typedef struct {
	int channels;
	int cards;
	OP_CARD card[VPB_MAX_OP_CARD+1];
} OP_INFO;

struct VTCORE_CARD
{
	typedef std::vector<VTCORE_CARD>    List;

	int cardnum;
	int type;
	void *config;
};

struct VTCORE_INFO {
	int cards;
	VTCORE_CARD *card;

	VTCORE_INFO()
		: card( 0 )
	{}

	~VTCORE_INFO()
	{
		delete [] card;
	}
};


/* Tone detectors */
typedef struct {
	char defn[128];
	char type[3];
	int freq1;
	int band1;
	int ton;
	int toff;
	int freq2;
	int band2;
	int snr;
	int twist;
} TONE_INFO;

typedef struct {
	int	type;
	int	number;
} CARD_LIST;

/* Conf definition */
struct CONF_INFO
{
	OL_INFO	     OpenLine;
	OP_INFO	     OpenPri;
	VTCORE_INFO  vtcore;
	int          country_code;
	int          tone_count;
	TONE_INFO    tones[10];
	int          verbosity;
	unsigned int cardcount;
	CARD_LIST    cards[254];
};

int vpb_read_conf(CONF_INFO * conf_pointer, char * file_name, int file_type);
llc_list *vpb_read_confll(CONF_INFO * cp);

//! Return info from a procfs @a node to a @a buffer of fized @a size.
bool GetProcfsInfo(const char *node, char *buffer, size_t size);

//XXX This one is of much more limited usefulness, by default the process
//    needs root privs to write to the proc nodes, and to change that usefully
//    people would need to specify a gid parameter to the kernel module. It
//    would have to be specified explicitly for each distro since we must use
//    gid_t and not a name, and there is no standard gid_t to name mapping we
//    can use.  Better to just do writes though a device node then which gives
//    a single point of device control permission selection via the udev rules.
// Write a new @a value of @a len bytes to a procfs @a node
//bool SetProcfsInfo(const char *node, const char *value, size_t len);

#endif

