/*=========================================================================

  Program:   Visualization Toolkit
  Module:    $RCSfile: vtkLongArray.cxx,v $

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// Instantiate superclass first to give the template a DLL interface.
#include "vtkDataArrayTemplate.txx"
VTK_DATA_ARRAY_TEMPLATE_INSTANTIATE(long);

#define __vtkLongArray_cxx
#include "vtkLongArray.h"

#include "vtkObjectFactory.h"

//----------------------------------------------------------------------------
vtkCxxRevisionMacro(vtkLongArray, "$Revision: 1.36 $");
vtkStandardNewMacro(vtkLongArray);

//----------------------------------------------------------------------------
vtkLongArray::vtkLongArray(vtkIdType numComp): RealSuperclass(numComp)
{
}

//----------------------------------------------------------------------------
vtkLongArray::~vtkLongArray()
{
}

//----------------------------------------------------------------------------
void vtkLongArray::PrintSelf(ostream& os, vtkIndent indent)
{
  this->RealSuperclass::PrintSelf(os,indent);
}
