/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.util;

import org.web3d.vrml.util.Xj3DKeyEvent;

public class KeySequence {
    private static final int DEFAULT_INITIAL_CAPACITY = 128;
    private static final int INCREMENT_SIZE = 16;
    private Object mutex = new Object();
    protected int index = 0;
    protected Xj3DKeyEvent[] eventArray;

    public KeySequence() {
        this(128);
    }

    public KeySequence(int n) {
        this.eventArray = new Xj3DKeyEvent[n];
    }

    public Xj3DKeyEvent get(int n) {
        return this.eventArray[n];
    }

    public int size() {
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Xj3DKeyEvent xj3DKeyEvent) {
        if (this.index == this.eventArray.length) {
            this.ensureCapacity(this.index + 16);
        }
        Object object = this.mutex;
        synchronized (object) {
            this.eventArray[this.index++] = xj3DKeyEvent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.index > 0) {
            Object object = this.mutex;
            synchronized (object) {
                for (int i = this.index - 1; i >= 0; --i) {
                    this.eventArray[i] = null;
                }
                this.index = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transfer(KeySequence keySequence) {
        keySequence.clear();
        if (keySequence.eventArray.length < this.index) {
            keySequence.ensureCapacity(this.index);
        }
        if (this.index > 0) {
            Object object = this.mutex;
            synchronized (object) {
                for (int i = this.index - 1; i >= 0; --i) {
                    keySequence.eventArray[i] = this.eventArray[i];
                    this.eventArray[i] = null;
                }
                keySequence.index = this.index;
                this.index = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCapacity(int n) {
        int n2 = this.eventArray.length;
        if (n2 < n) {
            while (n2 < n) {
                n2 += 16;
            }
            Object object = this.mutex;
            synchronized (object) {
                Xj3DKeyEvent[] xj3DKeyEventArray = new Xj3DKeyEvent[n2];
                if (this.index > 0) {
                    System.arraycopy(this.eventArray, 0, xj3DKeyEventArray, 0, this.index);
                }
                this.eventArray = xj3DKeyEventArray;
            }
        }
    }
}

