/*=========================================================================

  Program:   Visualization Toolkit
  Module:    $RCSfile: vtkQtTreeView.cxx,v $

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/*-------------------------------------------------------------------------
  Copyright 2008 Sandia Corporation.
  Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
  the U.S. Government retains certain rights in this software.
-------------------------------------------------------------------------*/

#include "vtkQtTreeView.h"

#include <QTreeView>

#include "vtkTree.h"
#include "vtkQtTreeModelAdapter.h"
#include "vtkObjectFactory.h"

vtkCxxRevisionMacro(vtkQtTreeView, "$Revision: 1.2 $");
vtkStandardNewMacro(vtkQtTreeView);

//----------------------------------------------------------------------------
vtkQtTreeView::vtkQtTreeView()
{
  // Create an internal view and adapter
  // Either of these can be overwritten 
  // through the API.
  this->TreeViewPtr = new QTreeView;
  this->TreeAdapterPtr = new vtkQtTreeModelAdapter();
  
  // Set up the tree view and adapter
  this->SetItemView(this->TreeViewPtr);
  this->SetItemModelAdapter(this->TreeAdapterPtr);
  
  this->IOwnTreeView = true;
  this->IOwnTreeAdapter = true;
}

//----------------------------------------------------------------------------
vtkQtTreeView::~vtkQtTreeView()
{
  if (this->IOwnTreeView)
    {
    delete this->TreeViewPtr;
    }
  if (this->IOwnTreeAdapter)
    {
    delete this->TreeAdapterPtr;
    }
}

//----------------------------------------------------------------------------
void vtkQtTreeView::SetItemView(QAbstractItemView *qiv)
{
  if (qiv != this->TreeViewPtr)
    {
    // Delete my copy
    delete this->TreeViewPtr;
    
    // Mark that I no longer own the view
    this->IOwnTreeView = false;    
    }
  
  // Set up my internals to point to the new view
  this->Superclass::SetItemView(qiv);
}

//----------------------------------------------------------------------------
void vtkQtTreeView::SetItemModelAdapter(vtkQtAbstractModelAdapter* qma)
{
  if (qma != this->TreeAdapterPtr)
    {
    // Delete my copy
    delete this->TreeAdapterPtr;
    
    // Mark that I no longer own the adapter
    this->IOwnTreeAdapter = false;
    }
  
  // Set up my internals to point to the new adapter
  this->Superclass::SetItemModelAdapter(qma);
}

//----------------------------------------------------------------------------
void vtkQtTreeView::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os,indent);
}

