// WP_TRAY_UTIL.H //////////////////////////////////////////////////////
//
// Author:				E^rthW( )rm 2003
// Last Mod:			Friday, September 05 2003
// About:				Utilities for directory recursion
//						and regular expression checks
// License:			GPL

// defines /////////////////////////////////////////////////////////////
//
#define ERROR_DIR_NOT_FOUND		-1
#define ERROR_DIR_NO_ACCESS		-2
#define ERROR_DIR_UNKNOWN		-3

// pass in the path to the a search directory and a pointer to a
// zeroed integer to count regular files
gint
f_count_dir_entries				(gchar *sz_dir, gint *p_dir_count);

// get the name of the file entry given a directory to search
// and the numerical index of the file entry
gchar *
f_get_dir_entry					(gchar *sz_dir, gint *p_dir_trgt, gchar **sz_dir_trgt);

// match a string to a regular expression
gboolean
f_reg_exp_match					(const gchar *string, const gchar *pattern);

// return a list of the directory entries matching a regular expression
GList *
f_get_dir_regex_match_list		(gchar *sz_dir, const gchar *sz_regex, GList **ls_result);

// select a wallpaper at random from the current dir list
gboolean
f_set_rand_wallpaper			(GtkWidget *button, gpointer user_data);
