var webdeveloper_styleElement = null;

// Output style information for an element
function webdeveloper_outputStyleInformationForElement(displayInDashboard, styleSheetArray, title)
{
    var bodyElement           = null;
    var cssElement            = null;
    var divElement            = null;
    var generatedDocument     = null;
    var headElement           = null;
    var headerElement         = null;
    var linkElement           = null;
    var preElement            = null;
    var spanElement           = null;
    var stringBundle          = document.getElementById("webdeveloper-string-bundle");
    var styleInformationFound = false;
    var styleSheet            = null;

    // If displaying in the dashboard
    if(displayInDashboard)
    {
        var parent = null;

        generatedDocument = webdeveloper_getDocumentInDashboard(stringBundle.getString("webdeveloper_styleInformation"));
        bodyElement       = webdeveloper_getDocumentBodyElement(generatedDocument);
        headElement       = webdeveloper_getDocumentHeadElement(generatedDocument);

        webdeveloper_removeAllChildElements(bodyElement);
        webdeveloper_removeAllChildElements(headElement);
    }
    else
    {
        generatedDocument = webdeveloper_generateDocument("");
        bodyElement       = webdeveloper_getDocumentBodyElement(generatedDocument);
        headElement       = webdeveloper_getDocumentHeadElement(generatedDocument);
        headerElement     = generatedDocument.createElement("h1");

        headerElement.appendChild(generatedDocument.createTextNode(title));
        bodyElement.appendChild(headerElement);
    }

    generatedDocument.title = title;
    linkElement             = generatedDocument.createElement("link");

    webdeveloper_addGeneratedStyles(generatedDocument);

    linkElement.setAttribute("href", "chrome://webdeveloper/content/stylesheets/generated/view_style_information.css");
    linkElement.setAttribute("rel", "stylesheet");
    linkElement.setAttribute("type", "text/css");
    headElement.appendChild(linkElement);

    // Loop through the style sheets
    for(styleSheet in styleSheetArray)
    {
        cssElement            = generatedDocument.createElement("div");
        divElement            = generatedDocument.createElement("div");
        headerElement         = generatedDocument.createElement("h2");
        linkElement           = generatedDocument.createElement("a");
        spanElement           = generatedDocument.createElement("span");
        styleInformationFound = true;

        spanElement.setAttribute("class", "expanded pivot");
        headerElement.appendChild(spanElement);
        linkElement.setAttribute("href", styleSheet);
        linkElement.appendChild(generatedDocument.createTextNode(styleSheet));
        headerElement.appendChild(linkElement);
        bodyElement.appendChild(headerElement);

        cssElement.setAttribute("class", "css");
        divElement.setAttribute("class", "output");
        divElement.appendChild(cssElement);
        bodyElement.appendChild(divElement);

        cssElement.innerHTML = styleSheetArray[styleSheet];
    }

    // If style information was found
    if(styleInformationFound)
    {
        var scriptElement = generatedDocument.createElement("script");

        scriptElement.setAttribute("defer", "defer");
        scriptElement.setAttribute("src", "chrome://webdeveloper/content/common/xpath.js");
        scriptElement.setAttribute("type", "text/javascript");
        headElement.appendChild(scriptElement);

        scriptElement = generatedDocument.createElement("script");

        scriptElement.setAttribute("defer", "defer");
        scriptElement.setAttribute("src", "chrome://webdeveloper/content/generated/output_pivot.js");
        scriptElement.setAttribute("type", "text/javascript");
        headElement.appendChild(scriptElement);
    }
    else
    {
        var pElement = generatedDocument.createElement("p");

        pElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_noStyleInformation")));
        bodyElement.appendChild(pElement);
    }
}

// View style information
function webdeveloper_viewStyleInformation(element)
{
    // If the DOM Inspector is available
    if(webdeveloper_isDOMInspectorAvailable())
    {
        var checked        = true;
        var contentWindow  = webdeveloper_getContentWindow();
        var documentList   = webdeveloper_getDocuments(contentWindow);
        var documentLength = documentList.length;
        var pageDocument   = null;

        // If the element is set
        if(element)
        {
            checked = webdeveloper_convertToBoolean(element.getAttribute("checked"));
        }
        else
        {
            var currentDocument = contentWindow.document;

            element = document.getElementById("webdeveloper-view-style-information-menu");

            // If the view style information element is set
            if(currentDocument.getElementById("webdeveloper-view-style-information"))
            {
                checked = false;
            }

            webdeveloper_configureElement(element, "checked", checked);
        }

        webdeveloper_configureElement(document.getElementById("webdeveloper-information-text-toolbar"), "hidden", !checked);

        // Loop through the documents
        for(var i = 0; i < documentLength; i++)
        {
            pageDocument = documentList[i];

            // If viewing style information
            if(checked)
            {
                pageDocument.addEventListener("click", webdeveloper_viewStyleInformationForElement, true);
                pageDocument.addEventListener("keypress", webdeveloper_viewStyleInformationKeyPress, false);
                pageDocument.addEventListener("mousemove", webdeveloper_viewStyleInformationMouseMove, false);
                pageDocument.addEventListener("mouseover", webdeveloper_viewStyleInformationMouseOver, false);
            }
            else
            {
                var title = document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_styleInformation");

                // Try to remove the event listener
                try
                {
                    pageDocument.removeEventListener("click", webdeveloper_viewStyleInformationForElement, true);
                }
                catch(exception)
                {
                    // Do nothing
                }

                // Try to remove the event listener
                try
                {
                    pageDocument.removeEventListener("keypress", webdeveloper_viewStyleInformationKeyPress, false);
                }
                catch(exception)
                {
                    // Do nothing
                }

                // Try to remove the event listener
                try
                {
                    pageDocument.removeEventListener("mousemove", webdeveloper_viewStyleInformationMouseMove, false);
                }
                catch(exception)
                {
                    // Do nothing
                }

                // Try to remove the event listener
                try
                {
                    pageDocument.removeEventListener("mouseover", webdeveloper_viewStyleInformationMouseOver, false);
                }
                catch(exception)
                {
                    // Do nothing
                }

                // If view style information is open in the dashboard
                if(webdeveloper_isOpenInDashboard(title))
                {
                    webdeveloper_closeInDashboard(title);
                }

                webdeveloper_removeElementOutline(webdeveloper_styleElement);
            }
        }

        // If not viewing style information
        if(!checked)
        {
            webdeveloper_styleElement = null;
        }

        webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/view_style_information.css", "webdeveloper-view-style-information");
    }
    else
    {
        window.openDialog("chrome://webdeveloper/content/message/message.xul", "webdeveloper-message-dialog", "centerscreen,chrome,modal", document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_domInspectorRequired"), "@home.page@documentation/faq/#dom-inspector");
    }
}

// View style information for an element
function webdeveloper_viewStyleInformationForElement(event)
{
    var eventTarget = event.target;

    // If there is an event target and the click was not a right click
    if(eventTarget && event.button != 2)
    {
        var displayInDashboard = webdeveloper_getBooleanPreference("webdeveloper.style.information.dashboard", true);
        var domUtils           = Components.classes["@mozilla.org/inspector/dom-utils;1"].getService(Components.interfaces.inIDOMUtils);
        var elementRule        = null;
        var headerElement      = null;
        var line               = null;
        var oldURL             = getBrowser().currentURI.spec;
        var ruleList           = domUtils.getCSSStyleRules(eventTarget);
        var stringBundle       = document.getElementById("webdeveloper-string-bundle");
        var styleRule          = null;
        var styleRuleLength    = null;
        var styleRuleList      = null;
        var styleSheet         = null;
        var styleSheetArray    = new Array();
        var styleSheetHref     = null;
        var styleText          = null;

        // Loop through the element rules
        for(var i = 0; i < ruleList.Count(); i++)
        {
            elementRule = ruleList.GetElementAt(i).QueryInterface(Components.interfaces.nsIDOMCSSStyleRule);
            line        = domUtils.getRuleLine(elementRule);

            // If there is a parent style sheet
            if(elementRule.parentStyleSheet)
            {
                styleSheet = elementRule.parentStyleSheet;
            }

            // If this is a valid style sheet
            if(webdeveloper_isValidStyleSheet(styleSheet))
            {
                styleRuleList   = elementRule.style;
                styleRuleLength = styleRuleList.length;
                styleSheetHref  = styleSheet.href;
                styleText       = '<p class="selector">' + elementRule.selectorText + ' <span>(' + stringBundle.getString("webdeveloper_line").toLowerCase() + " " + line + ")</span></p>";

                styleText += "<p>{</p>";

                // Loop through the style rules
                for(var j = 0; j < styleRuleLength; j++)
                {
                    styleRule  = styleRuleList[j];

                    // If this is a valid style rule
                    if(webdeveloper_isValidStyleRule(styleRuleList, styleRule))
                    {
                        styleText += '<p class="rule"><span class="property">' + webdeveloper_formatStyleRuleProperty(styleRule) + '</span>: <span class="value">' + webdeveloper_formatStyleRuleValue(styleRuleList.getPropertyValue(styleRule)) + "</span>;</p>";
                    }
                }

                styleText += "<p>}</p>";

                // If this style sheet has rules already stored
                if(styleSheetArray[styleSheetHref])
                {
                    styleSheetArray[styleSheetHref] += styleText;
                }
                else
                {
                    styleSheetArray[styleSheetHref] = styleText;
                }
            }
        }

        // If displaying in the dashboard
        if(displayInDashboard)
        {
            var title = stringBundle.getString("webdeveloper_styleInformation");

            // If view style information is already open in the dashboard
            if(webdeveloper_isOpenInDashboard(title))
            {
                webdeveloper_outputStyleInformationForElement(displayInDashboard, styleSheetArray, stringBundle.getFormattedString("webdeveloper_viewStyleInformationTitle", [oldURL]));
                webdeveloper_selectInDashboard(title);
            }
            else
            {
                webdeveloper_openInDashboard(title, "");

                // This sets a small timeout to guarantee the dashboard is open
                window.setTimeout(webdeveloper_outputStyleInformationForElement, 500, displayInDashboard, styleSheetArray, stringBundle.getFormattedString("webdeveloper_viewStyleInformationTitle", [oldURL]));
            }
        }
        else
        {
            var oldTab = getBrowser().selectedTab;

            webdeveloper_outputStyleInformationForElement(displayInDashboard, styleSheetArray, stringBundle.getFormattedString("webdeveloper_viewStyleInformationTitle", [oldURL]));

            // If the open tabs in background preference is set to true
            if(webdeveloper_getBooleanPreference("webdeveloper.open.tabs.background", true))
            {
                getBrowser().selectedTab = oldTab;
            }
        }

        event.stopPropagation();
        event.preventDefault();
    }
}

// Keypress event for view style information
function webdeveloper_viewStyleInformationKeyPress(event)
{
    webdeveloper_copyElementAncestors(event);
}

// Move event for view style information
function webdeveloper_viewStyleInformationMouseMove(event)
{
    var outlineElement = webdeveloper_addElementOutline(event, webdeveloper_styleElement);

    // If the outline element is set
    if(outlineElement)
    {
        webdeveloper_styleElement = outlineElement;
    }
}

// Mouseover event for view style information
function webdeveloper_viewStyleInformationMouseOver(event)
{
    webdeveloper_displayElementAncestors(event);
}
