/*
 * Copyright (C) 2008 Nuanti Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "config.h"
#include "AXObjectCache.h"

#include "AccessibilityObject.h"
#include "AccessibilityObjectWrapperAtk.h"
#include "RenderObject.h"

#include "CString.h"

namespace WebCore {

void AXObjectCache::detachWrapper(AccessibilityObject* obj)
{
    webkit_accessible_detach(WEBKIT_ACCESSIBLE(obj->wrapper()));
}

void AXObjectCache::attachWrapper(AccessibilityObject* obj)
{
    AtkObject* atkObj = ATK_OBJECT(webkit_accessible_new(obj));
    obj->setWrapper(atkObj);
    g_object_unref(atkObj);
}

void AXObjectCache::postNotification(RenderObject* renderer, const String& message)
{
    printf("postNotification: %s\n", message.utf8().data());

    if (!renderer)
        return;

    // notifications for text input objects are sent to that object
    // all others are sent to the top WebArea
    RefPtr<AccessibilityObject> obj = get(renderer)->observableObject();
    if (!obj)
        obj = get(renderer->document()->renderer());

    if (!obj)
        return;

    if (message == "AXValueChanged") {
#if 0
        printf("emit\n");
        gint start = 0;
        gint length = obj->textLength();
        // TODO: signal detail
        g_signal_emit_by_name(obj->wrapper(), "text_changed::insert", start, length);
#endif
    } else if (message == "AXSelectedTextChanged") {
        printf("emit\n");
        // FIXME: This is only fired from SelectionControllerMac.mm
        g_signal_emit_by_name(obj->wrapper(), "text_selection_changed");
    }
}

void AXObjectCache::postNotificationToElement(RenderObject* renderer, const String& message)
{
    printf("postNotificationToElement: %s\n", message.utf8().data());

    // send the notification to the specified element itself, not one of its ancestors
    if (!renderer)
        return;

    RefPtr<AccessibilityObject> obj = get(renderer);
    if (!obj)
        return;

    if (message == "AXLoadComplete") {
        printf("emit\n");
        // FIXME: This is only fired from Document.cpp MAC
        g_signal_emit_by_name(obj->wrapper(), "load_complete");
    }

    // TODO: Cover the other loader signals supported by AtkDocument.
}

void AXObjectCache::handleFocusedUIElementChanged()
{
    // FIXME: This is fired only in MAC
    printf("handleFocusedUIElementChanged\n");

    //g_signal_emit_by_name(obj->wrapper(), "focus_event", TRUE);
}

} // namespace WebCore
