/*  This file is part of "xprintmon"
 *  Copyright (C) 2006 Bernhard R. Link
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02111-1301  USA
 */
#include <config.h>

#include <assert.h>
#include <stdbool.h>

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include "global.h"

static Atom wm_delete_window, wm_protocols;

static void popdownOnDelete(Widget widget UNUSED, XtPointer dummy UNUSED,
		XEvent *event UNUSED,
		Boolean *continue_to_dispatch) {
	XClientMessageEvent *clientmsg = (XClientMessageEvent *)event;

	if( event->type != ClientMessage || clientmsg->message_type != wm_protocols
			|| (Atom)clientmsg->data.l[0] != wm_delete_window ) {
		*continue_to_dispatch = True;
		return;
	}
	XtPopdown(widget);

	*continue_to_dispatch = False;
}
static void iconifyOnDelete(Widget widget UNUSED, XtPointer dummy UNUSED,
		XEvent *event UNUSED,
		Boolean *continue_to_dispatch) {
	XClientMessageEvent *clientmsg = (XClientMessageEvent *)event;

	if( event->type != ClientMessage || clientmsg->message_type != wm_protocols
			|| (Atom)clientmsg->data.l[0] != wm_delete_window ) {
		*continue_to_dispatch = True;
		return;
	}
	if( XtIsTopLevelShell(widget) )
		XtVaSetValues(widget,
				XtNiconic,	(XtPointer)True,
				NULL);

	*continue_to_dispatch = False;
}
static void destroyOnDelete(Widget widget UNUSED, XtPointer dummy UNUSED,
		XEvent *event UNUSED,
		Boolean *continue_to_dispatch) {
	XClientMessageEvent *clientmsg = (XClientMessageEvent *)event;

	if( event->type != ClientMessage || clientmsg->message_type != wm_protocols
			|| (Atom)clientmsg->data.l[0] != wm_delete_window ) {
		*continue_to_dispatch = True;
		return;
	}
	XtDestroyWidget(widget);

	*continue_to_dispatch = False;
}

void setDeleteHandler(Widget shell, enum wmDeleteAction action) {
	XtEventHandler proc;

	assert(wm_delete_window != 0);
	proc = destroyOnDelete;
	switch( action ) {
		case wmdDestroy:
			proc = destroyOnDelete;
			break;
		case wmdIconify:
			assert(XtIsTopLevelShell(shell));
			proc = iconifyOnDelete;
			break;
		case wmdPopdown:
			proc = popdownOnDelete;
			break;
	}
	XSetWMProtocols(XtDisplay(shell), XtWindow(shell),
			&wm_delete_window, (Cardinal)1);
	XtAddEventHandler(shell, NoEventMask, True, proc, NULL);
}
void initDeleteProtocol(Display *display) {
	wm_protocols = XInternAtom(display, "WM_PROTOCOLS", False);
	wm_delete_window = XInternAtom(display, "WM_DELETE_WINDOW", False);
}
