/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INIFILE_H
#define INIFILE_H

#include <qlist.h>
#include <qstring.h>

#include "TextFile.h"

class IniFile : private TextFile
{
    struct Entry
    {
        QString key, value;
        Entry(const char* newKey, const char* newValue)
        {
            key = newKey;
            value = newValue;
        }
    };
    
    struct Group
    {
        QString name;
        QList<Entry> entries;
        Group(const char* newName)
        {
            name = newName;
            entries.setAutoDelete(true);
        }
    };
    
 public:  // --------------------------------------------------------- public

    IniFile(const int maxLineLen = 4096);
    virtual ~IniFile();

    bool load(const char* fileName);
    bool save(const char* fileName);

    void setHeader(const char* comment);
    
    void setGroup(const char* name);

    void setEntry(const char* key, const char* value);
    void setEntry(const char* key, float);
    void setEntry(const char* key, int);
    void setEntry(const char* key, long int);
    
    bool getValue(const char* key, QString& value);
    bool getValue(const char* key, bool& value);
    bool getValue(const char* key, float& value);
    bool getValue(const char* key, int& value);
    bool getValue(const char* key, long int& value);

    const QString& getString(const char* key);
    bool getBool(const char* key);
    long int getLongInt(const char* key);

    // Run a check and active current group or entry, respectively.
    bool haveGroup(const char* name);
    bool haveEntry(const char* key);

    void removeEntry(const char* key);
    
 private:
    QString configHeaderComment;
    QString empty;
    
    QList<Group> groups;
    Group* curGroup;

    Entry* curEntry;
    
    // Prevent copying.
    IniFile(const IniFile&);
    IniFile& operator=(IniFile&);  
};

#endif  /* INIFILE_H */
