/* extension-collection.c generated by valac 0.14.0, the Vala compiler
 * generated from extension-collection.vala, do not modify */

/* extension-collection.vala
 *
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>


#define ZEITGEIST_TYPE_EXTENSION_COLLECTION (zeitgeist_extension_collection_get_type ())
#define ZEITGEIST_EXTENSION_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollection))
#define ZEITGEIST_EXTENSION_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollectionClass))
#define ZEITGEIST_IS_EXTENSION_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EXTENSION_COLLECTION))
#define ZEITGEIST_IS_EXTENSION_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EXTENSION_COLLECTION))
#define ZEITGEIST_EXTENSION_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollectionClass))

typedef struct _ZeitgeistExtensionCollection ZeitgeistExtensionCollection;
typedef struct _ZeitgeistExtensionCollectionClass ZeitgeistExtensionCollectionClass;
typedef struct _ZeitgeistExtensionCollectionPrivate ZeitgeistExtensionCollectionPrivate;

#define ZEITGEIST_TYPE_EXTENSION (zeitgeist_extension_get_type ())
#define ZEITGEIST_EXTENSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EXTENSION, ZeitgeistExtension))
#define ZEITGEIST_EXTENSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EXTENSION, ZeitgeistExtensionClass))
#define ZEITGEIST_IS_EXTENSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EXTENSION))
#define ZEITGEIST_IS_EXTENSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EXTENSION))
#define ZEITGEIST_EXTENSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EXTENSION, ZeitgeistExtensionClass))

typedef struct _ZeitgeistExtension ZeitgeistExtension;
typedef struct _ZeitgeistExtensionClass ZeitgeistExtensionClass;

#define ZEITGEIST_TYPE_ENGINE (zeitgeist_engine_get_type ())
#define ZEITGEIST_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngine))
#define ZEITGEIST_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngineClass))
#define ZEITGEIST_IS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_ENGINE))
#define ZEITGEIST_IS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_ENGINE))
#define ZEITGEIST_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngineClass))

typedef struct _ZeitgeistEngine ZeitgeistEngine;
typedef struct _ZeitgeistEngineClass ZeitgeistEngineClass;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

#define ZEITGEIST_TYPE_EXTENSION_LOADER (zeitgeist_extension_loader_get_type ())
#define ZEITGEIST_EXTENSION_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EXTENSION_LOADER, ZeitgeistExtensionLoader))
#define ZEITGEIST_EXTENSION_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EXTENSION_LOADER, ZeitgeistExtensionLoaderClass))
#define ZEITGEIST_IS_EXTENSION_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EXTENSION_LOADER))
#define ZEITGEIST_IS_EXTENSION_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EXTENSION_LOADER))
#define ZEITGEIST_EXTENSION_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EXTENSION_LOADER, ZeitgeistExtensionLoaderClass))

typedef struct _ZeitgeistExtensionLoader ZeitgeistExtensionLoader;
typedef struct _ZeitgeistExtensionLoaderClass ZeitgeistExtensionLoaderClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ZEITGEIST_TYPE_EVENT (zeitgeist_event_get_type ())
#define ZEITGEIST_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEvent))
#define ZEITGEIST_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))
#define ZEITGEIST_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))

typedef struct _ZeitgeistEvent ZeitgeistEvent;
typedef struct _ZeitgeistEventClass ZeitgeistEventClass;

#define ZEITGEIST_TYPE_BUILTIN_EXTENSION (zeitgeist_builtin_extension_get_type ())
#define ZEITGEIST_BUILTIN_EXTENSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_BUILTIN_EXTENSION, ZeitgeistBuiltinExtension))
#define ZEITGEIST_BUILTIN_EXTENSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_BUILTIN_EXTENSION, ZeitgeistBuiltinExtensionClass))
#define ZEITGEIST_IS_BUILTIN_EXTENSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_BUILTIN_EXTENSION))
#define ZEITGEIST_IS_BUILTIN_EXTENSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_BUILTIN_EXTENSION))
#define ZEITGEIST_BUILTIN_EXTENSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_BUILTIN_EXTENSION, ZeitgeistBuiltinExtensionClass))

typedef struct _ZeitgeistBuiltinExtension ZeitgeistBuiltinExtension;
typedef struct _ZeitgeistBuiltinExtensionClass ZeitgeistBuiltinExtensionClass;
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define ZEITGEIST_TYPE_MODULE_LOADER (zeitgeist_module_loader_get_type ())
#define ZEITGEIST_MODULE_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_MODULE_LOADER, ZeitgeistModuleLoader))
#define ZEITGEIST_MODULE_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_MODULE_LOADER, ZeitgeistModuleLoaderClass))
#define ZEITGEIST_IS_MODULE_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_MODULE_LOADER))
#define ZEITGEIST_IS_MODULE_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_MODULE_LOADER))
#define ZEITGEIST_MODULE_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_MODULE_LOADER, ZeitgeistModuleLoaderClass))

typedef struct _ZeitgeistModuleLoader ZeitgeistModuleLoader;
typedef struct _ZeitgeistModuleLoaderClass ZeitgeistModuleLoaderClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ZeitgeistExtensionCollection {
	GObject parent_instance;
	ZeitgeistExtensionCollectionPrivate * priv;
};

struct _ZeitgeistExtensionCollectionClass {
	GObjectClass parent_class;
};

struct _ZeitgeistExtensionCollectionPrivate {
	GPtrArray* extensions;
	gchar** disabled_extensions;
	gint disabled_extensions_length1;
	gint _disabled_extensions_size_;
	ZeitgeistEngine* _engine;
};

typedef GType (*ZeitgeistRegisterExtensionFunc) (GTypeModule* module);

static gpointer zeitgeist_extension_collection_parent_class = NULL;

GType zeitgeist_extension_collection_get_type (void) G_GNUC_CONST;
GType zeitgeist_extension_get_type (void) G_GNUC_CONST;
GType zeitgeist_engine_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_EXTENSION_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollectionPrivate))
enum  {
	ZEITGEIST_EXTENSION_COLLECTION_DUMMY_PROPERTY,
	ZEITGEIST_EXTENSION_COLLECTION_ENGINE
};
static void _zeitgeist_extension_collection___lambda3_ (ZeitgeistExtensionCollection* self, ZeitgeistExtension* ext);
void zeitgeist_extension_unload (ZeitgeistExtension* self);
static void __zeitgeist_extension_collection___lambda3__gfunc (gconstpointer data, gpointer self);
ZeitgeistExtensionCollection* zeitgeist_extension_collection_new (ZeitgeistEngine* engine);
ZeitgeistExtensionCollection* zeitgeist_extension_collection_construct (GType object_type, ZeitgeistEngine* engine);
GType zeitgeist_extension_loader_get_type (void) G_GNUC_CONST;
static ZeitgeistExtension* zeitgeist_extension_collection_instantiate_extension (ZeitgeistExtensionCollection* self, ZeitgeistExtensionLoader* loader);
GType zeitgeist_extension_loader_get_extension_type (ZeitgeistExtensionLoader* self);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
ZeitgeistExtension* zeitgeist_extension_loader_create_instance (ZeitgeistExtensionLoader* self, ZeitgeistEngine* engine);
ZeitgeistEngine* zeitgeist_extension_collection_get_engine (ZeitgeistExtensionCollection* self);
gchar** zeitgeist_extension_collection_get_extension_names (ZeitgeistExtensionCollection* self, int* result_length1);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
GType zeitgeist_event_get_type (void) G_GNUC_CONST;
void zeitgeist_extension_collection_call_pre_insert_events (ZeitgeistExtensionCollection* self, GPtrArray* events, const char* sender);
void zeitgeist_extension_pre_insert_events (ZeitgeistExtension* self, GPtrArray* events, const char* sender);
void zeitgeist_extension_collection_call_post_insert_events (ZeitgeistExtensionCollection* self, GPtrArray* events, const char* sender);
void zeitgeist_extension_post_insert_events (ZeitgeistExtension* self, GPtrArray* events, const char* sender);
guint32* zeitgeist_extension_collection_call_pre_delete_events (ZeitgeistExtensionCollection* self, guint32* event_ids, int event_ids_length1, const char* sender, int* result_length1);
guint32* zeitgeist_extension_pre_delete_events (ZeitgeistExtension* self, guint32* ids, int ids_length1, const char* sender, int* result_length1);
void zeitgeist_extension_collection_call_post_delete_events (ZeitgeistExtensionCollection* self, guint32* event_ids, int event_ids_length1, const char* sender);
void zeitgeist_extension_post_delete_events (ZeitgeistExtension* self, guint32* ids, int ids_length1, const char* sender);
static void zeitgeist_extension_collection_set_engine (ZeitgeistExtensionCollection* self, ZeitgeistEngine* value);
static GObject * zeitgeist_extension_collection_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
GType zeitgeist_data_source_registry_init (GTypeModule* mod);
static GType _zeitgeist_data_source_registry_init_zeitgeist_register_extension_func (GTypeModule* module);
GType zeitgeist_blacklist_init (GTypeModule* mod);
static GType _zeitgeist_blacklist_init_zeitgeist_register_extension_func (GTypeModule* module);
GType zeitgeist_histogram_init (GTypeModule* mod);
static GType _zeitgeist_histogram_init_zeitgeist_register_extension_func (GTypeModule* module);
GType zeitgeist_storage_monitor_init (GTypeModule* mod);
static GType _zeitgeist_storage_monitor_init_zeitgeist_register_extension_func (GTypeModule* module);
GType zeitgeist_fts_init (GTypeModule* mod);
static GType _zeitgeist_fts_init_zeitgeist_register_extension_func (GTypeModule* module);
GType zeitgeist_benchmark_init (GTypeModule* mod);
static GType _zeitgeist_benchmark_init_zeitgeist_register_extension_func (GTypeModule* module);
ZeitgeistBuiltinExtension* zeitgeist_builtin_extension_new (ZeitgeistRegisterExtensionFunc func);
ZeitgeistBuiltinExtension* zeitgeist_builtin_extension_construct (GType object_type, ZeitgeistRegisterExtensionFunc func);
GType zeitgeist_builtin_extension_get_type (void) G_GNUC_CONST;
const gchar* zeitgeist_utils_get_local_extensions_path (void);
ZeitgeistModuleLoader* zeitgeist_module_loader_new (const gchar* module_path);
ZeitgeistModuleLoader* zeitgeist_module_loader_construct (GType object_type, const gchar* module_path);
GType zeitgeist_module_loader_get_type (void) G_GNUC_CONST;
static void zeitgeist_extension_collection_finalize (GObject* obj);
static void _vala_zeitgeist_extension_collection_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_zeitgeist_extension_collection_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _zeitgeist_extension_collection___lambda3_ (ZeitgeistExtensionCollection* self, ZeitgeistExtension* ext) {
	ZeitgeistExtension* _tmp0_;
	g_return_if_fail (ext != NULL);
	_tmp0_ = ext;
	zeitgeist_extension_unload (_tmp0_);
}


static void __zeitgeist_extension_collection___lambda3__gfunc (gconstpointer data, gpointer self) {
	_zeitgeist_extension_collection___lambda3_ (self, data);
}


ZeitgeistExtensionCollection* zeitgeist_extension_collection_construct (GType object_type, ZeitgeistEngine* engine) {
	ZeitgeistExtensionCollection * self = NULL;
	ZeitgeistEngine* _tmp0_;
	g_return_val_if_fail (engine != NULL, NULL);
	_tmp0_ = engine;
	self = (ZeitgeistExtensionCollection*) g_object_new (object_type, "engine", _tmp0_, NULL);
	return self;
}


ZeitgeistExtensionCollection* zeitgeist_extension_collection_new (ZeitgeistEngine* engine) {
	return zeitgeist_extension_collection_construct (ZEITGEIST_TYPE_EXTENSION_COLLECTION, engine);
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static ZeitgeistExtension* zeitgeist_extension_collection_instantiate_extension (ZeitgeistExtensionCollection* self, ZeitgeistExtensionLoader* loader) {
	ZeitgeistExtension* result = NULL;
	ZeitgeistExtensionLoader* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (loader != NULL, NULL);
	_tmp0_ = loader;
	_tmp1_ = g_type_module_use ((GTypeModule*) _tmp0_);
	if (_tmp1_) {
		ZeitgeistExtensionLoader* _tmp2_;
		GType _tmp3_;
		GType _tmp4_;
		const gchar* _tmp5_ = NULL;
		const gchar* type_name;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gboolean _tmp8_ = FALSE;
		const gchar* _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gboolean enabled;
		gboolean _tmp12_;
		ZeitgeistExtension* _tmp14_ = NULL;
		gboolean _tmp15_;
		ZeitgeistExtension* _tmp19_;
		ZeitgeistExtension* _tmp20_;
		ZeitgeistExtension* e;
		ZeitgeistExtensionLoader* _tmp21_;
		_tmp2_ = loader;
		_tmp3_ = zeitgeist_extension_loader_get_extension_type (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_type_name (_tmp4_);
		type_name = _tmp5_;
		_tmp6_ = type_name;
		if (_tmp6_ == NULL) {
			result = NULL;
			return result;
		}
		_tmp7_ = type_name;
		_tmp8_ = g_str_has_prefix (_tmp7_, "Zeitgeist");
		if (_tmp8_) {
			const gchar* _tmp9_;
			_tmp9_ = type_name;
			type_name = (const gchar*) (((gchar*) _tmp9_) + 9);
		}
		_tmp10_ = type_name;
		_tmp11_ = self->priv->disabled_extensions;
		_tmp11__length1 = self->priv->disabled_extensions_length1;
		enabled = !_vala_string_array_contains (_tmp11_, _tmp11__length1, _tmp10_);
		_tmp12_ = enabled;
		if (!_tmp12_) {
			const gchar* _tmp13_;
			_tmp13_ = type_name;
			g_message ("extension-collection.vala:121: Skipping %s (disabled)", _tmp13_);
		}
		_tmp15_ = enabled;
		if (_tmp15_) {
			ZeitgeistExtensionLoader* _tmp16_;
			ZeitgeistEngine* _tmp17_;
			ZeitgeistExtension* _tmp18_ = NULL;
			_tmp16_ = loader;
			_tmp17_ = self->priv->_engine;
			_tmp18_ = zeitgeist_extension_loader_create_instance (_tmp16_, _tmp17_);
			_g_object_unref0 (_tmp14_);
			_tmp14_ = _tmp18_;
		} else {
			_g_object_unref0 (_tmp14_);
			_tmp14_ = NULL;
		}
		_tmp19_ = _tmp14_;
		_tmp20_ = _g_object_ref0 (_tmp19_);
		e = _tmp20_;
		_tmp21_ = loader;
		g_type_module_unuse ((GTypeModule*) _tmp21_);
		result = e;
		_g_object_unref0 (_tmp14_);
		return result;
	}
	result = NULL;
	return result;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar** zeitgeist_extension_collection_get_extension_names (ZeitgeistExtensionCollection* self, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** _result_;
	gint _result__length1;
	gint __result__size_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_result_ = _tmp0_;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				GPtrArray* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				GPtrArray* _tmp8_;
				gint _tmp9_;
				gconstpointer _tmp10_ = NULL;
				GType _tmp11_ = 0UL;
				const gchar* _tmp12_ = NULL;
				const gchar* ext_name;
				const gchar* _tmp13_;
				gboolean _tmp14_ = FALSE;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = self->priv->extensions;
				_tmp6_ = g_ptr_array_get_length (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(_tmp4_ < _tmp7_)) {
					break;
				}
				_tmp8_ = self->priv->extensions;
				_tmp9_ = i;
				_tmp10_ = g_ptr_array_index (_tmp8_, (guint) _tmp9_);
				_tmp11_ = G_TYPE_FROM_INSTANCE ((GObject*) ((ZeitgeistExtension*) _tmp10_));
				_tmp12_ = g_type_name (_tmp11_);
				ext_name = _tmp12_;
				_tmp13_ = ext_name;
				_tmp14_ = g_str_has_prefix (_tmp13_, "Zeitgeist");
				if (_tmp14_) {
					gchar** _tmp15_;
					gint _tmp15__length1;
					const gchar* _tmp16_;
					gchar* _tmp17_ = NULL;
					_tmp15_ = _result_;
					_tmp15__length1 = _result__length1;
					_tmp16_ = ext_name;
					_tmp17_ = string_substring (_tmp16_, (glong) 9, (glong) (-1));
					_vala_array_add2 (&_result_, &_result__length1, &__result__size_, _tmp17_);
				} else {
					gchar** _tmp18_;
					gint _tmp18__length1;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					_tmp18_ = _result_;
					_tmp18__length1 = _result__length1;
					_tmp19_ = ext_name;
					_tmp20_ = g_strdup (_tmp19_);
					_vala_array_add3 (&_result_, &_result__length1, &__result__size_, _tmp20_);
				}
			}
		}
	}
	_tmp21_ = _result_;
	_tmp21__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp21__length1;
	}
	result = _tmp21_;
	return result;
}


void zeitgeist_extension_collection_call_pre_insert_events (ZeitgeistExtensionCollection* self, GPtrArray* events, const char* sender) {
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint num_events;
	gint _tmp15_;
	GPtrArray* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (events != NULL);
	_tmp0_ = events;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	num_events = _tmp2_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				GPtrArray* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				GPtrArray* _tmp10_;
				gint _tmp11_;
				gconstpointer _tmp12_ = NULL;
				GPtrArray* _tmp13_;
				const char* _tmp14_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = self->priv->extensions;
				_tmp8_ = g_ptr_array_get_length (_tmp7_);
				_tmp9_ = _tmp8_;
				if (!(_tmp6_ < _tmp9_)) {
					break;
				}
				_tmp10_ = self->priv->extensions;
				_tmp11_ = i;
				_tmp12_ = g_ptr_array_index (_tmp10_, (guint) _tmp11_);
				_tmp13_ = events;
				_tmp14_ = sender;
				zeitgeist_extension_pre_insert_events ((ZeitgeistExtension*) _tmp12_, _tmp13_, _tmp14_);
			}
		}
	}
	_tmp15_ = num_events;
	_tmp16_ = events;
	_tmp17_ = g_ptr_array_get_length (_tmp16_);
	_tmp18_ = _tmp17_;
	g_assert (_tmp15_ == _tmp18_);
}


void zeitgeist_extension_collection_call_post_insert_events (ZeitgeistExtensionCollection* self, GPtrArray* events, const char* sender) {
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint num_events;
	gint _tmp15_;
	GPtrArray* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (events != NULL);
	_tmp0_ = events;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	num_events = _tmp2_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				GPtrArray* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				GPtrArray* _tmp10_;
				gint _tmp11_;
				gconstpointer _tmp12_ = NULL;
				GPtrArray* _tmp13_;
				const char* _tmp14_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = self->priv->extensions;
				_tmp8_ = g_ptr_array_get_length (_tmp7_);
				_tmp9_ = _tmp8_;
				if (!(_tmp6_ < _tmp9_)) {
					break;
				}
				_tmp10_ = self->priv->extensions;
				_tmp11_ = i;
				_tmp12_ = g_ptr_array_index (_tmp10_, (guint) _tmp11_);
				_tmp13_ = events;
				_tmp14_ = sender;
				zeitgeist_extension_post_insert_events ((ZeitgeistExtension*) _tmp12_, _tmp13_, _tmp14_);
			}
		}
	}
	_tmp15_ = num_events;
	_tmp16_ = events;
	_tmp17_ = g_ptr_array_get_length (_tmp16_);
	_tmp18_ = _tmp17_;
	g_assert (_tmp15_ == _tmp18_);
}


guint32* zeitgeist_extension_collection_call_pre_delete_events (ZeitgeistExtensionCollection* self, guint32* event_ids, int event_ids_length1, const char* sender, int* result_length1) {
	guint32* result = NULL;
	guint32* _tmp16_;
	gint _tmp16__length1;
	guint32* _tmp17_;
	gint _tmp17__length1;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				GPtrArray* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				GPtrArray* _tmp7_;
				gint _tmp8_;
				gconstpointer _tmp9_ = NULL;
				guint32* _tmp10_;
				gint _tmp10__length1;
				const char* _tmp11_;
				gint _tmp12_ = 0;
				guint32* _tmp13_ = NULL;
				guint32* filtered_ids;
				gint filtered_ids_length1;
				gint _filtered_ids_size_;
				guint32* _tmp14_;
				gint _tmp14__length1;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->extensions;
				_tmp5_ = g_ptr_array_get_length (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp3_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->extensions;
				_tmp8_ = i;
				_tmp9_ = g_ptr_array_index (_tmp7_, (guint) _tmp8_);
				_tmp10_ = event_ids;
				_tmp10__length1 = event_ids_length1;
				_tmp11_ = sender;
				_tmp13_ = zeitgeist_extension_pre_delete_events ((ZeitgeistExtension*) _tmp9_, _tmp10_, _tmp10__length1, _tmp11_, &_tmp12_);
				filtered_ids = _tmp13_;
				filtered_ids_length1 = _tmp12_;
				_filtered_ids_size_ = filtered_ids_length1;
				_tmp14_ = filtered_ids;
				_tmp14__length1 = filtered_ids_length1;
				if (_tmp14_ != NULL) {
					guint32* _tmp15_;
					gint _tmp15__length1;
					_tmp15_ = filtered_ids;
					_tmp15__length1 = filtered_ids_length1;
					event_ids = _tmp15_;
					event_ids_length1 = _tmp15__length1;
				}
				filtered_ids = (g_free (filtered_ids), NULL);
			}
		}
	}
	_tmp16_ = event_ids;
	_tmp16__length1 = event_ids_length1;
	_tmp17_ = _tmp16_;
	_tmp17__length1 = _tmp16__length1;
	if (result_length1) {
		*result_length1 = _tmp17__length1;
	}
	result = _tmp17_;
	return result;
}


void zeitgeist_extension_collection_call_post_delete_events (ZeitgeistExtensionCollection* self, guint32* event_ids, int event_ids_length1, const char* sender) {
	g_return_if_fail (self != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				GPtrArray* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				GPtrArray* _tmp7_;
				gint _tmp8_;
				gconstpointer _tmp9_ = NULL;
				guint32* _tmp10_;
				gint _tmp10__length1;
				const char* _tmp11_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->extensions;
				_tmp5_ = g_ptr_array_get_length (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp3_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->extensions;
				_tmp8_ = i;
				_tmp9_ = g_ptr_array_index (_tmp7_, (guint) _tmp8_);
				_tmp10_ = event_ids;
				_tmp10__length1 = event_ids_length1;
				_tmp11_ = sender;
				zeitgeist_extension_post_delete_events ((ZeitgeistExtension*) _tmp9_, _tmp10_, _tmp10__length1, _tmp11_);
			}
		}
	}
}


ZeitgeistEngine* zeitgeist_extension_collection_get_engine (ZeitgeistExtensionCollection* self) {
	ZeitgeistEngine* result;
	ZeitgeistEngine* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_engine;
	result = _tmp0_;
	return result;
}


static void zeitgeist_extension_collection_set_engine (ZeitgeistExtensionCollection* self, ZeitgeistEngine* value) {
	ZeitgeistEngine* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_engine = _tmp0_;
	g_object_notify ((GObject *) self, "engine");
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static GType _zeitgeist_data_source_registry_init_zeitgeist_register_extension_func (GTypeModule* module) {
	GType result;
	result = zeitgeist_data_source_registry_init (module);
	return result;
}


static GType _zeitgeist_blacklist_init_zeitgeist_register_extension_func (GTypeModule* module) {
	GType result;
	result = zeitgeist_blacklist_init (module);
	return result;
}


static GType _zeitgeist_histogram_init_zeitgeist_register_extension_func (GTypeModule* module) {
	GType result;
	result = zeitgeist_histogram_init (module);
	return result;
}


static GType _zeitgeist_storage_monitor_init_zeitgeist_register_extension_func (GTypeModule* module) {
	GType result;
	result = zeitgeist_storage_monitor_init (module);
	return result;
}


static GType _zeitgeist_fts_init_zeitgeist_register_extension_func (GTypeModule* module) {
	GType result;
	result = zeitgeist_fts_init (module);
	return result;
}


static GType _zeitgeist_benchmark_init_zeitgeist_register_extension_func (GTypeModule* module) {
	GType result;
	result = zeitgeist_benchmark_init (module);
	return result;
}


static GObject * zeitgeist_extension_collection_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistExtensionCollection * self;
	ZeitgeistExtension* extension = NULL;
	GPtrArray* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* disabled;
	const gchar* _tmp2_;
	ZeitgeistRegisterExtensionFunc* _tmp6_ = NULL;
	ZeitgeistRegisterExtensionFunc* builtins;
	gint builtins_length1;
	gint _builtins_size_;
	ZeitgeistRegisterExtensionFunc* _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp16_ = NULL;
	const gchar* ext_dir1;
	const gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	GDir* user_ext_dir = NULL;
	GDir* _tmp24_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (zeitgeist_extension_collection_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ZEITGEIST_EXTENSION_COLLECTION (obj);
	_tmp0_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->extensions);
	self->priv->extensions = _tmp0_;
	_tmp1_ = g_getenv ("ZEITGEIST_DISABLED_EXTENSIONS");
	disabled = _tmp1_;
	_tmp2_ = disabled;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		gchar** _tmp4_;
		gchar** _tmp5_ = NULL;
		_tmp3_ = disabled;
		_tmp5_ = _tmp4_ = g_strsplit_set (_tmp3_, ",:;", 0);
		self->priv->disabled_extensions = (_vala_array_free (self->priv->disabled_extensions, self->priv->disabled_extensions_length1, (GDestroyNotify) g_free), NULL);
		self->priv->disabled_extensions = _tmp5_;
		self->priv->disabled_extensions_length1 = _vala_array_length (_tmp4_);
		self->priv->_disabled_extensions_size_ = self->priv->disabled_extensions_length1;
	}
	_tmp6_ = g_new0 (ZeitgeistRegisterExtensionFunc, 6);
	_tmp6_[0] = _zeitgeist_data_source_registry_init_zeitgeist_register_extension_func;
	_tmp6_[1] = _zeitgeist_blacklist_init_zeitgeist_register_extension_func;
	_tmp6_[2] = _zeitgeist_histogram_init_zeitgeist_register_extension_func;
	_tmp6_[3] = _zeitgeist_storage_monitor_init_zeitgeist_register_extension_func;
	_tmp6_[4] = _zeitgeist_fts_init_zeitgeist_register_extension_func;
	_tmp6_[5] = _zeitgeist_benchmark_init_zeitgeist_register_extension_func;
	builtins = _tmp6_;
	builtins_length1 = 6;
	_builtins_size_ = builtins_length1;
	_tmp7_ = builtins;
	_tmp7__length1 = builtins_length1;
	{
		ZeitgeistRegisterExtensionFunc* func_collection = NULL;
		gint func_collection_length1 = 0;
		gint _func_collection_size_ = 0;
		gint func_it = 0;
		func_collection = _tmp7_;
		func_collection_length1 = _tmp7__length1;
		for (func_it = 0; func_it < _tmp7__length1; func_it = func_it + 1) {
			ZeitgeistRegisterExtensionFunc func = NULL;
			func = func_collection[func_it];
			{
				ZeitgeistRegisterExtensionFunc _tmp8_;
				ZeitgeistBuiltinExtension* _tmp9_;
				ZeitgeistExtensionLoader* builtin;
				ZeitgeistExtensionLoader* _tmp10_;
				ZeitgeistExtension* _tmp11_ = NULL;
				ZeitgeistExtension* _tmp12_;
				_tmp8_ = func;
				_tmp9_ = zeitgeist_builtin_extension_new (_tmp8_);
				builtin = (ZeitgeistExtensionLoader*) _tmp9_;
				_tmp10_ = builtin;
				_tmp11_ = zeitgeist_extension_collection_instantiate_extension (self, _tmp10_);
				_g_object_unref0 (extension);
				extension = _tmp11_;
				_tmp12_ = extension;
				if (_tmp12_ != NULL) {
					GPtrArray* _tmp13_;
					ZeitgeistExtension* _tmp14_;
					ZeitgeistExtension* _tmp15_;
					_tmp13_ = self->priv->extensions;
					_tmp14_ = extension;
					_tmp15_ = _g_object_ref0 (_tmp14_);
					g_ptr_array_add (_tmp13_, _tmp15_);
				}
				_g_object_unref0 (builtin);
			}
		}
	}
	_tmp16_ = zeitgeist_utils_get_local_extensions_path ();
	ext_dir1 = _tmp16_;
	_tmp17_ = ext_dir1;
	_tmp18_ = g_file_test (_tmp17_, G_FILE_TEST_IS_DIR | G_FILE_TEST_EXISTS);
	if (!_tmp18_) {
		builtins = (g_free (builtins), NULL);
		_g_object_unref0 (extension);
		return obj;
	}
	{
		const gchar* _tmp19_;
		GDir* _tmp20_ = NULL;
		GDir* _tmp21_;
		_tmp19_ = ext_dir1;
		_tmp20_ = g_dir_open (_tmp19_, (guint) 0, &_inner_error_);
		_tmp21_ = _tmp20_;
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		_g_dir_close0 (user_ext_dir);
		user_ext_dir = _tmp21_;
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		const gchar* _tmp23_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		g_warning ("extension-collection.vala:83: Couldn't open local extensions directory" \
": %s", _tmp23_);
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_dir_close0 (user_ext_dir);
		builtins = (g_free (builtins), NULL);
		_g_object_unref0 (extension);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp24_ = user_ext_dir;
	if (_tmp24_ != NULL) {
		GDir* _tmp25_;
		const gchar* _tmp26_ = NULL;
		const gchar* file_name;
		_tmp25_ = user_ext_dir;
		_tmp26_ = g_dir_read_name (_tmp25_);
		file_name = _tmp26_;
		while (TRUE) {
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			gboolean _tmp29_ = FALSE;
			GDir* _tmp44_;
			const gchar* _tmp45_ = NULL;
			_tmp27_ = file_name;
			if (!(_tmp27_ != NULL)) {
				break;
			}
			_tmp28_ = file_name;
			_tmp29_ = g_str_has_suffix (_tmp28_, ".so");
			if (_tmp29_) {
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				gchar* _tmp32_ = NULL;
				gchar* path;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				ZeitgeistModuleLoader* _tmp35_;
				ZeitgeistModuleLoader* loader;
				ZeitgeistModuleLoader* _tmp36_;
				ZeitgeistExtension* _tmp37_ = NULL;
				ZeitgeistExtension* _tmp38_;
				_tmp30_ = ext_dir1;
				_tmp31_ = file_name;
				_tmp32_ = g_build_filename (_tmp30_, _tmp31_, NULL);
				path = _tmp32_;
				_tmp33_ = path;
				g_debug ("extension-collection.vala:94: Loading extension: \"%s\"", _tmp33_);
				_tmp34_ = path;
				_tmp35_ = zeitgeist_module_loader_new (_tmp34_);
				loader = _tmp35_;
				_tmp36_ = loader;
				_tmp37_ = zeitgeist_extension_collection_instantiate_extension (self, (ZeitgeistExtensionLoader*) _tmp36_);
				_g_object_unref0 (extension);
				extension = _tmp37_;
				_tmp38_ = extension;
				if (_tmp38_ != NULL) {
					GPtrArray* _tmp39_;
					ZeitgeistExtension* _tmp40_;
					ZeitgeistExtension* _tmp41_;
					_tmp39_ = self->priv->extensions;
					_tmp40_ = extension;
					_tmp41_ = _g_object_ref0 (_tmp40_);
					g_ptr_array_add (_tmp39_, _tmp41_);
				}
				_g_object_unref0 (loader);
				_g_free0 (path);
			} else {
				const gchar* _tmp42_;
				const gchar* _tmp43_;
				_tmp42_ = ext_dir1;
				_tmp43_ = file_name;
				g_debug ("extension-collection.vala:101: Ignored file \"%s/%s\"", _tmp42_, _tmp43_);
			}
			_tmp44_ = user_ext_dir;
			_tmp45_ = g_dir_read_name (_tmp44_);
			file_name = _tmp45_;
		}
	}
	_g_dir_close0 (user_ext_dir);
	builtins = (g_free (builtins), NULL);
	_g_object_unref0 (extension);
	return obj;
}


static void zeitgeist_extension_collection_class_init (ZeitgeistExtensionCollectionClass * klass) {
	zeitgeist_extension_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistExtensionCollectionPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_extension_collection_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_extension_collection_set_property;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_extension_collection_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_extension_collection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EXTENSION_COLLECTION_ENGINE, g_param_spec_object ("engine", "engine", "engine", ZEITGEIST_TYPE_ENGINE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void zeitgeist_extension_collection_instance_init (ZeitgeistExtensionCollection * self) {
	gchar** _tmp0_ = NULL;
	self->priv = ZEITGEIST_EXTENSION_COLLECTION_GET_PRIVATE (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->disabled_extensions = _tmp0_;
	self->priv->disabled_extensions_length1 = 0;
	self->priv->_disabled_extensions_size_ = self->priv->disabled_extensions_length1;
}


static void zeitgeist_extension_collection_finalize (GObject* obj) {
	ZeitgeistExtensionCollection * self;
	GPtrArray* _tmp0_;
	self = ZEITGEIST_EXTENSION_COLLECTION (obj);
	_tmp0_ = self->priv->extensions;
	g_ptr_array_foreach (_tmp0_, __zeitgeist_extension_collection___lambda3__gfunc, self);
	_g_ptr_array_unref0 (self->priv->extensions);
	self->priv->disabled_extensions = (_vala_array_free (self->priv->disabled_extensions, self->priv->disabled_extensions_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (zeitgeist_extension_collection_parent_class)->finalize (obj);
}


GType zeitgeist_extension_collection_get_type (void) {
	static volatile gsize zeitgeist_extension_collection_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_extension_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistExtensionCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_extension_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistExtensionCollection), 0, (GInstanceInitFunc) zeitgeist_extension_collection_instance_init, NULL };
		GType zeitgeist_extension_collection_type_id;
		zeitgeist_extension_collection_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistExtensionCollection", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_extension_collection_type_id__volatile, zeitgeist_extension_collection_type_id);
	}
	return zeitgeist_extension_collection_type_id__volatile;
}


static void _vala_zeitgeist_extension_collection_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ZeitgeistExtensionCollection * self;
	self = ZEITGEIST_EXTENSION_COLLECTION (object);
	switch (property_id) {
		case ZEITGEIST_EXTENSION_COLLECTION_ENGINE:
		g_value_set_object (value, zeitgeist_extension_collection_get_engine (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_zeitgeist_extension_collection_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ZeitgeistExtensionCollection * self;
	self = ZEITGEIST_EXTENSION_COLLECTION (object);
	switch (property_id) {
		case ZEITGEIST_EXTENSION_COLLECTION_ENGINE:
		zeitgeist_extension_collection_set_engine (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



